
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/presentation/presentation.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class PresentationService_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<PresentationService, PresentationService.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<PresentationService, PresentationService.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.PresentationService";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, PresentationService impl) {
            return new Stub(core, impl);
        }

        @Override
        public PresentationService[] buildArray(int size) {
          return new PresentationService[size];
        }
    };


    private static final int SET_CONTROLLER_ORDINAL = 0;

    private static final int SET_RECEIVER_ORDINAL = 1;

    private static final int SET_DEFAULT_PRESENTATION_URLS_ORDINAL = 2;

    private static final int LISTEN_FOR_SCREEN_AVAILABILITY_ORDINAL = 3;

    private static final int STOP_LISTENING_FOR_SCREEN_AVAILABILITY_ORDINAL = 4;

    private static final int START_PRESENTATION_ORDINAL = 5;

    private static final int RECONNECT_PRESENTATION_ORDINAL = 6;

    private static final int CLOSE_CONNECTION_ORDINAL = 7;

    private static final int TERMINATE_ORDINAL = 8;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements PresentationService.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setController(
PresentationController controller) {

            PresentationServiceSetControllerParams _message = new PresentationServiceSetControllerParams();

            _message.controller = controller;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_CONTROLLER_ORDINAL)));

        }


        @Override
        public void setReceiver(
PresentationReceiver receiver) {

            PresentationServiceSetReceiverParams _message = new PresentationServiceSetReceiverParams();

            _message.receiver = receiver;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_RECEIVER_ORDINAL)));

        }


        @Override
        public void setDefaultPresentationUrls(
com.vccorp.url.mojom.Url[] presentationUrls) {

            PresentationServiceSetDefaultPresentationUrlsParams _message = new PresentationServiceSetDefaultPresentationUrlsParams();

            _message.presentationUrls = presentationUrls;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_DEFAULT_PRESENTATION_URLS_ORDINAL)));

        }


        @Override
        public void listenForScreenAvailability(
com.vccorp.url.mojom.Url availabilityUrl) {

            PresentationServiceListenForScreenAvailabilityParams _message = new PresentationServiceListenForScreenAvailabilityParams();

            _message.availabilityUrl = availabilityUrl;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(LISTEN_FOR_SCREEN_AVAILABILITY_ORDINAL)));

        }


        @Override
        public void stopListeningForScreenAvailability(
com.vccorp.url.mojom.Url availabilityUrl) {

            PresentationServiceStopListeningForScreenAvailabilityParams _message = new PresentationServiceStopListeningForScreenAvailabilityParams();

            _message.availabilityUrl = availabilityUrl;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(STOP_LISTENING_FOR_SCREEN_AVAILABILITY_ORDINAL)));

        }


        @Override
        public void startPresentation(
com.vccorp.url.mojom.Url[] presentationUrls,
StartPresentationResponse callback) {

            PresentationServiceStartPresentationParams _message = new PresentationServiceStartPresentationParams();

            _message.presentationUrls = presentationUrls;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    START_PRESENTATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PresentationServiceStartPresentationResponseParamsForwardToCallback(callback));

        }


        @Override
        public void reconnectPresentation(
com.vccorp.url.mojom.Url[] presentationUrls, String presentationId,
ReconnectPresentationResponse callback) {

            PresentationServiceReconnectPresentationParams _message = new PresentationServiceReconnectPresentationParams();

            _message.presentationUrls = presentationUrls;

            _message.presentationId = presentationId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    RECONNECT_PRESENTATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new PresentationServiceReconnectPresentationResponseParamsForwardToCallback(callback));

        }


        @Override
        public void closeConnection(
com.vccorp.url.mojom.Url presentationUrl, String presentationId) {

            PresentationServiceCloseConnectionParams _message = new PresentationServiceCloseConnectionParams();

            _message.presentationUrl = presentationUrl;

            _message.presentationId = presentationId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CLOSE_CONNECTION_ORDINAL)));

        }


        @Override
        public void terminate(
com.vccorp.url.mojom.Url presentationUrl, String presentationId) {

            PresentationServiceTerminateParams _message = new PresentationServiceTerminateParams();

            _message.presentationUrl = presentationUrl;

            _message.presentationId = presentationId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(TERMINATE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<PresentationService> {

        Stub(com.vccorp.mojo.system.Core core, PresentationService impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                PresentationService_Internal.MANAGER, messageWithHeader);





                    case SET_CONTROLLER_ORDINAL: {

                        PresentationServiceSetControllerParams data =
                                PresentationServiceSetControllerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setController(data.controller);
                        return true;
                    }





                    case SET_RECEIVER_ORDINAL: {

                        PresentationServiceSetReceiverParams data =
                                PresentationServiceSetReceiverParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setReceiver(data.receiver);
                        return true;
                    }





                    case SET_DEFAULT_PRESENTATION_URLS_ORDINAL: {

                        PresentationServiceSetDefaultPresentationUrlsParams data =
                                PresentationServiceSetDefaultPresentationUrlsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setDefaultPresentationUrls(data.presentationUrls);
                        return true;
                    }





                    case LISTEN_FOR_SCREEN_AVAILABILITY_ORDINAL: {

                        PresentationServiceListenForScreenAvailabilityParams data =
                                PresentationServiceListenForScreenAvailabilityParams.deserialize(messageWithHeader.getPayload());

                        getImpl().listenForScreenAvailability(data.availabilityUrl);
                        return true;
                    }





                    case STOP_LISTENING_FOR_SCREEN_AVAILABILITY_ORDINAL: {

                        PresentationServiceStopListeningForScreenAvailabilityParams data =
                                PresentationServiceStopListeningForScreenAvailabilityParams.deserialize(messageWithHeader.getPayload());

                        getImpl().stopListeningForScreenAvailability(data.availabilityUrl);
                        return true;
                    }









                    case CLOSE_CONNECTION_ORDINAL: {

                        PresentationServiceCloseConnectionParams data =
                                PresentationServiceCloseConnectionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().closeConnection(data.presentationUrl, data.presentationId);
                        return true;
                    }





                    case TERMINATE_ORDINAL: {

                        PresentationServiceTerminateParams data =
                                PresentationServiceTerminateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().terminate(data.presentationUrl, data.presentationId);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), PresentationService_Internal.MANAGER, messageWithHeader, receiver);

















                    case START_PRESENTATION_ORDINAL: {

                        PresentationServiceStartPresentationParams data =
                                PresentationServiceStartPresentationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startPresentation(data.presentationUrls, new PresentationServiceStartPresentationResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case RECONNECT_PRESENTATION_ORDINAL: {

                        PresentationServiceReconnectPresentationParams data =
                                PresentationServiceReconnectPresentationParams.deserialize(messageWithHeader.getPayload());

                        getImpl().reconnectPresentation(data.presentationUrls, data.presentationId, new PresentationServiceReconnectPresentationResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }






                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class PresentationServiceSetControllerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PresentationController controller;

        private PresentationServiceSetControllerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceSetControllerParams() {
            this(0);
        }

        public static PresentationServiceSetControllerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceSetControllerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceSetControllerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceSetControllerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceSetControllerParams(elementsOrVersion);
                    {
                        
                    result.controller = decoder0.readServiceInterface(8, false, PresentationController.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.controller, 8, false, PresentationController.MANAGER);
        }
    }



    
    static final class PresentationServiceSetReceiverParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PresentationReceiver receiver;

        private PresentationServiceSetReceiverParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceSetReceiverParams() {
            this(0);
        }

        public static PresentationServiceSetReceiverParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceSetReceiverParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceSetReceiverParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceSetReceiverParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceSetReceiverParams(elementsOrVersion);
                    {
                        
                    result.receiver = decoder0.readServiceInterface(8, false, PresentationReceiver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.receiver, 8, false, PresentationReceiver.MANAGER);
        }
    }



    
    static final class PresentationServiceSetDefaultPresentationUrlsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url[] presentationUrls;

        private PresentationServiceSetDefaultPresentationUrlsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceSetDefaultPresentationUrlsParams() {
            this(0);
        }

        public static PresentationServiceSetDefaultPresentationUrlsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceSetDefaultPresentationUrlsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceSetDefaultPresentationUrlsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceSetDefaultPresentationUrlsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceSetDefaultPresentationUrlsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.presentationUrls = new com.vccorp.url.mojom.Url[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.presentationUrls[i1] = com.vccorp.url.mojom.Url.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.presentationUrls == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.presentationUrls.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.presentationUrls.length; ++i0) {
                    
                    encoder1.encode(this.presentationUrls[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class PresentationServiceListenForScreenAvailabilityParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url availabilityUrl;

        private PresentationServiceListenForScreenAvailabilityParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceListenForScreenAvailabilityParams() {
            this(0);
        }

        public static PresentationServiceListenForScreenAvailabilityParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceListenForScreenAvailabilityParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceListenForScreenAvailabilityParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceListenForScreenAvailabilityParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceListenForScreenAvailabilityParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.availabilityUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.availabilityUrl, 8, false);
        }
    }



    
    static final class PresentationServiceStopListeningForScreenAvailabilityParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url availabilityUrl;

        private PresentationServiceStopListeningForScreenAvailabilityParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceStopListeningForScreenAvailabilityParams() {
            this(0);
        }

        public static PresentationServiceStopListeningForScreenAvailabilityParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceStopListeningForScreenAvailabilityParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceStopListeningForScreenAvailabilityParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceStopListeningForScreenAvailabilityParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceStopListeningForScreenAvailabilityParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.availabilityUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.availabilityUrl, 8, false);
        }
    }



    
    static final class PresentationServiceStartPresentationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url[] presentationUrls;

        private PresentationServiceStartPresentationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceStartPresentationParams() {
            this(0);
        }

        public static PresentationServiceStartPresentationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceStartPresentationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceStartPresentationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceStartPresentationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceStartPresentationParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.presentationUrls = new com.vccorp.url.mojom.Url[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.presentationUrls[i1] = com.vccorp.url.mojom.Url.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.presentationUrls == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.presentationUrls.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.presentationUrls.length; ++i0) {
                    
                    encoder1.encode(this.presentationUrls[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class PresentationServiceStartPresentationResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PresentationConnectionResult result;
        public PresentationError error;

        private PresentationServiceStartPresentationResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceStartPresentationResponseParams() {
            this(0);
        }

        public static PresentationServiceStartPresentationResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceStartPresentationResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceStartPresentationResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceStartPresentationResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceStartPresentationResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.result = PresentationConnectionResult.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.error = PresentationError.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, true);
            
            encoder0.encode(this.error, 16, true);
        }
    }

    static class PresentationServiceStartPresentationResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PresentationService.StartPresentationResponse mCallback;

        PresentationServiceStartPresentationResponseParamsForwardToCallback(PresentationService.StartPresentationResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(START_PRESENTATION_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PresentationServiceStartPresentationResponseParams response = PresentationServiceStartPresentationResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PresentationServiceStartPresentationResponseParamsProxyToResponder implements PresentationService.StartPresentationResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PresentationServiceStartPresentationResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(PresentationConnectionResult result, PresentationError error) {
            PresentationServiceStartPresentationResponseParams _response = new PresentationServiceStartPresentationResponseParams();

            _response.result = result;

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    START_PRESENTATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PresentationServiceReconnectPresentationParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url[] presentationUrls;
        public String presentationId;

        private PresentationServiceReconnectPresentationParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceReconnectPresentationParams() {
            this(0);
        }

        public static PresentationServiceReconnectPresentationParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceReconnectPresentationParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceReconnectPresentationParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceReconnectPresentationParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceReconnectPresentationParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.presentationUrls = new com.vccorp.url.mojom.Url[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.presentationUrls[i1] = com.vccorp.url.mojom.Url.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    result.presentationId = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.presentationUrls == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.presentationUrls.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.presentationUrls.length; ++i0) {
                    
                    encoder1.encode(this.presentationUrls[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.presentationId, 16, false);
        }
    }



    
    static final class PresentationServiceReconnectPresentationResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PresentationConnectionResult result;
        public PresentationError error;

        private PresentationServiceReconnectPresentationResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceReconnectPresentationResponseParams() {
            this(0);
        }

        public static PresentationServiceReconnectPresentationResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceReconnectPresentationResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceReconnectPresentationResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceReconnectPresentationResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceReconnectPresentationResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.result = PresentationConnectionResult.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.error = PresentationError.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, true);
            
            encoder0.encode(this.error, 16, true);
        }
    }

    static class PresentationServiceReconnectPresentationResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final PresentationService.ReconnectPresentationResponse mCallback;

        PresentationServiceReconnectPresentationResponseParamsForwardToCallback(PresentationService.ReconnectPresentationResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(RECONNECT_PRESENTATION_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                PresentationServiceReconnectPresentationResponseParams response = PresentationServiceReconnectPresentationResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.error);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class PresentationServiceReconnectPresentationResponseParamsProxyToResponder implements PresentationService.ReconnectPresentationResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        PresentationServiceReconnectPresentationResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(PresentationConnectionResult result, PresentationError error) {
            PresentationServiceReconnectPresentationResponseParams _response = new PresentationServiceReconnectPresentationResponseParams();

            _response.result = result;

            _response.error = error;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    RECONNECT_PRESENTATION_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class PresentationServiceCloseConnectionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url presentationUrl;
        public String presentationId;

        private PresentationServiceCloseConnectionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceCloseConnectionParams() {
            this(0);
        }

        public static PresentationServiceCloseConnectionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceCloseConnectionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceCloseConnectionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceCloseConnectionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceCloseConnectionParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.presentationUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.presentationId = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.presentationUrl, 8, false);
            
            encoder0.encode(this.presentationId, 16, false);
        }
    }



    
    static final class PresentationServiceTerminateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url presentationUrl;
        public String presentationId;

        private PresentationServiceTerminateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public PresentationServiceTerminateParams() {
            this(0);
        }

        public static PresentationServiceTerminateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static PresentationServiceTerminateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static PresentationServiceTerminateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            PresentationServiceTerminateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new PresentationServiceTerminateParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.presentationUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.presentationId = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.presentationUrl, 8, false);
            
            encoder0.encode(this.presentationId, 16, false);
        }
    }



}
