
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/permissions/permission.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class PermissionName {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int GEOLOCATION = 0;
    public static final int NOTIFICATIONS = 1; // GEOLOCATION + 1
    public static final int MIDI = 2; // NOTIFICATIONS + 1
    public static final int PROTECTED_MEDIA_IDENTIFIER = 3; // MIDI + 1
    public static final int DURABLE_STORAGE = 4; // PROTECTED_MEDIA_IDENTIFIER + 1
    public static final int AUDIO_CAPTURE = 5; // DURABLE_STORAGE + 1
    public static final int VIDEO_CAPTURE = 6; // AUDIO_CAPTURE + 1
    public static final int BACKGROUND_SYNC = 7; // VIDEO_CAPTURE + 1
    public static final int SENSORS = 8; // BACKGROUND_SYNC + 1
    public static final int ACCESSIBILITY_EVENTS = 9; // SENSORS + 1
    public static final int CLIPBOARD_READ = 10; // ACCESSIBILITY_EVENTS + 1
    public static final int CLIPBOARD_WRITE = 11; // CLIPBOARD_READ + 1
    public static final int PAYMENT_HANDLER = 12; // CLIPBOARD_WRITE + 1
    public static final int BACKGROUND_FETCH = 13; // PAYMENT_HANDLER + 1
    public static final int IDLE_DETECTION = 14; // BACKGROUND_FETCH + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 14;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private PermissionName() {}
}