
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediastream/media_stream.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class MediaStreamDevice extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 72;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(72, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int type;
    public String id;
    public int videoFacing;
    public String groupId;
    public String matchedOutputDeviceId;
    public String name;
    public com.vccorp.media.mojom.AudioParameters input;
    public int sessionId;
    public com.vccorp.media.mojom.DisplayMediaInformation displayMediaInfo;

    private MediaStreamDevice(int version) {
        super(STRUCT_SIZE, version);
    }

    public MediaStreamDevice() {
        this(0);
    }

    public static MediaStreamDevice deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static MediaStreamDevice deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static MediaStreamDevice decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        MediaStreamDevice result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new MediaStreamDevice(elementsOrVersion);
                {
                    
                result.type = decoder0.readInt(8);
                    MediaStreamType.validate(result.type);
                }
                {
                    
                result.videoFacing = decoder0.readInt(12);
                    com.vccorp.media.mojom.VideoFacingMode.validate(result.videoFacing);
                }
                {
                    
                result.id = decoder0.readString(16, false);
                }
                {
                    
                result.groupId = decoder0.readString(24, true);
                }
                {
                    
                result.matchedOutputDeviceId = decoder0.readString(32, true);
                }
                {
                    
                result.name = decoder0.readString(40, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                result.input = com.vccorp.media.mojom.AudioParameters.decode(decoder1);
                }
                {
                    
                result.sessionId = decoder0.readInt(56);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(64, true);
                result.displayMediaInfo = com.vccorp.media.mojom.DisplayMediaInformation.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.type, 8);
        
        encoder0.encode(this.videoFacing, 12);
        
        encoder0.encode(this.id, 16, false);
        
        encoder0.encode(this.groupId, 24, true);
        
        encoder0.encode(this.matchedOutputDeviceId, 32, true);
        
        encoder0.encode(this.name, 40, false);
        
        encoder0.encode(this.input, 48, false);
        
        encoder0.encode(this.sessionId, 56);
        
        encoder0.encode(this.displayMediaInfo, 64, true);
    }
}