
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/mediastream/media_devices.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class MediaDevicesDispatcherHost_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<MediaDevicesDispatcherHost, MediaDevicesDispatcherHost.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<MediaDevicesDispatcherHost, MediaDevicesDispatcherHost.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.MediaDevicesDispatcherHost";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, MediaDevicesDispatcherHost impl) {
            return new Stub(core, impl);
        }

        @Override
        public MediaDevicesDispatcherHost[] buildArray(int size) {
          return new MediaDevicesDispatcherHost[size];
        }
    };


    private static final int ENUMERATE_DEVICES_ORDINAL = 0;

    private static final int GET_VIDEO_INPUT_CAPABILITIES_ORDINAL = 1;

    private static final int GET_ALL_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL = 2;

    private static final int GET_AVAILABLE_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL = 3;

    private static final int GET_AUDIO_INPUT_CAPABILITIES_ORDINAL = 4;

    private static final int ADD_MEDIA_DEVICES_LISTENER_ORDINAL = 5;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements MediaDevicesDispatcherHost.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void enumerateDevices(
boolean requestAudioInput, boolean requestVideoInput, boolean requestAudioOutput, boolean requestVideoInputCapabilities, boolean requestAudioInputCapabilities, 
EnumerateDevicesResponse callback) {

            MediaDevicesDispatcherHostEnumerateDevicesParams _message = new MediaDevicesDispatcherHostEnumerateDevicesParams();

            _message.requestAudioInput = requestAudioInput;

            _message.requestVideoInput = requestVideoInput;

            _message.requestAudioOutput = requestAudioOutput;

            _message.requestVideoInputCapabilities = requestVideoInputCapabilities;

            _message.requestAudioInputCapabilities = requestAudioInputCapabilities;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENUMERATE_DEVICES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaDevicesDispatcherHostEnumerateDevicesResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getVideoInputCapabilities(

GetVideoInputCapabilitiesResponse callback) {

            MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams _message = new MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_VIDEO_INPUT_CAPABILITIES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getAllVideoInputDeviceFormats(
String deviceId, 
GetAllVideoInputDeviceFormatsResponse callback) {

            MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams _message = new MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams();

            _message.deviceId = deviceId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_ALL_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getAvailableVideoInputDeviceFormats(
String deviceId, 
GetAvailableVideoInputDeviceFormatsResponse callback) {

            MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams _message = new MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams();

            _message.deviceId = deviceId;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AVAILABLE_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getAudioInputCapabilities(

GetAudioInputCapabilitiesResponse callback) {

            MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams _message = new MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AUDIO_INPUT_CAPABILITIES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParamsForwardToCallback(callback));

        }


        @Override
        public void addMediaDevicesListener(
boolean subscribeAudioInput, boolean subscribeVideoInput, boolean subscribeAudioOutput, MediaDevicesListener listener) {

            MediaDevicesDispatcherHostAddMediaDevicesListenerParams _message = new MediaDevicesDispatcherHostAddMediaDevicesListenerParams();

            _message.subscribeAudioInput = subscribeAudioInput;

            _message.subscribeVideoInput = subscribeVideoInput;

            _message.subscribeAudioOutput = subscribeAudioOutput;

            _message.listener = listener;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_MEDIA_DEVICES_LISTENER_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<MediaDevicesDispatcherHost> {

        Stub(com.vccorp.mojo.system.Core core, MediaDevicesDispatcherHost impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                MediaDevicesDispatcherHost_Internal.MANAGER, messageWithHeader);















                    case ADD_MEDIA_DEVICES_LISTENER_ORDINAL: {

                        MediaDevicesDispatcherHostAddMediaDevicesListenerParams data =
                                MediaDevicesDispatcherHostAddMediaDevicesListenerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addMediaDevicesListener(data.subscribeAudioInput, data.subscribeVideoInput, data.subscribeAudioOutput, data.listener);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), MediaDevicesDispatcherHost_Internal.MANAGER, messageWithHeader, receiver);







                    case ENUMERATE_DEVICES_ORDINAL: {

                        MediaDevicesDispatcherHostEnumerateDevicesParams data =
                                MediaDevicesDispatcherHostEnumerateDevicesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().enumerateDevices(data.requestAudioInput, data.requestVideoInput, data.requestAudioOutput, data.requestVideoInputCapabilities, data.requestAudioInputCapabilities, new MediaDevicesDispatcherHostEnumerateDevicesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_VIDEO_INPUT_CAPABILITIES_ORDINAL: {

                        MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getVideoInputCapabilities(new MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_ALL_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL: {

                        MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams data =
                                MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getAllVideoInputDeviceFormats(data.deviceId, new MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_AVAILABLE_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL: {

                        MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams data =
                                MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getAvailableVideoInputDeviceFormats(data.deviceId, new MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_AUDIO_INPUT_CAPABILITIES_ORDINAL: {

                        MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getAudioInputCapabilities(new MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class MediaDevicesDispatcherHostEnumerateDevicesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean requestAudioInput;
        public boolean requestVideoInput;
        public boolean requestAudioOutput;
        public boolean requestVideoInputCapabilities;
        public boolean requestAudioInputCapabilities;

        private MediaDevicesDispatcherHostEnumerateDevicesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostEnumerateDevicesParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostEnumerateDevicesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostEnumerateDevicesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostEnumerateDevicesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostEnumerateDevicesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostEnumerateDevicesParams(elementsOrVersion);
                    {
                        
                    result.requestAudioInput = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.requestVideoInput = decoder0.readBoolean(8, 1);
                    }
                    {
                        
                    result.requestAudioOutput = decoder0.readBoolean(8, 2);
                    }
                    {
                        
                    result.requestVideoInputCapabilities = decoder0.readBoolean(8, 3);
                    }
                    {
                        
                    result.requestAudioInputCapabilities = decoder0.readBoolean(8, 4);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.requestAudioInput, 8, 0);
            
            encoder0.encode(this.requestVideoInput, 8, 1);
            
            encoder0.encode(this.requestAudioOutput, 8, 2);
            
            encoder0.encode(this.requestVideoInputCapabilities, 8, 3);
            
            encoder0.encode(this.requestAudioInputCapabilities, 8, 4);
        }
    }



    
    static final class MediaDevicesDispatcherHostEnumerateDevicesResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public MediaDeviceInfo[][] enumeration;
        public VideoInputDeviceCapabilities[] videoInputDeviceCapabilities;
        public AudioInputDeviceCapabilities[] audioInputDeviceCapabilities;

        private MediaDevicesDispatcherHostEnumerateDevicesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostEnumerateDevicesResponseParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostEnumerateDevicesResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostEnumerateDevicesResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostEnumerateDevicesResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostEnumerateDevicesResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostEnumerateDevicesResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.enumeration = new MediaDeviceInfo[si1.elementsOrVersion][];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            {
                                com.vccorp.mojo.bindings.DataHeader si2 = decoder2.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                                result.enumeration[i1] = new MediaDeviceInfo[si2.elementsOrVersion];
                                for (int i2 = 0; i2 < si2.elementsOrVersion; ++i2) {
                                    
                                    com.vccorp.mojo.bindings.Decoder decoder3 = decoder2.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i2, false);
                                    result.enumeration[i1][i2] = MediaDeviceInfo.decode(decoder3);
                                }
                            }
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.videoInputDeviceCapabilities = new VideoInputDeviceCapabilities[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.videoInputDeviceCapabilities[i1] = VideoInputDeviceCapabilities.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.audioInputDeviceCapabilities = new AudioInputDeviceCapabilities[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.audioInputDeviceCapabilities[i1] = AudioInputDeviceCapabilities.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.enumeration == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.enumeration.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.enumeration.length; ++i0) {
                    
                    if (this.enumeration[i0] == null) {
                        encoder1.encodeNullPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                    } else {
                        org.chromium.mojo.bindings.Encoder encoder2 = encoder1.encodePointerArray(this.enumeration[i0].length, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        for (int i1 = 0; i1 < this.enumeration[i0].length; ++i1) {
                            
                            encoder2.encode(this.enumeration[i0][i1], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                }
            }
            
            if (this.videoInputDeviceCapabilities == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.videoInputDeviceCapabilities.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.videoInputDeviceCapabilities.length; ++i0) {
                    
                    encoder1.encode(this.videoInputDeviceCapabilities[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            if (this.audioInputDeviceCapabilities == null) {
                encoder0.encodeNullPointer(24, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.audioInputDeviceCapabilities.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.audioInputDeviceCapabilities.length; ++i0) {
                    
                    encoder1.encode(this.audioInputDeviceCapabilities[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class MediaDevicesDispatcherHostEnumerateDevicesResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaDevicesDispatcherHost.EnumerateDevicesResponse mCallback;

        MediaDevicesDispatcherHostEnumerateDevicesResponseParamsForwardToCallback(MediaDevicesDispatcherHost.EnumerateDevicesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ENUMERATE_DEVICES_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaDevicesDispatcherHostEnumerateDevicesResponseParams response = MediaDevicesDispatcherHostEnumerateDevicesResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.enumeration, response.videoInputDeviceCapabilities, response.audioInputDeviceCapabilities);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaDevicesDispatcherHostEnumerateDevicesResponseParamsProxyToResponder implements MediaDevicesDispatcherHost.EnumerateDevicesResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaDevicesDispatcherHostEnumerateDevicesResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(MediaDeviceInfo[][] enumeration, VideoInputDeviceCapabilities[] videoInputDeviceCapabilities, AudioInputDeviceCapabilities[] audioInputDeviceCapabilities) {
            MediaDevicesDispatcherHostEnumerateDevicesResponseParams _response = new MediaDevicesDispatcherHostEnumerateDevicesResponseParams();

            _response.enumeration = enumeration;

            _response.videoInputDeviceCapabilities = videoInputDeviceCapabilities;

            _response.audioInputDeviceCapabilities = audioInputDeviceCapabilities;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENUMERATE_DEVICES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetVideoInputCapabilitiesParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoInputDeviceCapabilities[] videoInputDeviceCapabilities;

        private MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.videoInputDeviceCapabilities = new VideoInputDeviceCapabilities[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.videoInputDeviceCapabilities[i1] = VideoInputDeviceCapabilities.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.videoInputDeviceCapabilities == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.videoInputDeviceCapabilities.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.videoInputDeviceCapabilities.length; ++i0) {
                    
                    encoder1.encode(this.videoInputDeviceCapabilities[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaDevicesDispatcherHost.GetVideoInputCapabilitiesResponse mCallback;

        MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParamsForwardToCallback(MediaDevicesDispatcherHost.GetVideoInputCapabilitiesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_VIDEO_INPUT_CAPABILITIES_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams response = MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.videoInputDeviceCapabilities);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParamsProxyToResponder implements MediaDevicesDispatcherHost.GetVideoInputCapabilitiesResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(VideoInputDeviceCapabilities[] videoInputDeviceCapabilities) {
            MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams _response = new MediaDevicesDispatcherHostGetVideoInputCapabilitiesResponseParams();

            _response.videoInputDeviceCapabilities = videoInputDeviceCapabilities;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_VIDEO_INPUT_CAPABILITIES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String deviceId;

        private MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8, false);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.media.mojom.VideoCaptureFormat[] formats;

        private MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.formats = new com.vccorp.media.mojom.VideoCaptureFormat[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.formats[i1] = com.vccorp.media.mojom.VideoCaptureFormat.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.formats == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.formats.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.formats.length; ++i0) {
                    
                    encoder1.encode(this.formats[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaDevicesDispatcherHost.GetAllVideoInputDeviceFormatsResponse mCallback;

        MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParamsForwardToCallback(MediaDevicesDispatcherHost.GetAllVideoInputDeviceFormatsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_ALL_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams response = MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.formats);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParamsProxyToResponder implements MediaDevicesDispatcherHost.GetAllVideoInputDeviceFormatsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.media.mojom.VideoCaptureFormat[] formats) {
            MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams _response = new MediaDevicesDispatcherHostGetAllVideoInputDeviceFormatsResponseParams();

            _response.formats = formats;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_ALL_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String deviceId;

        private MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsParams(elementsOrVersion);
                    {
                        
                    result.deviceId = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.deviceId, 8, false);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.media.mojom.VideoCaptureFormat[] formats;

        private MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.formats = new com.vccorp.media.mojom.VideoCaptureFormat[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.formats[i1] = com.vccorp.media.mojom.VideoCaptureFormat.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.formats == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.formats.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.formats.length; ++i0) {
                    
                    encoder1.encode(this.formats[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaDevicesDispatcherHost.GetAvailableVideoInputDeviceFormatsResponse mCallback;

        MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParamsForwardToCallback(MediaDevicesDispatcherHost.GetAvailableVideoInputDeviceFormatsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_AVAILABLE_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams response = MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.formats);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParamsProxyToResponder implements MediaDevicesDispatcherHost.GetAvailableVideoInputDeviceFormatsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.media.mojom.VideoCaptureFormat[] formats) {
            MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams _response = new MediaDevicesDispatcherHostGetAvailableVideoInputDeviceFormatsResponseParams();

            _response.formats = formats;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AVAILABLE_VIDEO_INPUT_DEVICE_FORMATS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetAudioInputCapabilitiesParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AudioInputDeviceCapabilities[] audioInputDeviceCapabilities;

        private MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.audioInputDeviceCapabilities = new AudioInputDeviceCapabilities[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.audioInputDeviceCapabilities[i1] = AudioInputDeviceCapabilities.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.audioInputDeviceCapabilities == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.audioInputDeviceCapabilities.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.audioInputDeviceCapabilities.length; ++i0) {
                    
                    encoder1.encode(this.audioInputDeviceCapabilities[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }

    static class MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final MediaDevicesDispatcherHost.GetAudioInputCapabilitiesResponse mCallback;

        MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParamsForwardToCallback(MediaDevicesDispatcherHost.GetAudioInputCapabilitiesResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_AUDIO_INPUT_CAPABILITIES_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams response = MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.audioInputDeviceCapabilities);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParamsProxyToResponder implements MediaDevicesDispatcherHost.GetAudioInputCapabilitiesResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(AudioInputDeviceCapabilities[] audioInputDeviceCapabilities) {
            MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams _response = new MediaDevicesDispatcherHostGetAudioInputCapabilitiesResponseParams();

            _response.audioInputDeviceCapabilities = audioInputDeviceCapabilities;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_AUDIO_INPUT_CAPABILITIES_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class MediaDevicesDispatcherHostAddMediaDevicesListenerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean subscribeAudioInput;
        public boolean subscribeVideoInput;
        public boolean subscribeAudioOutput;
        public MediaDevicesListener listener;

        private MediaDevicesDispatcherHostAddMediaDevicesListenerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public MediaDevicesDispatcherHostAddMediaDevicesListenerParams() {
            this(0);
        }

        public static MediaDevicesDispatcherHostAddMediaDevicesListenerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static MediaDevicesDispatcherHostAddMediaDevicesListenerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static MediaDevicesDispatcherHostAddMediaDevicesListenerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            MediaDevicesDispatcherHostAddMediaDevicesListenerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new MediaDevicesDispatcherHostAddMediaDevicesListenerParams(elementsOrVersion);
                    {
                        
                    result.subscribeAudioInput = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.subscribeVideoInput = decoder0.readBoolean(8, 1);
                    }
                    {
                        
                    result.subscribeAudioOutput = decoder0.readBoolean(8, 2);
                    }
                    {
                        
                    result.listener = decoder0.readServiceInterface(12, false, MediaDevicesListener.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.subscribeAudioInput, 8, 0);
            
            encoder0.encode(this.subscribeVideoInput, 8, 1);
            
            encoder0.encode(this.subscribeAudioOutput, 8, 2);
            
            encoder0.encode(this.listener, 12, false, MediaDevicesListener.MANAGER);
        }
    }



}
