
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/frame/find_in_page.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class FindOptions extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 16;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public boolean forward;
    public boolean matchCase;
    public boolean findNext;
    public boolean force;
    public boolean runSynchronouslyForTesting;

    private FindOptions(int version) {
        super(STRUCT_SIZE, version);
        this.forward = (boolean) true;
        this.matchCase = (boolean) false;
        this.findNext = (boolean) false;
        this.force = (boolean) false;
        this.runSynchronouslyForTesting = (boolean) false;
    }

    public FindOptions() {
        this(0);
    }

    public static FindOptions deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static FindOptions deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static FindOptions decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        FindOptions result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new FindOptions(elementsOrVersion);
                {
                    
                result.forward = decoder0.readBoolean(8, 0);
                }
                {
                    
                result.matchCase = decoder0.readBoolean(8, 1);
                }
                {
                    
                result.findNext = decoder0.readBoolean(8, 2);
                }
                {
                    
                result.force = decoder0.readBoolean(8, 3);
                }
                {
                    
                result.runSynchronouslyForTesting = decoder0.readBoolean(8, 4);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.forward, 8, 0);
        
        encoder0.encode(this.matchCase, 8, 1);
        
        encoder0.encode(this.findNext, 8, 2);
        
        encoder0.encode(this.force, 8, 3);
        
        encoder0.encode(this.runSynchronouslyForTesting, 8, 4);
    }
}