
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/filesystem/file_system.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface FileSystemManager extends com.vccorp.mojo.bindings.Interface {



    public interface Proxy extends FileSystemManager, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<FileSystemManager, FileSystemManager.Proxy> MANAGER = FileSystemManager_Internal.MANAGER;


    void open(
com.vccorp.url.mojom.Origin origin, int fileSystemType,
OpenResponse callback);

    interface OpenResponse extends com.vccorp.mojo.bindings.Callbacks.Callback3<String, com.vccorp.url.mojom.Url, Integer> { }



    void resolveUrl(
com.vccorp.url.mojom.Url filesystemUrl,
ResolveUrlResponse callback);

    interface ResolveUrlResponse extends com.vccorp.mojo.bindings.Callbacks.Callback4<FileSystemInfo, com.vccorp.mojo_base.mojom.FilePath, Boolean, Integer> { }



    void move(
com.vccorp.url.mojom.Url srcPath, com.vccorp.url.mojom.Url destPath,
MoveResponse callback);

    interface MoveResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void copy(
com.vccorp.url.mojom.Url srcPath, com.vccorp.url.mojom.Url destPath,
CopyResponse callback);

    interface CopyResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void remove(
com.vccorp.url.mojom.Url path, boolean recursive,
RemoveResponse callback);

    interface RemoveResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void readMetadata(
com.vccorp.url.mojom.Url path,
ReadMetadataResponse callback);

    interface ReadMetadataResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<com.vccorp.mojo_base.mojom.FileInfo, Integer> { }



    void create(
com.vccorp.url.mojom.Url path, boolean exclusive, boolean isDirectory, boolean recursive,
CreateResponse callback);

    interface CreateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void exists(
com.vccorp.url.mojom.Url path, boolean isDirectory,
ExistsResponse callback);

    interface ExistsResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void readDirectory(
com.vccorp.url.mojom.Url path, FileSystemOperationListener listener);



    void readDirectorySync(
com.vccorp.url.mojom.Url path,
ReadDirectorySyncResponse callback);

    interface ReadDirectorySyncResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<com.vccorp.filesystem.mojom.DirectoryEntry[], Integer> { }



    void write(
com.vccorp.url.mojom.Url filePath, String blobUuid, long position, com.vccorp.mojo.bindings.InterfaceRequest<FileSystemCancellableOperation> opRequest, FileSystemOperationListener listener);



    void writeSync(
com.vccorp.url.mojom.Url filePath, String blobUuid, long position,
WriteSyncResponse callback);

    interface WriteSyncResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Long, Integer> { }



    void truncate(
com.vccorp.url.mojom.Url filePath, long length, com.vccorp.mojo.bindings.InterfaceRequest<FileSystemCancellableOperation> opRequest,
TruncateResponse callback);

    interface TruncateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void truncateSync(
com.vccorp.url.mojom.Url filePath, long length,
TruncateSyncResponse callback);

    interface TruncateSyncResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void touchFile(
com.vccorp.url.mojom.Url path, com.vccorp.mojo_base.mojom.Time lastAccessTime, com.vccorp.mojo_base.mojom.Time lastModifiedTime,
TouchFileResponse callback);

    interface TouchFileResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<Integer> { }



    void createSnapshotFile(
com.vccorp.url.mojom.Url filePath,
CreateSnapshotFileResponse callback);

    interface CreateSnapshotFileResponse extends com.vccorp.mojo.bindings.Callbacks.Callback4<com.vccorp.mojo_base.mojom.FileInfo, com.vccorp.mojo_base.mojom.FilePath, Integer, ReceivedSnapshotListener> { }



    void getPlatformPath(
com.vccorp.url.mojom.Url filePath,
GetPlatformPathResponse callback);

    interface GetPlatformPathResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<com.vccorp.mojo_base.mojom.FilePath> { }



    void createWriter(
com.vccorp.url.mojom.Url filePath,
CreateWriterResponse callback);

    interface CreateWriterResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, FileWriter> { }



    void chooseEntry(
int type, ChooseFileSystemEntryAcceptsOption[] accepts, boolean includeAcceptsAll, 
ChooseEntryResponse callback);

    interface ChooseEntryResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<Integer, FileSystemEntry[]> { }


}
