
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class DedicatedWorkerHostFactoryClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<DedicatedWorkerHostFactoryClient, DedicatedWorkerHostFactoryClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<DedicatedWorkerHostFactoryClient, DedicatedWorkerHostFactoryClient.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.DedicatedWorkerHostFactoryClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, DedicatedWorkerHostFactoryClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public DedicatedWorkerHostFactoryClient[] buildArray(int size) {
          return new DedicatedWorkerHostFactoryClient[size];
        }
    };


    private static final int ON_WORKER_HOST_CREATED_ORDINAL = 0;

    private static final int ON_SCRIPT_LOAD_STARTED_ORDINAL = 1;

    private static final int ON_SCRIPT_LOAD_START_FAILED_ORDINAL = 2;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements DedicatedWorkerHostFactoryClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onWorkerHostCreated(
com.vccorp.service_manager.mojom.InterfaceProvider interfaceProvider) {

            DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams _message = new DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams();

            _message.interfaceProvider = interfaceProvider;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_WORKER_HOST_CREATED_ORDINAL)));

        }


        @Override
        public void onScriptLoadStarted(
ServiceWorkerProviderInfoForWorker serviceWorkerProviderInfo, WorkerMainScriptLoadParams mainScriptLoadParams, UrlLoaderFactoryBundle subresourceLoaderFactories, ControllerServiceWorkerInfo controllerInfo) {

            DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams _message = new DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams();

            _message.serviceWorkerProviderInfo = serviceWorkerProviderInfo;

            _message.mainScriptLoadParams = mainScriptLoadParams;

            _message.subresourceLoaderFactories = subresourceLoaderFactories;

            _message.controllerInfo = controllerInfo;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SCRIPT_LOAD_STARTED_ORDINAL)));

        }


        @Override
        public void onScriptLoadStartFailed(
) {

            DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams _message = new DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_SCRIPT_LOAD_START_FAILED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<DedicatedWorkerHostFactoryClient> {

        Stub(com.vccorp.mojo.system.Core core, DedicatedWorkerHostFactoryClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                DedicatedWorkerHostFactoryClient_Internal.MANAGER, messageWithHeader);





                    case ON_WORKER_HOST_CREATED_ORDINAL: {

                        DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams data =
                                DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onWorkerHostCreated(data.interfaceProvider);
                        return true;
                    }





                    case ON_SCRIPT_LOAD_STARTED_ORDINAL: {

                        DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams data =
                                DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onScriptLoadStarted(data.serviceWorkerProviderInfo, data.mainScriptLoadParams, data.subresourceLoaderFactories, data.controllerInfo);
                        return true;
                    }





                    case ON_SCRIPT_LOAD_START_FAILED_ORDINAL: {

                        DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onScriptLoadStartFailed();
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), DedicatedWorkerHostFactoryClient_Internal.MANAGER, messageWithHeader, receiver);








                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.service_manager.mojom.InterfaceProvider interfaceProvider;

        private DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams() {
            this(0);
        }

        public static DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DedicatedWorkerHostFactoryClientOnWorkerHostCreatedParams(elementsOrVersion);
                    {
                        
                    result.interfaceProvider = decoder0.readServiceInterface(8, false, com.vccorp.service_manager.mojom.InterfaceProvider.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.interfaceProvider, 8, false, com.vccorp.service_manager.mojom.InterfaceProvider.MANAGER);
        }
    }



    
    static final class DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ServiceWorkerProviderInfoForWorker serviceWorkerProviderInfo;
        public WorkerMainScriptLoadParams mainScriptLoadParams;
        public UrlLoaderFactoryBundle subresourceLoaderFactories;
        public ControllerServiceWorkerInfo controllerInfo;

        private DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams() {
            this(0);
        }

        public static DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DedicatedWorkerHostFactoryClientOnScriptLoadStartedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.serviceWorkerProviderInfo = ServiceWorkerProviderInfoForWorker.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.mainScriptLoadParams = WorkerMainScriptLoadParams.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.subresourceLoaderFactories = UrlLoaderFactoryBundle.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, true);
                    result.controllerInfo = ControllerServiceWorkerInfo.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.serviceWorkerProviderInfo, 8, false);
            
            encoder0.encode(this.mainScriptLoadParams, 16, false);
            
            encoder0.encode(this.subresourceLoaderFactories, 24, true);
            
            encoder0.encode(this.controllerInfo, 32, true);
        }
    }



    
    static final class DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams() {
            this(0);
        }

        public static DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new DedicatedWorkerHostFactoryClientOnScriptLoadStartFailedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



}
