
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/blob/blob_registry.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class BlobRegistry_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<BlobRegistry, BlobRegistry.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<BlobRegistry, BlobRegistry.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.BlobRegistry";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, BlobRegistry impl) {
            return new Stub(core, impl);
        }

        @Override
        public BlobRegistry[] buildArray(int size) {
          return new BlobRegistry[size];
        }
    };


    private static final int REGISTER_ORDINAL = 0;

    private static final int REGISTER_FROM_STREAM_ORDINAL = 1;

    private static final int GET_BLOB_FROM_UUID_ORDINAL = 2;

    private static final int URL_STORE_FOR_ORIGIN_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements BlobRegistry.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void register(
com.vccorp.mojo.bindings.InterfaceRequest<Blob> blob, String uuid, String contentType, String contentDisposition, DataElement[] elements,
RegisterResponse callback) {

            BlobRegistryRegisterParams _message = new BlobRegistryRegisterParams();

            _message.blob = blob;

            _message.uuid = uuid;

            _message.contentType = contentType;

            _message.contentDisposition = contentDisposition;

            _message.elements = elements;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REGISTER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BlobRegistryRegisterResponseParamsForwardToCallback(callback));

        }


        @Override
        public void registerFromStream(
String contentType, String contentDisposition, long lengthHint, com.vccorp.mojo.system.DataPipe.ConsumerHandle data, com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported progressClient,
RegisterFromStreamResponse callback) {

            BlobRegistryRegisterFromStreamParams _message = new BlobRegistryRegisterFromStreamParams();

            _message.contentType = contentType;

            _message.contentDisposition = contentDisposition;

            _message.lengthHint = lengthHint;

            _message.data = data;

            _message.progressClient = progressClient;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REGISTER_FROM_STREAM_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BlobRegistryRegisterFromStreamResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getBlobFromUuid(
com.vccorp.mojo.bindings.InterfaceRequest<Blob> blob, String uuid,
GetBlobFromUuidResponse callback) {

            BlobRegistryGetBlobFromUuidParams _message = new BlobRegistryGetBlobFromUuidParams();

            _message.blob = blob;

            _message.uuid = uuid;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_BLOB_FROM_UUID_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new BlobRegistryGetBlobFromUuidResponseParamsForwardToCallback(callback));

        }


        @Override
        public void urlStoreForOrigin(
com.vccorp.url.mojom.Origin origin, com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported urlStore) {

            BlobRegistryUrlStoreForOriginParams _message = new BlobRegistryUrlStoreForOriginParams();

            _message.origin = origin;

            _message.urlStore = urlStore;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(URL_STORE_FOR_ORIGIN_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<BlobRegistry> {

        Stub(com.vccorp.mojo.system.Core core, BlobRegistry impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                BlobRegistry_Internal.MANAGER, messageWithHeader);











                    case URL_STORE_FOR_ORIGIN_ORDINAL: {

                        BlobRegistryUrlStoreForOriginParams data =
                                BlobRegistryUrlStoreForOriginParams.deserialize(messageWithHeader.getPayload());

                        getImpl().urlStoreForOrigin(data.origin, data.urlStore);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), BlobRegistry_Internal.MANAGER, messageWithHeader, receiver);







                    case REGISTER_ORDINAL: {

                        BlobRegistryRegisterParams data =
                                BlobRegistryRegisterParams.deserialize(messageWithHeader.getPayload());

                        getImpl().register(data.blob, data.uuid, data.contentType, data.contentDisposition, data.elements, new BlobRegistryRegisterResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case REGISTER_FROM_STREAM_ORDINAL: {

                        BlobRegistryRegisterFromStreamParams data =
                                BlobRegistryRegisterFromStreamParams.deserialize(messageWithHeader.getPayload());

                        getImpl().registerFromStream(data.contentType, data.contentDisposition, data.lengthHint, data.data, data.progressClient, new BlobRegistryRegisterFromStreamResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_BLOB_FROM_UUID_ORDINAL: {

                        BlobRegistryGetBlobFromUuidParams data =
                                BlobRegistryGetBlobFromUuidParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getBlobFromUuid(data.blob, data.uuid, new BlobRegistryGetBlobFromUuidResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class BlobRegistryRegisterParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<Blob> blob;
        public String uuid;
        public String contentType;
        public String contentDisposition;
        public DataElement[] elements;

        private BlobRegistryRegisterParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BlobRegistryRegisterParams() {
            this(0);
        }

        public static BlobRegistryRegisterParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BlobRegistryRegisterParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BlobRegistryRegisterParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BlobRegistryRegisterParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BlobRegistryRegisterParams(elementsOrVersion);
                    {
                        
                    result.blob = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    result.uuid = decoder0.readString(16, false);
                    }
                    {
                        
                    result.contentType = decoder0.readString(24, false);
                    }
                    {
                        
                    result.contentDisposition = decoder0.readString(32, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.elements = new DataElement[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.elements[i1] = DataElement.decode(decoder1, com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE +
                            com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE * i1);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.blob, 8, false);
            
            encoder0.encode(this.uuid, 16, false);
            
            encoder0.encode(this.contentType, 24, false);
            
            encoder0.encode(this.contentDisposition, 32, false);
            
            if (this.elements == null) {
                encoder0.encodeNullPointer(40, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodeUnionArray(this.elements.length, 40, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.elements.length; ++i0) {
                    
                    encoder1.encode(this.elements[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE +
                    com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class BlobRegistryRegisterResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BlobRegistryRegisterResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BlobRegistryRegisterResponseParams() {
            this(0);
        }

        public static BlobRegistryRegisterResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BlobRegistryRegisterResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BlobRegistryRegisterResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BlobRegistryRegisterResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BlobRegistryRegisterResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class BlobRegistryRegisterResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BlobRegistry.RegisterResponse mCallback;

        BlobRegistryRegisterResponseParamsForwardToCallback(BlobRegistry.RegisterResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REGISTER_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BlobRegistryRegisterResponseParamsProxyToResponder implements BlobRegistry.RegisterResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BlobRegistryRegisterResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            BlobRegistryRegisterResponseParams _response = new BlobRegistryRegisterResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REGISTER_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BlobRegistryRegisterFromStreamParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String contentType;
        public String contentDisposition;
        public long lengthHint;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle data;
        public com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported progressClient;

        private BlobRegistryRegisterFromStreamParams(int version) {
            super(STRUCT_SIZE, version);
            this.data = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public BlobRegistryRegisterFromStreamParams() {
            this(0);
        }

        public static BlobRegistryRegisterFromStreamParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BlobRegistryRegisterFromStreamParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BlobRegistryRegisterFromStreamParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BlobRegistryRegisterFromStreamParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BlobRegistryRegisterFromStreamParams(elementsOrVersion);
                    {
                        
                    result.contentType = decoder0.readString(8, false);
                    }
                    {
                        
                    result.contentDisposition = decoder0.readString(16, false);
                    }
                    {
                        
                    result.lengthHint = decoder0.readLong(24);
                    }
                    {
                        
                    result.data = decoder0.readConsumerHandle(32, false);
                    }
                    {
                        
                    result.progressClient = decoder0.readAssociatedServiceInterfaceNotSupported(36, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.contentType, 8, false);
            
            encoder0.encode(this.contentDisposition, 16, false);
            
            encoder0.encode(this.lengthHint, 24);
            
            encoder0.encode(this.data, 32, false);
            
            encoder0.encode(this.progressClient, 36, true);
        }
    }



    
    static final class BlobRegistryRegisterFromStreamResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SerializedBlob blob;

        private BlobRegistryRegisterFromStreamResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BlobRegistryRegisterFromStreamResponseParams() {
            this(0);
        }

        public static BlobRegistryRegisterFromStreamResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BlobRegistryRegisterFromStreamResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BlobRegistryRegisterFromStreamResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BlobRegistryRegisterFromStreamResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BlobRegistryRegisterFromStreamResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.blob = SerializedBlob.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.blob, 8, true);
        }
    }

    static class BlobRegistryRegisterFromStreamResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BlobRegistry.RegisterFromStreamResponse mCallback;

        BlobRegistryRegisterFromStreamResponseParamsForwardToCallback(BlobRegistry.RegisterFromStreamResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(REGISTER_FROM_STREAM_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                BlobRegistryRegisterFromStreamResponseParams response = BlobRegistryRegisterFromStreamResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.blob);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BlobRegistryRegisterFromStreamResponseParamsProxyToResponder implements BlobRegistry.RegisterFromStreamResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BlobRegistryRegisterFromStreamResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(SerializedBlob blob) {
            BlobRegistryRegisterFromStreamResponseParams _response = new BlobRegistryRegisterFromStreamResponseParams();

            _response.blob = blob;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    REGISTER_FROM_STREAM_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BlobRegistryGetBlobFromUuidParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<Blob> blob;
        public String uuid;

        private BlobRegistryGetBlobFromUuidParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BlobRegistryGetBlobFromUuidParams() {
            this(0);
        }

        public static BlobRegistryGetBlobFromUuidParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BlobRegistryGetBlobFromUuidParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BlobRegistryGetBlobFromUuidParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BlobRegistryGetBlobFromUuidParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BlobRegistryGetBlobFromUuidParams(elementsOrVersion);
                    {
                        
                    result.blob = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    result.uuid = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.blob, 8, false);
            
            encoder0.encode(this.uuid, 16, false);
        }
    }



    
    static final class BlobRegistryGetBlobFromUuidResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private BlobRegistryGetBlobFromUuidResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BlobRegistryGetBlobFromUuidResponseParams() {
            this(0);
        }

        public static BlobRegistryGetBlobFromUuidResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BlobRegistryGetBlobFromUuidResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BlobRegistryGetBlobFromUuidResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BlobRegistryGetBlobFromUuidResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BlobRegistryGetBlobFromUuidResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class BlobRegistryGetBlobFromUuidResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final BlobRegistry.GetBlobFromUuidResponse mCallback;

        BlobRegistryGetBlobFromUuidResponseParamsForwardToCallback(BlobRegistry.GetBlobFromUuidResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_BLOB_FROM_UUID_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class BlobRegistryGetBlobFromUuidResponseParamsProxyToResponder implements BlobRegistry.GetBlobFromUuidResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        BlobRegistryGetBlobFromUuidResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            BlobRegistryGetBlobFromUuidResponseParams _response = new BlobRegistryGetBlobFromUuidResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_BLOB_FROM_UUID_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class BlobRegistryUrlStoreForOriginParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin origin;
        public com.vccorp.mojo.bindings.AssociatedInterfaceRequestNotSupported urlStore;

        private BlobRegistryUrlStoreForOriginParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public BlobRegistryUrlStoreForOriginParams() {
            this(0);
        }

        public static BlobRegistryUrlStoreForOriginParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static BlobRegistryUrlStoreForOriginParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static BlobRegistryUrlStoreForOriginParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            BlobRegistryUrlStoreForOriginParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new BlobRegistryUrlStoreForOriginParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.urlStore = decoder0.readAssociatedInterfaceRequestNotSupported(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.urlStore, 16, false);
        }
    }



}
