
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/appcache/appcache.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class AppCacheBackend_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<AppCacheBackend, AppCacheBackend.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<AppCacheBackend, AppCacheBackend.Proxy>() {

        @Override
        public String getName() {
            return "blink.mojom.AppCacheBackend";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, AppCacheBackend impl) {
            return new Stub(core, impl);
        }

        @Override
        public AppCacheBackend[] buildArray(int size) {
          return new AppCacheBackend[size];
        }
    };


    private static final int REGISTER_HOST_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements AppCacheBackend.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void registerHost(
com.vccorp.mojo.bindings.InterfaceRequest<AppCacheHost> hostRequest, AppCacheFrontend frontend, int hostId, int renderFrameId) {

            AppCacheBackendRegisterHostParams _message = new AppCacheBackendRegisterHostParams();

            _message.hostRequest = hostRequest;

            _message.frontend = frontend;

            _message.hostId = hostId;

            _message.renderFrameId = renderFrameId;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(REGISTER_HOST_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<AppCacheBackend> {

        Stub(com.vccorp.mojo.system.Core core, AppCacheBackend impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                AppCacheBackend_Internal.MANAGER, messageWithHeader);





                    case REGISTER_HOST_ORDINAL: {

                        AppCacheBackendRegisterHostParams data =
                                AppCacheBackendRegisterHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().registerHost(data.hostRequest, data.frontend, data.hostId, data.renderFrameId);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), AppCacheBackend_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class AppCacheBackendRegisterHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<AppCacheHost> hostRequest;
        public AppCacheFrontend frontend;
        public int hostId;
        public int renderFrameId;

        private AppCacheBackendRegisterHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public AppCacheBackendRegisterHostParams() {
            this(0);
        }

        public static AppCacheBackendRegisterHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static AppCacheBackendRegisterHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static AppCacheBackendRegisterHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            AppCacheBackendRegisterHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new AppCacheBackendRegisterHostParams(elementsOrVersion);
                    {
                        
                    result.hostRequest = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    result.frontend = decoder0.readServiceInterface(12, false, AppCacheFrontend.MANAGER);
                    }
                    {
                        
                    result.hostId = decoder0.readInt(20);
                    }
                    {
                        
                    result.renderFrameId = decoder0.readInt(24);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.hostRequest, 8, false);
            
            encoder0.encode(this.frontend, 12, false, AppCacheFrontend.MANAGER);
            
            encoder0.encode(this.hostId, 20);
            
            encoder0.encode(this.renderFrameId, 24);
        }
    }



}
