
// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by
//     java_cpp_enum.py
// From
//     ../../base/task/task_traits.h

package com.vccorp.base.task;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@IntDef({
    TaskPriority.LOWEST, TaskPriority.BEST_EFFORT, TaskPriority.USER_VISIBLE,
    TaskPriority.USER_BLOCKING, TaskPriority.HIGHEST
})
@Retention(RetentionPolicy.SOURCE)
public @interface TaskPriority {
  /**
   * This will always be equal to the lowest priority available.
   */
  int LOWEST = 0;
  /**
   * This task will only be scheduled when machine resources are available. Once running, it may be
   * descheduled if higher priority work arrives (in this process or another) and its running on a
   * non-critical thread.
   */
  int BEST_EFFORT = 0;
  /**
   * This task affects UI or responsiveness of future user interactions. It is not an immediate
   * response to a user interaction. Examples: - Updating the UI to reflect progress on a long task.
   * - Loading data that might be shown in the UI after a future user interaction.
   */
  int USER_VISIBLE = 1;
  /**
   * This task affects UI immediately after a user interaction. Example: Generating data shown in
   * the UI immediately after a click.
   */
  int USER_BLOCKING = 2;
  /**
   * This will always be equal to the highest priority available.
   */
  int HIGHEST = 2;
}
