/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.display;

import a.b.o.b.a;
import a.b.o.b.b;
import a.b.o.b.c;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;

@JNINamespace(value="ui")
@MainDex
public class DisplayAndroidManager {
    public static DisplayAndroidManager sDisplayAndroidManager;
    public static final int VIRTUAL_DISPLAY_ID_BEGIN = 0x3FFFFFFF;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativePointer;
    public int mMainSdkDisplayId;
    public final SparseArray<a> mIdMap = new SparseArray();
    public DisplayListenerBackend mBackend = new DisplayListenerBackend(null);
    public int mNextVirtualDisplayId = 0x3FFFFFFF;

    public static DisplayAndroidManager getInstance() {
        ThreadUtils.assertOnUiThread();
        if (sDisplayAndroidManager == null) {
            sDisplayAndroidManager = new DisplayAndroidManager();
            sDisplayAndroidManager.initialize();
        }
        return sDisplayAndroidManager;
    }

    public static Display getDefaultDisplayForContext(Context context) {
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
    }

    public static Context getContext() {
        return ContextUtils.sApplicationContext;
    }

    @SuppressLint(value={"NewApi"})
    public static DisplayManager getDisplayManager() {
        return (DisplayManager)ContextUtils.sApplicationContext.getSystemService("display");
    }

    public static void onNativeSideCreated(long l2) {
        DisplayAndroidManager.getInstance().setNativePointer(l2);
    }

    private void initialize() {
        Display display = DisplayAndroidManager.getDisplayManager().getDisplay(0);
        if (display == null) {
            display = DisplayAndroidManager.getDefaultDisplayForContext(ContextUtils.sApplicationContext);
        }
        DisplayAndroidManager displayAndroidManager = this;
        this.mMainSdkDisplayId = display.getDisplayId();
        displayAndroidManager.addDisplay(display);
        displayAndroidManager.mBackend.startListening();
    }

    private void setNativePointer(long l2) {
        DisplayAndroidManager displayAndroidManager = this;
        displayAndroidManager.mNativePointer = l2;
        displayAndroidManager.nativeSetPrimaryDisplayId(displayAndroidManager.mNativePointer, this.mMainSdkDisplayId);
        for (int i2 = 0; i2 < this.mIdMap.size(); ++i2) {
            DisplayAndroidManager displayAndroidManager2 = this;
            displayAndroidManager2.updateDisplayOnNativeSide((a)displayAndroidManager2.mIdMap.valueAt(i2));
        }
    }

    private a addDisplay(Display display) {
        b b2;
        int n2 = display.getDisplayId();
        b b3 = b2;
        b2 = new b(display);
        if (!$assertionsDisabled && this.mIdMap.get(n2) != null) {
            throw new AssertionError();
        }
        b b4 = b3;
        this.mIdMap.put(n2, (Object)b3);
        b4.a(display);
        return b4;
    }

    private int getNextVirtualDisplayId() {
        return this.mNextVirtualDisplayId++;
    }

    private native void nativeUpdateDisplay(long var1, int var3, int var4, int var5, float var6, int var7, int var8, int var9, boolean var10);

    private native void nativeRemoveDisplay(long var1, int var3);

    private native void nativeSetPrimaryDisplayId(long var1, int var3);

    public static /* synthetic */ DisplayManager access$000() {
        return DisplayAndroidManager.getDisplayManager();
    }

    static {
        $assertionsDisabled = DisplayAndroidManager.class.desiredAssertionStatus() ^ true;
    }

    public a getDisplayAndroid(Display display) {
        int n2 = display.getDisplayId();
        a a2 = (a)this.mIdMap.get(n2);
        if (a2 == null) {
            a2 = this.addDisplay(display);
        }
        return a2;
    }

    public c addVirtualDisplay() {
        c c2;
        c c3 = c2;
        c2 = new c(this.getNextVirtualDisplayId());
        if (!$assertionsDisabled && this.mIdMap.get(c3.d) != null) {
            throw new AssertionError();
        }
        this.mIdMap.put(c3.d, (Object)c3);
        this.updateDisplayOnNativeSide(c3);
        return c3;
    }

    public void removeVirtualDisplay(c c2) {
        a a2 = (a)this.mIdMap.get(c2.d);
        if (!$assertionsDisabled && a2 != c2) {
            throw new AssertionError();
        }
        long l2 = this.mNativePointer;
        if (l2 != 0L) {
            this.nativeRemoveDisplay(l2, c2.d);
        }
        this.mIdMap.remove(c2.d);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    public void updateDisplayOnNativeSide(a a2) {
        int n2;
        long l2 = this.mNativePointer;
        if (l2 == 0L) {
            return;
        }
        a a3 = a2;
        int n3 = a3.d;
        Point point = a3.e;
        int n4 = point.x;
        int n5 = point.y;
        float f2 = a3.f;
        int n6 = Integer.MIN_VALUE;
        block6: do {
            switch (n6 == Integer.MIN_VALUE ? a3.i : n6) {
                default: {
                    if (!a.b) throw new AssertionError();
                    n6 = 0;
                    continue block6;
                }
                case 3: {
                    n2 = 270;
                    break;
                }
                case 2: {
                    n2 = 180;
                    break;
                }
                case 1: {
                    n2 = 90;
                    break;
                }
                case 0: {
                    n2 = 0;
                }
            }
            break;
        } while (true);
        a a4 = a2;
        int n7 = a4.g;
        int n8 = a4.h;
        boolean bl = a4.m && a2.n;
        this.nativeUpdateDisplay(l2, n3, n4, n5, f2, n2, n7, n8, bl);
    }

    private class DisplayListenerBackend
    implements DisplayManager.DisplayListener {
        public DisplayListenerBackend() {
        }

        public /* synthetic */ DisplayListenerBackend(1 var2_2) {
        }

        public void startListening() {
            DisplayAndroidManager.getDisplayManager().registerDisplayListener((DisplayManager.DisplayListener)this, null);
        }

        public void onDisplayAdded(int n2) {
        }

        public void onDisplayRemoved(int n2) {
            if (n2 == DisplayAndroidManager.this.mMainSdkDisplayId) {
                return;
            }
            if ((a)DisplayAndroidManager.this.mIdMap.get(n2) == null) {
                return;
            }
            if (DisplayAndroidManager.this.mNativePointer != 0L) {
                DisplayAndroidManager displayAndroidManager = DisplayAndroidManager.this;
                displayAndroidManager.nativeRemoveDisplay(displayAndroidManager.mNativePointer, n2);
            }
            DisplayAndroidManager.this.mIdMap.remove(n2);
        }

        public void onDisplayChanged(int n2) {
            b b2 = (b)((DisplayListenerBackend)((Object)b2)).DisplayAndroidManager.this.mIdMap.get(n2);
            Display display = DisplayAndroidManager.getDisplayManager().getDisplay(n2);
            if (b2 != null && display != null) {
                b2.a(display);
            }
        }
    }
}

