/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import a.b.a.e;
import a.b.l.h;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net")
public class ProxyChangeListener {
    public static final String TAG = "ProxyChangeListener";
    public static boolean sEnabled;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final Looper mLooper = Looper.myLooper();
    public final Handler mHandler = new Handler(this.mLooper);
    public long mNativePtr;
    public ProxyReceiver mProxyReceiver;
    public BroadcastReceiver mRealProxyReceiver;
    public Delegate mDelegate;

    public static void setEnabled(boolean bl) {
        sEnabled = bl;
    }

    public static ProxyChangeListener create() {
        return new ProxyChangeListener();
    }

    public static String getProperty(String string2) {
        return System.getProperty(string2);
    }

    private void proxySettingsChanged(ProxyConfig proxyConfig) {
        long l2;
        this.assertOnThread();
        if (!sEnabled) {
            return;
        }
        Delegate delegate = this.mDelegate;
        if (delegate != null) {
            delegate.proxySettingsChanged();
        }
        if ((l2 = this.mNativePtr) == 0L) {
            return;
        }
        if (proxyConfig != null) {
            this.nativeProxySettingsChangedTo(l2, proxyConfig.mHost, proxyConfig.mPort, proxyConfig.mPacUrl, proxyConfig.mExclusionList);
        } else {
            this.nativeProxySettingsChanged(l2);
        }
    }

    @TargetApi(value=23)
    private ProxyConfig getProxyConfig() {
        Object object = ((ConnectivityManager)ContextUtils.sApplicationContext.getSystemService("connectivity")).getDefaultProxy();
        object = object == null ? ProxyConfig.DIRECT : ProxyConfig.fromProxyInfo((ProxyInfo)object);
        return object;
    }

    private void registerReceiver() {
        IntentFilter intentFilter;
        this.assertOnThread();
        if (!$assertionsDisabled && this.mProxyReceiver != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mRealProxyReceiver != null) {
            throw new AssertionError();
        }
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.intent.action.PROXY_CHANGE");
        this.mProxyReceiver = new ProxyReceiver(null);
        if (Build.VERSION.SDK_INT < 23) {
            ContextUtils.sApplicationContext.registerReceiver((BroadcastReceiver)this.mProxyReceiver, intentFilter2);
        } else {
            ContextUtils.sApplicationContext.registerReceiver((BroadcastReceiver)this.mProxyReceiver, new IntentFilter());
            this.mRealProxyReceiver = new h(this);
            ContextUtils.sApplicationContext.registerReceiver(this.mRealProxyReceiver, intentFilter2);
        }
    }

    private void unregisterReceiver() {
        this.assertOnThread();
        if (!$assertionsDisabled && this.mProxyReceiver == null) {
            throw new AssertionError();
        }
        ContextUtils.sApplicationContext.unregisterReceiver((BroadcastReceiver)this.mProxyReceiver);
        BroadcastReceiver broadcastReceiver = this.mRealProxyReceiver;
        if (broadcastReceiver != null) {
            ContextUtils.sApplicationContext.unregisterReceiver(broadcastReceiver);
        }
        ProxyChangeListener proxyChangeListener = this;
        proxyChangeListener.mProxyReceiver = null;
        proxyChangeListener.mRealProxyReceiver = null;
    }

    private boolean onThread() {
        return this.mLooper == Looper.myLooper();
    }

    private void assertOnThread() {
        if (e.c && !this.onThread()) {
            throw new IllegalStateException("Must be called on ProxyChangeListener thread.");
        }
    }

    private void runOnThread(Runnable runnable) {
        if (this.onThread()) {
            runnable.run();
        } else {
            this.mHandler.post(runnable);
        }
    }

    private native void nativeProxySettingsChangedTo(long var1, String var3, int var4, String var5, String[] var6);

    private native void nativeProxySettingsChanged(long var1);

    public static /* synthetic */ void access$000(ProxyChangeListener proxyChangeListener, Runnable runnable) {
        if (proxyChangeListener.onThread()) {
            runnable.run();
        } else {
            proxyChangeListener.mHandler.post(runnable);
        }
    }

    static {
        $assertionsDisabled = ProxyChangeListener.class.desiredAssertionStatus() ^ true;
        sEnabled = true;
    }

    public void setDelegateForTesting(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public void start(long l2) {
        this.assertOnThread();
        if (!$assertionsDisabled && this.mNativePtr != 0L) {
            throw new AssertionError();
        }
        this.mNativePtr = l2;
        this.registerReceiver();
    }

    public void stop() {
        ProxyChangeListener proxyChangeListener = this;
        proxyChangeListener.assertOnThread();
        proxyChangeListener.mNativePtr = 0L;
        proxyChangeListener.unregisterReceiver();
    }

    public void updateProxyConfigFromConnectivityManager() {
        ProxyChangeListener proxyChangeListener = this;
        proxyChangeListener.runOnThread(() -> {
            ProxyChangeListener proxyChangeListener = this;
            proxyChangeListener.proxySettingsChanged(proxyChangeListener.getProxyConfig());
        });
    }

    private class ProxyReceiver
    extends BroadcastReceiver {
        public ProxyReceiver() {
        }

        /*
         * WARNING - void declaration
         */
        private ProxyConfig extractNewProxy(Intent object) {
            void var0_6;
            String[] stringArray;
            int n2;
            Object object2;
            block21: {
                Object object3;
                block20: {
                    object3 = object.getExtras();
                    if (object3 == null) {
                        return null;
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        return ProxyConfig.fromProxyInfo((ProxyInfo)object3.get("android.intent.extra.PROXY_INFO"));
                    }
                    object3 = object3.get("proxy");
                    if (object3 != null) break block20;
                    return null;
                }
                Class<?> clazz = Class.forName("android.net.ProxyProperties");
                Class<?> clazz2 = object;
                object = object;
                Class<Object> clazz3 = object;
                object2 = clazz.getDeclaredMethod("getHost", new Class[0]);
                Method method = clazz2.getDeclaredMethod("getPort", new Class[0]);
                Method method2 = clazz3.getDeclaredMethod("getExclusionList", new Class[0]);
                object2 = (String)((Method)object2).invoke(object3, new Object[0]);
                n2 = (Integer)method.invoke(object3, new Object[0]);
                String string2 = (String)method2.invoke(object3, new Object[0]);
                stringArray = string2.split(",");
                if (Build.VERSION.SDK_INT < 19) break block21;
                Method method3 = ((Class)object).getDeclaredMethod("getPacFileUrl", new Class[0]);
                object3 = (String)method3.invoke(object3, new Object[0]);
                if (TextUtils.isEmpty((CharSequence)object3)) break block21;
                return new ProxyConfig((String)object2, n2, (String)object3, stringArray);
            }
            try {
                return new ProxyConfig((String)object2, n2, null, stringArray);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Log.e((String)ProxyChangeListener.TAG, (String)("Using no proxy configuration due to exception:" + var0_6));
            return null;
        }

        public /* synthetic */ ProxyReceiver(1 var2_2) {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.PROXY_CHANGE")) {
                ProxyChangeListener.access$000(ProxyChangeListener.this, () -> ProxyChangeListener.this.proxySettingsChanged(this.extractNewProxy(intent)));
            }
        }
    }

    public static interface Delegate {
        public void proxySettingsChanged();
    }

    private static class ProxyConfig {
        public static final ProxyConfig DIRECT;
        public final String mHost;
        public final int mPort;
        public final String mPacUrl;
        public final String[] mExclusionList;

        public ProxyConfig(String string2, int n2, String string3, String[] stringArray) {
            this.mHost = string2;
            this.mPort = n2;
            this.mPacUrl = string3;
            this.mExclusionList = stringArray;
        }

        @TargetApi(value=21)
        public static ProxyConfig fromProxyInfo(ProxyInfo proxyInfo) {
            ProxyConfig proxyConfig;
            if (proxyInfo == null) {
                return null;
            }
            ProxyInfo proxyInfo2 = proxyInfo;
            Object object = proxyInfo2.getPacFileUrl();
            String string2 = proxyInfo2.getHost();
            int n2 = proxyInfo2.getPort();
            object = Uri.EMPTY.equals(object) ? null : object.toString();
            ProxyConfig proxyConfig2 = proxyConfig;
            proxyConfig2(string2, n2, (String)object, proxyInfo.getExclusionList());
            return proxyConfig2;
        }

        public static /* synthetic */ ProxyConfig access$100(ProxyInfo proxyInfo) {
            return ProxyConfig.fromProxyInfo(proxyInfo);
        }

        static {
            String[] stringArray = new String[]{};
            DIRECT = new ProxyConfig("", 0, "", stringArray);
        }
    }
}

