/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import a.b.a.j;
import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.text.TextUtils;
import java.io.IOException;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class HttpNegotiateAuthenticator {
    public static final String TAG = "net_auth";
    public static final /* synthetic */ boolean $assertionsDisabled;
    public Bundle mSpnegoContext;
    public final String mAccountType;

    public HttpNegotiateAuthenticator(String string2) {
        if (!$assertionsDisabled && TextUtils.isEmpty((CharSequence)string2)) {
            throw new AssertionError();
        }
        this.mAccountType = string2;
    }

    public static HttpNegotiateAuthenticator create(String string2) {
        return new HttpNegotiateAuthenticator(string2);
    }

    private void processResult(Bundle bundle, RequestData requestData) {
        int n2;
        this.mSpnegoContext = bundle.getBundle("spnegoContext");
        switch (bundle.getInt("spnegoResult", 1)) {
            default: {
                n2 = -9;
                break;
            }
            case 9: {
                n2 = -329;
                break;
            }
            case 8: {
                n2 = -344;
                break;
            }
            case 7: {
                n2 = -341;
                break;
            }
            case 6: {
                n2 = -339;
                break;
            }
            case 5: {
                n2 = -338;
                break;
            }
            case 4: {
                n2 = -320;
                break;
            }
            case 3: {
                n2 = -342;
                break;
            }
            case 2: {
                n2 = -3;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.nativeSetResult(requestData.nativeResultObject, n2, bundle.getString("authtoken"));
    }

    private void requestTokenWithoutActivity(Context context, RequestData requestData, String[] stringArray) {
        if (objectArray2.lacksPermission(context, "android.permission.GET_ACCOUNTS", true)) {
            Object[] objectArray = objectArray2;
            Object[] objectArray2 = new Object[]{};
            j.b(TAG, "ERR_MISCONFIGURED_AUTH_ENVIRONMENT: GET_ACCOUNTS permission not granted. Aborting authentication.", objectArray2);
            objectArray.nativeSetResult(requestData.nativeResultObject, -343, null);
            return;
        }
        requestData.accountManager.getAccountsByTypeAndFeatures(objectArray2.mAccountType, stringArray, (AccountManagerCallback)(HttpNegotiateAuthenticator)objectArray2.new GetAccountsCallback(requestData), new Handler(ThreadUtils.getUiThreadHandler().getLooper()));
    }

    private void requestTokenWithActivity(Context context, Activity activity, RequestData requestData, String[] stringArray) {
        boolean bl = Build.VERSION.SDK_INT < 23;
        String string2 = bl ? "android.permission.MANAGE_ACCOUNTS" : "android.permission.GET_ACCOUNTS";
        if (objectArray3.lacksPermission(context, string2, bl)) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = string2;
            j.b(TAG, "ERR_MISCONFIGURED_AUTH_ENVIRONMENT: %s permission not granted. Aborting authentication", objectArray3);
            objectArray.nativeSetResult(requestData.nativeResultObject, -343, null);
            return;
        }
        requestData.accountManager.getAuthTokenByFeatures(objectArray3.mAccountType, requestData.authTokenType, stringArray, activity, null, requestData.options, (AccountManagerCallback)(HttpNegotiateAuthenticator)objectArray3.new GetTokenCallback(requestData), new Handler(ThreadUtils.getUiThreadHandler().getLooper()));
    }

    static {
        $assertionsDisabled = HttpNegotiateAuthenticator.class.desiredAssertionStatus() ^ true;
    }

    public void getNextAuthToken(long l2, String string2, String string3, boolean bl) {
        Bundle bundle;
        RequestData requestData;
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        Context context = ContextUtils.sApplicationContext;
        RequestData requestData2 = requestData;
        requestData2();
        requestData2.authTokenType = "SPNEGO:HOSTBASED:" + string2;
        requestData2.accountManager = AccountManager.get((Context)context);
        requestData.nativeResultObject = l2;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "SPNEGO";
        requestData.options = new Bundle();
        if (string3 != null) {
            requestData2.options.putString("incomingAuthToken", string3);
        }
        if ((bundle = this.mSpnegoContext) != null) {
            requestData2.options.putBundle("spnegoContext", bundle);
        }
        requestData2.options.putBoolean("canDelegate", bl);
        bundle = ApplicationStatus.sActivity;
        if (bundle == null) {
            this.requestTokenWithoutActivity(context, requestData2, stringArray2);
        } else {
            this.requestTokenWithActivity(context, (Activity)bundle, requestData2, stringArray2);
        }
    }

    public boolean lacksPermission(Context context, String string2, boolean bl) {
        if (bl && Build.VERSION.SDK_INT >= 23) {
            return false;
        }
        return context.checkPermission(string2, Process.myPid(), Process.myUid()) != 0;
    }

    public native void nativeSetResult(long var1, int var3, String var4);

    public class GetTokenCallback
    implements AccountManagerCallback<Bundle> {
        public final RequestData mRequestData;

        public GetTokenCallback(RequestData requestData) {
            this.mRequestData = requestData;
        }

        /*
         * WARNING - void declaration
         */
        public void run(AccountManagerFuture<Bundle> bundle) {
            void var1_5;
            block5: {
                block4: {
                    try {
                        bundle = (Bundle)bundle.getResult();
                        if (!bundle.containsKey("intent")) break block4;
                        bundle = ContextUtils.sApplicationContext;
                    }
                    catch (IOException iOException) {
                    }
                    catch (AuthenticatorException authenticatorException) {
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        // empty catch block
                    }
                    bundle.registerReceiver(new BroadcastReceiver((Context)bundle){
                        public final /* synthetic */ Context val$appContext;
                        {
                            this.val$appContext = context;
                        }

                        public void onReceive(Context object, Intent intent) {
                            GetTokenCallback getTokenCallback;
                            1 v0 = object2;
                            v0.val$appContext.unregisterReceiver((BroadcastReceiver)object2);
                            object = getTokenCallback;
                            Object object2 = object2.GetTokenCallback.this;
                            getTokenCallback = new GetTokenCallback(((GetTokenCallback)object2).mRequestData);
                            ((GetTokenCallback)v0.GetTokenCallback.this).mRequestData.accountManager.getAuthToken(((GetTokenCallback)object2.GetTokenCallback.this).mRequestData.account, ((GetTokenCallback)object2.GetTokenCallback.this).mRequestData.authTokenType, ((GetTokenCallback)object2.GetTokenCallback.this).mRequestData.options, true, (AccountManagerCallback)object, null);
                        }
                    }, new IntentFilter("android.accounts.LOGIN_ACCOUNTS_CHANGED"));
                    break block5;
                }
                HttpNegotiateAuthenticator.this.processResult(bundle, this.mRequestData);
            }
            return;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = var1_5;
            j.d(HttpNegotiateAuthenticator.TAG, "ERR_UNEXPECTED: Error while attempting to obtain a token.", objectArray2);
            HttpNegotiateAuthenticator.this.nativeSetResult(this.mRequestData.nativeResultObject, -9, null);
        }
    }

    public class GetAccountsCallback
    implements AccountManagerCallback<Account[]> {
        public final RequestData mRequestData;

        public GetAccountsCallback(RequestData requestData) {
            this.mRequestData = requestData;
        }

        /*
         * WARNING - void declaration
         */
        public void run(AccountManagerFuture<Account[]> objectArray) {
            void var1_5;
            block6: {
                try {
                    objectArray = (Account[])objectArray.getResult();
                    if (objectArray.length != 0) break block6;
                }
                catch (IOException iOException) {
                }
                catch (AuthenticatorException authenticatorException) {
                }
                catch (OperationCanceledException operationCanceledException) {
                    // empty catch block
                }
                objectArray = new Object[]{};
                j.d(HttpNegotiateAuthenticator.TAG, "ERR_MISSING_AUTH_CREDENTIALS: No account provided for the kerberos authentication. Please verify the configuration policies and that the CONTACTS runtime permission is granted. ", objectArray);
                HttpNegotiateAuthenticator.this.nativeSetResult(this.mRequestData.nativeResultObject, -341, null);
                return;
            }
            if (objectArray.length > 1) {
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = objectArray.length;
                j.d(HttpNegotiateAuthenticator.TAG, "ERR_MISSING_AUTH_CREDENTIALS: Found %d accounts eligible for the kerberos authentication. Please fix the configuration by providing a single account.", objectArray3);
                HttpNegotiateAuthenticator.this.nativeSetResult(this.mRequestData.nativeResultObject, -341, null);
                return;
            }
            if (HttpNegotiateAuthenticator.this.lacksPermission(ContextUtils.sApplicationContext, "android.permission.USE_CREDENTIALS", true)) {
                objectArray = new Object[]{};
                j.b(HttpNegotiateAuthenticator.TAG, "ERR_MISCONFIGURED_AUTH_ENVIRONMENT: USE_CREDENTIALS permission not granted. Aborting authentication.", objectArray);
                HttpNegotiateAuthenticator.this.nativeSetResult(this.mRequestData.nativeResultObject, -343, null);
                return;
            }
            RequestData requestData = this.mRequestData;
            requestData.account = objectArray[0];
            requestData.accountManager.getAuthToken(requestData.account, requestData.authTokenType, requestData.options, true, (AccountManagerCallback)new GetTokenCallback(requestData), new Handler(ThreadUtils.getUiThreadHandler().getLooper()));
            return;
            Object[] objectArray4 = new Object[1];
            Object[] objectArray5 = objectArray4;
            objectArray4[0] = var1_5;
            j.d(HttpNegotiateAuthenticator.TAG, "ERR_UNEXPECTED: Error while attempting to retrieve accounts.", objectArray5);
            HttpNegotiateAuthenticator.this.nativeSetResult(this.mRequestData.nativeResultObject, -9, null);
        }
    }

    public static class RequestData {
        public long nativeResultObject;
        public AccountManager accountManager;
        public Bundle options;
        public String authTokenType;
        public Account account;
    }
}

