/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import a.b.l.k;
import android.annotation.TargetApi;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.wifi.WifiInfo;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.security.NetworkSecurityPolicy;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.chromium.base.ContextUtils;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.net.AndroidCertVerifyResult;
import org.chromium.net.X509Util;

@MainDex
public class AndroidNetworkLibrary {
    public static final String TAG = "AndroidNetworkLibrary";
    public static Boolean sHaveAccessNetworkState;
    public static final Set<InetAddress> sAutoDohServers;
    public static final Set<String> sAutoDohDotServers;

    public static String getMimeTypeFromExtension(String string2) {
        return URLConnection.guessContentTypeFromName("foo." + string2);
    }

    public static boolean haveOnlyLoopbackAddresses() {
        Enumeration<NetworkInterface> enumeration;
        block6: {
            try {
                enumeration = NetworkInterface.getNetworkInterfaces();
                if (enumeration != null) break block6;
                return false;
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)("could not get network interfaces: " + exception));
                return false;
            }
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            try {
                if (!networkInterface.isUp()) continue;
            }
            catch (SocketException socketException) {
                continue;
            }
            if (networkInterface.isLoopback()) continue;
            return false;
        }
        return true;
    }

    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] byArray, String string2, String string3) {
        try {
            return X509Util.verifyServerCertificates(byArray, string2, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (KeyStoreException keyStoreException) {
            return new AndroidCertVerifyResult(-1);
        }
    }

    public static void addTestRootCertificate(byte[] byArray) {
        X509Util.addTestRootCertificate(byArray);
    }

    public static void clearTestRootCertificates() {
        X509Util.clearTestRootCertificates();
    }

    public static String getNetworkCountryIso() {
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.sApplicationContext.getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getNetworkCountryIso();
    }

    public static String getNetworkOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.sApplicationContext.getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getNetworkOperator();
    }

    public static String getSimOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)ContextUtils.sApplicationContext.getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getSimOperator();
    }

    public static boolean getIsRoaming() {
        NetworkInfo networkInfo = ((ConnectivityManager)ContextUtils.sApplicationContext.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isRoaming();
    }

    @TargetApi(value=23)
    public static boolean getIsCaptivePortal() {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)ContextUtils.sApplicationContext.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        return (connectivityManager = connectivityManager.getNetworkCapabilities(network)) != null && connectivityManager.hasCapability(17);
    }

    public static String getWifiSSID() {
        IntentFilter intentFilter;
        Object object = intentFilter;
        intentFilter = new IntentFilter("android.net.wifi.STATE_CHANGE");
        if ((object = ContextUtils.sApplicationContext.registerReceiver(null, (IntentFilter)object)) != null && (object = (WifiInfo)object.getParcelableExtra("wifiInfo")) != null && (object = object.getSSID()) != null && !((String)object).equals("<unknown ssid>")) {
            return object;
        }
        return "";
    }

    public static boolean isCleartextPermitted(String string2) {
        try {
            return NetworkSecurityPolicyProxy.sInstance.isCleartextTrafficPermitted(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return NetworkSecurityPolicyProxy.sInstance.isCleartextTrafficPermitted();
        }
    }

    public static boolean isPrivateDnsActive(LinkProperties linkProperties) {
        if (Build.VERSION.SDK_INT >= 28 && linkProperties != null) {
            return linkProperties.isPrivateDnsActive();
        }
        return false;
    }

    public static String getPrivateDnsServerName(LinkProperties linkProperties) {
        if (Build.VERSION.SDK_INT >= 28 && linkProperties != null) {
            return linkProperties.getPrivateDnsServerName();
        }
        return null;
    }

    public static boolean haveAccessNetworkState() {
        if (sHaveAccessNetworkState == null) {
            int n2 = Process.myUid();
            sHaveAccessNetworkState = ContextUtils.sApplicationContext.checkPermission("android.permission.ACCESS_NETWORK_STATE", Process.myPid(), n2) == 0;
        }
        return sHaveAccessNetworkState;
    }

    @TargetApi(value=23)
    public static byte[][] getDnsServers() {
        if (!AndroidNetworkLibrary.haveAccessNetworkState()) {
            return new byte[0][0];
        }
        Object object = (ConnectivityManager)ContextUtils.sApplicationContext.getSystemService("connectivity");
        if (object == null) {
            return new byte[0][0];
        }
        Object object2 = object.getActiveNetwork();
        if (object2 == null) {
            return new byte[0][0];
        }
        if ((object = object.getLinkProperties((Network)object2)) == null) {
            return new byte[0][0];
        }
        object2 = object.getDnsServers();
        int n2 = 0;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            if (!sAutoDohServers.contains((InetAddress)iterator.next())) continue;
            n2 = 1;
            break;
        }
        if (AndroidNetworkLibrary.isPrivateDnsActive((LinkProperties)object)) {
            if ((object = AndroidNetworkLibrary.getPrivateDnsServerName((LinkProperties)object)) != null) {
                n2 = sAutoDohDotServers.contains(object.toLowerCase(Locale.US));
            }
            ConnectivityManager connectivityManager = object;
            object = "Net.DNS.Android.DotExplicit";
            boolean bl = connectivityManager != null;
            RecordHistogram.recordBooleanHistogram((String)object, bl);
            RecordHistogram.recordBooleanHistogram("Net.DNS.Android.AutoDohPrivate", n2 != 0);
            return new byte[1][1];
        }
        RecordHistogram.recordBooleanHistogram("Net.DNS.Android.AutoDohPublic", n2 != 0);
        object = new byte[object2.size()][];
        for (n2 = 0; n2 < object2.size(); ++n2) {
            object[n2] = (ConnectivityManager)((InetAddress)object2.get(n2)).getAddress();
        }
        return object;
    }

    public static void tagSocket(int n2, int n3, int n4) {
        FileDescriptor fileDescriptor;
        ParcelFileDescriptor parcelFileDescriptor;
        int n5 = TrafficStats.getThreadStatsTag();
        if (n4 != n5) {
            TrafficStats.setThreadStatsTag((int)n4);
        }
        if (n3 != -1) {
            k.a(n3);
        }
        if (Build.VERSION.SDK_INT < 23) {
            parcelFileDescriptor = null;
            fileDescriptor = SetFileDescriptor.createWithFd(n2);
        } else {
            parcelFileDescriptor = ParcelFileDescriptor.adoptFd((int)n2);
            fileDescriptor = parcelFileDescriptor.getFileDescriptor();
        }
        SocketFd socketFd = new SocketFd(fileDescriptor);
        TrafficStats.tagSocket((Socket)socketFd);
        socketFd.close();
        if (parcelFileDescriptor != null) {
            parcelFileDescriptor.detachFd();
        }
        if (n4 != n5) {
            TrafficStats.setThreadStatsTag((int)n5);
        }
        if (n3 != -1) {
            k.a();
        }
    }

    static {
        Set<InetAddress> set;
        sAutoDohServers = new HashSet<InetAddress>();
        sAutoDohDotServers = new HashSet<String>();
        try {
            set = sAutoDohServers;
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Failed to parse IP addresses", unknownHostException);
        }
        set.add(InetAddress.getByName("8.8.8.8"));
        Set<InetAddress> set2 = sAutoDohServers;
        set2.add(InetAddress.getByName("8.8.4.4"));
        Set<InetAddress> set3 = sAutoDohServers;
        set3.add(InetAddress.getByName("2001:4860:4860::8888"));
        Set<InetAddress> set4 = sAutoDohServers;
        set4.add(InetAddress.getByName("2001:4860:4860::8844"));
        Set<InetAddress> set5 = sAutoDohServers;
        set5.add(InetAddress.getByName("1.1.1.1"));
        Set<InetAddress> set6 = sAutoDohServers;
        set6.add(InetAddress.getByName("1.0.0.1"));
        Set<InetAddress> set7 = sAutoDohServers;
        set7.add(InetAddress.getByName("2606:4700:4700::1111"));
        Set<InetAddress> set8 = sAutoDohServers;
        set8.add(InetAddress.getByName("2606:4700:4700::1001"));
        Set<InetAddress> set9 = sAutoDohServers;
        set9.add(InetAddress.getByName("9.9.9.9"));
        Set<InetAddress> set10 = sAutoDohServers;
        set10.add(InetAddress.getByName("149.112.112.112"));
        Set<InetAddress> set11 = sAutoDohServers;
        set11.add(InetAddress.getByName("2620:fe::fe"));
        Set<InetAddress> set12 = sAutoDohServers;
        set12.add(InetAddress.getByName("2620:fe::9"));
        sAutoDohDotServers.add("dns.google");
        sAutoDohDotServers.add("1dot1dot1dot1.cloudflare-dns.com");
        sAutoDohDotServers.add("cloudflare-dns.com");
        sAutoDohDotServers.add("dns.quad9.net");
    }

    private static class SocketFd
    extends Socket {
        public SocketFd(FileDescriptor fileDescriptor) {
            super(new SocketImplFd(fileDescriptor));
        }

        private static class SocketImplFd
        extends SocketImpl {
            public SocketImplFd(FileDescriptor fileDescriptor) {
                this.fd = fileDescriptor;
            }

            @Override
            public void accept(SocketImpl socketImpl) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            public int available() {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            public void bind(InetAddress inetAddress, int n2) {
                throw new RuntimeException("accept not implemented");
            }

            @Override
            public void close() {
            }

            @Override
            public void connect(InetAddress inetAddress, int n2) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            public void connect(SocketAddress socketAddress, int n2) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            public void connect(String string2, int n2) {
                throw new RuntimeException("connect not implemented");
            }

            @Override
            public void create(boolean bl) {
            }

            @Override
            public InputStream getInputStream() {
                throw new RuntimeException("getInputStream not implemented");
            }

            @Override
            public OutputStream getOutputStream() {
                throw new RuntimeException("getOutputStream not implemented");
            }

            @Override
            public void listen(int n2) {
                throw new RuntimeException("listen not implemented");
            }

            @Override
            public void sendUrgentData(int n2) {
                throw new RuntimeException("sendUrgentData not implemented");
            }

            @Override
            public Object getOption(int n2) {
                throw new RuntimeException("getOption not implemented");
            }

            @Override
            public void setOption(int n2, Object object) {
                throw new RuntimeException("setOption not implemented");
            }
        }
    }

    private static class SetFileDescriptor {
        public static final Method sFileDescriptorSetInt;

        public static FileDescriptor createWithFd(int n2) {
            FileDescriptor fileDescriptor;
            FileDescriptor fileDescriptor2 = fileDescriptor;
            fileDescriptor = new FileDescriptor();
            FileDescriptor fileDescriptor3 = fileDescriptor;
            Method method = sFileDescriptorSetInt;
            Object[] objectArray = new Object[1];
            try {
                objectArray[0] = n2;
                method.invoke((Object)fileDescriptor2, objectArray);
                return fileDescriptor3;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("FileDescriptor.setInt$() failed", illegalAccessException);
            }
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0_2;
            Class<FileDescriptor> clazz = FileDescriptor.class;
            Class[] classArray = new Class[1];
            try {
                classArray[0] = Integer.TYPE;
                sFileDescriptorSetInt = clazz.getMethod("setInt$", classArray);
                return;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            throw new RuntimeException("Unable to get FileDescriptor.setInt$", (Throwable)var0_2);
        }
    }

    public static class NetworkSecurityPolicyProxy {
        public static NetworkSecurityPolicyProxy sInstance = new NetworkSecurityPolicyProxy();

        public static NetworkSecurityPolicyProxy getInstance() {
            return sInstance;
        }

        public static void setInstanceForTesting(NetworkSecurityPolicyProxy networkSecurityPolicyProxy) {
            sInstance = networkSecurityPolicyProxy;
        }

        @TargetApi(value=24)
        public boolean isCleartextTrafficPermitted(String string2) {
            if (Build.VERSION.SDK_INT < 24) {
                return this.isCleartextTrafficPermitted();
            }
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(string2);
        }

        @TargetApi(value=23)
        public boolean isCleartextTrafficPermitted() {
            if (Build.VERSION.SDK_INT < 23) {
                return true;
            }
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
    }
}

