/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="net::android")
public class AndroidCellularSignalStrength {
    public static final AndroidCellularSignalStrength sInstance = new AndroidCellularSignalStrength();
    public volatile int mSignalLevel = Integer.MIN_VALUE;

    public AndroidCellularSignalStrength() {
        HandlerThread handlerThread;
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("AndroidCellularSignalStrength").start();
        new Handler(handlerThread2.getLooper()).post(new Runnable(){

            @Override
            public void run() {
                new CellStateListener(AndroidCellularSignalStrength.this);
            }
        });
    }

    @TargetApi(value=23)
    public static int getSignalStrengthLevel() {
        return AndroidCellularSignalStrength.sInstance.mSignalLevel;
    }

    public static /* synthetic */ int access$002(AndroidCellularSignalStrength androidCellularSignalStrength, int n2) {
        androidCellularSignalStrength.mSignalLevel = n2;
        return n2;
    }

    private class CellStateListener
    extends PhoneStateListener
    implements ApplicationStatus.ApplicationStateListener {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final TelephonyManager mTelephonyManager;
        public final /* synthetic */ AndroidCellularSignalStrength this$0;

        public CellStateListener(AndroidCellularSignalStrength androidCellularSignalStrength) {
            CellStateListener cellStateListener = this;
            cellStateListener.this$0 = androidCellularSignalStrength;
            ThreadUtils.assertOnBackgroundThread();
            cellStateListener.mTelephonyManager = (TelephonyManager)ContextUtils.sApplicationContext.getSystemService("phone");
            if (cellStateListener.mTelephonyManager.getSimState() != 5) {
                return;
            }
            ApplicationStatus.sApplicationStateListeners.a(this);
            this.onApplicationStateChange(ApplicationStatus.getStateForApplication());
        }

        private void register() {
            this.mTelephonyManager.listen((PhoneStateListener)this, 256);
        }

        private void unregister() {
            CellStateListener cellStateListener = this;
            AndroidCellularSignalStrength.access$002(cellStateListener.this$0, Integer.MIN_VALUE);
            cellStateListener.mTelephonyManager.listen((PhoneStateListener)this, 0);
        }

        static {
            $assertionsDisabled = AndroidCellularSignalStrength.class.desiredAssertionStatus() ^ true;
        }

        @TargetApi(value=23)
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            block3: {
                if (ApplicationStatus.getStateForApplication() != 1) {
                    return;
                }
                try {
                    AndroidCellularSignalStrength.access$002(this.this$0, signalStrength.getLevel());
                }
                catch (SecurityException securityException) {
                    AndroidCellularSignalStrength.access$002(this.this$0, Integer.MIN_VALUE);
                    if (!$assertionsDisabled) break block3;
                }
                return;
            }
            throw new AssertionError();
        }

        @Override
        public void onApplicationStateChange(int n2) {
            if (n2 == 1) {
                this.register();
            } else if (n2 == 2) {
                this.unregister();
            }
        }
    }
}

