/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import a.b.j.a.C;
import a.b.j.a.F;
import a.b.j.a.b;
import a.b.j.a.e;
import a.b.j.a.l;
import a.b.j.a.s;
import a.b.j.a.t;
import a.b.j.a.u;
import a.b.j.a.v;
import a.b.j.b.a;
import a.b.j.b.h;
import a.b.j.b.j;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.chromium.mojo.bindings.Struct;

public class Encoder {
    public static final int INITIAL_BUFFER_SIZE = 1024;
    public int mBaseOffset;
    public final EncoderState mEncoderState;

    public Encoder(a a2, int n2) {
        EncoderState encoderState;
        Encoder encoder = this;
        EncoderState encoderState2 = encoderState;
        encoderState2(a2, n2);
        encoder.mEncoderState = encoderState;
        encoder.mBaseOffset = encoderState2.dataEnd;
    }

    public Encoder(EncoderState encoderState) {
        this.mEncoderState = encoderState;
        this.mBaseOffset = encoderState.dataEnd;
    }

    private void encodePointerToNextUnclaimedData(int n2) {
        Encoder encoder = this;
        encoder.encode((long)encoder.mEncoderState.dataEnd - (long)(this.mBaseOffset + n2), n2);
    }

    private Encoder encoderForArray(int n2, int n3, int n4, int n5) {
        if (n5 != -1 && n5 != n3) {
            throw new C("Trying to encode a fixed array of incorrect length.");
        }
        return this.encoderForArrayByTotalSize(n3 * n2, n3, n4);
    }

    private Encoder encoderForArrayByTotalSize(int n2, int n3, int n4) {
        Encoder encoder = this;
        encoder.encodePointerToNextUnclaimedData(n4);
        return encoder.getEncoderAtDataOffset(new l(n2 + 8, n3));
    }

    private void encodeByteArray(byte[] byArray, int n2, int n3) {
        this.encoderForArrayByTotalSize(byArray.length, n2, n3).append(byArray);
    }

    private void append(byte[] byArray) {
        Encoder encoder = this;
        encoder.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        encoder.mEncoderState.byteBuffer.put(byArray);
    }

    private void append(short[] sArray) {
        Encoder encoder = this;
        encoder.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        encoder.mEncoderState.byteBuffer.asShortBuffer().put(sArray);
    }

    private void append(int[] nArray) {
        Encoder encoder = this;
        encoder.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        encoder.mEncoderState.byteBuffer.asIntBuffer().put(nArray);
    }

    private void append(float[] fArray) {
        Encoder encoder = this;
        encoder.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        encoder.mEncoderState.byteBuffer.asFloatBuffer().put(fArray);
    }

    private void append(double[] dArray) {
        Encoder encoder = this;
        encoder.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        encoder.mEncoderState.byteBuffer.asDoubleBuffer().put(dArray);
    }

    private void append(long[] lArray) {
        Encoder encoder = this;
        encoder.mEncoderState.byteBuffer.position(this.mBaseOffset + 8);
        encoder.mEncoderState.byteBuffer.asLongBuffer().put(lArray);
    }

    public v getMessage() {
        Encoder encoder = encoderState2;
        encoder.mEncoderState.byteBuffer.position(0);
        EncoderState encoderState = encoder.mEncoderState;
        encoderState.byteBuffer.limit(encoderState.dataEnd);
        EncoderState encoderState2 = ((Encoder)((Object)encoderState2)).mEncoderState;
        return new v(encoderState2.byteBuffer, encoderState2.handles);
    }

    public Encoder getEncoderAtDataOffset(l l2) {
        Encoder encoder = new Encoder(this.mEncoderState);
        encoder.encode(l2);
        return encoder;
    }

    public void encode(l l2) {
        this.mEncoderState.claimMemory(e.a(l2.a));
        this.encode(l2.a, 0);
        this.encode(l2.b, 4);
    }

    public void encode(byte by, int n2) {
        this.mEncoderState.byteBuffer.put(this.mBaseOffset + n2, by);
    }

    /*
     * WARNING - void declaration
     */
    public void encode(boolean bl, int n2, int n3) {
        if (bl) {
            void var3_4;
            void var2_3;
            Encoder encoder = this;
            byte by = (byte)(encoder.mEncoderState.byteBuffer.get(this.mBaseOffset + var2_3) | (byte)(1 << var3_4));
            encoder.mEncoderState.byteBuffer.put(this.mBaseOffset + var2_3, by);
        }
    }

    public void encode(short s2, int n2) {
        this.mEncoderState.byteBuffer.putShort(this.mBaseOffset + n2, s2);
    }

    public void encode(int n2, int n3) {
        this.mEncoderState.byteBuffer.putInt(this.mBaseOffset + n3, n2);
    }

    public void encode(float f2, int n2) {
        this.mEncoderState.byteBuffer.putFloat(this.mBaseOffset + n2, f2);
    }

    public void encode(long l2, int n2) {
        this.mEncoderState.byteBuffer.putLong(this.mBaseOffset + n2, l2);
    }

    public void encode(double d2, int n2) {
        this.mEncoderState.byteBuffer.putDouble(this.mBaseOffset + n2, d2);
    }

    public void encode(Struct struct, int n2, boolean bl) {
        if (struct == null) {
            this.encodeNullPointer(n2, bl);
            return;
        }
        Encoder encoder = this;
        encoder.encodePointerToNextUnclaimedData(n2);
        struct.encode(encoder);
    }

    public void encode(F f2, int n2, boolean bl) {
        if (f2 == null && !bl) {
            throw new C("Trying to encode a null pointer for a non-nullable type.");
        }
        if (f2 == null) {
            Encoder encoder = this;
            encoder.encode(0L, n2);
            int n3 = n2 + 8;
            encoder.encode(0L, n3);
            return;
        }
        f2.a(this, n2);
    }

    public void encode(String string2, int n2, boolean bl) {
        if (string2 == null) {
            this.encodeNullPointer(n2, bl);
            return;
        }
        this.encode(string2.getBytes(Charset.forName("utf8")), n2, bl ? 1 : 0, -1);
    }

    public void encode(h h2, int n2, boolean bl) {
        if (h2 != null && h2.isValid()) {
            Encoder encoder = this;
            encoder.encode(encoder.mEncoderState.handles.size(), n2);
            encoder.mEncoderState.handles.add(h2);
        } else {
            this.encodeInvalidHandle(n2, bl);
        }
    }

    public <T extends t> void encode(T t2, int n2, boolean bl, t.b<T, ?> b2) {
        if (t2 == null) {
            Encoder encoder = l2;
            encoder.encodeInvalidHandle(n2, bl);
            encoder.encode(0, n2 + 4);
            return;
        }
        a a2 = ((Encoder)((Object)l2)).mEncoderState.core;
        if (a2 != null) {
            a.b.j.b.l<j, j> l2;
            if (t2 instanceof t.c) {
                Encoder encoder = l2;
                l2 = ((t.a)t2).a;
                encoder.encode((j)((s)((Object)((t.a.a)((Object)l2)).b)).c(), n2, bl);
                encoder.encode(((t.a.a)((Object)l2)).d, n2 + 4);
                return;
            }
            Encoder encoder = l2;
            Encoder encoder2 = l2;
            l2 = a2.createMessagePipe(null);
            b2.a(t2, (j)l2.first);
            encoder2.encode((h)l2.second, n2, bl);
            encoder.encode(b2.b(), n2 + 4);
            return;
        }
        throw new UnsupportedOperationException("The encoder has been created without a Core. It can't encode an interface.");
    }

    public <I extends t> void encode(u<I> u2, int n2, boolean bl) {
        if (u2 == null) {
            this.encodeInvalidHandle(n2, bl);
            return;
        }
        if (this.mEncoderState.core != null) {
            this.encode(u2.a.e(), n2, bl);
            return;
        }
        throw new UnsupportedOperationException("The encoder has been created without a Core. It can't encode an interface.");
    }

    public void encode(a.b.j.a.a a2, int n2, boolean bl) {
    }

    public void encode(b b2, int n2, boolean bl) {
    }

    public Encoder encodePointerArray(int n2, int n3, int n4) {
        return this.encoderForArray(8, n2, n3, n4);
    }

    public Encoder encodeUnionArray(int n2, int n3, int n4) {
        return this.encoderForArray(16, n2, n3, n4);
    }

    public void encode(boolean[] blArray, int n2, int n3, int n4) {
        if (blArray == null) {
            this.encodeNullPointer(n2, e.b(n3));
            return;
        }
        if (n4 != -1 && n4 != blArray.length) {
            throw new C("Trying to encode a fixed array of incorrect length.");
        }
        byte[] byArray = new byte[(blArray.length + 7) / 8];
        for (n4 = 0; n4 < byArray.length; ++n4) {
            for (int i2 = 0; i2 < 8; ++i2) {
                int n5 = n4 * 8 + i2;
                if (n5 >= blArray.length || !blArray[n5]) continue;
                byArray[n4] = (byte)(byArray[n4] | (byte)(1 << i2));
            }
        }
        this.encodeByteArray(byArray, blArray.length, n2);
    }

    public void encode(byte[] byArray, int n2, int n3, int n4) {
        if (byArray == null) {
            this.encodeNullPointer(n2, e.b(n3));
            return;
        }
        if (n4 != -1 && n4 != byArray.length) {
            throw new C("Trying to encode a fixed array of incorrect length.");
        }
        this.encodeByteArray(byArray, byArray.length, n2);
    }

    public void encode(short[] sArray, int n2, int n3, int n4) {
        if (sArray == null) {
            this.encodeNullPointer(n2, e.b(n3));
            return;
        }
        this.encoderForArray(2, sArray.length, n2, n4).append(sArray);
    }

    public void encode(int[] nArray, int n2, int n3, int n4) {
        if (nArray == null) {
            this.encodeNullPointer(n2, e.b(n3));
            return;
        }
        this.encoderForArray(4, nArray.length, n2, n4).append(nArray);
    }

    public void encode(float[] fArray, int n2, int n3, int n4) {
        if (fArray == null) {
            this.encodeNullPointer(n2, e.b(n3));
            return;
        }
        this.encoderForArray(4, fArray.length, n2, n4).append(fArray);
    }

    public void encode(long[] lArray, int n2, int n3, int n4) {
        if (lArray == null) {
            this.encodeNullPointer(n2, e.b(n3));
            return;
        }
        this.encoderForArray(8, lArray.length, n2, n4).append(lArray);
    }

    public void encode(double[] dArray, int n2, int n3, int n4) {
        if (dArray == null) {
            this.encodeNullPointer(n2, e.b(n3));
            return;
        }
        this.encoderForArray(8, dArray.length, n2, n4).append(dArray);
    }

    public void encode(h[] hArray, int n2, int n3, int n4) {
        if (hArray == null) {
            encoder.encodeNullPointer(n2, e.b(n3));
            return;
        }
        Encoder encoder = encoder.encoderForArray(4, hArray.length, n2, n4);
        for (n2 = 0; n2 < hArray.length; ++n2) {
            encoder.encode(hArray[n2], n2 * 4 + 8, e.c(n3));
        }
    }

    public <T extends t> void encode(T[] TArray, int n2, int n3, int n4, t.b<T, ?> b2) {
        if (TArray == null) {
            encoder.encodeNullPointer(n2, e.b(n3));
            return;
        }
        Encoder encoder = encoder.encoderForArray(8, TArray.length, n2, n4);
        for (n2 = 0; n2 < TArray.length; ++n2) {
            encoder.encode(TArray[n2], n2 * 8 + 8, e.c(n3), b2);
        }
    }

    public Encoder encoderForMap(int n2) {
        Encoder encoder = this;
        encoder.encodePointerToNextUnclaimedData(n2);
        return encoder.getEncoderAtDataOffset(e.a);
    }

    public Encoder encoderForUnionPointer(int n2) {
        this.encodePointerToNextUnclaimedData(n2);
        Encoder encoder = new Encoder(this.mEncoderState);
        encoder.mEncoderState.claimMemory(16);
        return encoder;
    }

    public <I extends t> void encode(u<I>[] uArray, int n2, int n3, int n4) {
        if (uArray == null) {
            encoder.encodeNullPointer(n2, e.b(n3));
            return;
        }
        Encoder encoder = encoder.encoderForArray(4, uArray.length, n2, n4);
        for (n2 = 0; n2 < uArray.length; ++n2) {
            encoder.encode(uArray[n2], n2 * 4 + 8, e.c(n3));
        }
    }

    public void encode(a.b.j.a.a[] aArray, int n2, int n3, int n4) {
    }

    public void encode(b[] bArray, int n2, int n3, int n4) {
    }

    public void encodeNullPointer(int n2, boolean bl) {
        if (bl) {
            this.mEncoderState.byteBuffer.putLong(this.mBaseOffset + n2, 0L);
            return;
        }
        throw new C("Trying to encode a null pointer for a non-nullable type.");
    }

    public void encodeInvalidHandle(int n2, boolean bl) {
        if (bl) {
            this.mEncoderState.byteBuffer.putInt(this.mBaseOffset + n2, -1);
            return;
        }
        throw new C("Trying to encode an invalid handle for a non-nullable type.");
    }

    public void claimMemory(int n2) {
        this.mEncoderState.claimMemory(e.a(n2));
    }

    private static class EncoderState {
        public static final /* synthetic */ boolean $assertionsDisabled;
        public final a core;
        public ByteBuffer byteBuffer;
        public final List<h> handles = new ArrayList<h>();
        public int dataEnd;

        public EncoderState(a a2, int n2) {
            if (!$assertionsDisabled && n2 % 8 != 0) {
                throw new AssertionError();
            }
            this.core = a2;
            if (n2 <= 0) {
                n2 = 1024;
            }
            this.byteBuffer = ByteBuffer.allocateDirect(n2);
            this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.dataEnd = 0;
        }

        private void growIfNeeded() {
            int n2;
            if (this.byteBuffer.capacity() >= this.dataEnd) {
                return;
            }
            for (n2 = this.byteBuffer.capacity() * 2; n2 < this.dataEnd; n2 *= 2) {
            }
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
            EncoderState encoderState = this;
            byteBuffer.order(ByteOrder.nativeOrder());
            encoderState.byteBuffer.position(0);
            ByteBuffer byteBuffer2 = encoderState.byteBuffer;
            byteBuffer2.limit(byteBuffer2.capacity());
            byteBuffer.put(encoderState.byteBuffer);
            this.byteBuffer = byteBuffer;
        }

        public /* synthetic */ EncoderState(a a2, int n2, 1 var3_3) {
            this(a2, n2);
        }

        static {
            $assertionsDisabled = Encoder.class.desiredAssertionStatus() ^ true;
        }

        public void claimMemory(int n2) {
            EncoderState encoderState = this;
            encoderState.dataEnd += n2;
            encoderState.growIfNeeded();
        }
    }
}

