/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.b.a.j;
import android.annotation.SuppressLint;
import android.media.AudioTrack;
import android.os.Build;
import java.nio.ByteBuffer;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media")
public class AudioTrackOutputStream {
    public static final String TAG = "AudioTrackOutput";
    public static final int CHANNEL_ALIGNMENT = 16;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeAudioTrackOutputStream;
    public Callback mCallback;
    public AudioTrack mAudioTrack;
    public int mBufferSizeInBytes;
    public WorkerThread mWorkerThread;
    public int mLastPlaybackHeadPosition;
    public long mTotalPlayedFrames;
    public long mTotalReadFrames;
    public ByteBuffer mReadBuffer;
    public ByteBuffer mWriteBuffer;
    public int mLeftSize;

    public static AudioTrackOutputStream create() {
        return new AudioTrackOutputStream(null);
    }

    public static AudioTrackOutputStream create(Callback callback) {
        return new AudioTrackOutputStream(callback);
    }

    public AudioTrackOutputStream(Callback callback) {
        this.mCallback = callback;
        if (this.mCallback != null) {
            return;
        }
        this.mCallback = new Callback(){

            @Override
            public int getMinBufferSize(int n2, int n3, int n4) {
                return AudioTrack.getMinBufferSize((int)n2, (int)n3, (int)n4);
            }

            @Override
            public AudioTrack createAudioTrack(int n2, int n3, int n4, int n5, int n6, int n7) {
                return new AudioTrack(n2, n3, n4, n5, n6, n7);
            }

            @Override
            public AudioBufferInfo onMoreData(ByteBuffer byteBuffer, long l2) {
                AudioTrackOutputStream audioTrackOutputStream = AudioTrackOutputStream.this;
                return audioTrackOutputStream.nativeOnMoreData(audioTrackOutputStream.mNativeAudioTrackOutputStream, byteBuffer, l2);
            }

            @Override
            public long getAddress(ByteBuffer byteBuffer) {
                AudioTrackOutputStream audioTrackOutputStream = AudioTrackOutputStream.this;
                return audioTrackOutputStream.nativeGetAddress(audioTrackOutputStream.mNativeAudioTrackOutputStream, byteBuffer);
            }

            @Override
            public void onError() {
                AudioTrackOutputStream audioTrackOutputStream = AudioTrackOutputStream.this;
                audioTrackOutputStream.nativeOnError(audioTrackOutputStream.mNativeAudioTrackOutputStream);
            }
        };
    }

    private int getChannelConfig(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (n2 != 6) {
                        if (n2 != 8) {
                            return 1;
                        }
                        if (Build.VERSION.SDK_INT >= 23) {
                            return 6396;
                        }
                        return 1020;
                    }
                    return 252;
                }
                return 204;
            }
            return 12;
        }
        return 4;
    }

    private ByteBuffer allocateAlignedByteBuffer(int n2, int n3) {
        int n4 = n3 - 1;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + n4);
        int n5 = n3 - (int)(this.mCallback.getAddress(byteBuffer) & (long)n4) & n4;
        byteBuffer.position(n5);
        byteBuffer.limit(n5 + n2);
        return byteBuffer.slice();
    }

    private void readMoreData() {
        AudioBufferInfo audioBufferInfo;
        if (!$assertionsDisabled && this.mNativeAudioTrackOutputStream == 0L) {
            throw new AssertionError();
        }
        AudioTrackOutputStream audioTrackOutputStream = this;
        int n2 = audioTrackOutputStream.mAudioTrack.getPlaybackHeadPosition();
        this.mTotalPlayedFrames += (long)(n2 - this.mLastPlaybackHeadPosition);
        audioTrackOutputStream.mLastPlaybackHeadPosition = n2;
        long l2 = audioTrackOutputStream.mTotalReadFrames - this.mTotalPlayedFrames;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if ((audioBufferInfo = this.mCallback.onMoreData(this.mReadBuffer.duplicate(), l2)) != null && audioBufferInfo.getNumBytes() > 0) {
            AudioTrackOutputStream audioTrackOutputStream2 = this;
            audioTrackOutputStream2.mTotalReadFrames += (long)audioBufferInfo.getNumFrames();
            audioTrackOutputStream2.mWriteBuffer = audioTrackOutputStream2.mReadBuffer.asReadOnlyBuffer();
            this.mLeftSize = audioBufferInfo.getNumBytes();
            return;
        }
    }

    private int writeData() {
        if (objectArray2.mLeftSize == 0) {
            return 0;
        }
        int n2 = objectArray2.writeAudioTrack();
        if (n2 < 0) {
            Object[] objectArray = objectArray2;
            Object[] objectArray2 = new Object[]{};
            j.b(TAG, "AudioTrack.write() failed. Error:" + n2, objectArray2);
            objectArray.mCallback.onError();
            return n2;
        }
        if (!$assertionsDisabled && objectArray2.mLeftSize < n2) {
            throw new AssertionError();
        }
        objectArray2.mLeftSize -= n2;
        return objectArray2.mLeftSize;
    }

    @SuppressLint(value={"NewApi"})
    private int writeAudioTrack() {
        return this.mAudioTrack.write(this.mWriteBuffer, this.mLeftSize, 0);
    }

    private native AudioBufferInfo nativeOnMoreData(long var1, ByteBuffer var3, long var4);

    private native void nativeOnError(long var1);

    private native long nativeGetAddress(long var1, ByteBuffer var3);

    static {
        $assertionsDisabled = AudioTrackOutputStream.class.desiredAssertionStatus() ^ true;
    }

    public boolean open(int n2, int n3, int n4) {
        block8: {
            Callback callback;
            if (!$assertionsDisabled && objectArray3.mAudioTrack != null) {
                throw new AssertionError();
            }
            n2 = objectArray3.getChannelConfig(n2);
            objectArray3.mBufferSizeInBytes = objectArray3.mCallback.getMinBufferSize(n3, n2, n4) * 3;
            try {
                j.a(TAG, "Crate AudioTrack with sample rate:%d, channel:%d, format:%d ", (Object)n3, (Object)n2, (Object)n4);
                callback = objectArray3.mCallback;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = illegalArgumentException;
                j.b(TAG, "Exception creating AudioTrack for playback: ", objectArray2);
                return false;
            }
            int n5 = n3;
            int n6 = n2;
            int n7 = n4;
            int n8 = objectArray3.mBufferSizeInBytes;
            objectArray3.mAudioTrack = callback.createAudioTrack(3, n5, n6, n7, n8, 1);
            if ($assertionsDisabled) break block8;
            if (objectArray3.mAudioTrack != null) break block8;
            throw new AssertionError();
        }
        if (objectArray3.mAudioTrack.getState() == 0) {
            Object[] objectArray = objectArray3;
            Object[] objectArray3 = new Object[]{};
            j.b(TAG, "Cannot create AudioTrack", objectArray3);
            objectArray.mAudioTrack = null;
            return false;
        }
        objectArray3.mLastPlaybackHeadPosition = 0;
        objectArray3.mTotalPlayedFrames = 0L;
        return true;
    }

    public void start(long l2) {
        j.a(TAG, "AudioTrackOutputStream.start()");
        if (this.mWorkerThread != null) {
            return;
        }
        AudioTrackOutputStream audioTrackOutputStream = this;
        audioTrackOutputStream.mNativeAudioTrackOutputStream = l2;
        audioTrackOutputStream.mTotalReadFrames = 0L;
        audioTrackOutputStream.mReadBuffer = audioTrackOutputStream.allocateAlignedByteBuffer(audioTrackOutputStream.mBufferSizeInBytes, 16);
        audioTrackOutputStream.mAudioTrack.play();
        audioTrackOutputStream.mWorkerThread = new WorkerThread();
        audioTrackOutputStream.mWorkerThread.start();
    }

    public void stop() {
        j.a(TAG, "AudioTrackOutputStream.stop()");
        WorkerThread workerThread = this.mWorkerThread;
        if (workerThread != null) {
            AudioTrackOutputStream audioTrackOutputStream = this;
            workerThread.finish();
            try {
                audioTrackOutputStream.mWorkerThread.interrupt();
                audioTrackOutputStream.mWorkerThread.join();
            }
            catch (InterruptedException interruptedException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = interruptedException;
                j.b(TAG, "Exception while waiting for AudioTrack worker thread finished: ", objectArray2);
            }
            catch (SecurityException securityException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = securityException;
                j.b(TAG, "Exception while waiting for AudioTrack worker thread finished: ", objectArray3);
            }
            this.mWorkerThread = null;
        }
        AudioTrackOutputStream audioTrackOutputStream = this;
        audioTrackOutputStream.mAudioTrack.pause();
        audioTrackOutputStream.mAudioTrack.flush();
        audioTrackOutputStream.mLastPlaybackHeadPosition = 0;
        audioTrackOutputStream.mTotalPlayedFrames = 0L;
        audioTrackOutputStream.mNativeAudioTrackOutputStream = 0L;
    }

    public void setVolume(double d2) {
        float f2;
        float f3 = f2 = (float)(d2 * (double)AudioTrack.getMaxVolume());
        this.mAudioTrack.setStereoVolume(f3, f3);
    }

    public void close() {
        j.a(TAG, "AudioTrackOutputStream.close()");
        AudioTrack audioTrack = this.mAudioTrack;
        if (audioTrack != null) {
            audioTrack.release();
            this.mAudioTrack = null;
        }
    }

    public AudioBufferInfo createAudioBufferInfo(int n2, int n3) {
        return new AudioBufferInfo(n2, n3);
    }

    public class WorkerThread
    extends Thread {
        public volatile boolean mDone;

        public void finish() {
            this.mDone = true;
        }

        @Override
        public void run() {
            int n2;
            while (!this.mDone && (n2 = AudioTrackOutputStream.this.writeData()) >= 0) {
                if (n2 > 0) continue;
                AudioTrackOutputStream.this.readMoreData();
            }
        }
    }

    public static interface Callback {
        public int getMinBufferSize(int var1, int var2, int var3);

        public AudioTrack createAudioTrack(int var1, int var2, int var3, int var4, int var5, int var6);

        public AudioBufferInfo onMoreData(ByteBuffer var1, long var2);

        public long getAddress(ByteBuffer var1);

        public void onError();
    }

    public static class AudioBufferInfo {
        public final int mNumFrames;
        public final int mNumBytes;

        public AudioBufferInfo(int n2, int n3) {
            this.mNumFrames = n2;
            this.mNumBytes = n3;
        }

        public int getNumFrames() {
            return this.mNumFrames;
        }

        public int getNumBytes() {
            return this.mNumBytes;
        }
    }
}

