/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import a.b.a.j;
import android.annotation.SuppressLint;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Process;
import java.nio.ByteBuffer;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media")
public class AudioRecordInput {
    public static final String TAG = "cr.media";
    public static final boolean DEBUG = false;
    public static final int HARDWARE_DELAY_MS = 100;
    public final long mNativeAudioRecordInputStream;
    public final int mSampleRate;
    public final int mChannels;
    public final int mBitsPerSample;
    public final boolean mUsePlatformAEC;
    public ByteBuffer mBuffer;
    public AudioRecord mAudioRecord;
    public AudioRecordThread mAudioRecordThread;
    public AcousticEchoCanceler mAEC;

    public static AudioRecordInput createAudioRecordInput(long l2, int n2, int n3, int n4, int n5, boolean bl) {
        return new AudioRecordInput(l2, n2, n3, n4, n5, bl);
    }

    public AudioRecordInput(long l2, int n2, int n3, int n4, int n5, boolean bl) {
        AudioRecordInput audioRecordInput = this;
        this.mNativeAudioRecordInputStream = l2;
        this.mSampleRate = n2;
        this.mChannels = n3;
        this.mBitsPerSample = n4;
        this.mUsePlatformAEC = bl;
        audioRecordInput.mBuffer = ByteBuffer.allocateDirect(n5);
        audioRecordInput.nativeCacheDirectBufferAddress(audioRecordInput.mNativeAudioRecordInputStream, this.mBuffer);
    }

    @SuppressLint(value={"NewApi"})
    private boolean open() {
        int n2;
        Object[] objectArray;
        block13: {
            int n3;
            block16: {
                block15: {
                    block14: {
                        block12: {
                            block11: {
                                if (objectArray.mAudioRecord != null) {
                                    objectArray = new Object[]{};
                                    j.b(TAG, "open() called twice without a close()", objectArray);
                                    return false;
                                }
                                n2 = objectArray.mChannels;
                                if (n2 != 1) break block11;
                                n2 = 16;
                                break block12;
                            }
                            if (n2 != 2) break block13;
                            n2 = 12;
                        }
                        n3 = objectArray.mBitsPerSample;
                        if (n3 != 8) break block14;
                        n3 = 3;
                        break block15;
                    }
                    if (n3 != 16) break block16;
                    n3 = 2;
                }
                int n4 = AudioRecord.getMinBufferSize((int)objectArray.mSampleRate, (int)n2, (int)n3);
                if (n4 < 0) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = n4;
                    j.b(TAG, "getMinBufferSize error: %d", objectArray);
                    return false;
                }
                n4 = Math.max(objectArray.mBuffer.capacity(), n4);
                try {
                    objectArray.mAudioRecord = new AudioRecord(7, objectArray.mSampleRate, n2, n3, n4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Object[] objectArray3 = new Object[1];
                    Object[] objectArray4 = objectArray3;
                    objectArray3[0] = illegalArgumentException;
                    j.b(TAG, "AudioRecord failed", objectArray4);
                    return false;
                }
                if (AcousticEchoCanceler.isAvailable()) {
                    objectArray.mAEC = AcousticEchoCanceler.create((int)objectArray.mAudioRecord.getAudioSessionId());
                    Object[] objectArray5 = objectArray.mAEC;
                    if (objectArray.mAEC == null) {
                        objectArray = new Object[]{};
                        j.b(TAG, "AcousticEchoCanceler.create failed", objectArray);
                        return false;
                    }
                    int n5 = objectArray5.setEnabled(objectArray.mUsePlatformAEC);
                    if (n5 != 0) {
                        Object[] objectArray6 = new Object[1];
                        objectArray5 = objectArray6;
                        objectArray6[0] = n5;
                        j.b(TAG, "setEnabled error: %d", objectArray5);
                        return false;
                    }
                }
                return true;
            }
            Object[] objectArray7 = new Object[1];
            objectArray = objectArray7;
            objectArray7[0] = n3;
            j.b(TAG, "Unsupported bits per sample: %d", objectArray);
            return false;
        }
        Object[] objectArray8 = new Object[1];
        objectArray = objectArray8;
        objectArray8[0] = n2;
        j.b(TAG, "Unsupported number of channels: %d", objectArray);
        return false;
    }

    private void start() {
        if (objectArray.mAudioRecord == null) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "start() called before open().", objectArray);
            return;
        }
        if (objectArray.mAudioRecordThread != null) {
            return;
        }
        objectArray.mAudioRecordThread = (AudioRecordInput)objectArray.new AudioRecordThread(null);
        objectArray.mAudioRecordThread.start();
    }

    private void stop() {
        AudioRecordThread audioRecordThread = this.mAudioRecordThread;
        if (audioRecordThread == null) {
            return;
        }
        audioRecordThread.joinRecordThread();
        this.mAudioRecordThread = null;
    }

    @SuppressLint(value={"NewApi"})
    private void close() {
        if (objectArray.mAudioRecordThread != null) {
            Object[] objectArray = new Object[]{};
            j.b(TAG, "close() called before stop().", objectArray);
            return;
        }
        if (objectArray.mAudioRecord == null) {
            return;
        }
        AcousticEchoCanceler acousticEchoCanceler = objectArray.mAEC;
        if (acousticEchoCanceler != null) {
            acousticEchoCanceler.release();
            objectArray.mAEC = null;
        }
        objectArray.mAudioRecord.release();
        objectArray.mAudioRecord = null;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeOnData(long var1, int var3, int var4);

    private class AudioRecordThread
    extends Thread {
        public volatile boolean mKeepAlive = true;

        public AudioRecordThread() {
        }

        public /* synthetic */ AudioRecordThread(1 var2_2) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            try {
                AudioRecordInput.this.mAudioRecord.startRecording();
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray4 = objectArray;
                objectArray[0] = illegalStateException;
                j.b(AudioRecordInput.TAG, "startRecording failed", objectArray4);
                return;
            }
            while (this.mKeepAlive) {
                int n2 = AudioRecordInput.this.mAudioRecord.read(AudioRecordInput.this.mBuffer, AudioRecordInput.this.mBuffer.capacity());
                if (n2 > 0) {
                    AudioRecordInput audioRecordInput = AudioRecordInput.this;
                    audioRecordInput.nativeOnData(audioRecordInput.mNativeAudioRecordInputStream, n2, 100);
                    continue;
                }
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n2;
                j.b(AudioRecordInput.TAG, "read failed: %d", objectArray2);
                if (n2 != -3) continue;
                this.mKeepAlive = false;
            }
            try {
                AudioRecordInput.this.mAudioRecord.stop();
                return;
            }
            catch (IllegalStateException illegalStateException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = illegalStateException;
                j.b(AudioRecordInput.TAG, "stop failed", objectArray3);
            }
        }

        public void joinRecordThread() {
            this.mKeepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

