/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_shell;

import android.content.Context;
import android.net.ConnectivityManager;
import android.util.Log;
import com.vcc.securitysdk.OnAuthPlayerListener;
import com.vcc.securitysdk.SecureSDK;
import org.chromium.content_shell.ConfigErrorType;
import org.chromium.content_shell.OnConfigListener;
import org.json.JSONObject;

public class SecureManager {
    public static final int NON_PERMISSION = -1;
    public static final int PERMISSION_ACCEPTED = 1;
    public static final int PERMISSION_DENIED = 0;
    public static final String TAG = "SecureManager";
    public static SecureManager secureManager;
    public Context context;
    public String appKey;
    public String secretKey;
    public String playerId;
    public String versionName;
    public int permission = -1;
    public OnConfigListener onConfigListener;
    public boolean isRequest = false;

    public static SecureManager shareInstance() {
        SecureManager secureManager = SecureManager.secureManager;
        if (secureManager == null) {
            SecureManager.secureManager = new SecureManager();
            return SecureManager.secureManager;
        }
        return secureManager;
    }

    private void pushPermissionUnrequest(ConfigErrorType configErrorType, String string2) {
        if (this.getOnConfigListener() == null) {
            Log.e((String)"Player sdk: ", (String)string2);
        } else {
            this.getOnConfigListener().onInitFailed(configErrorType, string2);
        }
    }

    private void reauthPlayer() {
        int n2 = SecureSDK.reauthPlayer((Context)this.context, (String)this.appKey, (String)this.secretKey, (String)this.playerId, (String)this.versionName).getErrorCode();
        if (n2 != 200) {
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    this.permission = 0;
                    break;
                }
                case 0: 
                case 2: 
                case 3: {
                    this.permission = -1;
                    break;
                }
            }
        } else {
            this.permission = 1;
            if (this.getOnConfigListener() != null) {
                this.getOnConfigListener().onInitSuccessfully();
            }
        }
    }

    public static /* synthetic */ boolean access$002(SecureManager secureManager, boolean bl) {
        secureManager.isRequest = bl;
        return bl;
    }

    public static /* synthetic */ int access$102(SecureManager secureManager, int n2) {
        secureManager.permission = n2;
        return n2;
    }

    public int getPermission() {
        return this.permission;
    }

    public void setOnConfigListener(OnConfigListener onConfigListener) {
        this.onConfigListener = onConfigListener;
    }

    public void checkStateSecure(Context context, OnConfigListener onConfigListener) {
        if (secureManager != null) {
            if (this.isRequest) {
                return;
            }
            this.isRequest = true;
            SecureSDK.authPlayer((Context)context, (String)this.appKey, (String)this.secretKey, (String)this.playerId, (String)this.versionName, (OnAuthPlayerListener)new OnAuthPlayerListener(){

                public void onAuthorizing() {
                }

                public void onAuthFailed(int n2, String string2) {
                    1 v0 = this;
                    SecureManager.access$002(v0.SecureManager.this, false);
                    ConfigErrorType configErrorType = ConfigErrorType.CONFIG_PREBUILD;
                    SecureManager.access$102(v0.SecureManager.this, -1);
                    switch (n2) {
                        default: {
                            break;
                        }
                        case 3: {
                            configErrorType = ConfigErrorType.CONFIG_PREBUILD;
                            break;
                        }
                        case 2: {
                            configErrorType = ConfigErrorType.PARAMESTER_REQUIRED;
                            break;
                        }
                        case 1: {
                            SecureManager.access$102(SecureManager.this, 0);
                            configErrorType = ConfigErrorType.PLAYER_AUTHENTICATION;
                            break;
                        }
                        case 0: {
                            configErrorType = ConfigErrorType.MANIFEST_PERMISSION;
                        }
                    }
                    SecureManager.this.pushPermissionUnrequest(configErrorType, string2);
                }

                public void onAuthSuccessfully(int n2, JSONObject jSONObject) {
                    SecureManager.access$002(SecureManager.this, false);
                    if (n2 == -1) {
                        1 v0 = this;
                        SecureManager.access$102(v0.SecureManager.this, -1);
                        if (v0.SecureManager.this.getOnConfigListener() != null) {
                            SecureManager.this.getOnConfigListener().onInitSuccessfully();
                        }
                        return;
                    }
                    SecureManager.access$102(SecureManager.this, 1);
                }
            });
        }
    }

    public OnConfigListener getOnConfigListener() {
        return this.onConfigListener;
    }

    public boolean isAllowUsingBrowser() {
        int n2 = this.permission;
        if (n2 == 0) {
            if (this.getOnConfigListener() != null) {
                this.getOnConfigListener().onInitFailed(ConfigErrorType.PLAYER_AUTHENTICATION, "You haven't permission to player content.");
            } else {
                Log.e((String)TAG, (String)"You haven't permisison to player content. You must register OnConfigListener interface to listen state");
            }
            return false;
        }
        if (n2 == -1) {
            SecureManager secureManager = this;
            if (secureManager.isInternetAvailable(secureManager.getContext())) {
                SecureManager.shareInstance().reauthPlayer();
                return this.getPermission() == 1;
            }
            return true;
        }
        return true;
    }

    public boolean isInternetAvailable(Context context) {
        SecureManager secureManager = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        return secureManager != null && secureManager.isConnectedOrConnecting();
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void configKey(String string2, String string3, String string4, String string5) {
        this.appKey = string2;
        this.secretKey = string3;
        this.playerId = string4;
        this.versionName = string5;
    }
}

