/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_public.browser;

import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public class NavigationHandle {
    public long mNativeNavigationHandleProxy;
    public final boolean mIsInMainFrame;
    public final boolean mIsRendererInitiated;
    public final boolean mIsSameDocument;
    public Integer mPageTransition;
    public String mUrl;
    public boolean mHasCommitted;
    public boolean mIsDownload;
    public boolean mIsErrorPage;
    public boolean mIsFragmentNavigation;
    public boolean mIsValidSearchFormUrl;
    public int mErrorCode;
    public int mHttpStatusCode;

    public NavigationHandle(long l2, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.mNativeNavigationHandleProxy = l2;
        this.mUrl = string2;
        this.mIsInMainFrame = bl;
        this.mIsSameDocument = bl2;
        this.mIsRendererInitiated = bl3;
    }

    private void didRedirect(String string2) {
        this.mUrl = string2;
    }

    private void release() {
        this.mNativeNavigationHandleProxy = 0L;
    }

    public static native void nativeSetRequestHeader(long var0, String var2, String var3);

    public static native void nativeRemoveRequestHeader(long var0, String var2);

    public void didFinish(String object, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, int n3, int n4) {
        this.mUrl = object;
        this.mIsErrorPage = bl;
        this.mHasCommitted = bl2;
        this.mIsFragmentNavigation = bl3;
        this.mIsDownload = bl4;
        this.mIsValidSearchFormUrl = bl5;
        object = n2 == -1 ? null : Integer.valueOf(n2);
        this.mPageTransition = object;
        this.mErrorCode = n3;
        this.mHttpStatusCode = n4;
    }

    public long nativePtr() {
        return this.mNativeNavigationHandleProxy;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean isInMainFrame() {
        return this.mIsInMainFrame;
    }

    public boolean isRendererInitiated() {
        return this.mIsRendererInitiated;
    }

    public boolean isSameDocument() {
        return this.mIsSameDocument;
    }

    public String errorDescription() {
        return "";
    }

    public int errorCode() {
        return this.mErrorCode;
    }

    public boolean hasCommitted() {
        return this.mHasCommitted;
    }

    public int httpStatusCode() {
        return this.mHttpStatusCode;
    }

    public Integer pageTransition() {
        return this.mPageTransition;
    }

    public boolean isFragmentNavigation() {
        return this.mIsFragmentNavigation;
    }

    public boolean isErrorPage() {
        return this.mIsErrorPage;
    }

    public boolean isDownload() {
        return this.mIsDownload;
    }

    public boolean isValidSearchFormUrl() {
        return this.mIsValidSearchFormUrl;
    }

    public void setRequestHeader(String string2, String string3) {
        NavigationHandle.nativeSetRequestHeader(this.mNativeNavigationHandleProxy, string2, string3);
    }

    public void removeRequestHeader(String string2) {
        NavigationHandle.nativeRemoveRequestHeader(this.mNativeNavigationHandleProxy, string2);
    }
}

