/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.androidoverlay;

import a.b.c.b.b.b;
import a.b.c.b.b.f;
import a.b.d.a.z;
import a.b.i.a.d;
import a.b.i.a.e;
import a.b.j.a.t;
import a.b.j.b.k;
import a.b.k.a.a;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.view.Surface;
import android.view.SurfaceHolder;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.PostTask;

@JNINamespace(value="content")
public class DialogOverlayImpl
implements a.b.i.a.a,
b.b {
    public static final String TAG = "DialogOverlayImpl";
    public static final /* synthetic */ boolean $assertionsDisabled;
    public a.b.i.a.b mClient;
    public Handler mOverlayHandler;
    public Runnable mReleasedRunnable;
    public Runnable mReleaseCoreRunnable;
    public final f mHoppingHost;
    public b mDialogCore;
    public long mNativeHandle;
    public int mSurfaceId;
    public boolean mClosed;
    public final int[] mCompositorOffset;

    public DialogOverlayImpl(a.b.i.a.b object, e e2, Handler handler, Runnable runnable, boolean bl) {
        DialogOverlayImpl dialogOverlayImpl = this;
        this.mCompositorOffset = new int[2];
        ThreadUtils.assertOnUiThread();
        this.mClient = object;
        this.mReleasedRunnable = runnable;
        dialogOverlayImpl.mOverlayHandler = handler;
        dialogOverlayImpl.mDialogCore = new b();
        dialogOverlayImpl.mHoppingHost = new f(this);
        object = e2.c;
        long l2 = this.mNativeHandle = this.nativeInit(((a)object).c, ((a)object).d, e2.f);
        if (l2 == 0L) {
            DialogOverlayImpl dialogOverlayImpl2 = this;
            ((d.d)dialogOverlayImpl2.mClient).c();
            dialogOverlayImpl2.cleanup();
            return;
        }
        DialogOverlayImpl dialogOverlayImpl3 = this;
        object = this.mDialogCore;
        Context context = ContextUtils.sApplicationContext;
        dialogOverlayImpl3.nativeGetCompositorOffset(l2, e2.d);
        dialogOverlayImpl3.mOverlayHandler.post(new Runnable((b)object, context, e2, bl){
            public final /* synthetic */ b val$dialogCore;
            public final /* synthetic */ Context val$context;
            public final /* synthetic */ e val$config;
            public final /* synthetic */ boolean val$asPanel;
            {
                this.val$dialogCore = b2;
                this.val$context = context;
                this.val$config = e2;
                this.val$asPanel = bl;
            }

            @Override
            public void run() {
                this.val$dialogCore.a(this.val$context, this.val$config, DialogOverlayImpl.this.mHoppingHost, this.val$asPanel);
                PostTask.postDelayedTask(z.a, new Runnable(){

                    @Override
                    public void run() {
                        if (DialogOverlayImpl.this.mNativeHandle != 0L) {
                            DialogOverlayImpl dialogOverlayImpl = DialogOverlayImpl.this;
                            dialogOverlayImpl.nativeCompleteInit(dialogOverlayImpl.mNativeHandle);
                        }
                    }
                }, 0L);
            }
        });
        dialogOverlayImpl3.mReleaseCoreRunnable = new Runnable((b)object){
            public final /* synthetic */ b val$dialogCore;
            {
                this.val$dialogCore = b2;
            }

            @Override
            public void run() {
                b b2 = this.val$dialogCore;
                b2.a();
                b2.b();
                b2.d.token = null;
                b2.a = null;
            }
        };
    }

    public static void receiveCompositorOffset(a.b.h.a.b b2, int n2, int n3) {
        a.b.h.a.b b3 = b2;
        b3.c += n2;
        b3.d += n3;
    }

    private void sendWindowTokenToCore(final IBinder iBinder) {
        ThreadUtils.assertOnUiThread();
        final b b2 = this.mDialogCore;
        if (b2 != null) {
            this.mOverlayHandler.post(new Runnable(){

                @Override
                public void run() {
                    b b22 = this_.b2;
                    4 this_ = this_.iBinder;
                    b22.a();
                    if (b22.b != null && b22.a != null) {
                        IBinder iBinder2;
                        if (this_ != null && ((iBinder2 = b22.d.token) == null || this_ == iBinder2)) {
                            iBinder2 = b22.d;
                            if (iBinder2.token != this_) {
                                b b3 = b22;
                                iBinder2.token = this_;
                                b3.b.getWindow().setAttributes(b22.d);
                                b3.c = b22.new b.a(null);
                                b3.b.getWindow().takeSurface((SurfaceHolder.Callback2)b22.c);
                                b3.b.show();
                            }
                        } else {
                            b b4 = b22;
                            b4.a.onOverlayDestroyed();
                            b4.a = null;
                            b4.b();
                        }
                    }
                }
            });
        }
    }

    private void onPowerEfficientState(boolean bl) {
        ThreadUtils.assertOnUiThread();
        if (t2.mDialogCore == null) {
            return;
        }
        t t2 = t2.mClient;
        if (t2 == null) {
            return;
        }
        ((d.d)t2).a(bl);
    }

    private void cleanup() {
        long l2;
        ThreadUtils.assertOnUiThread();
        int n2 = this.mSurfaceId;
        if (n2 != 0) {
            DialogOverlayImpl.nativeUnregisterSurface(n2);
            this.mSurfaceId = 0;
        }
        if ((l2 = this.mNativeHandle) != 0L) {
            this.nativeDestroy(l2);
            this.mNativeHandle = 0L;
        }
        this.mDialogCore = null;
        a.b.i.a.b b2 = this.mClient;
        if (b2 != null) {
            b2.close();
        }
        this.mClient = null;
    }

    private native long nativeInit(long var1, long var3, boolean var5);

    private native void nativeCompleteInit(long var1);

    private native void nativeDestroy(long var1);

    private native void nativeGetCompositorOffset(long var1, a.b.h.a.b var3);

    public static native int nativeRegisterSurface(Surface var0);

    public static native void nativeUnregisterSurface(int var0);

    public static native Surface nativeLookupSurfaceForTesting(int var0);

    static {
        $assertionsDisabled = DialogOverlayImpl.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public void close() {
        ThreadUtils.assertOnUiThread();
        if (this.mClosed) {
            return;
        }
        DialogOverlayImpl dialogOverlayImpl = this;
        dialogOverlayImpl.mClosed = true;
        dialogOverlayImpl.mHoppingHost.c.release(1);
        Runnable runnable = dialogOverlayImpl.mReleaseCoreRunnable;
        if (runnable != null) {
            DialogOverlayImpl dialogOverlayImpl2 = this;
            dialogOverlayImpl2.mOverlayHandler.post(runnable);
            dialogOverlayImpl2.mReleaseCoreRunnable = null;
            dialogOverlayImpl2.cleanup();
        }
        this.mReleasedRunnable.run();
    }

    @Override
    public void onConnectionError(k k2) {
        ThreadUtils.assertOnUiThread();
        this.close();
    }

    @Override
    public void scheduleLayout(final a.b.h.a.b b2) {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore == null) {
            return;
        }
        DialogOverlayImpl dialogOverlayImpl = this;
        dialogOverlayImpl.nativeGetCompositorOffset(dialogOverlayImpl.mNativeHandle, b2);
        final b b3 = dialogOverlayImpl.mDialogCore;
        dialogOverlayImpl.mOverlayHandler.post(new Runnable(){

            @Override
            public void run() {
                3 v0 = b22;
                b b22 = v0.b3;
                a.b.h.a.b b32 = v0.b2;
                if (b22.b != null && b22.d.token != null && b22.a(b32)) {
                    b22.b.getWindow().setAttributes(b22.d);
                }
            }
        });
    }

    @Override
    public void onSurfaceReady(Surface surface) {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore != null && this.mClient != null) {
            this.mSurfaceId = DialogOverlayImpl.nativeRegisterSurface(surface);
            long l2 = this.mSurfaceId;
            ((d.d)this.mClient).a(l2);
            return;
        }
    }

    @Override
    public void onOverlayDestroyed() {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore == null) {
            return;
        }
        a.b.i.a.b b2 = this.mClient;
        if (b2 != null) {
            ((d.d)b2).c();
        }
        this.cleanup();
    }

    @Override
    public void waitForClose() {
        if ($assertionsDisabled) {
            return;
        }
        throw new AssertionError((Object)"Not reached");
    }

    @Override
    public void enforceClose() {
        this.close();
    }

    public void onWindowToken(IBinder iBinder) {
        ThreadUtils.assertOnUiThread();
        if (this.mDialogCore == null) {
            return;
        }
        this.sendWindowTokenToCore(iBinder);
    }

    public void onDismissed() {
        ThreadUtils.assertOnUiThread();
        a.b.i.a.b b2 = this.mClient;
        if (b2 != null) {
            ((d.d)b2).c();
        }
        DialogOverlayImpl dialogOverlayImpl = this;
        dialogOverlayImpl.sendWindowTokenToCore(null);
        dialogOverlayImpl.cleanup();
    }
}

