/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import a.b.c.b.o;
import a.b.c.b.w;
import a.b.c.b.y;
import a.b.d.a.B;
import a.b.d.a.a;
import a.b.d.a.b;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Settings;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.accessibility.KitKatWebContentsAccessibility;
import org.chromium.content.browser.accessibility.LollipopWebContentsAccessibility;
import org.chromium.content.browser.accessibility.OWebContentsAccessibility;
import org.chromium.content.browser.accessibility.captioning.CaptioningController;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContents;

@JNINamespace(value="content")
public class WebContentsAccessibilityImpl
extends AccessibilityNodeProvider
implements AccessibilityManager.AccessibilityStateChangeListener,
B,
w,
a.b.a.o {
    public static final int ACTION_COLLAPSE = 524288;
    public static final int ACTION_EXPAND = 262144;
    public static final int ACTION_SET_TEXT = 0x200000;
    public static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static final int WINDOW_CONTENT_CHANGED_DELAY_MS = 500;
    public static final int ACTION_CONTEXT_CLICK = 16908348;
    public static final int ACTION_SHOW_ON_SCREEN = 16908342;
    public static final int ACTION_SCROLL_UP = 16908344;
    public static final int ACTION_SCROLL_DOWN = 16908346;
    public static final int ACTION_SCROLL_LEFT = 16908345;
    public static final int ACTION_SCROLL_RIGHT = 16908347;
    public static final int NO_GRANULARITY_SELECTED = 0;
    public final WebContentsImpl mWebContents;
    public AccessibilityManager mAccessibilityManager;
    public final Context mContext;
    public String mProductVersion;
    public long mNativeObj;
    public Rect mAccessibilityFocusRect;
    public boolean mIsHovering;
    public int mLastHoverId;
    public int mCurrentRootId;
    public int[] mTempLocation;
    public ViewGroup mView;
    public boolean mUserHasTouchExplored;
    public boolean mPendingScrollToMakeNodeVisible;
    public boolean mNotifyFrameInfoInitializedCalled;
    public boolean mAccessibilityEnabledForTesting;
    public int mSelectionGranularity;
    public int mSelectionStartIndex;
    public int mSelectionEndIndex;
    public int mAccessibilityFocusId;
    public int mSelectionNodeId;
    public Runnable mSendWindowContentChangedRunnable;
    public View mAutofillPopupView;
    public CaptioningController mCaptioningController;
    public boolean mNativeAccessibilityAllowed;
    public boolean mShouldFocusOnPageLoad;
    public boolean mIsObscuredByAnotherView;
    public boolean mTouchExplorationEnabled;

    public static WebContentsAccessibilityImpl fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(WebContentsAccessibilityImpl.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public WebContentsAccessibilityImpl(WebContents webContents) {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        this.mLastHoverId = -1;
        this.mTempLocation = new int[2];
        webContentsAccessibilityImpl.mWebContents = (WebContentsImpl)webContents;
        webContentsAccessibilityImpl.mView = webContentsAccessibilityImpl.mWebContents.getViewAndroidDelegate().getContainerView();
        webContentsAccessibilityImpl.mContext = webContentsAccessibilityImpl.mView.getContext();
        webContentsAccessibilityImpl.mProductVersion = webContentsAccessibilityImpl.mWebContents.getProductVersion();
        webContentsAccessibilityImpl.mAccessibilityManager = (AccessibilityManager)webContentsAccessibilityImpl.mContext.getSystemService("accessibility");
        webContentsAccessibilityImpl.mCaptioningController = new CaptioningController(this.mWebContents);
        y.a(webContentsAccessibilityImpl.mWebContents).a(this);
    }

    private boolean isEnabled() {
        boolean bl;
        if (this.isNativeInitialized()) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            bl = webContentsAccessibilityImpl.nativeIsEnabled(webContentsAccessibilityImpl.mNativeObj);
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean isValidMovementGranularity(int n2) {
        return n2 == 1 || n2 == 2 || n2 == 4;
    }

    @TargetApi(value=23)
    private void createVirtualStructure(ViewStructure viewStructure, b b2, boolean n2) {
        Rect rect;
        viewStructure.setClassName(b2.h);
        if (b2.p) {
            viewStructure.setText((CharSequence)b2.g, b2.q, b2.r);
        } else {
            viewStructure.setText((CharSequence)b2.g);
        }
        o o2 = this.mWebContents.getRenderCoordinates();
        int n3 = (int)o2.a(b2.a);
        int n4 = (int)o2.a(b2.b);
        int n5 = (int)o2.a(b2.c);
        int n6 = (int)o2.a(b2.d);
        Rect rect2 = rect;
        rect = new Rect(n3, n4, n3 + n5, n4 + n6);
        if (b2.e) {
            rect2.offset(0, (int)o2.k);
            if (n2 == 0) {
                o o3 = o2;
                o o4 = o2;
                rect2.offset(-((int)o3.a(o3.a)), -((int)o4.a(o4.b)));
            }
        }
        viewStructure.setDimens(rect2.left, rect2.top, 0, 0, n5, n6);
        viewStructure.setChildCount(b2.s.size());
        if (b2.i) {
            b b3 = b2;
            float f2 = o2.a(b2.f);
            int n7 = b3.l;
            n3 = b3.m ? 2 : 0;
            int n8 = n7 | n3;
            n3 = b2.n ? 4 : 0;
            int n9 = n8 | n3;
            n3 = b2.o ? 8 : 0;
            n2 = n9 | n3;
            viewStructure.setTextStyle(f2, b2.j, b2.k, n2);
        }
        for (n2 = 0; n2 < b2.s.size(); ++n2) {
            this.createVirtualStructure(viewStructure.asyncNewChild(n2), b2.s.get(n2), true);
        }
        viewStructure.asyncCommit();
    }

    private boolean onHoverEvent(int n2) {
        if (!this.isAccessibilityEnabled()) {
            return false;
        }
        if (n2 == 10) {
            this.mIsHovering = false;
            n2 = this.mLastHoverId;
            if (n2 != -1) {
                this.sendAccessibilityEvent(n2, 256);
                this.mLastHoverId = -1;
            }
            if (this.mPendingScrollToMakeNodeVisible) {
                WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
                webContentsAccessibilityImpl.nativeScrollToMakeNodeVisible(webContentsAccessibilityImpl.mNativeObj, this.mAccessibilityFocusId);
            }
            this.mPendingScrollToMakeNodeVisible = false;
            return true;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.mIsHovering = true;
        webContentsAccessibilityImpl.mUserHasTouchExplored = true;
        return true;
    }

    private void notifyFrameInfoInitialized() {
        if (this.mNotifyFrameInfoInitializedCalled) {
            return;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.mNotifyFrameInfoInitializedCalled = true;
        webContentsAccessibilityImpl.sendWindowContentChangedOnView();
        if (!webContentsAccessibilityImpl.mShouldFocusOnPageLoad) {
            return;
        }
        int n2 = this.mAccessibilityFocusId;
        if (n2 != -1) {
            this.moveAccessibilityFocusToIdAndRefocusIfNeeded(n2);
        }
    }

    private boolean jumpToElementType(int n2, String string2, boolean bl) {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        if ((n2 = webContentsAccessibilityImpl.nativeFindElementType(webContentsAccessibilityImpl.mNativeObj, n2, string2, bl)) == 0) {
            return false;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
        webContentsAccessibilityImpl2.moveAccessibilityFocusToId(n2);
        webContentsAccessibilityImpl2.nativeScrollToMakeNodeVisible(webContentsAccessibilityImpl2.mNativeObj, this.mAccessibilityFocusId);
        return true;
    }

    private void setGranularityAndUpdateSelection(int n2) {
        this.mSelectionGranularity = n2;
        if (this.mSelectionGranularity == 0) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            webContentsAccessibilityImpl.mSelectionStartIndex = -1;
            webContentsAccessibilityImpl.mSelectionEndIndex = -1;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        if (webContentsAccessibilityImpl.nativeIsEditableText(webContentsAccessibilityImpl.mNativeObj, this.mAccessibilityFocusId)) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
            if (webContentsAccessibilityImpl2.nativeIsFocused(webContentsAccessibilityImpl2.mNativeObj, this.mAccessibilityFocusId)) {
                WebContentsAccessibilityImpl webContentsAccessibilityImpl3 = this;
                webContentsAccessibilityImpl3.mSelectionStartIndex = webContentsAccessibilityImpl3.nativeGetEditableTextSelectionStart(webContentsAccessibilityImpl3.mNativeObj, this.mAccessibilityFocusId);
                webContentsAccessibilityImpl3.mSelectionEndIndex = webContentsAccessibilityImpl3.nativeGetEditableTextSelectionEnd(webContentsAccessibilityImpl3.mNativeObj, this.mAccessibilityFocusId);
            }
        }
    }

    private boolean nextAtGranularity(int n2, boolean bl, int n3) {
        if (n3 != this.mSelectionNodeId) {
            return false;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.setGranularityAndUpdateSelection(n2);
        return webContentsAccessibilityImpl.nativeNextAtGranularity(webContentsAccessibilityImpl.mNativeObj, this.mSelectionGranularity, bl, n3, this.mSelectionStartIndex);
    }

    private boolean previousAtGranularity(int n2, boolean bl, int n3) {
        if (n3 != this.mSelectionNodeId) {
            return false;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.setGranularityAndUpdateSelection(n2);
        return webContentsAccessibilityImpl.nativePreviousAtGranularity(webContentsAccessibilityImpl.mNativeObj, this.mSelectionGranularity, bl, n3, this.mSelectionEndIndex);
    }

    /*
     * Unable to fully structure code
     */
    private void finishGranularityMove(String var1_1, boolean var2_2, int var3_3, int var4_4, boolean var5_5) {
        v0 = this;
        var6_6 = v0.buildAccessibilityEvent(v0.mSelectionNodeId, 8192);
        if (var6_6 == null) {
            return;
        }
        v1 = this;
        var7_7 = v1.buildAccessibilityEvent(v1.mSelectionNodeId, 131072);
        if (var7_7 == null) {
            var6_6.recycle();
            return;
        }
        this.mSelectionEndIndex = var5_5 != false ? var4_4 : var3_3;
        if (!var2_2) {
            this.mSelectionStartIndex = this.mSelectionEndIndex;
        }
        v2 = this;
        if (v2.nativeIsEditableText(v2.mNativeObj, this.mSelectionNodeId)) {
            v3 = this;
            if (v3.nativeIsFocused(v3.mNativeObj, this.mSelectionNodeId)) {
                v4 = this;
                v4.nativeSetSelection(v4.mNativeObj, this.mSelectionNodeId, this.mSelectionStartIndex, this.mSelectionEndIndex);
            }
        }
        var6_6.setFromIndex(this.mSelectionStartIndex);
        var6_6.setToIndex(this.mSelectionStartIndex);
        var6_6.setItemCount(var1_1.length());
        if (!var5_5) ** GOTO lbl-1000
        v5 = this;
        if (v5.nativeIsEditableText(v5.mNativeObj, this.mSelectionNodeId)) {
            var7_7.setFromIndex(var3_3 - 1);
            var7_7.setToIndex(var4_4 - 1);
        } else lbl-1000:
        // 2 sources

        {
            var7_7.setFromIndex(var3_3);
            var7_7.setToIndex(var4_4);
        }
        var7_7.setItemCount(var1_1.length());
        var7_7.setMovementGranularity(this.mSelectionGranularity);
        var7_7.setContentDescription((CharSequence)var1_1);
        if (var5_5) {
            var7_7.setAction(256);
        } else {
            var7_7.setAction(512);
        }
        v6 = this;
        v7 = v6.mView;
        v7.requestSendAccessibilityEvent((View)v7, var6_6);
        v8 = v6.mView;
        v8.requestSendAccessibilityEvent((View)v8, var7_7);
    }

    private boolean scrollForward(int n2) {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        if (webContentsAccessibilityImpl.nativeIsSlider(webContentsAccessibilityImpl.mNativeObj, n2)) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
            return webContentsAccessibilityImpl2.nativeAdjustSlider(webContentsAccessibilityImpl2.mNativeObj, n2, true);
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl3 = this;
        return webContentsAccessibilityImpl3.nativeScroll(webContentsAccessibilityImpl3.mNativeObj, n2, 0);
    }

    private boolean scrollBackward(int n2) {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        if (webContentsAccessibilityImpl.nativeIsSlider(webContentsAccessibilityImpl.mNativeObj, n2)) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
            return webContentsAccessibilityImpl2.nativeAdjustSlider(webContentsAccessibilityImpl2.mNativeObj, n2, false);
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl3 = this;
        return webContentsAccessibilityImpl3.nativeScroll(webContentsAccessibilityImpl3.mNativeObj, n2, 1);
    }

    private boolean moveAccessibilityFocusToId(int n2) {
        int n3 = this.mAccessibilityFocusId;
        if (n2 == n3) {
            return false;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
        webContentsAccessibilityImpl2.nativeMoveAccessibilityFocus(webContentsAccessibilityImpl2.mNativeObj, n3, n2);
        webContentsAccessibilityImpl.mAccessibilityFocusId = n2;
        webContentsAccessibilityImpl.mAccessibilityFocusRect = null;
        webContentsAccessibilityImpl.mSelectionNodeId = webContentsAccessibilityImpl.mAccessibilityFocusId;
        webContentsAccessibilityImpl.mSelectionGranularity = 0;
        webContentsAccessibilityImpl.mSelectionStartIndex = -1;
        webContentsAccessibilityImpl.mSelectionEndIndex = webContentsAccessibilityImpl.nativeGetTextLength(webContentsAccessibilityImpl.mNativeObj, n2);
        if (webContentsAccessibilityImpl.nativeIsAutofillPopupNode(webContentsAccessibilityImpl.mNativeObj, this.mAccessibilityFocusId)) {
            this.mAutofillPopupView.requestFocus();
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl3 = this;
        webContentsAccessibilityImpl3.sendAccessibilityEvent(webContentsAccessibilityImpl3.mAccessibilityFocusId, 32768);
        return true;
    }

    private void moveAccessibilityFocusToIdAndRefocusIfNeeded(int n2) {
        if (n2 == this.mAccessibilityFocusId) {
            this.sendAccessibilityEvent(n2, 65536);
            this.mAccessibilityFocusId = -1;
        }
        this.moveAccessibilityFocusToId(n2);
    }

    private void sendDelayedWindowContentChangedEvent() {
        if (this.mSendWindowContentChangedRunnable != null) {
            return;
        }
        this.mSendWindowContentChangedRunnable = new Runnable(){

            @Override
            public void run() {
                WebContentsAccessibilityImpl.this.sendWindowContentChangedOnView();
            }
        };
        this.mView.postDelayed(this.mSendWindowContentChangedRunnable, 500L);
    }

    private void sendWindowContentChangedOnView() {
        Runnable runnable = this.mSendWindowContentChangedRunnable;
        if (runnable != null) {
            this.mView.removeCallbacks(runnable);
            this.mSendWindowContentChangedRunnable = null;
        }
        this.mView.sendAccessibilityEvent(2048);
    }

    private void sendWindowContentChangedOnVirtualView(int n2) {
        this.sendAccessibilityEvent(n2, 2048);
    }

    private void sendAccessibilityEvent(int n2, int n3) {
        if (n2 == -1) {
            this.mView.sendAccessibilityEvent(n3);
            return;
        }
        AccessibilityEvent accessibilityEvent = this.buildAccessibilityEvent(n2, n3);
        if (accessibilityEvent != null) {
            ViewGroup viewGroup = this.mView;
            viewGroup.requestSendAccessibilityEvent((View)viewGroup, accessibilityEvent);
        }
    }

    private AccessibilityEvent buildAccessibilityEvent(int n2, int n3) {
        if (this.isAccessibilityEnabled() && this.isFrameInfoInitialized()) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            this.mView.postInvalidate();
            AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n3);
            accessibilityEvent.setPackageName((CharSequence)this.mContext.getPackageName());
            accessibilityEvent.setSource((View)this.mView, n2);
            if (!webContentsAccessibilityImpl.nativePopulateAccessibilityEvent(webContentsAccessibilityImpl.mNativeObj, accessibilityEvent, n2, n3)) {
                accessibilityEvent.recycle();
                return null;
            }
            return accessibilityEvent;
        }
        return null;
    }

    private Bundle getOrCreateBundleForAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = (Bundle)accessibilityEvent.getParcelableData();
        if (webContentsAccessibilityImpl == null) {
            Bundle bundle;
            webContentsAccessibilityImpl = bundle;
            accessibilityEvent.setParcelableData((Parcelable)new Bundle());
        }
        return webContentsAccessibilityImpl;
    }

    private AccessibilityNodeInfo createNodeForHost(int n2) {
        Rect rect;
        Rect rect2;
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)webContentsAccessibilityImpl.mView);
        WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
        AccessibilityNodeInfo accessibilityNodeInfo2 = AccessibilityNodeInfo.obtain((View)webContentsAccessibilityImpl2.mView);
        webContentsAccessibilityImpl2.mView.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo2);
        Rect rect3 = rect2 = rect;
        rect3();
        accessibilityNodeInfo2.getBoundsInParent(rect3);
        accessibilityNodeInfo.setBoundsInParent(rect2);
        accessibilityNodeInfo2.getBoundsInScreen(rect2);
        accessibilityNodeInfo.setBoundsInScreen(rect);
        rect2 = webContentsAccessibilityImpl.mView.getParentForAccessibility();
        if (rect2 instanceof View) {
            accessibilityNodeInfo.setParent((View)rect2);
        }
        accessibilityNodeInfo.setVisibleToUser(accessibilityNodeInfo2.isVisibleToUser());
        accessibilityNodeInfo.setEnabled(accessibilityNodeInfo2.isEnabled());
        accessibilityNodeInfo.setPackageName(accessibilityNodeInfo2.getPackageName());
        accessibilityNodeInfo.setClassName(accessibilityNodeInfo2.getClassName());
        if (this.isFrameInfoInitialized()) {
            accessibilityNodeInfo.addChild((View)this.mView, n2);
        }
        return accessibilityNodeInfo;
    }

    private boolean isFrameInfoInitialized() {
        Object object = ((WebContentsAccessibilityImpl)object).mWebContents;
        if (object == null) {
            return true;
        }
        object = ((WebContentsImpl)object).getRenderCoordinates();
        return (double)((o)object).c != 0.0 || (double)((o)object).d != 0.0;
    }

    private void handlePageLoaded(int n2) {
        if (!this.mShouldFocusOnPageLoad) {
            return;
        }
        if (this.mUserHasTouchExplored) {
            return;
        }
        this.moveAccessibilityFocusToIdAndRefocusIfNeeded(n2);
    }

    private void handleFocusChanged(int n2) {
        if (!this.mShouldFocusOnPageLoad && this.mAccessibilityFocusId == -1) {
            return;
        }
        this.sendAccessibilityEvent(n2, 8);
        this.moveAccessibilityFocusToId(n2);
    }

    private void handleCheckStateChanged(int n2) {
        this.sendAccessibilityEvent(n2, 1);
    }

    private void handleClicked(int n2) {
        this.sendAccessibilityEvent(n2, 1);
    }

    private void handleTextSelectionChanged(int n2) {
        this.sendAccessibilityEvent(n2, 8192);
    }

    private void handleEditableTextChanged(int n2) {
        this.sendAccessibilityEvent(n2, 16);
    }

    private void handleSliderChanged(int n2) {
        this.sendAccessibilityEvent(n2, 4);
    }

    private void handleContentChanged(int n2) {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        int n3 = webContentsAccessibilityImpl.nativeGetRootId(webContentsAccessibilityImpl.mNativeObj);
        if (n3 != this.mCurrentRootId) {
            this.mCurrentRootId = n3;
            this.sendWindowContentChangedOnView();
        } else {
            this.sendAccessibilityEvent(n2, 2048);
        }
    }

    private void handleNavigate() {
        this.mAccessibilityFocusId = -1;
        this.mAccessibilityFocusRect = null;
        this.mUserHasTouchExplored = false;
        this.sendWindowContentChangedOnView();
    }

    private void handleScrollPositionChanged(int n2) {
        this.sendAccessibilityEvent(n2, 4096);
    }

    private void handleScrolledToAnchor(int n2) {
        this.moveAccessibilityFocusToId(n2);
    }

    private void handleHover(int n2) {
        if (this.mLastHoverId == n2) {
            return;
        }
        if (!this.mIsHovering) {
            return;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.sendAccessibilityEvent(n2, 128);
        int n3 = webContentsAccessibilityImpl.mLastHoverId;
        if (n3 != -1) {
            this.sendAccessibilityEvent(n3, 256);
        }
        this.mLastHoverId = n2;
    }

    private void announceLiveRegionText(String string2) {
        this.mView.announceForAccessibility((CharSequence)string2);
    }

    private void setAccessibilityNodeInfoParent(AccessibilityNodeInfo accessibilityNodeInfo, int n2) {
        accessibilityNodeInfo.setParent((View)this.mView, n2);
    }

    private void addAccessibilityNodeInfoChild(AccessibilityNodeInfo accessibilityNodeInfo, int n2) {
        accessibilityNodeInfo.addChild((View)this.mView, n2);
    }

    private void setAccessibilityNodeInfoBooleanAttributes(AccessibilityNodeInfo accessibilityNodeInfo, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        AccessibilityNodeInfo accessibilityNodeInfo2 = accessibilityNodeInfo;
        accessibilityNodeInfo.setCheckable(bl);
        accessibilityNodeInfo.setChecked(bl2);
        accessibilityNodeInfo.setClickable(bl3);
        accessibilityNodeInfo.setEnabled(bl4);
        accessibilityNodeInfo.setFocusable(bl5);
        accessibilityNodeInfo.setFocused(bl6);
        accessibilityNodeInfo.setPassword(bl7);
        accessibilityNodeInfo.setScrollable(bl8);
        accessibilityNodeInfo.setSelected(bl9);
        accessibilityNodeInfo2.setVisibleToUser(bl10);
        accessibilityNodeInfo2.setMovementGranularities(7);
        if (this.mAccessibilityFocusId == n2) {
            accessibilityNodeInfo.setAccessibilityFocused(true);
        } else {
            accessibilityNodeInfo.setAccessibilityFocused(false);
        }
    }

    private void addAccessibilityNodeInfoActions(AccessibilityNodeInfo accessibilityNodeInfo, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14) {
        this.addAction(accessibilityNodeInfo, 1024);
        this.addAction(accessibilityNodeInfo, 2048);
        this.addAction(accessibilityNodeInfo, 256);
        this.addAction(accessibilityNodeInfo, 512);
        this.addAction(accessibilityNodeInfo, 16908342);
        this.addAction(accessibilityNodeInfo, 16908348);
        if (bl8 && bl9) {
            this.addAction(accessibilityNodeInfo, 0x200000);
            this.addAction(accessibilityNodeInfo, 32768);
            if (bl14) {
                this.addAction(accessibilityNodeInfo, 131072);
                this.addAction(accessibilityNodeInfo, 65536);
                this.addAction(accessibilityNodeInfo, 16384);
            }
        }
        if (bl) {
            this.addAction(accessibilityNodeInfo, 4096);
        }
        if (bl2) {
            this.addAction(accessibilityNodeInfo, 8192);
        }
        if (bl3) {
            this.addAction(accessibilityNodeInfo, 16908344);
        }
        if (bl4) {
            this.addAction(accessibilityNodeInfo, 16908346);
        }
        if (bl5) {
            this.addAction(accessibilityNodeInfo, 16908345);
        }
        if (bl6) {
            this.addAction(accessibilityNodeInfo, 16908347);
        }
        if (bl10) {
            if (bl11) {
                this.addAction(accessibilityNodeInfo, 2);
            } else {
                this.addAction(accessibilityNodeInfo, 1);
            }
        }
        if (this.mAccessibilityFocusId == n2) {
            this.addAction(accessibilityNodeInfo, 128);
        } else {
            this.addAction(accessibilityNodeInfo, 64);
        }
        if (bl7) {
            this.addAction(accessibilityNodeInfo, 16);
        }
        if (bl12) {
            this.addAction(accessibilityNodeInfo, 262144);
        }
        if (bl13) {
            this.addAction(accessibilityNodeInfo, 524288);
        }
    }

    private void setAccessibilityNodeInfoClassName(AccessibilityNodeInfo accessibilityNodeInfo, String string2) {
        accessibilityNodeInfo.setClassName((CharSequence)string2);
    }

    @SuppressLint(value={"NewApi"})
    private void setAccessibilityNodeInfoText(AccessibilityNodeInfo accessibilityNodeInfo, String string2, boolean bl, boolean bl2, String string3) {
        accessibilityNodeInfo.setText(this.computeText(string2, bl2, string3));
    }

    private void setAccessibilityNodeInfoLocation(AccessibilityNodeInfo accessibilityNodeInfo, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        Rect rect;
        Rect rect2;
        Rect rect3 = rect2;
        rect2 = new Rect(n5, n6, n5 + n7, n6 + n8);
        if (bl) {
            rect3.offset(0, (int)this.mWebContents.getRenderCoordinates().k);
        }
        AccessibilityNodeInfo accessibilityNodeInfo2 = accessibilityNodeInfo;
        accessibilityNodeInfo2.setBoundsInParent(rect3);
        AccessibilityNodeInfo accessibilityNodeInfo3 = accessibilityNodeInfo = rect;
        accessibilityNodeInfo3(n3, n4, n3 + n7, n4 + n8);
        this.convertWebRectToAndroidCoordinates((Rect)accessibilityNodeInfo3);
        accessibilityNodeInfo2.setBoundsInScreen(rect);
        if (n2 == this.mAccessibilityFocusId && n2 != this.mCurrentRootId) {
            Rect rect4 = this.mAccessibilityFocusRect;
            if (rect4 == null) {
                this.mAccessibilityFocusRect = accessibilityNodeInfo;
            } else if (!rect4.equals((Object)accessibilityNodeInfo)) {
                this.mAccessibilityFocusRect = accessibilityNodeInfo;
                this.moveAccessibilityFocusToIdAndRefocusIfNeeded(n2);
            }
        }
    }

    private void setAccessibilityEventBooleanAttributes(AccessibilityEvent accessibilityEvent, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        accessibilityEvent.setChecked(bl);
        accessibilityEvent.setEnabled(bl2);
        accessibilityEvent.setPassword(bl3);
        accessibilityEvent.setScrollable(bl4);
    }

    private void setAccessibilityEventClassName(AccessibilityEvent accessibilityEvent, String string2) {
        accessibilityEvent.setClassName((CharSequence)string2);
    }

    private void setAccessibilityEventListAttributes(AccessibilityEvent accessibilityEvent, int n2, int n3) {
        accessibilityEvent.setCurrentItemIndex(n2);
        accessibilityEvent.setItemCount(n3);
    }

    private void setAccessibilityEventScrollAttributes(AccessibilityEvent accessibilityEvent, int n2, int n3, int n4, int n5) {
        accessibilityEvent.setScrollX(n2);
        accessibilityEvent.setScrollY(n3);
        accessibilityEvent.setMaxScrollX(n4);
        accessibilityEvent.setMaxScrollY(n5);
    }

    private void setAccessibilityEventTextChangedAttrs(AccessibilityEvent accessibilityEvent, int n2, int n3, int n4, String string2, String string3) {
        AccessibilityEvent accessibilityEvent2 = accessibilityEvent;
        accessibilityEvent.setFromIndex(n2);
        accessibilityEvent.setAddedCount(n3);
        accessibilityEvent.setRemovedCount(n4);
        accessibilityEvent2.setBeforeText((CharSequence)string2);
        accessibilityEvent2.getText().add(string3);
    }

    private void setAccessibilityEventSelectionAttrs(AccessibilityEvent accessibilityEvent, int n2, int n3, int n4, String string2) {
        AccessibilityEvent accessibilityEvent2 = accessibilityEvent;
        accessibilityEvent.setFromIndex(n2);
        accessibilityEvent.setToIndex(n3);
        accessibilityEvent2.setItemCount(n4);
        accessibilityEvent2.getText().add(string2);
    }

    private int getAccessibilityServiceEventTypeMask() {
        int n2 = 0;
        Iterator iterator = this.mAccessibilityManager.getEnabledAccessibilityServiceList(-1).iterator();
        while (iterator.hasNext()) {
            n2 |= ((AccessibilityServiceInfo)iterator.next()).eventTypes;
        }
        return n2;
    }

    private int getAccessibilityServiceFeedbackTypeMask() {
        int n2 = 0;
        Iterator iterator = this.mAccessibilityManager.getEnabledAccessibilityServiceList(-1).iterator();
        while (iterator.hasNext()) {
            n2 |= ((AccessibilityServiceInfo)iterator.next()).feedbackType;
        }
        return n2;
    }

    private int getAccessibilityServiceFlagsMask() {
        int n2 = 0;
        Iterator iterator = this.mAccessibilityManager.getEnabledAccessibilityServiceList(-1).iterator();
        while (iterator.hasNext()) {
            n2 |= ((AccessibilityServiceInfo)iterator.next()).flags;
        }
        return n2;
    }

    private native long nativeInit(WebContents var1);

    private native void nativeOnAutofillPopupDisplayed(long var1);

    private native void nativeOnAutofillPopupDismissed(long var1);

    private native int nativeGetIdForElementAfterElementHostingAutofillPopup(long var1);

    private native int nativeGetRootId(long var1);

    private native boolean nativeIsNodeValid(long var1, int var3);

    private native boolean nativeIsAutofillPopupNode(long var1, int var3);

    private native boolean nativeIsEditableText(long var1, int var3);

    private native boolean nativeIsFocused(long var1, int var3);

    private native int nativeGetEditableTextSelectionStart(long var1, int var3);

    private native int nativeGetEditableTextSelectionEnd(long var1, int var3);

    private native boolean nativePopulateAccessibilityNodeInfo(long var1, AccessibilityNodeInfo var3, int var4);

    private native boolean nativePopulateAccessibilityEvent(long var1, AccessibilityEvent var3, int var4, int var5);

    private native void nativeClick(long var1, int var3);

    private native void nativeFocus(long var1, int var3);

    private native void nativeBlur(long var1);

    private native void nativeScrollToMakeNodeVisible(long var1, int var3);

    private native int nativeFindElementType(long var1, int var3, String var4, boolean var5);

    private native void nativeSetTextFieldValue(long var1, int var3, String var4);

    private native void nativeSetSelection(long var1, int var3, int var4, int var5);

    private native boolean nativeNextAtGranularity(long var1, int var3, boolean var4, int var5, int var6);

    private native boolean nativePreviousAtGranularity(long var1, int var3, boolean var4, int var5, int var6);

    private native boolean nativeAdjustSlider(long var1, int var3, boolean var4);

    private native void nativeMoveAccessibilityFocus(long var1, int var3, int var4);

    private native boolean nativeIsSlider(long var1, int var3);

    private native boolean nativeScroll(long var1, int var3, int var4);

    private native void nativeShowContextMenu(long var1, int var3);

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1);

    private native int nativeGetTextLength(long var1, int var3);

    public void onNativeInit() {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.mAccessibilityFocusId = -1;
        webContentsAccessibilityImpl.mSelectionNodeId = -1;
        webContentsAccessibilityImpl.mIsHovering = false;
        webContentsAccessibilityImpl.mCurrentRootId = -1;
    }

    public void onNativeObjectDestroyed() {
        this.mNativeObj = 0L;
    }

    public boolean isNativeInitialized() {
        return this.mNativeObj != 0L;
    }

    public void setAccessibilityEnabledForTesting() {
        this.mAccessibilityEnabledForTesting = true;
    }

    @Override
    public void onDetachedFromWindow() {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.mAccessibilityManager.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
        webContentsAccessibilityImpl.mCaptioningController.stopListening();
    }

    @Override
    public void onAttachedToWindow() {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.mAccessibilityManager.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
        webContentsAccessibilityImpl.refreshState();
        webContentsAccessibilityImpl.mCaptioningController.startListening();
    }

    public void refreshState() {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        webContentsAccessibilityImpl.setState(webContentsAccessibilityImpl.mAccessibilityManager.isEnabled());
    }

    @Override
    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mIsObscuredByAnotherView) {
            return null;
        }
        if (!this.isNativeInitialized()) {
            if (!this.mNativeAccessibilityAllowed) {
                return null;
            }
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            webContentsAccessibilityImpl.mNativeObj = webContentsAccessibilityImpl.nativeInit(webContentsAccessibilityImpl.mWebContents);
            webContentsAccessibilityImpl.onNativeInit();
        }
        if (!this.isEnabled()) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            webContentsAccessibilityImpl.nativeEnable(webContentsAccessibilityImpl.mNativeObj);
            return null;
        }
        return this;
    }

    public AccessibilityNodeInfo createAccessibilityNodeInfo(int n2) {
        if (!this.isAccessibilityEnabled()) {
            return null;
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
        int n3 = webContentsAccessibilityImpl.nativeGetRootId(webContentsAccessibilityImpl.mNativeObj);
        if (n2 == -1) {
            return this.createNodeForHost(n3);
        }
        if (!this.isFrameInfoInitialized()) {
            return null;
        }
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)this.mView);
        accessibilityNodeInfo.setPackageName((CharSequence)this.mContext.getPackageName());
        accessibilityNodeInfo.setSource((View)this.mView, n2);
        if (n2 == n3) {
            accessibilityNodeInfo.setParent((View)this.mView);
        }
        WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
        if (webContentsAccessibilityImpl2.nativePopulateAccessibilityNodeInfo(webContentsAccessibilityImpl2.mNativeObj, accessibilityNodeInfo, n2)) {
            return accessibilityNodeInfo;
        }
        accessibilityNodeInfo.recycle();
        return null;
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String string2, int n2) {
        return new ArrayList<AccessibilityNodeInfo>();
    }

    public void onAccessibilityStateChanged(boolean bl) {
        this.setState(bl);
    }

    public void setObscuredByAnotherView(boolean bl) {
        if (bl != this.mIsObscuredByAnotherView) {
            this.mIsObscuredByAnotherView = bl;
            this.mView.sendAccessibilityEvent(2048);
        }
    }

    @Override
    public boolean isTouchExplorationEnabled() {
        return this.mTouchExplorationEnabled;
    }

    public void setState(boolean bl) {
        if (!bl) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            webContentsAccessibilityImpl.mNativeAccessibilityAllowed = false;
            webContentsAccessibilityImpl.mTouchExplorationEnabled = false;
        } else {
            this.mNativeAccessibilityAllowed = true;
            this.mTouchExplorationEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        }
    }

    public void setShouldFocusOnPageLoad(boolean bl) {
        this.mShouldFocusOnPageLoad = bl;
    }

    @Override
    public boolean supportsAction(int n2) {
        return false;
    }

    @Override
    public boolean performAction(int n2, Bundle bundle) {
        return false;
    }

    @Override
    @TargetApi(value=23)
    public void onProvideVirtualStructure(final ViewStructure viewStructure, final boolean bl) {
        if (this.mWebContents.isIncognito()) {
            viewStructure.setChildCount(0);
            return;
        }
        ViewStructure viewStructure2 = viewStructure;
        viewStructure2.setChildCount(1);
        viewStructure = viewStructure2.asyncNewChild(0);
        this.mWebContents.requestAccessibilitySnapshot(new a(){

            @Override
            public void onAccessibilitySnapshot(b b2) {
                1 v0 = this;
                v0.viewStructure.setClassName("");
                v0.viewStructure.setHint((CharSequence)WebContentsAccessibilityImpl.this.mProductVersion);
                if (b2 == null) {
                    viewStructure.asyncCommit();
                    return;
                }
                WebContentsAccessibilityImpl.this.createVirtualStructure(viewStructure, b2, bl);
            }
        });
    }

    public boolean performAction(int n2, int n3, Bundle bundle) {
        if (((WebContentsAccessibilityImpl)w4).isAccessibilityEnabled()) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = w4;
            if (webContentsAccessibilityImpl.nativeIsNodeValid(webContentsAccessibilityImpl.mNativeObj, n2)) {
                if (n3 != 1) {
                    if (n3 != 2) {
                        switch (n3) {
                            default: {
                                switch (n3) {
                                    default: {
                                        return false;
                                    }
                                    case 16908348: {
                                        WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = w4;
                                        webContentsAccessibilityImpl2.nativeShowContextMenu(webContentsAccessibilityImpl2.mNativeObj, n2);
                                        return true;
                                    }
                                    case 16908347: {
                                        WebContentsAccessibilityImpl webContentsAccessibilityImpl3 = w4;
                                        return webContentsAccessibilityImpl3.nativeScroll(webContentsAccessibilityImpl3.mNativeObj, n2, 5);
                                    }
                                    case 16908346: {
                                        WebContentsAccessibilityImpl webContentsAccessibilityImpl4 = w4;
                                        return webContentsAccessibilityImpl4.nativeScroll(webContentsAccessibilityImpl4.mNativeObj, n2, 3);
                                    }
                                    case 16908345: {
                                        WebContentsAccessibilityImpl webContentsAccessibilityImpl5 = w4;
                                        return webContentsAccessibilityImpl5.nativeScroll(webContentsAccessibilityImpl5.mNativeObj, n2, 4);
                                    }
                                    case 16908344: 
                                }
                                WebContentsAccessibilityImpl webContentsAccessibilityImpl6 = w4;
                                return webContentsAccessibilityImpl6.nativeScroll(webContentsAccessibilityImpl6.mNativeObj, n2, 2);
                            }
                            case 16908342: {
                                WebContentsAccessibilityImpl webContentsAccessibilityImpl7 = w4;
                                webContentsAccessibilityImpl7.nativeScrollToMakeNodeVisible(webContentsAccessibilityImpl7.mNativeObj, n2);
                                return true;
                            }
                            case 0x200000: {
                                WebContentsAccessibilityImpl webContentsAccessibilityImpl8 = w4;
                                if (!webContentsAccessibilityImpl8.nativeIsEditableText(webContentsAccessibilityImpl8.mNativeObj, n2)) {
                                    return false;
                                }
                                if (bundle == null) {
                                    return false;
                                }
                                String string2 = bundle.getString(ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE);
                                if (string2 == null) {
                                    return false;
                                }
                                w w2 = w4;
                                super.nativeSetTextFieldValue(((WebContentsAccessibilityImpl)w2).mNativeObj, n2, string2);
                                super.nativeSetSelection(((WebContentsAccessibilityImpl)w2).mNativeObj, n2, string2.length(), string2.length());
                                return true;
                            }
                            case 262144: 
                            case 524288: {
                                WebContentsAccessibilityImpl webContentsAccessibilityImpl9 = w4;
                                webContentsAccessibilityImpl9.nativeClick(webContentsAccessibilityImpl9.mNativeObj, n2);
                                return true;
                            }
                            case 131072: {
                                WebContentsAccessibilityImpl webContentsAccessibilityImpl10 = w4;
                                if (!webContentsAccessibilityImpl10.nativeIsEditableText(webContentsAccessibilityImpl10.mNativeObj, n2)) {
                                    return false;
                                }
                                n3 = 0;
                                int n4 = 0;
                                if (bundle != null) {
                                    Bundle bundle2 = bundle;
                                    n3 = bundle2.getInt("ACTION_ARGUMENT_SELECTION_START_INT");
                                    n4 = bundle2.getInt("ACTION_ARGUMENT_SELECTION_END_INT");
                                }
                                w w3 = w4;
                                super.nativeSetSelection(((WebContentsAccessibilityImpl)w3).mNativeObj, n2, n3, n4);
                                return true;
                            }
                            case 65536: {
                                w w4 = ((WebContentsAccessibilityImpl)w4).mWebContents;
                                if (w4 != null) {
                                    ((WebContentsImpl)w4).cut();
                                    return true;
                                }
                                return false;
                            }
                            case 32768: {
                                w w4 = ((WebContentsAccessibilityImpl)w4).mWebContents;
                                if (w4 != null) {
                                    ((WebContentsImpl)w4).paste();
                                    return true;
                                }
                                return false;
                            }
                            case 16384: {
                                w w4 = ((WebContentsAccessibilityImpl)w4).mWebContents;
                                if (w4 != null) {
                                    ((WebContentsImpl)w4).copy();
                                    return true;
                                }
                                return false;
                            }
                            case 8192: {
                                return ((WebContentsAccessibilityImpl)w4).scrollBackward(n2);
                            }
                            case 4096: {
                                return ((WebContentsAccessibilityImpl)w4).scrollForward(n2);
                            }
                            case 2048: {
                                if (bundle == null) {
                                    return false;
                                }
                                String string3 = bundle.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                                if (string3 == null) {
                                    return false;
                                }
                                return super.jumpToElementType(n2, string3.toUpperCase(Locale.US), false);
                            }
                            case 1024: {
                                if (bundle == null) {
                                    return false;
                                }
                                String string4 = bundle.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                                if (string4 == null) {
                                    return false;
                                }
                                return super.jumpToElementType(n2, string4.toUpperCase(Locale.US), true);
                            }
                            case 512: {
                                if (bundle == null) {
                                    return false;
                                }
                                Bundle bundle3 = bundle;
                                n3 = bundle3.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                                boolean bl = bundle3.getBoolean("ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN");
                                if (!WebContentsAccessibilityImpl.isValidMovementGranularity(n3)) {
                                    return false;
                                }
                                return super.previousAtGranularity(n3, bl, n2);
                            }
                            case 256: {
                                if (bundle == null) {
                                    return false;
                                }
                                Bundle bundle4 = bundle;
                                n3 = bundle4.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                                boolean bl = bundle4.getBoolean("ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN");
                                if (!WebContentsAccessibilityImpl.isValidMovementGranularity(n3)) {
                                    return false;
                                }
                                return super.nextAtGranularity(n3, bl, n2);
                            }
                            case 128: {
                                WebContentsAccessibilityImpl webContentsAccessibilityImpl11 = w4;
                                webContentsAccessibilityImpl11.sendAccessibilityEvent(n2, 65536);
                                n3 = webContentsAccessibilityImpl11.mAccessibilityFocusId;
                                if (n3 == n2) {
                                    w w5 = w4;
                                    super.nativeMoveAccessibilityFocus(((WebContentsAccessibilityImpl)w5).mNativeObj, n3, -1);
                                    ((WebContentsAccessibilityImpl)w5).mAccessibilityFocusId = -1;
                                    ((WebContentsAccessibilityImpl)w5).mAccessibilityFocusRect = null;
                                }
                                return true;
                            }
                            case 64: {
                                if (!((WebContentsAccessibilityImpl)w4).moveAccessibilityFocusToId(n2)) {
                                    return true;
                                }
                                if (!((WebContentsAccessibilityImpl)w4).mIsHovering) {
                                    w w6 = w4;
                                    super.nativeScrollToMakeNodeVisible(((WebContentsAccessibilityImpl)w6).mNativeObj, ((WebContentsAccessibilityImpl)w4).mAccessibilityFocusId);
                                } else {
                                    ((WebContentsAccessibilityImpl)w4).mPendingScrollToMakeNodeVisible = true;
                                }
                                return true;
                            }
                            case 16: 
                        }
                        if (!((WebContentsAccessibilityImpl)w4).mView.hasFocus()) {
                            ((WebContentsAccessibilityImpl)w4).mView.requestFocus();
                        }
                        w w7 = w4;
                        super.nativeClick(((WebContentsAccessibilityImpl)w7).mNativeObj, n2);
                        return true;
                    }
                    WebContentsAccessibilityImpl webContentsAccessibilityImpl12 = w4;
                    webContentsAccessibilityImpl12.nativeBlur(webContentsAccessibilityImpl12.mNativeObj);
                    return true;
                }
                if (!((WebContentsAccessibilityImpl)w4).mView.hasFocus()) {
                    ((WebContentsAccessibilityImpl)w4).mView.requestFocus();
                }
                WebContentsAccessibilityImpl webContentsAccessibilityImpl13 = w4;
                webContentsAccessibilityImpl13.nativeFocus(webContentsAccessibilityImpl13.mNativeObj, n2);
                return true;
            }
        }
        return false;
    }

    public void onAutofillPopupDisplayed(View view) {
        if (this.isAccessibilityEnabled()) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            webContentsAccessibilityImpl.mAutofillPopupView = view;
            webContentsAccessibilityImpl.nativeOnAutofillPopupDisplayed(webContentsAccessibilityImpl.mNativeObj);
        }
    }

    public void onAutofillPopupDismissed() {
        if (this.isAccessibilityEnabled()) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            webContentsAccessibilityImpl.nativeOnAutofillPopupDismissed(webContentsAccessibilityImpl.mNativeObj);
            webContentsAccessibilityImpl.mAutofillPopupView = null;
        }
    }

    public void onAutofillPopupAccessibilityFocusCleared() {
        if (this.isAccessibilityEnabled()) {
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = this;
            int n2 = webContentsAccessibilityImpl.nativeGetIdForElementAfterElementHostingAutofillPopup(webContentsAccessibilityImpl.mNativeObj);
            if (n2 == 0) {
                return;
            }
            WebContentsAccessibilityImpl webContentsAccessibilityImpl2 = this;
            webContentsAccessibilityImpl2.moveAccessibilityFocusToId(n2);
            webContentsAccessibilityImpl2.nativeScrollToMakeNodeVisible(webContentsAccessibilityImpl2.mNativeObj, this.mAccessibilityFocusId);
        }
    }

    public boolean isAccessibilityEnabled() {
        return this.isNativeInitialized() && (this.mAccessibilityEnabledForTesting || this.mAccessibilityManager.isEnabled());
    }

    public void addAction(AccessibilityNodeInfo accessibilityNodeInfo, int n2) {
        if (n2 > 0x200000) {
            return;
        }
        accessibilityNodeInfo.addAction(n2);
    }

    public CharSequence computeText(String string2, boolean bl, String string3) {
        if (bl) {
            SpannableString spannableString;
            WebContentsAccessibilityImpl webContentsAccessibilityImpl = spannableString;
            new SpannableString((CharSequence)string2).setSpan((Object)new URLSpan(""), 0, webContentsAccessibilityImpl.length(), 0);
            return webContentsAccessibilityImpl;
        }
        return string2;
    }

    public void convertWebRectToAndroidCoordinates(Rect rect) {
        o o2 = this.mWebContents.getRenderCoordinates();
        Rect rect2 = rect;
        rect2.offset(-((int)o2.a), -((int)o2.b));
        rect.left = (int)o2.a(rect2.left);
        rect.top = (int)o2.a(rect.top);
        rect.bottom = (int)o2.a(rect.bottom);
        rect.right = (int)o2.a(rect.right);
        rect.offset(0, (int)o2.k);
        int[] nArray = new int[2];
        this.mView.getLocationOnScreen(nArray);
        rect.offset(nArray[0], nArray[1]);
        int n2 = nArray[1] + (int)o2.k;
        int n3 = this.mView.getHeight() + n2;
        if (rect.top < n2) {
            rect.top = n2;
        }
        if (rect.bottom > n3) {
            rect.bottom = n3;
        }
    }

    public void setAccessibilityNodeInfoKitKatAttributes(AccessibilityNodeInfo accessibilityNodeInfo, boolean bl, boolean bl2, String string2, String string3, String string4, int n2, int n3, boolean bl3, boolean bl4) {
    }

    public void setAccessibilityNodeInfoLollipopAttributes(AccessibilityNodeInfo accessibilityNodeInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, String string2) {
    }

    public void setAccessibilityNodeInfoCollectionInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n2, int n3, boolean bl) {
    }

    public void setAccessibilityNodeInfoCollectionItemInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n2, int n3, int n4, int n5, boolean bl) {
    }

    public void setAccessibilityNodeInfoRangeInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n2, float f2, float f3, float f4) {
    }

    public void setAccessibilityNodeInfoViewIdResourceName(AccessibilityNodeInfo accessibilityNodeInfo, String string2) {
    }

    public void setAccessibilityNodeInfoOAttributes(AccessibilityNodeInfo accessibilityNodeInfo, boolean bl) {
    }

    public void setAccessibilityEventLollipopAttributes(AccessibilityEvent accessibilityEvent, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(accessibilityEvent);
        bundle.putBoolean("AccessibilityNodeInfo.canOpenPopup", bl);
        bundle.putBoolean("AccessibilityNodeInfo.contentInvalid", bl2);
        bundle.putBoolean("AccessibilityNodeInfo.dismissable", bl3);
        bundle.putBoolean("AccessibilityNodeInfo.multiLine", bl4);
        bundle.putInt("AccessibilityNodeInfo.inputType", n2);
        bundle.putInt("AccessibilityNodeInfo.liveRegion", n3);
    }

    public void setAccessibilityEventCollectionInfo(AccessibilityEvent accessibilityEvent, int n2, int n3, boolean bl) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(accessibilityEvent);
        bundle.putInt("AccessibilityNodeInfo.CollectionInfo.rowCount", n2);
        bundle.putInt("AccessibilityNodeInfo.CollectionInfo.columnCount", n3);
        bundle.putBoolean("AccessibilityNodeInfo.CollectionInfo.hierarchical", bl);
    }

    public void setAccessibilityEventHeadingFlag(AccessibilityEvent accessibilityEvent, boolean bl) {
        this.getOrCreateBundleForAccessibilityEvent(accessibilityEvent).putBoolean("AccessibilityNodeInfo.CollectionItemInfo.heading", bl);
    }

    public void setAccessibilityEventCollectionItemInfo(AccessibilityEvent accessibilityEvent, int n2, int n3, int n4, int n5) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(accessibilityEvent);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.rowIndex", n2);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.rowSpan", n3);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.columnIndex", n4);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.columnSpan", n5);
    }

    public void setAccessibilityEventRangeInfo(AccessibilityEvent accessibilityEvent, int n2, float f2, float f3, float f4) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(accessibilityEvent);
        bundle.putInt("AccessibilityNodeInfo.RangeInfo.type", n2);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.min", f2);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.max", f3);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.current", f4);
    }

    public boolean shouldRespectDisplayedPasswordText() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public boolean shouldExposePasswordText() {
        WebContentsAccessibilityImpl webContentsAccessibilityImpl = webContentsAccessibilityImpl.mContext.getContentResolver();
        if (Build.VERSION.SDK_INT >= 26) {
            return Settings.System.getInt((ContentResolver)webContentsAccessibilityImpl, (String)"show_password", (int)1) == 1;
        }
        return Settings.Secure.getInt((ContentResolver)webContentsAccessibilityImpl, (String)"speak_password", (int)0) == 1;
    }

    public int getAccessibilityServiceCapabilitiesMask() {
        return 0;
    }

    public native String nativeGetSupportedHtmlElementTypes(long var1);

    public native boolean nativeAreInlineTextBoxesLoaded(long var1, int var3);

    public native void nativeLoadInlineTextBoxes(long var1, int var3);

    public native int[] nativeGetCharacterBoundingBoxes(long var1, int var3, int var4, int var5);

    private static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<WebContentsAccessibilityImpl> INSTANCE = new Factory(null);

        public static /* synthetic */ WebContentsImpl.UserDataFactory access$100() {
            return INSTANCE;
        }
    }

    private static class Factory
    implements WebContentsImpl.UserDataFactory<WebContentsAccessibilityImpl> {
        public Factory() {
        }

        public /* synthetic */ Factory(1 var1_1) {
        }

        @Override
        public WebContentsAccessibilityImpl create(WebContents webContents) {
            int n2 = Build.VERSION.SDK_INT;
            if (n2 >= 26) {
                return new OWebContentsAccessibility(webContents);
            }
            if (n2 >= 21) {
                return new LollipopWebContentsAccessibility(webContents);
            }
            if (n2 >= 19) {
                return new KitKatWebContentsAccessibility(webContents);
            }
            return new WebContentsAccessibilityImpl(webContents);
        }
    }
}

