/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.annotation.TargetApi;
import android.os.Bundle;
import android.view.accessibility.AccessibilityNodeInfo;
import java.util.Iterator;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.accessibility.WebContentsAccessibilityImpl;
import org.chromium.content_public.browser.WebContents;

@JNINamespace(value="content")
@TargetApi(value=19)
public class KitKatWebContentsAccessibility
extends WebContentsAccessibilityImpl {
    public String mSupportedHtmlElementTypes;

    public KitKatWebContentsAccessibility(WebContents webContents) {
        super(webContents);
    }

    @Override
    public void onNativeInit() {
        KitKatWebContentsAccessibility kitKatWebContentsAccessibility = this;
        super.onNativeInit();
        kitKatWebContentsAccessibility.mSupportedHtmlElementTypes = kitKatWebContentsAccessibility.nativeGetSupportedHtmlElementTypes(kitKatWebContentsAccessibility.mNativeObj);
    }

    @Override
    public void setAccessibilityNodeInfoKitKatAttributes(AccessibilityNodeInfo accessibilityNodeInfo, boolean bl, boolean bl2, String string2, String string3, String string4, int n2, int n3, boolean bl3, boolean bl4) {
        Bundle bundle = accessibilityNodeInfo.getExtras();
        bundle.putCharSequence("AccessibilityNodeInfo.chromeRole", (CharSequence)string2);
        bundle.putCharSequence("AccessibilityNodeInfo.roleDescription", (CharSequence)string3);
        bundle.putCharSequence("AccessibilityNodeInfo.hint", (CharSequence)string4);
        if (bl3) {
            bundle.putCharSequence("AccessibilityNodeInfo.hasImage", (CharSequence)"true");
        }
        if (bl) {
            bundle.putCharSequence("ACTION_ARGUMENT_HTML_ELEMENT_STRING_VALUES", (CharSequence)this.mSupportedHtmlElementTypes);
        }
        if (bl2) {
            accessibilityNodeInfo.setEditable(true);
            accessibilityNodeInfo.setTextSelection(n2, n3);
        }
        accessibilityNodeInfo.setContentInvalid(bl4);
    }

    @Override
    public int getAccessibilityServiceCapabilitiesMask() {
        int n2 = 0;
        Iterator iterator = this.mAccessibilityManager.getEnabledAccessibilityServiceList(-1).iterator();
        while (iterator.hasNext()) {
            n2 |= ((AccessibilityServiceInfo)iterator.next()).getCapabilities();
        }
        return n2;
    }
}

