/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.metrics.RecordHistogram;

@JNINamespace(value="content")
public class BrowserAccessibilityState {
    public static final int ANIMATIONS_STATE_DEFAULT_VALUE = 0;
    public static final int ANIMATIONS_STATE_DISABLED = 1;
    public static final int ANIMATIONS_STATE_ENABLED = 2;
    public static final int ANIMATIONS_STATE_COUNT = 3;

    @TargetApi(value=17)
    public static void registerAnimatorDurationScaleObserver() {
        AnimatorDurationScaleObserver animatorDurationScaleObserver;
        Handler handler;
        Handler handler2 = handler;
        handler = new Handler(ThreadUtils.getUiThreadHandler().getLooper());
        AnimatorDurationScaleObserver animatorDurationScaleObserver2 = animatorDurationScaleObserver;
        animatorDurationScaleObserver = new AnimatorDurationScaleObserver(handler2);
        ContextUtils.sApplicationContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor((String)"animator_duration_scale"), false, (ContentObserver)animatorDurationScaleObserver2);
    }

    @TargetApi(value=17)
    public static void recordAccessibilityHistograms() {
        float f2;
        if (Build.VERSION.SDK_INT < 17) {
            return;
        }
        float f3 = Settings.Global.getFloat((ContentResolver)ContextUtils.sApplicationContext.getContentResolver(), (String)"animator_duration_scale", (float)-1.0f);
        int n2 = f2 < 0.0f ? 0 : (f3 > 0.0f ? 2 : 1);
        RecordHistogram.recordEnumeratedHistogram("Accessibility.Android.AnimationsEnabled2", n2, 3);
    }

    public static native void nativeOnAnimatorDurationScaleChanged();

    public static /* synthetic */ void access$000() {
        BrowserAccessibilityState.nativeOnAnimatorDurationScaleChanged();
    }

    private static class AnimatorDurationScaleObserver
    extends ContentObserver {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public AnimatorDurationScaleObserver(Handler handler) {
            super(handler);
        }

        static {
            $assertionsDisabled = BrowserAccessibilityState.class.desiredAssertionStatus() ^ true;
        }

        public void onChange(boolean bl) {
            this.onChange(bl, null);
        }

        public void onChange(boolean bl, Uri uri) {
            if (!$assertionsDisabled && !ThreadUtils.runningOnUiThread()) {
                throw new AssertionError();
            }
            BrowserAccessibilityState.nativeOnAnimatorDurationScaleChanged();
        }
    }
}

