/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.os.Handler;
import android.os.Looper;
import org.chromium.base.JavaHandlerThread;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content::android")
public final class LauncherThread {
    public static final JavaHandlerThread sThread = new JavaHandlerThread("Chrome_ProcessLauncherThread", 0);
    public static final Handler sThreadHandler;
    public static Handler sHandler;

    public static void post(Runnable runnable) {
        sHandler.post(runnable);
    }

    public static void postDelayed(Runnable runnable, long l2) {
        sHandler.postDelayed(runnable, l2);
    }

    public static void removeCallbacks(Runnable runnable) {
        sHandler.removeCallbacks(runnable);
    }

    public static boolean runningOnLauncherThread() {
        return sHandler.getLooper() == Looper.myLooper();
    }

    public static Handler getHandler() {
        return sHandler;
    }

    public static void setCurrentThreadAsLauncherThread() {
        sHandler = new Handler();
    }

    public static void setLauncherThreadAsLauncherThread() {
        sHandler = sThreadHandler;
    }

    public static JavaHandlerThread getHandlerThread() {
        return sThread;
    }

    static {
        sThread.maybeStart();
        sHandler = sThreadHandler = new Handler(sThread.getLooper());
    }
}

