/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.l;
import a.b.c.b.n;
import a.b.c.b.o;
import a.b.c.b.w;
import a.b.c.b.y;
import a.b.d.a.A;
import a.b.d.a.e;
import a.b.d.a.f;
import android.view.ViewGroup;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.input.ImeAdapterImpl;
import org.chromium.content.browser.selection.SelectionPopupControllerImpl;
import org.chromium.content.browser.webcontents.WebContentsImpl;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.ViewAndroidDelegate;

@JNINamespace(value="content")
public class GestureListenerManagerImpl
implements e,
w,
a.b.a.o {
    public final WebContentsImpl mWebContents;
    public final l<f> mListeners;
    public final l.b<f> mIterator;
    public ViewAndroidDelegate mViewDelegate;
    public A.a mScrollDelegate;
    public long mNativeGestureListenerManager;
    public boolean mIsTouchScrollInProgress;
    public boolean mHasActiveFlingScroll;

    public static GestureListenerManagerImpl fromWebContents(WebContents webContents) {
        return ((WebContentsImpl)webContents).getOrSetUserData(GestureListenerManagerImpl.class, UserDataFactoryLazyHolder.INSTANCE);
    }

    public GestureListenerManagerImpl(WebContents webContents) {
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.mWebContents = (WebContentsImpl)webContents;
        gestureListenerManagerImpl.mListeners = new l();
        gestureListenerManagerImpl.mIterator = gestureListenerManagerImpl.mListeners.a();
        gestureListenerManagerImpl.mViewDelegate = gestureListenerManagerImpl.mWebContents.getViewAndroidDelegate();
        y.a(gestureListenerManagerImpl.mWebContents).a(this);
        gestureListenerManagerImpl.mNativeGestureListenerManager = gestureListenerManagerImpl.nativeInit(gestureListenerManagerImpl.mWebContents);
    }

    private void resetGestureDetection() {
        long l2 = this.mNativeGestureListenerManager;
        if (l2 != 0L) {
            this.nativeResetGestureDetection(l2);
        }
    }

    private void updateOnTouchDown() {
        ((l.a)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).f();
        }
    }

    private void resetFlingGesture() {
        if (this.mHasActiveFlingScroll) {
            this.onFlingEnd();
            this.mHasActiveFlingScroll = false;
        }
    }

    private void onFlingEnd() {
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.mHasActiveFlingScroll = false;
        gestureListenerManagerImpl.setTouchScrollInProgress(false);
        ((l.a)gestureListenerManagerImpl.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).d(this.verticalScrollOffset(), this.verticalScrollExtent());
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private void onEventAck(int n2, boolean bl) {
        int n3 = 0;
        block10: do {
            switch (n3 == 0 ? n2 : n3) {
                default: {
                    return;
                }
                case 23: {
                    if (!bl) {
                        return;
                    }
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.mViewDelegate.getContainerView().performHapticFeedback(0);
                    ((l.a)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((f)this.mIterator.next()).a();
                    }
                    return;
                }
                case 21: {
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.destroyPastePopup();
                    ((l.a)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((f)this.mIterator.next()).a(bl);
                    }
                    return;
                }
                case 17: {
                    ((l.a)this.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((f)this.mIterator.next()).e();
                    }
                    return;
                }
                case 16: {
                    ((l.a)this.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((f)this.mIterator.next()).c();
                    }
                    return;
                }
                case 14: {
                    n3 = 12;
                    if (!bl) continue block10;
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.mHasActiveFlingScroll = true;
                    gestureListenerManagerImpl.setTouchScrollInProgress(false);
                    ((l.a)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((f)this.mIterator.next()).b(this.verticalScrollOffset(), this.verticalScrollExtent());
                    }
                    return;
                }
                case 13: {
                    if (!bl) {
                        return;
                    }
                    GestureListenerManagerImpl gestureListenerManagerImpl = this;
                    gestureListenerManagerImpl.destroyPastePopup();
                    ((l.a)gestureListenerManagerImpl.mIterator).b();
                    while (this.mIterator.hasNext()) {
                        ((f)this.mIterator.next()).d();
                    }
                    return;
                }
                case 12: {
                    this.updateOnScrollEnd();
                    return;
                }
                case 11: 
            }
            break;
        } while (true);
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.setTouchScrollInProgress(true);
        ((l.a)gestureListenerManagerImpl.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).a(this.verticalScrollOffset(), this.verticalScrollExtent());
        }
    }

    private void destroyPastePopup() {
        w w2 = SelectionPopupControllerImpl.fromWebContents(((GestureListenerManagerImpl)w2).mWebContents);
        if (w2 != null) {
            ((SelectionPopupControllerImpl)w2).destroyPastePopup();
        }
    }

    private void resetPopupsAndInput(boolean bl) {
        Object object = ((GestureListenerManagerImpl)this).mWebContents;
        if (object != null) {
            SelectionPopupControllerImpl selectionPopupControllerImpl = SelectionPopupControllerImpl.fromWebContents((WebContents)object);
            if (selectionPopupControllerImpl != null) {
                selectionPopupControllerImpl.destroyActionModeAndUnselect();
            }
            if ((object = n.a((WebContents)object)) != null) {
                ((n)object).a();
            }
        }
        ((GestureListenerManagerImpl)this).resetScrollInProgress();
        if (bl && (this = ImeAdapterImpl.fromWebContents(((GestureListenerManagerImpl)this).mWebContents)) != null) {
            ((ImeAdapterImpl)this).resetAndHideKeyboard();
        }
    }

    private void onNativeDestroyed() {
        ((l.a)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).b();
        }
        this.mListeners.clear();
        this.mNativeGestureListenerManager = 0L;
    }

    private boolean filterTapOrPressEvent(int n2, int n3, int n4) {
        return n2 == 5 && this.offerLongPressToEmbedder();
    }

    private void updateScrollInfo(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, boolean bl) {
        float f12 = f8;
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        TraceEvent.begin("GestureListenerManagerImpl:updateScrollInfo", null);
        o o2 = gestureListenerManagerImpl.mWebContents.getRenderCoordinates();
        f8 = o2.j;
        ViewGroup viewGroup = gestureListenerManagerImpl.mViewDelegate.getContainerView();
        float f13 = Math.max(f7, (float)viewGroup.getWidth() / (f8 *= f4));
        f8 = Math.max(f12, (float)viewGroup.getHeight() / f8);
        boolean bl2 = f5 != o2.h || f6 != o2.i;
        boolean bl3 = f4 != o2.g || f2 != o2.a || f3 != o2.b;
        if (bl3) {
            float f14 = o2.g;
            float f15 = o2.j;
            o o3 = o2;
            o o4 = o2;
            this.mScrollDelegate.onScrollChanged((int)(f2 * f14 * f15), (int)(f3 * f14 * f15), (int)o3.a(o3.a), (int)o4.a(o4.b));
        }
        o2.a = f2;
        o2.b = f3;
        o2.g = f4;
        o2.h = f5;
        o2.i = f6;
        o2.k = f11;
        o2.c = f13;
        o2.d = f8;
        o2.e = f9;
        o2.f = f10;
        if (bl3 || bl) {
            GestureListenerManagerImpl gestureListenerManagerImpl2 = this;
            gestureListenerManagerImpl2.updateOnScrollChanged(gestureListenerManagerImpl2.verticalScrollOffset(), this.verticalScrollExtent());
        }
        if (bl2) {
            this.updateOnScaleLimitsChanged(f5, f6);
        }
        TraceEvent.end("GestureListenerManagerImpl:updateScrollInfo", null);
    }

    private void setTouchScrollInProgress(boolean bl) {
        this.mIsTouchScrollInProgress = bl;
        SelectionPopupControllerImpl.fromWebContents(this.mWebContents).setScrollInProgress(bl);
    }

    private void resetScrollInProgress() {
        if (!this.isScrollInProgress()) {
            return;
        }
        this.setTouchScrollInProgress(false);
        if (this.mIsTouchScrollInProgress) {
            this.updateOnScrollEnd();
        }
        this.resetFlingGesture();
    }

    private SelectionPopupControllerImpl getSelectionPopupController() {
        return SelectionPopupControllerImpl.fromWebContents(this.mWebContents);
    }

    private boolean offerLongPressToEmbedder() {
        return this.mViewDelegate.getContainerView().performLongClick();
    }

    private int verticalScrollOffset() {
        o o2 = this.mWebContents.getRenderCoordinates();
        return (int)Math.floor(o2.a(o2.b));
    }

    private int verticalScrollExtent() {
        o o2 = this.mWebContents.getRenderCoordinates();
        return (int)Math.ceil(o2.a(o2.f));
    }

    private native long nativeInit(WebContentsImpl var1);

    private native void nativeResetGestureDetection(long var1);

    private native void nativeSetDoubleTapSupportEnabled(long var1, boolean var3);

    private native void nativeSetMultiTouchZoomSupportEnabled(long var1, boolean var3);

    public void setScrollDelegate(A.a a2) {
        this.mScrollDelegate = a2;
    }

    public void addListener(f f2) {
        this.mListeners.a(f2);
    }

    public void removeListener(f f2) {
        this.mListeners.b(f2);
    }

    public void updateMultiTouchZoomSupport(boolean bl) {
        long l2 = this.mNativeGestureListenerManager;
        if (l2 == 0L) {
            return;
        }
        this.nativeSetMultiTouchZoomSupportEnabled(l2, bl);
    }

    public void updateDoubleTapSupport(boolean bl) {
        long l2 = this.mNativeGestureListenerManager;
        if (l2 == 0L) {
            return;
        }
        this.nativeSetDoubleTapSupportEnabled(l2, bl);
    }

    public boolean hasActiveFlingScroll() {
        return this.mHasActiveFlingScroll;
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        if (!bl) {
            this.resetGestureDetection();
        }
        ((l.a)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).onWindowFocusChanged(bl);
        }
    }

    public void updateOnScrollChanged(int n2, int n3) {
        ((l.a)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).c(n2, n3);
        }
    }

    public void updateOnScrollEnd() {
        GestureListenerManagerImpl gestureListenerManagerImpl = this;
        gestureListenerManagerImpl.setTouchScrollInProgress(false);
        ((l.a)gestureListenerManagerImpl.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).e(this.verticalScrollOffset(), this.verticalScrollExtent());
        }
    }

    public void updateOnScaleLimitsChanged(float f2, float f3) {
        ((l.a)this.mIterator).b();
        while (this.mIterator.hasNext()) {
            ((f)this.mIterator.next()).a(f2, f3);
        }
    }

    public boolean isScrollInProgress() {
        return this.mIsTouchScrollInProgress || this.mHasActiveFlingScroll;
    }

    private static final class UserDataFactoryLazyHolder {
        public static final WebContentsImpl.UserDataFactory<GestureListenerManagerImpl> INSTANCE = GestureListenerManagerImpl::new;

        public static /* synthetic */ WebContentsImpl.UserDataFactory access$000() {
            return INSTANCE;
        }
    }
}

