/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import a.b.a.a;
import a.b.l.b;
import a.b.l.i;
import android.annotation.SuppressLint;
import android.os.Process;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.chromium.base.ContextUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.metrics.RecordHistogram;

@JNINamespace(value="content")
public class BackgroundSyncNetworkObserver
implements b.f {
    public static final String TAG = "cr_BgSyncNetObserver";
    @SuppressLint(value={"StaticFieldLeak"})
    public static BackgroundSyncNetworkObserver sInstance;
    public b mNotifier;
    public List<Long> mNativePtrs;
    public int mLastBroadcastConnectionType;
    public boolean mHasBroadcastConnectionType;

    public BackgroundSyncNetworkObserver() {
        ThreadUtils.assertOnUiThread();
        this.mNativePtrs = new ArrayList<Long>();
    }

    public static boolean canCreateObserver() {
        int n2 = Process.myUid();
        return a.a(ContextUtils.sApplicationContext, "android.permission.ACCESS_NETWORK_STATE", Process.myPid(), n2) == 0;
    }

    public static BackgroundSyncNetworkObserver createObserver(long l2) {
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            sInstance = new BackgroundSyncNetworkObserver();
        }
        sInstance.registerObserver(l2);
        return sInstance;
    }

    private void registerObserver(long l2) {
        ThreadUtils.assertOnUiThread();
        if (!BackgroundSyncNetworkObserver.canCreateObserver()) {
            RecordHistogram.recordBooleanHistogram("BackgroundSync.NetworkObserver.HasPermission", false);
            return;
        }
        if (this.mNotifier == null) {
            this.mNotifier = new b(this, new i());
            RecordHistogram.recordBooleanHistogram("BackgroundSync.NetworkObserver.HasPermission", true);
        }
        BackgroundSyncNetworkObserver backgroundSyncNetworkObserver = this;
        backgroundSyncNetworkObserver.mNativePtrs.add(l2);
        this.nativeNotifyConnectionTypeChanged(l2, backgroundSyncNetworkObserver.mNotifier.c().b());
    }

    private void removeObserver(long l2) {
        b b2;
        BackgroundSyncNetworkObserver backgroundSyncNetworkObserver = this;
        ThreadUtils.assertOnUiThread();
        backgroundSyncNetworkObserver.mNativePtrs.remove(l2);
        if (backgroundSyncNetworkObserver.mNativePtrs.size() == 0 && (b2 = this.mNotifier) != null) {
            b b3 = b2;
            b3.a();
            b3.e.a();
            b3.g();
            this.mNotifier = null;
        }
    }

    private void broadcastNetworkChangeIfNecessary(int n2) {
        if (this.mHasBroadcastConnectionType && n2 == this.mLastBroadcastConnectionType) {
            return;
        }
        this.mHasBroadcastConnectionType = true;
        this.mLastBroadcastConnectionType = n2;
        Iterator<Long> iterator = this.mNativePtrs.iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyConnectionTypeChanged(iterator.next(), n2);
        }
    }

    private native void nativeNotifyConnectionTypeChanged(long var1, int var3);

    @Override
    public void onConnectionTypeChanged(int n2) {
        ThreadUtils.assertOnUiThread();
        this.broadcastNetworkChangeIfNecessary(n2);
    }

    @Override
    public void onConnectionSubtypeChanged(int n2) {
    }

    @Override
    public void onNetworkConnect(long l2, int n2) {
        BackgroundSyncNetworkObserver backgroundSyncNetworkObserver = this;
        ThreadUtils.assertOnUiThread();
        backgroundSyncNetworkObserver.broadcastNetworkChangeIfNecessary(backgroundSyncNetworkObserver.mNotifier.c().b());
    }

    @Override
    public void onNetworkSoonToDisconnect(long l2) {
    }

    @Override
    public void onNetworkDisconnect(long l2) {
        BackgroundSyncNetworkObserver backgroundSyncNetworkObserver = this;
        ThreadUtils.assertOnUiThread();
        backgroundSyncNetworkObserver.broadcastNetworkChangeIfNecessary(backgroundSyncNetworkObserver.mNotifier.c().b());
    }

    @Override
    public void purgeActiveNetworkList(long[] lArray) {
    }
}

