/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.components.embedder_support.view;

import android.content.Context;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="embedder_support")
public class ContentViewRenderView
extends FrameLayout {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public long mNativeContentViewRenderView;
    public SurfaceHolder.Callback mSurfaceCallback;
    public WindowAndroid mWindowAndroid;
    public final SurfaceView mSurfaceView;
    public WebContents mWebContents;
    public int mWidth;
    public int mHeight;

    public ContentViewRenderView(Context context) {
        ContentViewRenderView contentViewRenderView = this;
        super(context);
        contentViewRenderView.mSurfaceView = contentViewRenderView.createSurfaceView(contentViewRenderView.getContext());
        contentViewRenderView.mSurfaceView.setZOrderMediaOverlay(true);
        contentViewRenderView.setSurfaceViewBackgroundColor(-1);
        contentViewRenderView.addView((View)contentViewRenderView.mSurfaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        contentViewRenderView.mSurfaceView.setVisibility(8);
    }

    private void didSwapFrame() {
        if (this.mSurfaceView.getBackground() != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ContentViewRenderView.this.mSurfaceView.setBackgroundResource(0);
                }
            });
        }
    }

    private native long nativeInit(WindowAndroid var1);

    private native void nativeDestroy(long var1);

    private native void nativeSetCurrentWebContents(long var1, WebContents var3);

    private native void nativeOnPhysicalBackingSizeChanged(long var1, WebContents var3, int var4, int var5);

    private native void nativeSurfaceCreated(long var1);

    private native void nativeSurfaceDestroyed(long var1);

    private native void nativeSurfaceChanged(long var1, int var3, int var4, int var5, Surface var6);

    private native void nativeSetOverlayVideoMode(long var1, boolean var3);

    static {
        $assertionsDisabled = ContentViewRenderView.class.desiredAssertionStatus() ^ true;
    }

    public void onNativeLibraryLoaded(WindowAndroid windowAndroid) {
        if (!$assertionsDisabled && this.mSurfaceView.getHolder().getSurface().isValid()) {
            throw new AssertionError((Object)"Surface created before native library loaded.");
        }
        if (!$assertionsDisabled && windowAndroid == null) {
            throw new AssertionError();
        }
        this.mNativeContentViewRenderView = this.nativeInit(windowAndroid);
        if (!$assertionsDisabled && this.mNativeContentViewRenderView == 0L) {
            throw new AssertionError();
        }
        ContentViewRenderView contentViewRenderView = this;
        contentViewRenderView.mWindowAndroid = windowAndroid;
        contentViewRenderView.mSurfaceCallback = new SurfaceHolder.Callback(){
            public static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = ContentViewRenderView.class.desiredAssertionStatus() ^ true;
            }

            public void surfaceChanged(SurfaceHolder object, int n2, int n3, int n4) {
                if (!$assertionsDisabled && ContentViewRenderView.this.mNativeContentViewRenderView == 0L) {
                    throw new AssertionError();
                }
                1 v0 = this;
                ContentViewRenderView contentViewRenderView = v0.ContentViewRenderView.this;
                contentViewRenderView.nativeSurfaceChanged(contentViewRenderView.mNativeContentViewRenderView, n2, n3, n4, object.getSurface());
                object = v0.ContentViewRenderView.this;
                if (object.mWebContents != null) {
                    Object object2 = object;
                    ((ContentViewRenderView)((Object)object2)).nativeOnPhysicalBackingSizeChanged(((ContentViewRenderView)((Object)object2)).mNativeContentViewRenderView, ContentViewRenderView.this.mWebContents, n3, n4);
                }
            }

            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                if (!$assertionsDisabled && ContentViewRenderView.this.mNativeContentViewRenderView == 0L) {
                    throw new AssertionError();
                }
                1 v0 = this;
                ContentViewRenderView contentViewRenderView = v0.ContentViewRenderView.this;
                contentViewRenderView.nativeSurfaceCreated(contentViewRenderView.mNativeContentViewRenderView);
                v0.ContentViewRenderView.this.mSurfaceView.setVisibility(ContentViewRenderView.this.mSurfaceView.getVisibility());
                v0.ContentViewRenderView.this.onReadyToRender();
            }

            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                if (!$assertionsDisabled && ContentViewRenderView.this.mNativeContentViewRenderView == 0L) {
                    throw new AssertionError();
                }
                ContentViewRenderView contentViewRenderView = ContentViewRenderView.this;
                contentViewRenderView.nativeSurfaceDestroyed(contentViewRenderView.mNativeContentViewRenderView);
            }
        };
        contentViewRenderView.mSurfaceView.getHolder().addCallback(this.mSurfaceCallback);
        contentViewRenderView.mSurfaceView.setVisibility(0);
    }

    public void onSizeChanged(int n2, int n3, int n4, int n5) {
        ((ContentViewRenderView)((Object)webContents)).mWidth = n2;
        ((ContentViewRenderView)((Object)webContents)).mHeight = n3;
        WebContents webContents = ((ContentViewRenderView)((Object)webContents)).mWebContents;
        if (webContents != null) {
            webContents.setSize(n2, n3);
        }
    }

    public void onWindowVisibilityChanged(int n2) {
        ContentViewRenderView contentViewRenderView = windowAndroid;
        super.onWindowVisibilityChanged(n2);
        WindowAndroid windowAndroid = contentViewRenderView.mWindowAndroid;
        if (windowAndroid == null) {
            return;
        }
        if (n2 == 8) {
            windowAndroid.onVisibilityChanged(false);
        } else if (n2 == 0) {
            windowAndroid.onVisibilityChanged(true);
        }
    }

    public void setSurfaceViewBackgroundColor(int n2) {
        ContentViewRenderView contentViewRenderView = contentViewRenderView.mSurfaceView;
        if (contentViewRenderView != null) {
            contentViewRenderView.setBackgroundColor(n2);
        }
    }

    public SurfaceView getSurfaceView() {
        return this.mSurfaceView;
    }

    public void destroy() {
        ContentViewRenderView contentViewRenderView = this;
        contentViewRenderView.mSurfaceView.getHolder().removeCallback(this.mSurfaceCallback);
        contentViewRenderView.mWindowAndroid = null;
        contentViewRenderView.nativeDestroy(contentViewRenderView.mNativeContentViewRenderView);
        contentViewRenderView.mNativeContentViewRenderView = 0L;
    }

    public void setCurrentWebContents(WebContents webContents) {
        if (!$assertionsDisabled && this.mNativeContentViewRenderView == 0L) {
            throw new AssertionError();
        }
        this.mWebContents = webContents;
        if (webContents != null) {
            ContentViewRenderView contentViewRenderView = this;
            webContents.setSize(this.mWidth, this.mHeight);
            contentViewRenderView.nativeOnPhysicalBackingSizeChanged(contentViewRenderView.mNativeContentViewRenderView, webContents, this.mWidth, this.mHeight);
        }
        ContentViewRenderView contentViewRenderView = this;
        contentViewRenderView.nativeSetCurrentWebContents(contentViewRenderView.mNativeContentViewRenderView, webContents);
    }

    public void onReadyToRender() {
    }

    public SurfaceView createSurfaceView(Context context) {
        return new SurfaceView(context);
    }

    public boolean isInitialized() {
        return this.mSurfaceView.getHolder().getSurface() != null;
    }

    public void setOverlayVideoMode(boolean bl) {
        int n2 = bl ? -3 : -1;
        ContentViewRenderView contentViewRenderView = this;
        contentViewRenderView.mSurfaceView.getHolder().setFormat(n2);
        contentViewRenderView.nativeSetOverlayVideoMode(contentViewRenderView.mNativeContentViewRenderView, bl);
    }
}

