/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.components.embedder_support.view;

import a.b.c.b.o;
import a.b.c.b.v;
import a.b.c.b.w;
import a.b.c.b.y;
import a.b.d.a.A;
import a.b.d.a.B;
import a.b.d.a.h;
import a.b.d.a.r;
import a.b.d.a.x;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.DragEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import java.util.Iterator;
import org.chromium.base.TraceEvent;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.EventForwarder;

public class ContentView
extends FrameLayout
implements A.a,
x {
    public static final String TAG = "cr.ContentView";
    public static final int DEFAULT_MEASURE_SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    public final WebContents mWebContents;
    public A mViewEventSink;
    public EventForwarder mEventForwarder;
    public TouchEventDelegate mDelegate;
    public int mDesiredWidthMeasureSpec;
    public int mDesiredHeightMeasureSpec;

    public static ContentView createContentView(Context context, WebContents webContents) {
        if (Build.VERSION.SDK_INT >= 23) {
            return new ContentViewApi23(context, webContents);
        }
        return new ContentView(context, webContents);
    }

    public ContentView(Context context, WebContents webContents) {
        ContentView contentView = this;
        super(context, null, 16842885);
        contentView.mDesiredHeightMeasureSpec = this.mDesiredWidthMeasureSpec = DEFAULT_MEASURE_SPEC;
        if (contentView.getScrollBarStyle() == 0) {
            ContentView contentView2 = this;
            contentView2.setHorizontalScrollBarEnabled(false);
            contentView2.setVerticalScrollBarEnabled(false);
        }
        ContentView contentView3 = this;
        contentView3.mWebContents = webContents;
        contentView3.setFocusable(true);
        contentView3.setFocusableInTouchMode(true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setDefaultFocusHighlightEnabled(false);
        }
    }

    private EventForwarder getEventForwarder() {
        if (this.mEventForwarder == null) {
            this.mEventForwarder = this.mWebContents.getEventForwarder();
        }
        return this.mEventForwarder;
    }

    private A getViewEventSink() {
        if (this.mViewEventSink == null) {
            this.mViewEventSink = A.a(this.mWebContents);
        }
        return this.mViewEventSink;
    }

    public B getWebContentsAccessibility() {
        return !this.mWebContents.isDestroyed() ? B.fromWebContents(this.mWebContents) : null;
    }

    public boolean performAccessibilityAction(int n2, Bundle bundle) {
        B b2 = this.getWebContentsAccessibility();
        return b2 != null && b2.supportsAction(n2) ? b2.performAction(n2, bundle) : super.performAccessibilityAction(n2, bundle);
    }

    public void setDesiredMeasureSpec(int n2, int n3) {
        this.mDesiredWidthMeasureSpec = n2;
        this.mDesiredHeightMeasureSpec = n3;
    }

    public void setTouchEventDelegate(TouchEventDelegate touchEventDelegate) {
        this.mDelegate = touchEventDelegate;
    }

    public void onMeasure(int n2, int n3) {
        int n4 = this.mDesiredWidthMeasureSpec;
        if (n4 == DEFAULT_MEASURE_SPEC) {
            n4 = n2;
        }
        n2 = this.mDesiredHeightMeasureSpec;
        if (n2 == DEFAULT_MEASURE_SPEC) {
            n2 = n3;
        }
        super.onMeasure(n4, n2);
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        B b2 = this.getWebContentsAccessibility();
        b2 = b2 != null ? b2.getAccessibilityNodeProvider() : null;
        if (b2 == null) {
            b2 = super.getAccessibilityNodeProvider();
        }
        return b2;
    }

    @Override
    public void onScrollChanged(int n2, int n3, int n4, int n5) {
        super.onScrollChanged(n2, n3, n4, n5);
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.mWebContents.isDestroyed()) {
            return null;
        }
        return h.fromWebContents(this.mWebContents).onCreateInputConnection(editorInfo);
    }

    public boolean onCheckIsTextEditor() {
        if (this.mWebContents.isDestroyed()) {
            return false;
        }
        return h.fromWebContents(this.mWebContents).onCheckIsTextEditor();
    }

    public void onFocusChanged(boolean bl, int n2, Rect rect) {
        v v2;
        block6: {
            ContentView contentView = this;
            TraceEvent.begin("ContentView.onFocusChanged", null);
            super.onFocusChanged(bl, n2, rect);
            A a2 = contentView.getViewEventSink();
            boolean bl2 = true;
            ((v)a2).e = bl2;
            v2 = (v)contentView.getViewEventSink();
            Boolean bl3 = v2.b;
            if (bl3 == null) break block6;
            if (bl3 != bl) break block6;
        }
        v2.b = bl;
        v2.a();
        return;
        finally {
            TraceEvent.end("ContentView.onFocusChanged", null);
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        ContentView contentView = iterator;
        super.onWindowFocusChanged(bl);
        Iterator<w> iterator = y.a((WebContents)((v)contentView.getViewEventSink()).a).b.iterator();
        while (iterator.hasNext()) {
            ((w)iterator.next()).onWindowFocusChanged(bl);
        }
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.getEventForwarder().onKeyUp(n2, keyEvent);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return this.isFocused() ? this.getEventForwarder().dispatchKeyEvent(keyEvent) : super.dispatchKeyEvent(keyEvent);
    }

    public boolean onDragEvent(DragEvent dragEvent) {
        return this.getEventForwarder().onDragEvent(dragEvent, (View)this);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        TouchEventDelegate touchEventDelegate = this.mDelegate;
        if (touchEventDelegate != null && touchEventDelegate.dispatchTouchEvent(motionEvent)) {
            return true;
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        TouchEventDelegate touchEventDelegate = this.mDelegate;
        if (touchEventDelegate != null && touchEventDelegate.onInterceptTouchEvent(motionEvent)) {
            return true;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.getEventForwarder().onTouchEvent(motionEvent);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        ContentView contentView = this;
        boolean bl = contentView.getEventForwarder().onHoverEvent(motionEvent);
        B b2 = contentView.getWebContentsAccessibility();
        if (b2 != null && !b2.isTouchExplorationEnabled()) {
            super.onHoverEvent(motionEvent);
        }
        return bl;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.getEventForwarder().onGenericMotionEvent(motionEvent);
    }

    public boolean performLongClick() {
        return false;
    }

    public void onConfigurationChanged(Configuration configuration) {
        ((v)this.getViewEventSink()).a(configuration);
        super.onConfigurationChanged(configuration);
    }

    public void scrollBy(int n2, int n3) {
        this.getEventForwarder().scrollBy(n2, n3);
    }

    public void scrollTo(int n2, int n3) {
        this.getEventForwarder().scrollTo(n2, n3);
    }

    public int computeHorizontalScrollExtent() {
        int n2;
        r r2 = r.fromWebContents(((ContentView)((Object)r2)).mWebContents);
        if (r2 != null) {
            o o2 = (o)r2;
            n2 = (int)Math.ceil(o2.a(o2.e));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeHorizontalScrollOffset() {
        int n2;
        r r2 = r.fromWebContents(((ContentView)((Object)r2)).mWebContents);
        if (r2 != null) {
            o o2 = (o)r2;
            n2 = (int)Math.floor(o2.a(o2.a));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeHorizontalScrollRange() {
        int n2;
        r r2 = r.fromWebContents(((ContentView)((Object)r2)).mWebContents);
        if (r2 != null) {
            o o2 = (o)r2;
            n2 = (int)Math.ceil(o2.a(o2.c));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeVerticalScrollExtent() {
        int n2;
        r r2 = r.fromWebContents(((ContentView)((Object)r2)).mWebContents);
        if (r2 != null) {
            o o2 = (o)r2;
            n2 = (int)Math.ceil(o2.a(o2.f));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeVerticalScrollOffset() {
        int n2;
        r r2 = r.fromWebContents(((ContentView)((Object)r2)).mWebContents);
        if (r2 != null) {
            o o2 = (o)r2;
            n2 = (int)Math.floor(o2.a(o2.b));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public int computeVerticalScrollRange() {
        int n2;
        r r2 = r.fromWebContents(((ContentView)((Object)r2)).mWebContents);
        if (r2 != null) {
            o o2 = (o)r2;
            n2 = (int)Math.ceil(o2.a(o2.d));
        } else {
            n2 = 0;
        }
        return n2;
    }

    public boolean awakenScrollBars(int n2, boolean bl) {
        if (this.getScrollBarStyle() == 0) {
            return false;
        }
        return super.awakenScrollBars(n2, bl);
    }

    public void onAttachedToWindow() {
        ContentView contentView = iterator;
        super.onAttachedToWindow();
        y y2 = y.a(((v)contentView.getViewEventSink()).a);
        y2.e = true;
        y2.a();
        Iterator<w> iterator = y2.b.iterator();
        while (iterator.hasNext()) {
            ((w)iterator.next()).onAttachedToWindow();
        }
    }

    public void onDetachedFromWindow() {
        ContentView contentView = iterator;
        super.onDetachedFromWindow();
        y y2 = y.a(((v)contentView.getViewEventSink()).a);
        y2.b();
        y2.e = false;
        Iterator<w> iterator = y2.b.iterator();
        while (iterator.hasNext()) {
            ((w)iterator.next()).onDetachedFromWindow();
        }
    }

    public void extractSmartClipData(int n2, int n3, int n4, int n5) {
        this.mWebContents.requestSmartClipExtract(n2, n3, n4, n5);
    }

    public void setSmartClipResultHandler(Handler handler) {
        this.mWebContents.setSmartClipResultHandler(handler);
    }

    @Override
    public boolean super_onKeyUp(int n2, KeyEvent keyEvent) {
        return super.onKeyUp(n2, keyEvent);
    }

    @Override
    public boolean super_dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent);
    }

    @Override
    public boolean super_onGenericMotionEvent(MotionEvent motionEvent) {
        return super.onGenericMotionEvent(motionEvent);
    }

    private static class ContentViewApi23
    extends ContentView {
        public ContentViewApi23(Context context, WebContents webContents) {
            super(context, webContents);
        }

        public void onProvideVirtualStructure(ViewStructure viewStructure) {
            if ((this = ((ContentView)this).getWebContentsAccessibility()) != null) {
                this.onProvideVirtualStructure(viewStructure, false);
            }
        }
    }

    public static interface TouchEventDelegate {
        public boolean dispatchTouchEvent(MotionEvent var1);

        public boolean onInterceptTouchEvent(MotionEvent var1);
    }
}

