/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import a.b.a.e;
import a.b.a.e.j;
import a.b.a.e.k;
import a.b.a.h;
import android.os.Process;
import android.support.annotation.Nullable;
import android.util.Pair;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.PostTask;

@JNINamespace(value="base")
public class TaskRunnerImpl
implements j {
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final k mTaskTraits;
    public final String mTraceEvent;
    public final int mTaskRunnerType;
    public final Object mLock;
    @GuardedBy(value="mLock")
    public long mNativeTaskRunnerAndroid;
    public final Runnable mRunPreNativeTaskClosure;
    @GuardedBy(value="mLock")
    public boolean mIsDestroying;
    public final h mLifetimeAssert;
    @Nullable
    public LinkedList<Runnable> mPreNativeTasks;
    @Nullable
    public List<Pair<Runnable, Long>> mPreNativeDelayedTasks;

    public TaskRunnerImpl(k k2) {
        this(k2, "TaskRunnerImpl", 0);
    }

    public TaskRunnerImpl(k k2, String string2, int n2) {
        h h2;
        TaskRunnerImpl taskRunnerImpl = this;
        taskRunnerImpl.mLock = new Object();
        taskRunnerImpl.mRunPreNativeTaskClosure = taskRunnerImpl::runPreNativeTask;
        if (!e.c) {
            h2 = null;
        } else {
            h h3;
            h2 = h3;
            h3 = new h(new h.d(this, new h.a(), false));
        }
        TaskRunnerImpl taskRunnerImpl2 = this;
        TaskRunnerImpl taskRunnerImpl3 = this;
        taskRunnerImpl3.mLifetimeAssert = h2;
        taskRunnerImpl3.mPreNativeTasks = new LinkedList();
        taskRunnerImpl3.mPreNativeDelayedTasks = new ArrayList<Pair<Runnable, Long>>();
        taskRunnerImpl2.mTaskTraits = k2;
        taskRunnerImpl2.mTraceEvent = string2 + ".PreNativeTask.run";
        this.mTaskRunnerType = n2;
        if (!PostTask.registerPreNativeTaskRunnerLocked(this)) {
            this.initNativeTaskRunner();
        }
    }

    private native long nativeInit(int var1, boolean var2, int var3, boolean var4, byte var5, byte[] var6);

    private native void nativeDestroy(long var1);

    private native void nativePostDelayedTask(long var1, Runnable var3, long var4);

    static {
        $assertionsDisabled = TaskRunnerImpl.class.desiredAssertionStatus() ^ true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() {
        TaskRunnerImpl taskRunnerImpl = this;
        Object object = taskRunnerImpl.mLock;
        synchronized (object) {
            try {
                h h2 = taskRunnerImpl.mLifetimeAssert;
                boolean bl = true;
                if (e.c) {
                    h2.b.c = bl;
                }
                this.mIsDestroying = true;
                this.destroyInternal();
                return;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    @GuardedBy(value="mLock")
    public void destroyInternal() {
        long l2 = this.mNativeTaskRunnerAndroid;
        if (l2 != 0L) {
            this.nativeDestroy(l2);
        }
        this.mNativeTaskRunnerAndroid = 0L;
    }

    @Override
    public void disableLifetimeCheck() {
        h h2 = ((TaskRunnerImpl)((Object)h2)).mLifetimeAssert;
        boolean bl = true;
        if (e.c) {
            h2.b.c = bl;
        }
    }

    @Override
    public void postTask(Runnable runnable) {
        this.postDelayedTask(runnable, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void postDelayedTask(Runnable runnable, long l2) {
        Object object = taskRunnerImpl2.mLock;
        synchronized (object) {
            if (!$assertionsDisabled && taskRunnerImpl2.mIsDestroying) {
                throw new AssertionError();
            }
            if (taskRunnerImpl2.mPreNativeTasks == null) {
                taskRunnerImpl2.postDelayedTaskToNative(runnable, l2);
                return;
            }
            if (l2 == 0L) {
                TaskRunnerImpl taskRunnerImpl = taskRunnerImpl2;
                taskRunnerImpl.mPreNativeTasks.add(runnable);
                taskRunnerImpl.schedulePreNativeTask();
            } else {
                Pair pair;
                TaskRunnerImpl taskRunnerImpl = taskRunnerImpl2;
                TaskRunnerImpl taskRunnerImpl2 = pair;
                pair = new Pair((Object)runnable, (Object)l2);
                taskRunnerImpl.mPreNativeDelayedTasks.add((Pair<Runnable, Long>)taskRunnerImpl2);
            }
            return;
        }
    }

    public void schedulePreNativeTask() {
        PostTask.getPrenativeThreadPoolExecutor().execute(this.mRunPreNativeTaskClosure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void runPreNativeTask() {
        Throwable throwable;
        TaskRunnerImpl taskRunnerImpl = runnable;
        TraceEvent traceEvent = TraceEvent.scoped(taskRunnerImpl.mTraceEvent, null);
        Throwable throwable2 = null;
        Object object = taskRunnerImpl.mLock;
        // MONITORENTER : object
        if (taskRunnerImpl.mPreNativeTasks == null) {
            // MONITOREXIT : object
            if (traceEvent == null) return;
            traceEvent.close();
            return;
        }
        TaskRunnerImpl taskRunnerImpl2 = runnable;
        Runnable runnable = ((TaskRunnerImpl)((Object)runnable)).mPreNativeTasks.poll();
        // MONITOREXIT : object
        int n2 = taskRunnerImpl2.mTaskTraits.f;
        Process.setThreadPriority((int)(n2 != 1 ? (n2 != 2 ? 10 : -1) : 0));
        runnable.run();
        if (traceEvent == null) return;
        traceEvent.close();
        return;
        catch (Throwable throwable3) {
            // MONITOREXIT : object
            try {
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throwable = throwable2;
                throwable2 = throwable4;
            }
            catch (Throwable throwable5) {
                try {
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    // empty catch block
                }
            }
        }
        if (traceEvent == null) throw throwable2;
        if (throwable == null) {
            traceEvent.close();
            throw throwable2;
        }
        try {
            traceEvent.close();
            throw throwable2;
        }
        catch (Throwable throwable7) {
            throwable.addSuppressed(throwable7);
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initNativeTaskRunner() {
        Object object = this.mLock;
        TaskRunnerImpl taskRunnerImpl = this;
        synchronized (object) {
            taskRunnerImpl.initNativeTaskRunnerInternal();
            taskRunnerImpl.migratePreNativeTasksToNative();
            return;
        }
    }

    @GuardedBy(value="mLock")
    public void initNativeTaskRunnerInternal() {
        if (((TaskRunnerImpl)((Object)k2)).mNativeTaskRunnerAndroid == 0L) {
            TaskRunnerImpl taskRunnerImpl = k2;
            k k2 = ((TaskRunnerImpl)((Object)k2)).mTaskTraits;
            taskRunnerImpl.mNativeTaskRunnerAndroid = taskRunnerImpl.nativeInit(taskRunnerImpl.mTaskRunnerType, k2.e, k2.f, k2.g, k2.h, k2.i);
        }
    }

    @GuardedBy(value="mLock")
    public void migratePreNativeTasksToNative() {
        Object object = this.mPreNativeTasks;
        if (object != null) {
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext()) {
                this.postDelayedTaskToNative((Runnable)object.next(), 0L);
            }
            for (Pair<Runnable, Long> pair : this.mPreNativeDelayedTasks) {
                this.postDelayedTaskToNative((Runnable)pair.first, (Long)pair.second);
            }
            TaskRunnerImpl taskRunnerImpl = this;
            taskRunnerImpl.mPreNativeTasks = null;
            taskRunnerImpl.mPreNativeDelayedTasks = null;
        }
    }

    @GuardedBy(value="mLock")
    public void postDelayedTaskToNative(Runnable runnable, long l2) {
        TaskRunnerImpl taskRunnerImpl = this;
        taskRunnerImpl.nativePostDelayedTask(taskRunnerImpl.mNativeTaskRunnerAndroid, runnable, l2);
    }

    public native boolean nativeBelongsToCurrentThread(long var1);
}

