/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.task;

import a.b.a.c;
import a.b.a.e.d;
import a.b.a.e.e;
import a.b.a.e.i;
import a.b.a.e.j;
import a.b.a.e.k;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.task.TaskExecutor;

@JNINamespace(value="base")
public class PostTask {
    public static final Object sLock;
    public static Set<j> sPreNativeTaskRunners;
    public static final Executor sPrenativeThreadPoolExecutor;
    public static Executor sPrenativeThreadPoolExecutorOverride;
    public static final TaskExecutor[] sTaskExecutors;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public static TaskExecutor[] getInitialTaskExecutors() {
        d d2;
        TaskExecutor[] taskExecutorArray = new TaskExecutor[5];
        d d3 = d2;
        d2 = new d();
        taskExecutorArray[0] = d3;
        return taskExecutorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static j createTaskRunner(k k2) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(k2).createTaskRunner(k2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static e createSequencedTaskRunner(k k2) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(k2).createSequencedTaskRunner(k2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static i createSingleThreadTaskRunner(k k2) {
        Object object = sLock;
        synchronized (object) {
            return PostTask.getTaskExecutorForTraits(k2).createSingleThreadTaskRunner(k2);
        }
    }

    public static void postTask(k k2, Runnable runnable) {
        PostTask.postDelayedTask(k2, runnable, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void postDelayedTask(k k2, Runnable runnable, long l2) {
        Object object = sLock;
        synchronized (object) {
            if (sPreNativeTaskRunners != null) {
                PostTask.getTaskExecutorForTraits(k2).postDelayedTask(k2, runnable, l2);
            } else {
                PostTask.nativePostDelayedTask(k2.e, k2.f, k2.g, k2.h, k2.i, runnable, l2);
            }
            return;
        }
    }

    public static void runOrPostTask(k k2, Runnable runnable) {
        if (PostTask.getTaskExecutorForTraits(k2).canRunTaskImmediately(k2)) {
            runnable.run();
        } else {
            PostTask.postDelayedTask(k2, runnable, 0L);
        }
    }

    @Deprecated
    public static <T> T runSynchronously(k k2, Callable<T> callable) {
        return PostTask.runSynchronouslyInternal(k2, new FutureTask<T>(callable));
    }

    @Deprecated
    public static void runSynchronously(k k2, Runnable runnable) {
        PostTask.runSynchronouslyInternal(k2, new FutureTask<Object>(runnable, null));
    }

    public static <T> T runSynchronouslyInternal(k k2, FutureTask<T> futureTask) {
        PostTask.runOrPostTask(k2, futureTask);
        try {
            return futureTask.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void registerTaskExecutor(int n2, TaskExecutor taskExecutor) {
        Object object = sLock;
        synchronized (object) {
            if (!$assertionsDisabled && n2 == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n2 > 4) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && sTaskExecutors[n2] != null) {
                throw new AssertionError();
            }
            PostTask.sTaskExecutors[n2] = taskExecutor;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPrenativeThreadPoolExecutorForTesting(Executor executor) {
        Object object = sLock;
        synchronized (object) {
            sPrenativeThreadPoolExecutorOverride = executor;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPrenativeThreadPoolExecutorForTesting() {
        Object object = sLock;
        synchronized (object) {
            sPrenativeThreadPoolExecutorOverride = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Executor getPrenativeThreadPoolExecutor() {
        Object object = sLock;
        synchronized (object) {
            if (sPrenativeThreadPoolExecutorOverride != null) {
                return sPrenativeThreadPoolExecutorOverride;
            }
            return sPrenativeThreadPoolExecutor;
        }
    }

    public static boolean registerPreNativeTaskRunnerLocked(j j2) {
        Set<j> set = sPreNativeTaskRunners;
        if (set != null) {
            set.add(j2);
            return true;
        }
        return false;
    }

    public static TaskExecutor getTaskExecutorForTraits(k k2) {
        return sTaskExecutors[k2.h];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void onNativeSchedulerReady() {
        Object object = sLock;
        synchronized (object) {
            Iterator<j> iterator = sPreNativeTaskRunners.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    sPreNativeTaskRunners = null;
                    return;
                }
                iterator.next().initNativeTaskRunner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onNativeSchedulerShutdown() {
        Object object = sLock;
        synchronized (object) {
            sPreNativeTaskRunners = Collections.newSetFromMap(new WeakHashMap());
            return;
        }
    }

    public static native void nativePostDelayedTask(boolean var0, int var1, boolean var2, byte var3, byte[] var4, Runnable var5, long var6);

    static {
        $assertionsDisabled = PostTask.class.desiredAssertionStatus() ^ true;
        sLock = new Object();
        sPreNativeTaskRunners = Collections.newSetFromMap(new WeakHashMap());
        sPrenativeThreadPoolExecutor = new c.a();
        sTaskExecutors = PostTask.getInitialTaskExecutors();
    }
}

