/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import a.b.a.a.b;
import a.b.a.a.c;
import a.b.a.a.d;
import a.b.a.c.a;
import a.b.a.e;
import a.b.a.e.k;
import a.b.a.g;
import a.b.a.j;
import a.b.a.m;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.StrictMode;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.system.Os;
import com.vccorp.base.library_loader.Linker;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.chromium.base.BuildInfo;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.SysUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.base.task.PostTask;

@JNINamespace(value="base::android")
@MainDex
public class LibraryLoader {
    public static final String TAG = "LibraryLoader";
    public static final boolean DEBUG = false;
    public static final boolean PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION;
    public static final String LIBRARY_DIR = "native_libraries";
    public static final String DONT_PREFETCH_LIBRARIES_KEY = "dont_prefetch_libraries";
    public static final String REACHED_CODE_PROFILER_ENABLED_KEY = "reached_code_profiler_enabled";
    public static final a.e sRelinkerCountHistogram;
    public static LibraryLoader sInstance;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public volatile boolean mInitialized;
    public final AtomicBoolean mPrefetchLibraryHasBeenCalled = new AtomicBoolean();
    public final Object mLock = new Object();
    public c mLibraryPreloader;
    public boolean mLibraryPreloaderCalled;
    public boolean mLoaded;
    public boolean mLoadedByZygote;
    public boolean mCommandLineSwitched;
    public boolean mIsUsingBrowserSharedRelros;
    public boolean mLoadAtFixedAddressFailed;
    public boolean mLibraryWasLoadedFromApk;
    public int mLibraryProcessType;
    public long mLibraryLoadTimeMs;
    public int mLibraryPreloaderStatus = -1;

    public static boolean useCrazyLinker() {
        return b.a;
    }

    public static boolean isInZipFile() {
        return b.b;
    }

    public static LibraryLoader getInstance() {
        return sInstance;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void preloadAlreadyLocked(ApplicationInfo applicationInfo) {
        Throwable throwable2222222;
        TraceEvent traceEvent = TraceEvent.scoped("LibraryLoader.preloadAlreadyLocked", null);
        applicationInfo = null;
        if (!$assertionsDisabled) {
            if (b.a) throw new AssertionError();
        }
        if (traceEvent == null) return;
        traceEvent.close();
        return;
        {
            catch (Throwable throwable2222222) {
            }
            catch (Throwable throwable3) {}
            {
                throw throwable3;
            }
        }
        if (traceEvent == null) throw throwable2222222;
        if (applicationInfo == null) {
            traceEvent.close();
            throw throwable2222222;
        }
        try {
            traceEvent.close();
            throw throwable2222222;
        }
        catch (Throwable throwable4) {
            applicationInfo.addSuppressed(throwable4);
            throw throwable2222222;
        }
    }

    public static void setDontPrefetchLibrariesOnNextRuns(boolean bl) {
        ContextUtils.getAppSharedPreferences().edit().putBoolean(DONT_PREFETCH_LIBRARIES_KEY, bl).apply();
    }

    public static boolean isNotPrefetchingLibraries() {
        SharedPreferences sharedPreferences;
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            sharedPreferences = ContextUtils.getAppSharedPreferences();
        }
        catch (Throwable throwable) {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            throw throwable;
        }
        boolean bl = sharedPreferences.getBoolean(DONT_PREFETCH_LIBRARIES_KEY, false);
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        return bl;
    }

    public static void setReachedCodeProfilerEnabledOnNextRuns(boolean bl) {
        ContextUtils.getAppSharedPreferences().edit().putBoolean(REACHED_CODE_PROFILER_ENABLED_KEY, bl).apply();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReachedCodeProfilerEnabled() {
        Throwable throwable3222222;
        m m2 = m.g();
        Throwable throwable2 = null;
        boolean bl = ContextUtils.getAppSharedPreferences().getBoolean(REACHED_CODE_PROFILER_ENABLED_KEY, false);
        m2.close();
        return bl;
        {
            catch (Throwable throwable3222222) {
            }
            catch (Throwable throwable4) {}
            {
                throw throwable4;
            }
        }
        if (throwable2 == null) {
            m2.close();
            throw throwable3222222;
        }
        try {
            m2.close();
            throw throwable3222222;
        }
        catch (Throwable throwable5) {
            throwable2.addSuppressed(throwable5);
            throw throwable3222222;
        }
    }

    private void loadLibraryWithCustomLinkerAlreadyLocked(Linker objectArray, @Nullable String string2, String string3) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.mLock)) {
            throw new AssertionError();
        }
        if (objectArray.i()) {
            this.mIsUsingBrowserSharedRelros = true;
            try {
                objectArray.a(string3, true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Object[] objectArray2 = objectArray;
                objectArray = new Object[]{};
                j.d(TAG, "Failed to load native library with shared RELRO, retrying without", objectArray);
                this.mLoadAtFixedAddressFailed = true;
                objectArray2.a(string3, false);
            }
        } else {
            objectArray.a(string3, true);
        }
        if (string2 != null) {
            this.mLibraryWasLoadedFromApk = true;
        }
    }

    public static void incrementRelinkerCountHitHistogram() {
        sRelinkerCountHistogram.a(1);
    }

    public static void incrementRelinkerCountNotHitHistogram() {
        sRelinkerCountHistogram.a(0);
    }

    public static String getExtractedLibraryPath(ApplicationInfo objectArray, String string2) {
        if (!$assertionsDisabled && !PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION) {
            throw new AssertionError();
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string2;
        j.d(TAG, "Failed to load libName %s, attempting fallback extraction then trying again", objectArray);
        return LibraryLoader.extractFileIfStale((ApplicationInfo)objectArray2, LibraryLoader.makeLibraryPathInZipFile(string2, false, false), LibraryLoader.makeLibraryDirAndSetPermission());
    }

    /*
     * Exception decompiling
     */
    @SuppressLint(value={"DefaultLocale", "UnsafeDynamicallyLoadedCode"})
    private void loadAlreadyLocked(ApplicationInfo var1_6, boolean var2_9) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 34[TRYBLOCK] [66, 67 : 380->404)] java.lang.UnsatisfiedLinkError
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static String makeLibraryPathInZipFile(String string2, boolean bl, boolean bl2) {
        String string3;
        int n2 = b.f;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) throw new RuntimeException("Unknown CPU ABI for native libraries");
                string3 = bl2 ? "x86_64" : "x86";
            } else {
                string3 = bl2 ? "mips64" : "mips";
            }
        } else {
            string3 = bl2 ? "arm64-v8a" : "armeabi-v7a";
        }
        String string4 = bl ? "crazy." : "";
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string3;
        objectArray2[1] = string4;
        objectArray[2] = System.mapLibraryName(string2);
        return String.format("lib/%s/%s%s", objectArray2);
    }

    private void ensureCommandLineSwitchedAlreadyLocked() {
        if (!$assertionsDisabled && !this.mLoaded) {
            throw new AssertionError();
        }
        if (this.mCommandLineSwitched) {
            return;
        }
        CommandLine.enableNativeProxy();
        this.mCommandLineSwitched = true;
    }

    private void initializeAlreadyLocked(int n2) {
        if (objectArray4.mInitialized) {
            if (objectArray4.mLibraryProcessType == n2) {
                return;
            }
            throw new d(2);
        }
        objectArray4.mLibraryProcessType = n2;
        if (objectArray4.mLibraryProcessType == 1 && LibraryLoader.isReachedCodeProfilerEnabled()) {
            CommandLine.getInstance().appendSwitch("enable-reached-code-profiler");
        }
        Object[] objectArray = objectArray4;
        objectArray.ensureCommandLineSwitchedAlreadyLocked();
        if (objectArray4.nativeLibraryLoaded(objectArray.mLibraryProcessType)) {
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = b.e;
            objectArray2[1] = super.nativeGetVersionNumber();
            String string2 = String.format("Expected native library version number \"%s\", actual native library version number \"%s\"", objectArray3);
            objectArray3 = new Object[]{};
            j.c(TAG, string2, objectArray3);
            if (b.e.equals(super.nativeGetVersionNumber())) {
                TraceEvent.nativeRegisterEnabledObserver();
                if (n2 == 1 && PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION) {
                    PostTask.postDelayedTask(k.a, () -> {
                        String string2 = BuildInfo.getInstance().extractedFileSuffix;
                        File[] fileArray = LibraryLoader.getLibraryDir().listFiles();
                        if (fileArray == null) {
                            return;
                        }
                        for (File file : fileArray) {
                            Object[] objectArray;
                            if (file.getName().contains(string2)) continue;
                            File file2 = file;
                            String string3 = file2.getName();
                            if (!file2.delete()) {
                                Object[] objectArray2 = new Object[1];
                                objectArray = objectArray2;
                                objectArray2[0] = string3;
                                j.d(TAG, "Unable to remove %s", objectArray);
                                continue;
                            }
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = string3;
                            j.c(TAG, "Removed obsolete file %s", objectArray);
                        }
                    }, 0L);
                }
                objectArray4.mInitialized = true;
                return;
            }
            throw new d(3);
        }
        Object[] objectArray4 = new Object[]{};
        j.b(TAG, "error calling nativeLibraryLoaded", objectArray4);
        throw new d(1);
    }

    private void recordBrowserProcessHistogramAlreadyLocked() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.mLock)) {
            throw new AssertionError();
        }
        if (b.a) {
            LibraryLoader libraryLoader = this;
            boolean bl = libraryLoader.mIsUsingBrowserSharedRelros;
            boolean bl2 = libraryLoader.mLoadAtFixedAddressFailed;
            int n2 = libraryLoader.mLibraryWasLoadedFromApk ? 3 : 0;
            this.nativeRecordChromiumAndroidLinkerBrowserHistogram(bl, bl2, n2, this.mLibraryLoadTimeMs);
        }
    }

    public static void setLibraryLoaderForTesting(LibraryLoader libraryLoader) {
        sInstance = libraryLoader;
    }

    public static void setEnvForNative() {
        if (e.d && Build.VERSION.SDK_INT >= 21) {
            try {
                Os.setenv((String)"UBSAN_OPTIONS", (String)"print_stacktrace=1 stack_trace_format='#%n pc %o %m' handle_segv=0 handle_sigbus=0 handle_sigfpe=0", (boolean)true);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = exception;
                j.d(TAG, "failed to set UBSAN_OPTIONS", objectArray2);
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"SetWorldReadable"})
    public static String extractFileIfStale(ApplicationInfo object, String string2, File file) {
        void var0_6;
        Object object2;
        block15: {
            void var0_5;
            block14: {
                ZipFile zipFile;
                File file2;
                if (!$assertionsDisabled) {
                    if (!PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION) throw new AssertionError();
                }
                object = object.sourceDir;
                object2 = new File(string2).getName() + BuildInfo.getInstance().extractedFileSuffix;
                File file3 = file2;
                if (new File(file, (String)object2).exists()) return file3.getAbsolutePath();
                file = null;
                Object object3 = object2 = zipFile;
                String string3 = string2;
                ((ZipFile)object2)((String)object);
                object = ((ZipFile)object3).getEntry(string3);
                if (object == null) break block14;
                Object object4 = object2;
                File file4 = file3;
                g.a(((ZipFile)object2).getInputStream((ZipEntry)object), file3, new byte[16384]);
                file4.setReadable(true, false);
                file4.setExecutable(true, false);
                try {
                    ((ZipFile)object4).close();
                    return file3.getAbsolutePath();
                }
                catch (IOException iOException) {
                    return file3.getAbsolutePath();
                }
            }
            try {
                throw new RuntimeException("Cannot find ZipEntry" + string2);
            }
            catch (Throwable throwable) {
            }
            catch (IOException iOException) {
                throw new RuntimeException((Throwable)var0_5);
            }
            catch (Throwable throwable) {
                object2 = file;
                break block15;
            }
            catch (IOException iOException) {
                object2 = file;
            }
            throw new RuntimeException((Throwable)var0_5);
        }
        if (object2 == null) {
            throw var0_6;
        }
        try {
            ((ZipFile)object2).close();
            throw var0_6;
        }
        catch (IOException iOException) {}
        throw var0_6;
    }

    public static File makeLibraryDirAndSetPermission() {
        if (!ContextUtils.isIsolatedProcess()) {
            File file;
            File file2 = ContextCompat.getCodeCacheDir((Context)ContextUtils.sApplicationContext);
            File file3 = file;
            File file4 = file2;
            file3(file2, LIBRARY_DIR);
            file4.mkdir();
            file4.setExecutable(true, false);
            file.mkdir();
            file.setExecutable(true, false);
        }
        return LibraryLoader.getLibraryDir();
    }

    public static File getLibraryDir() {
        return new File(ContextCompat.getCodeCacheDir((Context)ContextUtils.sApplicationContext), LIBRARY_DIR);
    }

    private native boolean nativeLibraryLoaded(int var1);

    private native void nativeRecordChromiumAndroidLinkerBrowserHistogram(boolean var1, boolean var2, int var3, long var4);

    private native void nativeRecordLibraryPreloaderBrowserHistogram(int var1);

    private native void nativeRegisterChromiumAndroidLinkerRendererHistogram(boolean var1, boolean var2, long var3);

    private native void nativeRegisterLibraryPreloaderRendererHistogram(int var1);

    private native String nativeGetVersionNumber();

    public static native void nativeForkAndPrefetchNativeLibrary();

    public static native int nativePercentageOfResidentNativeLibraryCode();

    public static native void nativePeriodicallyCollectResidency();

    static {
        $assertionsDisabled = LibraryLoader.class.desiredAssertionStatus() ^ true;
        PLATFORM_REQUIRES_NATIVE_FALLBACK_EXTRACTION = Build.VERSION.SDK_INT <= 19;
        sRelinkerCountHistogram = new a.e("ChromiumAndroidLinker.RelinkerFallbackCount", 2);
        sInstance = new LibraryLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNativeLibraryPreloader(c object) {
        object = this.mLock;
        synchronized (object) {
            if (!$assertionsDisabled && this.mLoaded) {
                throw new AssertionError();
            }
            return;
        }
    }

    public boolean isLoadedByZygote() {
        return this.mLoadedByZygote;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ensureInitialized(int n2) {
        LibraryLoader libraryLoader = this;
        Object object = libraryLoader.mLock;
        synchronized (object) {
            if (libraryLoader.mInitialized) {
                return;
            }
            this.loadAlreadyLocked(ContextUtils.sApplicationContext.getApplicationInfo(), false);
            this.initializeAlreadyLocked(n2);
            return;
        }
    }

    public void preloadNow() {
        this.preloadNowOverrideApplicationContext(ContextUtils.sApplicationContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void preloadNowOverrideApplicationContext(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (!b.a) {
                    this.preloadAlreadyLocked(context.getApplicationInfo());
                }
                return;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void loadNow() {
        this.loadNowOverrideApplicationContext(ContextUtils.sApplicationContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadNowOverrideApplicationContext(Context context) {
        LibraryLoader libraryLoader = this;
        Object object = libraryLoader.mLock;
        synchronized (object) {
            block6: {
                block5: {
                    if (libraryLoader.mLoaded && context != ContextUtils.sApplicationContext) break block5;
                    break block6;
                }
                throw new IllegalStateException("Attempt to load again from alternate context.");
            }
            this.loadAlreadyLocked(context.getApplicationInfo(), false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNowInZygote(ApplicationInfo applicationInfo) {
        Object object = this.mLock;
        synchronized (object) {
            block7: {
                if ($assertionsDisabled) break block7;
                if (!this.mLoaded) break block7;
                throw new AssertionError();
            }
            this.loadAlreadyLocked(applicationInfo, true);
            this.mLoadedByZygote = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(int n2) {
        Object object = this.mLock;
        synchronized (object) {
            this.initializeAlreadyLocked(n2);
            return;
        }
    }

    public void asyncPrefetchLibrariesToMemory() {
        SysUtils.nativeLogPageFaultCountToTracing();
        if (LibraryLoader.isNotPrefetchingLibraries()) {
            return;
        }
        boolean bl = this.mPrefetchLibraryHasBeenCalled.compareAndSet(false, true);
        if (bl && CommandLine.getInstance().hasSwitch("log-native-library-residency")) {
            new Thread(LibraryLoader::nativePeriodicallyCollectResidency).start();
            return;
        }
        PostTask.postDelayedTask(k.c, () -> {
            TraceEvent traceEvent;
            block12: {
                Throwable throwable;
                Throwable throwable2;
                block10: {
                    Throwable throwable32;
                    block11: {
                        int n2 = LibraryLoader.nativePercentageOfResidentNativeLibraryCode();
                        traceEvent = TraceEvent.scoped("LibraryLoader.asyncPrefetchLibrariesToMemory", Integer.toString(n2));
                        Throwable throwable4 = null;
                        if (bl && n2 < 90) {
                            try {
                                LibraryLoader.nativeForkAndPrefetchNativeLibrary();
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable4;
                                throwable = throwable5;
                                break block10;
                            }
                            catch (Throwable throwable32) {
                                break block11;
                            }
                        }
                        if (n2 != -1) {
                            StringBuilder stringBuilder = new StringBuilder().append("LibraryLoader.PercentageOfResidentCodeBeforePrefetch");
                            String string2 = bl ? ".ColdStartup" : ".WarmStartup";
                            RecordHistogram.recordPercentageHistogram(stringBuilder.append(string2).toString(), n2);
                        }
                        break block12;
                    }
                    try {
                        throw throwable32;
                    }
                    catch (Throwable throwable6) {
                        // empty catch block
                    }
                }
                if (traceEvent == null) throw throwable;
                if (throwable2 == null) {
                    traceEvent.close();
                    throw throwable;
                }
                try {
                    traceEvent.close();
                    throw throwable;
                }
                catch (Throwable throwable7) {
                    throwable2.addSuppressed(throwable7);
                    throw throwable;
                }
            }
            if (traceEvent == null) return;
            traceEvent.close();
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCommandLineForWebView() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureCommandLineSwitchedAlreadyLocked();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNativeInitializationComplete() {
        Object object = this.mLock;
        synchronized (object) {
            this.recordBrowserProcessHistogramAlreadyLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerRendererProcessHistogram(boolean bl, boolean bl2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (b.a) {
                    this.nativeRegisterChromiumAndroidLinkerRendererHistogram(bl, bl2, this.mLibraryLoadTimeMs);
                }
                return;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }
}

