/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import a.b.a.e;
import android.annotation.TargetApi;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.chromium.base.CommandLine;

public class LocaleUtils {
    public static String getUpdatedLanguageForChromium(String string2) {
        int n2 = -1;
        int n3 = string2.hashCode();
        if (n3 != 3365) {
            if (n3 != 3374) {
                if (n3 != 3391) {
                    if (n3 == 3704 && string2.equals("tl")) {
                        n2 = 3;
                    }
                } else if (string2.equals("ji")) {
                    n2 = 1;
                }
            } else if (string2.equals("iw")) {
                n2 = 0;
            }
        } else if (string2.equals("in")) {
            n2 = 2;
        }
        switch (n2) {
            default: {
                return string2;
            }
            case 3: {
                return "fil";
            }
            case 2: {
                return "id";
            }
            case 1: {
                return "yi";
            }
            case 0: 
        }
        return "he";
    }

    @TargetApi(value=21)
    public static Locale getUpdatedLocaleForChromium(Locale locale) {
        String string2 = locale.getLanguage();
        String string3 = LocaleUtils.getUpdatedLanguageForChromium(string2);
        if (string3.equals(string2)) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(string3).build();
    }

    public static String getUpdatedLanguageForAndroid(String string2) {
        int n2 = -1;
        int n3 = string2.hashCode();
        if (n3 != 101385) {
            if (n3 == 115947 && string2.equals("und")) {
                n2 = 0;
            }
        } else if (string2.equals("fil")) {
            n2 = 1;
        }
        if (n2 != 0) {
            if (n2 != 1) {
                return string2;
            }
            return "tl";
        }
        return "";
    }

    @TargetApi(value=21)
    public static Locale getUpdatedLocaleForAndroid(Locale locale) {
        String string2 = locale.getLanguage();
        String string3 = LocaleUtils.getUpdatedLanguageForAndroid(string2);
        if (string3.equals(string2)) {
            return locale;
        }
        return new Locale.Builder().setLocale(locale).setLanguage(string3).build();
    }

    public static Locale forLanguageTagCompat(String object) {
        if (((String[])(object = ((String)object).split("-"))).length == 0) {
            return new Locale("");
        }
        String string2 = LocaleUtils.getUpdatedLanguageForAndroid(object[0]);
        if (string2.length() != 2 && string2.length() != 3) {
            return new Locale("");
        }
        if (((String[])object).length == 1) {
            return new Locale(string2);
        }
        if (((String)(object = object[1])).length() != 2 && ((String)object).length() != 3) {
            return new Locale(string2);
        }
        return new Locale(string2, (String)object);
    }

    public static Locale forLanguageTag(String string2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return LocaleUtils.getUpdatedLocaleForAndroid(Locale.forLanguageTag(string2));
        }
        return LocaleUtils.forLanguageTagCompat(string2);
    }

    public static String toLanguageTag(Locale locale) {
        String string2 = LocaleUtils.getUpdatedLanguageForChromium(locale.getLanguage());
        String string3 = locale.getCountry();
        if (string2.equals("no") && string3.equals("NO") && locale.getVariant().equals("NY")) {
            return "nn-NO";
        }
        if (!string3.isEmpty()) {
            string2 = string2 + "-" + string3;
        }
        return string2;
    }

    @TargetApi(value=24)
    public static String toLanguageTags(LocaleList localeList) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < localeList.size(); ++i2) {
            arrayList2.add(LocaleUtils.toLanguageTag(LocaleUtils.getUpdatedLocaleForChromium(localeList.get(i2))));
        }
        return TextUtils.join((CharSequence)",", arrayList2);
    }

    public static String toLanguage(String string2) {
        int n2 = string2.indexOf(45);
        if (n2 < 0) {
            return string2;
        }
        return string2.substring(0, n2);
    }

    public static boolean isLanguageSupported(String string2) {
        String[] stringArray = e.e;
        int n2 = e.e.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!LocaleUtils.toLanguage(stringArray[i2]).equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getDefaultLocaleString() {
        return LocaleUtils.toLanguageTag(Locale.getDefault());
    }

    public static String getDefaultLocaleListString() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleUtils.toLanguageTags(LocaleList.getDefault());
        }
        return LocaleUtils.toLanguageTag(Locale.getDefault());
    }

    public static String getDefaultCountryCode() {
        CommandLine commandLine = CommandLine.getInstance();
        return commandLine.hasSwitch("default-country-code") ? commandLine.getSwitchValue("default-country-code") : Locale.getDefault().getCountry();
    }
}

