/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.chromium.base.ContextUtils;

public abstract class ContentUriUtils {
    public static final String TAG = "ContentUriUtils";
    public static FileProviderUtil sFileProviderUtil;
    public static final Object sLock;
    public static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFileProviderUtil(FileProviderUtil fileProviderUtil) {
        Object object = sLock;
        synchronized (object) {
            sFileProviderUtil = fileProviderUtil;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Uri getContentUriFromFile(File file) {
        Object object = sLock;
        synchronized (object) {
            if (sFileProviderUtil != null) {
                return sFileProviderUtil.getContentUriFromFile(file);
            }
            return null;
        }
    }

    public static int openContentUriForRead(String string2) {
        if ((string2 = ContentUriUtils.getAssetFileDescriptor(string2)) != null) {
            return string2.getParcelFileDescriptor().detachFd();
        }
        return -1;
    }

    public static boolean contentUriExists(String string2) {
        boolean bl;
        block4: {
            string2 = ContentUriUtils.getAssetFileDescriptor(string2);
            bl = string2 != null;
            if (string2 == null) break block4;
            try {
                string2.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    public static String getMimeType(String stringArray) {
        String[] stringArray2 = stringArray;
        stringArray = ContextUtils.sApplicationContext.getContentResolver();
        Uri uri = Uri.parse((String)stringArray2);
        if (ContentUriUtils.isVirtualDocument(uri)) {
            return (stringArray = stringArray.getStreamTypes(uri, "*/*")) != null && stringArray.length > 0 ? stringArray[0] : null;
        }
        return stringArray.getType(uri);
    }

    public static AssetFileDescriptor getAssetFileDescriptor(String string2) {
        block17: {
            Uri uri;
            ContentResolver contentResolver;
            block16: {
                block18: {
                    contentResolver = ContextUtils.sApplicationContext.getContentResolver();
                    uri = Uri.parse((String)string2);
                    if (!ContentUriUtils.isVirtualDocument(uri)) break block16;
                    String[] stringArray = contentResolver.getStreamTypes(uri, "*/*");
                    if (stringArray == null) break block17;
                    if (stringArray.length <= 0) break block17;
                    String string3 = stringArray[0];
                    contentResolver = contentResolver.openTypedAssetFileDescriptor(uri, string3, null);
                    if (contentResolver == null) break block18;
                    if (contentResolver.getStartOffset() == 0L) break block18;
                    try {
                        contentResolver.close();
                    }
                    catch (IOException iOException) {}
                    throw new SecurityException("Cannot open files with non-zero offset type.");
                }
                return contentResolver;
            }
            contentResolver = contentResolver.openFileDescriptor(uri, "r");
            if (contentResolver == null) break block17;
            try {
                return new AssetFileDescriptor((ParcelFileDescriptor)contentResolver, 0L, -1L);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)("Unknown content uri: " + string2), (Throwable)exception);
            }
            catch (SecurityException securityException) {
                Log.w((String)TAG, (String)("Cannot open content uri: " + string2), (Throwable)securityException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.w((String)TAG, (String)("Cannot find content uri: " + string2), (Throwable)fileNotFoundException);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static String getDisplayName(Uri var0, Context var1_4, String var2_6) {
        block23: {
            block26: {
                block25: {
                    block24: {
                        if (var0 /* !! */  == null) {
                            return "";
                        }
                        var1_4 /* !! */  = var1_4 /* !! */ .getContentResolver();
                        var4_10 = null;
                        var3_9 = var1_4 /* !! */ .query((Uri)var0 /* !! */ , null, null, null, null);
                        if (var3_9 == null) break block23;
                        {
                            catch (NullPointerException v0) {
                                return "";
                            }
                        }
                        if (var3_9.getCount() < 1) break block23;
                        var3_9.moveToFirst();
                        var2_7 = var3_9.getColumnIndex(var2_6);
                        if (var2_7 != -1) break block24;
                        var3_9.close();
                        return "";
                    }
                    v1 = var3_9;
                    var2_8 = v1.getString(var2_7);
                    if (!ContentUriUtils.hasVirtualFlag(v1)) break block25;
                    var0 /* !! */  = var1_4 /* !! */ .getStreamTypes((Uri)var0 /* !! */ , "*/*");
                    if (var0 /* !! */  == null) break block25;
                    if (var0 /* !! */ .length <= 0) break block25;
                    v2 = MimeTypeMap.getSingleton();
                    var0 /* !! */  = v2.getExtensionFromMimeType(var0 /* !! */ [0]);
                    if (var0 /* !! */  == null) break block25;
                    v3 = new StringBuilder().append(var2_8);
                    var2_8 = v3.append(".").append((String)var0 /* !! */ ).toString();
                }
                var3_9.close();
                return var2_8;
                catch (Throwable var0_1) {
                    var0_2 = var4_10;
                    var1_4 /* !! */  = var0_1;
                    break block26;
                }
                catch (Throwable var0_3) {
                    try {
                        throw var0_3;
                    }
                    catch (Throwable var1_5) {
                        // empty catch block
                    }
                }
            }
            if (var0_2 == null) ** GOTO lbl-1000
            try {
                var3_9.close();
            }
            catch (Throwable v4) {
                var0_2.addSuppressed(v4);
            }
            ** GOTO lbl-1000
lbl-1000:
            // 1 sources

            {
                var3_9.close();
lbl-1000:
                // 3 sources

                {
                    throw var1_4 /* !! */ ;
                }
            }
        }
        if (var3_9 != null) {
            var3_9.close();
        }
        return "";
    }

    @Nullable
    public static String maybeGetDisplayName(String string2) {
        Context context;
        try {
            context = ContextUtils.sApplicationContext;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("Cannot open content uri: " + string2), (Throwable)exception);
            return null;
        }
        String string3 = ContentUriUtils.getDisplayName(Uri.parse((String)string2), context, "_display_name");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = null;
        }
        return string3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVirtualDocument(Uri var0) {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        if (var0 == null) {
            return false;
        }
        if (!DocumentsContract.isDocumentUri((Context)ContextUtils.sApplicationContext, (Uri)var0)) {
            return false;
        }
        var0 = ContextUtils.sApplicationContext.getContentResolver().query(var0, null, null, null, null);
        v0 = var0;
        var1_1 = null;
lbl-1000:
        // 3 sources

        {
            catch (NullPointerException v1) {
                return false;
            }
        }
        if (v0 == null) ** GOTO lbl-1000
        if (var0.getCount() < 1) ** GOTO lbl-1000
        v2 = var0;
        v2.moveToFirst();
        v3 = ContentUriUtils.hasVirtualFlag((Cursor)v2);
        var0.close();
        return v3;
lbl-1000:
        // 2 sources

        {
            if (var0 == null) return false;
            var0.close();
            return false;
            {
                catch (Throwable var2_3) {
                }
                catch (Throwable var1_2) {}
                {
                    throw var1_2;
                }
            }
            if (var1_1 == null) ** GOTO lbl38
            try {
                var0.close();
                throw var2_3;
            }
            catch (Throwable v4) {
                ** try [egrp 5[TRYBLOCK] [8 : 97->123)] { 
lbl36:
                // 1 sources

                var1_1.addSuppressed(v4);
                throw var2_3;
lbl38:
                // 1 sources

                var0.close();
                throw var2_3;
            }
        }
    }

    public static boolean hasVirtualFlag(Cursor cursor) {
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        int n2 = cursor.getColumnIndex("flags");
        return n2 > -1 && (cursor.getLong(n2) & 0x200L) != 0L;
    }

    public static boolean isContentUri(String string2) {
        if (string2 == null) {
            return false;
        }
        return (string2 = Uri.parse((String)string2)) != null && "content".equals(string2.getScheme());
    }

    public static void delete(String string2) {
        if (!$assertionsDisabled && !ContentUriUtils.isContentUri(string2)) {
            throw new AssertionError();
        }
        ContextUtils.sApplicationContext.getContentResolver().delete(Uri.parse((String)string2), null, null);
    }

    static {
        $assertionsDisabled = ContentUriUtils.class.desiredAssertionStatus() ^ true;
        sLock = new Object();
    }

    public static interface FileProviderUtil {
        public Uri getContentUriFromFile(File var1);
    }
}

