
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/viz/public/interfaces/compositing/quads.mojom
//

package com.vccorp.viz.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class RenderPassQuadState extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 72;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(72, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public long renderPassId;
    public int maskResourceId;
    public com.vccorp.gfx.mojom.RectF maskUvRect;
    public com.vccorp.gfx.mojom.Size maskTextureSize;
    public com.vccorp.gfx.mojom.Vector2dF filtersScale;
    public com.vccorp.gfx.mojom.PointF filtersOrigin;
    public com.vccorp.gfx.mojom.RectF texCoordRect;
    public boolean forceAntiAliasingOff;
    public float backdropFilterQuality;

    private RenderPassQuadState(int version) {
        super(STRUCT_SIZE, version);
    }

    public RenderPassQuadState() {
        this(0);
    }

    public static RenderPassQuadState deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static RenderPassQuadState deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static RenderPassQuadState decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        RenderPassQuadState result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new RenderPassQuadState(elementsOrVersion);
                {
                    
                result.renderPassId = decoder0.readLong(8);
                }
                {
                    
                result.maskResourceId = decoder0.readInt(16);
                }
                {
                    
                result.forceAntiAliasingOff = decoder0.readBoolean(20, 0);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.maskUvRect = com.vccorp.gfx.mojom.RectF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.maskTextureSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.filtersScale = com.vccorp.gfx.mojom.Vector2dF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
                result.filtersOrigin = com.vccorp.gfx.mojom.PointF.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                result.texCoordRect = com.vccorp.gfx.mojom.RectF.decode(decoder1);
                }
                {
                    
                result.backdropFilterQuality = decoder0.readFloat(64);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.renderPassId, 8);
        
        encoder0.encode(this.maskResourceId, 16);
        
        encoder0.encode(this.forceAntiAliasingOff, 20, 0);
        
        encoder0.encode(this.maskUvRect, 24, false);
        
        encoder0.encode(this.maskTextureSize, 32, false);
        
        encoder0.encode(this.filtersScale, 40, false);
        
        encoder0.encode(this.filtersOrigin, 48, false);
        
        encoder0.encode(this.texCoordRect, 56, false);
        
        encoder0.encode(this.backdropFilterQuality, 64);
    }
}