
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     ui/latency/mojo/latency_info.mojom
//

package com.vccorp.ui.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class SourceEventType {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int UNKNOWN = 0;
    public static final int WHEEL = 1; // UNKNOWN + 1
    public static final int MOUSE = 2; // WHEEL + 1
    public static final int TOUCH = 3; // MOUSE + 1
    public static final int INERTIAL = 4; // TOUCH + 1
    public static final int KEY_PRESS = 5; // INERTIAL + 1
    public static final int TOUCHPAD = 6; // KEY_PRESS + 1
    public static final int FRAME = 7; // TOUCHPAD + 1
    public static final int OTHER = 8; // FRAME + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 8;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private SourceEventType() {}
}