
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/websocket.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class WebSocket_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<WebSocket, WebSocket.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<WebSocket, WebSocket.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.WebSocket";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, WebSocket impl) {
            return new Stub(core, impl);
        }

        @Override
        public WebSocket[] buildArray(int size) {
          return new WebSocket[size];
        }
    };


    private static final int ADD_CHANNEL_REQUEST_ORDINAL = 0;

    private static final int SEND_FRAME_ORDINAL = 1;

    private static final int SEND_FLOW_CONTROL_ORDINAL = 2;

    private static final int START_CLOSING_HANDSHAKE_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements WebSocket.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void addChannelRequest(
com.vccorp.url.mojom.Url url, String[] requestedProtocols, com.vccorp.url.mojom.Url firstPartyForCookies, HttpHeader[] additionalHeaders, WebSocketClient client) {

            WebSocketAddChannelRequestParams _message = new WebSocketAddChannelRequestParams();

            _message.url = url;

            _message.requestedProtocols = requestedProtocols;

            _message.firstPartyForCookies = firstPartyForCookies;

            _message.additionalHeaders = additionalHeaders;

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ADD_CHANNEL_REQUEST_ORDINAL)));

        }


        @Override
        public void sendFrame(
boolean fin, int type, byte[] data) {

            WebSocketSendFrameParams _message = new WebSocketSendFrameParams();

            _message.fin = fin;

            _message.type = type;

            _message.data = data;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SEND_FRAME_ORDINAL)));

        }


        @Override
        public void sendFlowControl(
long quota) {

            WebSocketSendFlowControlParams _message = new WebSocketSendFlowControlParams();

            _message.quota = quota;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SEND_FLOW_CONTROL_ORDINAL)));

        }


        @Override
        public void startClosingHandshake(
short code, String reason) {

            WebSocketStartClosingHandshakeParams _message = new WebSocketStartClosingHandshakeParams();

            _message.code = code;

            _message.reason = reason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(START_CLOSING_HANDSHAKE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<WebSocket> {

        Stub(com.vccorp.mojo.system.Core core, WebSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WebSocket_Internal.MANAGER, messageWithHeader);





                    case ADD_CHANNEL_REQUEST_ORDINAL: {

                        WebSocketAddChannelRequestParams data =
                                WebSocketAddChannelRequestParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addChannelRequest(data.url, data.requestedProtocols, data.firstPartyForCookies, data.additionalHeaders, data.client);
                        return true;
                    }





                    case SEND_FRAME_ORDINAL: {

                        WebSocketSendFrameParams data =
                                WebSocketSendFrameParams.deserialize(messageWithHeader.getPayload());

                        getImpl().sendFrame(data.fin, data.type, data.data);
                        return true;
                    }





                    case SEND_FLOW_CONTROL_ORDINAL: {

                        WebSocketSendFlowControlParams data =
                                WebSocketSendFlowControlParams.deserialize(messageWithHeader.getPayload());

                        getImpl().sendFlowControl(data.quota);
                        return true;
                    }





                    case START_CLOSING_HANDSHAKE_ORDINAL: {

                        WebSocketStartClosingHandshakeParams data =
                                WebSocketStartClosingHandshakeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().startClosingHandshake(data.code, data.reason);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WebSocket_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class WebSocketAddChannelRequestParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public String[] requestedProtocols;
        public com.vccorp.url.mojom.Url firstPartyForCookies;
        public HttpHeader[] additionalHeaders;
        public WebSocketClient client;

        private WebSocketAddChannelRequestParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketAddChannelRequestParams() {
            this(0);
        }

        public static WebSocketAddChannelRequestParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketAddChannelRequestParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketAddChannelRequestParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketAddChannelRequestParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketAddChannelRequestParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.requestedProtocols = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.requestedProtocols[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.firstPartyForCookies = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.additionalHeaders = new HttpHeader[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.additionalHeaders[i1] = HttpHeader.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    result.client = decoder0.readServiceInterface(40, false, WebSocketClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            if (this.requestedProtocols == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.requestedProtocols.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.requestedProtocols.length; ++i0) {
                    
                    encoder1.encode(this.requestedProtocols[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.firstPartyForCookies, 24, false);
            
            if (this.additionalHeaders == null) {
                encoder0.encodeNullPointer(32, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.additionalHeaders.length, 32, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.additionalHeaders.length; ++i0) {
                    
                    encoder1.encode(this.additionalHeaders[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            encoder0.encode(this.client, 40, false, WebSocketClient.MANAGER);
        }
    }



    
    static final class WebSocketSendFrameParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean fin;
        public int type;
        public byte[] data;

        private WebSocketSendFrameParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketSendFrameParams() {
            this(0);
        }

        public static WebSocketSendFrameParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketSendFrameParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketSendFrameParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketSendFrameParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketSendFrameParams(elementsOrVersion);
                    {
                        
                    result.fin = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.type = decoder0.readInt(12);
                        WebSocketMessageType.validate(result.type);
                    }
                    {
                        
                    result.data = decoder0.readBytes(16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.fin, 8, 0);
            
            encoder0.encode(this.type, 12);
            
            encoder0.encode(this.data, 16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class WebSocketSendFlowControlParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public long quota;

        private WebSocketSendFlowControlParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketSendFlowControlParams() {
            this(0);
        }

        public static WebSocketSendFlowControlParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketSendFlowControlParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketSendFlowControlParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketSendFlowControlParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketSendFlowControlParams(elementsOrVersion);
                    {
                        
                    result.quota = decoder0.readLong(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.quota, 8);
        }
    }



    
    static final class WebSocketStartClosingHandshakeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public short code;
        public String reason;

        private WebSocketStartClosingHandshakeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public WebSocketStartClosingHandshakeParams() {
            this(0);
        }

        public static WebSocketStartClosingHandshakeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static WebSocketStartClosingHandshakeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static WebSocketStartClosingHandshakeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            WebSocketStartClosingHandshakeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new WebSocketStartClosingHandshakeParams(elementsOrVersion);
                    {
                        
                    result.code = decoder0.readShort(8);
                    }
                    {
                        
                    result.reason = decoder0.readString(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.code, 8);
            
            encoder0.encode(this.reason, 16, false);
        }
    }



}
