
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class SignedExchangeReport extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 88;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(88, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public boolean success;
    public String type;
    public com.vccorp.url.mojom.Url outerUrl;
    public com.vccorp.url.mojom.Url innerUrl;
    public com.vccorp.url.mojom.Url certUrl;
    public String referrer;
    public IpAddress serverIpAddress;
    public String protocol;
    public String method;
    public int statusCode;
    public com.vccorp.mojo_base.mojom.TimeDelta elapsedTime;

    private SignedExchangeReport(int version) {
        super(STRUCT_SIZE, version);
    }

    public SignedExchangeReport() {
        this(0);
    }

    public static SignedExchangeReport deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static SignedExchangeReport deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static SignedExchangeReport decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        SignedExchangeReport result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new SignedExchangeReport(elementsOrVersion);
                {
                    
                result.success = decoder0.readBoolean(8, 0);
                }
                {
                    
                result.statusCode = decoder0.readInt(12);
                }
                {
                    
                result.type = decoder0.readString(16, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                result.outerUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                result.innerUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                result.certUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                }
                {
                    
                result.referrer = decoder0.readString(48, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(56, false);
                result.serverIpAddress = IpAddress.decode(decoder1);
                }
                {
                    
                result.protocol = decoder0.readString(64, false);
                }
                {
                    
                result.method = decoder0.readString(72, false);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(80, false);
                result.elapsedTime = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.success, 8, 0);
        
        encoder0.encode(this.statusCode, 12);
        
        encoder0.encode(this.type, 16, false);
        
        encoder0.encode(this.outerUrl, 24, false);
        
        encoder0.encode(this.innerUrl, 32, false);
        
        encoder0.encode(this.certUrl, 40, false);
        
        encoder0.encode(this.referrer, 48, false);
        
        encoder0.encode(this.serverIpAddress, 56, false);
        
        encoder0.encode(this.protocol, 64, false);
        
        encoder0.encode(this.method, 72, false);
        
        encoder0.encode(this.elapsedTime, 80, false);
    }
}