
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/referrer_policy.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ReferrerPolicy {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int ALWAYS = 0;
    public static final int DEFAULT = 1; // ALWAYS + 1
    public static final int NO_REFERRER_WHEN_DOWNGRADE = 2; // DEFAULT + 1
    public static final int NEVER = 3; // NO_REFERRER_WHEN_DOWNGRADE + 1
    public static final int ORIGIN = 4; // NEVER + 1
    public static final int ORIGIN_WHEN_CROSS_ORIGIN = 5; // ORIGIN + 1
    public static final int NO_REFERRER_WHEN_DOWNGRADE_ORIGIN_WHEN_CROSS_ORIGIN = 6; // ORIGIN_WHEN_CROSS_ORIGIN + 1
    public static final int SAME_ORIGIN = 7; // NO_REFERRER_WHEN_DOWNGRADE_ORIGIN_WHEN_CROSS_ORIGIN + 1
    public static final int STRICT_ORIGIN = 8; // SAME_ORIGIN + 1
    public static final int LAST = ReferrerPolicy.STRICT_ORIGIN;

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 8;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ReferrerPolicy() {}
}