
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/p2p.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class P2pSocketClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<P2pSocketClient, P2pSocketClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<P2pSocketClient, P2pSocketClient.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.P2PSocketClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, P2pSocketClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public P2pSocketClient[] buildArray(int size) {
          return new P2pSocketClient[size];
        }
    };


    private static final int SOCKET_CREATED_ORDINAL = 0;

    private static final int SEND_COMPLETE_ORDINAL = 1;

    private static final int INCOMING_TCP_CONNECTION_ORDINAL = 2;

    private static final int DATA_RECEIVED_ORDINAL = 3;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements P2pSocketClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void socketCreated(
IpEndPoint localAddress, IpEndPoint remoteAddress) {

            P2pSocketClientSocketCreatedParams _message = new P2pSocketClientSocketCreatedParams();

            _message.localAddress = localAddress;

            _message.remoteAddress = remoteAddress;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SOCKET_CREATED_ORDINAL)));

        }


        @Override
        public void sendComplete(
P2pSendPacketMetrics sendMetrics) {

            P2pSocketClientSendCompleteParams _message = new P2pSocketClientSendCompleteParams();

            _message.sendMetrics = sendMetrics;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SEND_COMPLETE_ORDINAL)));

        }


        @Override
        public void incomingTcpConnection(
IpEndPoint socketAddress, P2pSocket socket, com.vccorp.mojo.bindings.InterfaceRequest<P2pSocketClient> client) {

            P2pSocketClientIncomingTcpConnectionParams _message = new P2pSocketClientIncomingTcpConnectionParams();

            _message.socketAddress = socketAddress;

            _message.socket = socket;

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(INCOMING_TCP_CONNECTION_ORDINAL)));

        }


        @Override
        public void dataReceived(
IpEndPoint socketAddress, byte[] data, com.vccorp.mojo_base.mojom.TimeTicks timestamp) {

            P2pSocketClientDataReceivedParams _message = new P2pSocketClientDataReceivedParams();

            _message.socketAddress = socketAddress;

            _message.data = data;

            _message.timestamp = timestamp;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(DATA_RECEIVED_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<P2pSocketClient> {

        Stub(com.vccorp.mojo.system.Core core, P2pSocketClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                P2pSocketClient_Internal.MANAGER, messageWithHeader);





                    case SOCKET_CREATED_ORDINAL: {

                        P2pSocketClientSocketCreatedParams data =
                                P2pSocketClientSocketCreatedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().socketCreated(data.localAddress, data.remoteAddress);
                        return true;
                    }





                    case SEND_COMPLETE_ORDINAL: {

                        P2pSocketClientSendCompleteParams data =
                                P2pSocketClientSendCompleteParams.deserialize(messageWithHeader.getPayload());

                        getImpl().sendComplete(data.sendMetrics);
                        return true;
                    }





                    case INCOMING_TCP_CONNECTION_ORDINAL: {

                        P2pSocketClientIncomingTcpConnectionParams data =
                                P2pSocketClientIncomingTcpConnectionParams.deserialize(messageWithHeader.getPayload());

                        getImpl().incomingTcpConnection(data.socketAddress, data.socket, data.client);
                        return true;
                    }





                    case DATA_RECEIVED_ORDINAL: {

                        P2pSocketClientDataReceivedParams data =
                                P2pSocketClientDataReceivedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().dataReceived(data.socketAddress, data.data, data.timestamp);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), P2pSocketClient_Internal.MANAGER, messageWithHeader, receiver);










                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class P2pSocketClientSocketCreatedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public IpEndPoint localAddress;
        public IpEndPoint remoteAddress;

        private P2pSocketClientSocketCreatedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketClientSocketCreatedParams() {
            this(0);
        }

        public static P2pSocketClientSocketCreatedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketClientSocketCreatedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketClientSocketCreatedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketClientSocketCreatedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketClientSocketCreatedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.localAddress = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.remoteAddress = IpEndPoint.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.localAddress, 8, false);
            
            encoder0.encode(this.remoteAddress, 16, false);
        }
    }



    
    static final class P2pSocketClientSendCompleteParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public P2pSendPacketMetrics sendMetrics;

        private P2pSocketClientSendCompleteParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketClientSendCompleteParams() {
            this(0);
        }

        public static P2pSocketClientSendCompleteParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketClientSendCompleteParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketClientSendCompleteParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketClientSendCompleteParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketClientSendCompleteParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.sendMetrics = P2pSendPacketMetrics.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sendMetrics, 8, false);
        }
    }



    
    static final class P2pSocketClientIncomingTcpConnectionParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public IpEndPoint socketAddress;
        public P2pSocket socket;
        public com.vccorp.mojo.bindings.InterfaceRequest<P2pSocketClient> client;

        private P2pSocketClientIncomingTcpConnectionParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketClientIncomingTcpConnectionParams() {
            this(0);
        }

        public static P2pSocketClientIncomingTcpConnectionParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketClientIncomingTcpConnectionParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketClientIncomingTcpConnectionParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketClientIncomingTcpConnectionParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketClientIncomingTcpConnectionParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.socketAddress = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    result.socket = decoder0.readServiceInterface(16, false, P2pSocket.MANAGER);
                    }
                    {
                        
                    result.client = decoder0.readInterfaceRequest(24, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.socketAddress, 8, false);
            
            encoder0.encode(this.socket, 16, false, P2pSocket.MANAGER);
            
            encoder0.encode(this.client, 24, false);
        }
    }



    
    static final class P2pSocketClientDataReceivedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public IpEndPoint socketAddress;
        public byte[] data;
        public com.vccorp.mojo_base.mojom.TimeTicks timestamp;

        private P2pSocketClientDataReceivedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public P2pSocketClientDataReceivedParams() {
            this(0);
        }

        public static P2pSocketClientDataReceivedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static P2pSocketClientDataReceivedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static P2pSocketClientDataReceivedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            P2pSocketClientDataReceivedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new P2pSocketClientDataReceivedParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.socketAddress = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    result.data = decoder0.readBytes(16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.timestamp = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.socketAddress, 8, false);
            
            encoder0.encode(this.data, 16, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            
            encoder0.encode(this.timestamp, 24, false);
        }
    }



}
