
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/network_context.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NetworkContext_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NetworkContext, NetworkContext.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NetworkContext, NetworkContext.Proxy>() {

        @Override
        public String getName() {
            return "network.mojom.NetworkContext";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NetworkContext impl) {
            return new Stub(core, impl);
        }

        @Override
        public NetworkContext[] buildArray(int size) {
          return new NetworkContext[size];
        }
    };


    private static final int SET_CLIENT_ORDINAL = 0;

    private static final int CREATE_URL_LOADER_FACTORY_ORDINAL = 1;

    private static final int RESET_URL_LOADER_FACTORIES_ORDINAL = 2;

    private static final int GET_COOKIE_MANAGER_ORDINAL = 3;

    private static final int GET_RESTRICTED_COOKIE_MANAGER_ORDINAL = 4;

    private static final int CLEAR_NETWORKING_HISTORY_SINCE_ORDINAL = 5;

    private static final int CLEAR_HTTP_CACHE_ORDINAL = 6;

    private static final int COMPUTE_HTTP_CACHE_SIZE_ORDINAL = 7;

    private static final int NOTIFY_EXTERNAL_CACHE_HIT_ORDINAL = 8;

    private static final int WRITE_CACHE_METADATA_ORDINAL = 9;

    private static final int CLEAR_CHANNEL_IDS_ORDINAL = 10;

    private static final int CLEAR_HOST_CACHE_ORDINAL = 11;

    private static final int CLEAR_HTTP_AUTH_CACHE_ORDINAL = 12;

    private static final int CLEAR_REPORTING_CACHE_REPORTS_ORDINAL = 13;

    private static final int CLEAR_REPORTING_CACHE_CLIENTS_ORDINAL = 14;

    private static final int CLEAR_NETWORK_ERROR_LOGGING_ORDINAL = 15;

    private static final int CLEAR_DOMAIN_RELIABILITY_ORDINAL = 16;

    private static final int GET_DOMAIN_RELIABILITY_JSON_ORDINAL = 17;

    private static final int QUEUE_REPORT_ORDINAL = 18;

    private static final int QUEUE_SIGNED_EXCHANGE_REPORT_ORDINAL = 19;

    private static final int CLOSE_ALL_CONNECTIONS_ORDINAL = 20;

    private static final int CLOSE_IDLE_CONNECTIONS_ORDINAL = 21;

    private static final int SET_NETWORK_CONDITIONS_ORDINAL = 22;

    private static final int SET_ACCEPT_LANGUAGE_ORDINAL = 23;

    private static final int SET_ENABLE_REFERRERS_ORDINAL = 24;

    private static final int SET_CT_POLICY_ORDINAL = 25;

    private static final int ADD_EXPECT_CT_ORDINAL = 26;

    private static final int SET_EXPECT_CT_TEST_REPORT_ORDINAL = 27;

    private static final int GET_EXPECT_CT_STATE_ORDINAL = 28;

    private static final int CREATE_UDP_SOCKET_ORDINAL = 29;

    private static final int CREATE_TCP_SERVER_SOCKET_ORDINAL = 30;

    private static final int CREATE_TCP_CONNECTED_SOCKET_ORDINAL = 31;

    private static final int CREATE_TCP_BOUND_SOCKET_ORDINAL = 32;

    private static final int CREATE_PROXY_RESOLVING_SOCKET_FACTORY_ORDINAL = 33;

    private static final int LOOK_UP_PROXY_FOR_URL_ORDINAL = 34;

    private static final int FORCE_RELOAD_PROXY_CONFIG_ORDINAL = 35;

    private static final int CLEAR_BAD_PROXIES_CACHE_ORDINAL = 36;

    private static final int CREATE_WEB_SOCKET_ORDINAL = 37;

    private static final int CREATE_NET_LOG_EXPORTER_ORDINAL = 38;

    private static final int PRECONNECT_SOCKETS_ORDINAL = 39;

    private static final int CREATE_P2P_SOCKET_MANAGER_ORDINAL = 40;

    private static final int CREATE_MDNS_RESPONDER_ORDINAL = 41;

    private static final int RESOLVE_HOST_ORDINAL = 42;

    private static final int CREATE_HOST_RESOLVER_ORDINAL = 43;

    private static final int VERIFY_CERT_FOR_SIGNED_EXCHANGE_ORDINAL = 44;

    private static final int ADD_HSTS_ORDINAL = 45;

    private static final int IS_HSTS_ACTIVE_FOR_HOST_ORDINAL = 46;

    private static final int GET_HSTS_STATE_ORDINAL = 47;

    private static final int SET_CORS_ORIGIN_ACCESS_LISTS_FOR_ORIGIN_ORDINAL = 48;

    private static final int DELETE_DYNAMIC_DATA_FOR_HOST_ORDINAL = 49;

    private static final int SAVE_HTTP_AUTH_CACHE_ORDINAL = 50;

    private static final int LOAD_HTTP_AUTH_CACHE_ORDINAL = 51;

    private static final int LOOKUP_BASIC_AUTH_CREDENTIALS_ORDINAL = 52;

    private static final int ENABLE_STATIC_KEY_PINNING_FOR_TESTING_ORDINAL = 53;

    private static final int SET_FAILING_HTTP_TRANSACTION_FOR_TESTING_ORDINAL = 54;

    private static final int VERIFY_CERTIFICATE_FOR_TESTING_ORDINAL = 55;

    private static final int ADD_DOMAIN_RELIABILITY_CONTEXT_FOR_TESTING_ORDINAL = 56;

    private static final int FORCE_DOMAIN_RELIABILITY_UPLOADS_FOR_TESTING_ORDINAL = 57;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NetworkContext.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void setClient(
NetworkContextClient client) {

            NetworkContextSetClientParams _message = new NetworkContextSetClientParams();

            _message.client = client;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_CLIENT_ORDINAL)));

        }


        @Override
        public void createUrlLoaderFactory(
com.vccorp.mojo.bindings.InterfaceRequest<UrlLoaderFactory> urlLoaderFactory, UrlLoaderFactoryParams params) {

            NetworkContextCreateUrlLoaderFactoryParams _message = new NetworkContextCreateUrlLoaderFactoryParams();

            _message.urlLoaderFactory = urlLoaderFactory;

            _message.params = params;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_URL_LOADER_FACTORY_ORDINAL)));

        }


        @Override
        public void resetUrlLoaderFactories(
) {

            NetworkContextResetUrlLoaderFactoriesParams _message = new NetworkContextResetUrlLoaderFactoriesParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RESET_URL_LOADER_FACTORIES_ORDINAL)));

        }


        @Override
        public void getCookieManager(
com.vccorp.mojo.bindings.InterfaceRequest<CookieManager> cookieManager) {

            NetworkContextGetCookieManagerParams _message = new NetworkContextGetCookieManagerParams();

            _message.cookieManager = cookieManager;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_COOKIE_MANAGER_ORDINAL)));

        }


        @Override
        public void getRestrictedCookieManager(
com.vccorp.mojo.bindings.InterfaceRequest<RestrictedCookieManager> restrictedCookieManager, com.vccorp.url.mojom.Origin origin) {

            NetworkContextGetRestrictedCookieManagerParams _message = new NetworkContextGetRestrictedCookieManagerParams();

            _message.restrictedCookieManager = restrictedCookieManager;

            _message.origin = origin;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_RESTRICTED_COOKIE_MANAGER_ORDINAL)));

        }


        @Override
        public void clearNetworkingHistorySince(
com.vccorp.mojo_base.mojom.Time startTime,
ClearNetworkingHistorySinceResponse callback) {

            NetworkContextClearNetworkingHistorySinceParams _message = new NetworkContextClearNetworkingHistorySinceParams();

            _message.startTime = startTime;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_NETWORKING_HISTORY_SINCE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearNetworkingHistorySinceResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearHttpCache(
com.vccorp.mojo_base.mojom.Time startTime, com.vccorp.mojo_base.mojom.Time endTime, ClearDataFilter filter,
ClearHttpCacheResponse callback) {

            NetworkContextClearHttpCacheParams _message = new NetworkContextClearHttpCacheParams();

            _message.startTime = startTime;

            _message.endTime = endTime;

            _message.filter = filter;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_HTTP_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearHttpCacheResponseParamsForwardToCallback(callback));

        }


        @Override
        public void computeHttpCacheSize(
com.vccorp.mojo_base.mojom.Time startTime, com.vccorp.mojo_base.mojom.Time endTime,
ComputeHttpCacheSizeResponse callback) {

            NetworkContextComputeHttpCacheSizeParams _message = new NetworkContextComputeHttpCacheSizeParams();

            _message.startTime = startTime;

            _message.endTime = endTime;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    COMPUTE_HTTP_CACHE_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextComputeHttpCacheSizeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void notifyExternalCacheHit(
com.vccorp.url.mojom.Url url, String httpMethod, com.vccorp.url.mojom.Origin topFrameOrigin) {

            NetworkContextNotifyExternalCacheHitParams _message = new NetworkContextNotifyExternalCacheHitParams();

            _message.url = url;

            _message.httpMethod = httpMethod;

            _message.topFrameOrigin = topFrameOrigin;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(NOTIFY_EXTERNAL_CACHE_HIT_ORDINAL)));

        }


        @Override
        public void writeCacheMetadata(
com.vccorp.url.mojom.Url url, int priority, com.vccorp.mojo_base.mojom.Time expectedResponseTime, byte[] data) {

            NetworkContextWriteCacheMetadataParams _message = new NetworkContextWriteCacheMetadataParams();

            _message.url = url;

            _message.priority = priority;

            _message.expectedResponseTime = expectedResponseTime;

            _message.data = data;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(WRITE_CACHE_METADATA_ORDINAL)));

        }


        @Override
        public void clearChannelIds(
com.vccorp.mojo_base.mojom.Time startTime, com.vccorp.mojo_base.mojom.Time endTime, ClearDataFilter filter,
ClearChannelIdsResponse callback) {

            NetworkContextClearChannelIdsParams _message = new NetworkContextClearChannelIdsParams();

            _message.startTime = startTime;

            _message.endTime = endTime;

            _message.filter = filter;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_CHANNEL_IDS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearChannelIdsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearHostCache(
ClearDataFilter filter, 
ClearHostCacheResponse callback) {

            NetworkContextClearHostCacheParams _message = new NetworkContextClearHostCacheParams();

            _message.filter = filter;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_HOST_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearHostCacheResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearHttpAuthCache(
com.vccorp.mojo_base.mojom.Time startTime,
ClearHttpAuthCacheResponse callback) {

            NetworkContextClearHttpAuthCacheParams _message = new NetworkContextClearHttpAuthCacheParams();

            _message.startTime = startTime;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_HTTP_AUTH_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearHttpAuthCacheResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearReportingCacheReports(
ClearDataFilter filter, 
ClearReportingCacheReportsResponse callback) {

            NetworkContextClearReportingCacheReportsParams _message = new NetworkContextClearReportingCacheReportsParams();

            _message.filter = filter;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_REPORTING_CACHE_REPORTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearReportingCacheReportsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearReportingCacheClients(
ClearDataFilter filter, 
ClearReportingCacheClientsResponse callback) {

            NetworkContextClearReportingCacheClientsParams _message = new NetworkContextClearReportingCacheClientsParams();

            _message.filter = filter;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_REPORTING_CACHE_CLIENTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearReportingCacheClientsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearNetworkErrorLogging(
ClearDataFilter filter, 
ClearNetworkErrorLoggingResponse callback) {

            NetworkContextClearNetworkErrorLoggingParams _message = new NetworkContextClearNetworkErrorLoggingParams();

            _message.filter = filter;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_NETWORK_ERROR_LOGGING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearNetworkErrorLoggingResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearDomainReliability(
ClearDataFilter filter, int mode, 
ClearDomainReliabilityResponse callback) {

            NetworkContextClearDomainReliabilityParams _message = new NetworkContextClearDomainReliabilityParams();

            _message.filter = filter;

            _message.mode = mode;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_DOMAIN_RELIABILITY_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearDomainReliabilityResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getDomainReliabilityJson(

GetDomainReliabilityJsonResponse callback) {

            NetworkContextGetDomainReliabilityJsonParams _message = new NetworkContextGetDomainReliabilityJsonParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DOMAIN_RELIABILITY_JSON_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextGetDomainReliabilityJsonResponseParamsForwardToCallback(callback));

        }


        @Override
        public void queueReport(
String type, String group, com.vccorp.url.mojom.Url url, String userAgent, com.vccorp.mojo_base.mojom.DictionaryValue body) {

            NetworkContextQueueReportParams _message = new NetworkContextQueueReportParams();

            _message.type = type;

            _message.group = group;

            _message.url = url;

            _message.userAgent = userAgent;

            _message.body = body;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(QUEUE_REPORT_ORDINAL)));

        }


        @Override
        public void queueSignedExchangeReport(
SignedExchangeReport report) {

            NetworkContextQueueSignedExchangeReportParams _message = new NetworkContextQueueSignedExchangeReportParams();

            _message.report = report;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(QUEUE_SIGNED_EXCHANGE_REPORT_ORDINAL)));

        }


        @Override
        public void closeAllConnections(

CloseAllConnectionsResponse callback) {

            NetworkContextCloseAllConnectionsParams _message = new NetworkContextCloseAllConnectionsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLOSE_ALL_CONNECTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextCloseAllConnectionsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void closeIdleConnections(

CloseIdleConnectionsResponse callback) {

            NetworkContextCloseIdleConnectionsParams _message = new NetworkContextCloseIdleConnectionsParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLOSE_IDLE_CONNECTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextCloseIdleConnectionsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setNetworkConditions(
com.vccorp.mojo_base.mojom.UnguessableToken throttlingProfileId, NetworkConditions conditions) {

            NetworkContextSetNetworkConditionsParams _message = new NetworkContextSetNetworkConditionsParams();

            _message.throttlingProfileId = throttlingProfileId;

            _message.conditions = conditions;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_NETWORK_CONDITIONS_ORDINAL)));

        }


        @Override
        public void setAcceptLanguage(
String newAcceptLanguage) {

            NetworkContextSetAcceptLanguageParams _message = new NetworkContextSetAcceptLanguageParams();

            _message.newAcceptLanguage = newAcceptLanguage;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_ACCEPT_LANGUAGE_ORDINAL)));

        }


        @Override
        public void setEnableReferrers(
boolean enableReferrers) {

            NetworkContextSetEnableReferrersParams _message = new NetworkContextSetEnableReferrersParams();

            _message.enableReferrers = enableReferrers;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_ENABLE_REFERRERS_ORDINAL)));

        }


        @Override
        public void setCtPolicy(
String[] requiredHosts, String[] excludedHosts, String[] excludedSpkis, String[] excludedLegacySpkis) {

            NetworkContextSetCtPolicyParams _message = new NetworkContextSetCtPolicyParams();

            _message.requiredHosts = requiredHosts;

            _message.excludedHosts = excludedHosts;

            _message.excludedSpkis = excludedSpkis;

            _message.excludedLegacySpkis = excludedLegacySpkis;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(SET_CT_POLICY_ORDINAL)));

        }


        @Override
        public void addExpectCt(
String host, com.vccorp.mojo_base.mojom.Time expiry, boolean enforce, com.vccorp.url.mojom.Url reportUri,
AddExpectCtResponse callback) {

            NetworkContextAddExpectCtParams _message = new NetworkContextAddExpectCtParams();

            _message.host = host;

            _message.expiry = expiry;

            _message.enforce = enforce;

            _message.reportUri = reportUri;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_EXPECT_CT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextAddExpectCtResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setExpectCtTestReport(
com.vccorp.url.mojom.Url reportUri,
SetExpectCtTestReportResponse callback) {

            NetworkContextSetExpectCtTestReportParams _message = new NetworkContextSetExpectCtTestReportParams();

            _message.reportUri = reportUri;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_EXPECT_CT_TEST_REPORT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextSetExpectCtTestReportResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getExpectCtState(
String domain, 
GetExpectCtStateResponse callback) {

            NetworkContextGetExpectCtStateParams _message = new NetworkContextGetExpectCtStateParams();

            _message.domain = domain;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_EXPECT_CT_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextGetExpectCtStateResponseParamsForwardToCallback(callback));

        }


        @Override
        public void createUdpSocket(
com.vccorp.mojo.bindings.InterfaceRequest<UdpSocket> request, UdpSocketReceiver receiver) {

            NetworkContextCreateUdpSocketParams _message = new NetworkContextCreateUdpSocketParams();

            _message.request = request;

            _message.receiver = receiver;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_UDP_SOCKET_ORDINAL)));

        }


        @Override
        public void createTcpServerSocket(
IpEndPoint localAddr, int backlog, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TcpServerSocket> socket,
CreateTcpServerSocketResponse callback) {

            NetworkContextCreateTcpServerSocketParams _message = new NetworkContextCreateTcpServerSocketParams();

            _message.localAddr = localAddr;

            _message.backlog = backlog;

            _message.trafficAnnotation = trafficAnnotation;

            _message.socket = socket;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_TCP_SERVER_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextCreateTcpServerSocketResponseParamsForwardToCallback(callback));

        }


        @Override
        public void createTcpConnectedSocket(
IpEndPoint localAddr, AddressList remoteAddrList, TcpConnectedSocketOptions tcpConnectedSocketOptions, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TcpConnectedSocket> socket, SocketObserver observer,
CreateTcpConnectedSocketResponse callback) {

            NetworkContextCreateTcpConnectedSocketParams _message = new NetworkContextCreateTcpConnectedSocketParams();

            _message.localAddr = localAddr;

            _message.remoteAddrList = remoteAddrList;

            _message.tcpConnectedSocketOptions = tcpConnectedSocketOptions;

            _message.trafficAnnotation = trafficAnnotation;

            _message.socket = socket;

            _message.observer = observer;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_TCP_CONNECTED_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextCreateTcpConnectedSocketResponseParamsForwardToCallback(callback));

        }


        @Override
        public void createTcpBoundSocket(
IpEndPoint localAddr, MutableNetworkTrafficAnnotationTag trafficAnnotation, com.vccorp.mojo.bindings.InterfaceRequest<TcpBoundSocket> socket,
CreateTcpBoundSocketResponse callback) {

            NetworkContextCreateTcpBoundSocketParams _message = new NetworkContextCreateTcpBoundSocketParams();

            _message.localAddr = localAddr;

            _message.trafficAnnotation = trafficAnnotation;

            _message.socket = socket;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_TCP_BOUND_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextCreateTcpBoundSocketResponseParamsForwardToCallback(callback));

        }


        @Override
        public void createProxyResolvingSocketFactory(
com.vccorp.mojo.bindings.InterfaceRequest<ProxyResolvingSocketFactory> factory) {

            NetworkContextCreateProxyResolvingSocketFactoryParams _message = new NetworkContextCreateProxyResolvingSocketFactoryParams();

            _message.factory = factory;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_PROXY_RESOLVING_SOCKET_FACTORY_ORDINAL)));

        }


        @Override
        public void lookUpProxyForUrl(
com.vccorp.url.mojom.Url url, ProxyLookupClient proxyLookupClient) {

            NetworkContextLookUpProxyForUrlParams _message = new NetworkContextLookUpProxyForUrlParams();

            _message.url = url;

            _message.proxyLookupClient = proxyLookupClient;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(LOOK_UP_PROXY_FOR_URL_ORDINAL)));

        }


        @Override
        public void forceReloadProxyConfig(

ForceReloadProxyConfigResponse callback) {

            NetworkContextForceReloadProxyConfigParams _message = new NetworkContextForceReloadProxyConfigParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FORCE_RELOAD_PROXY_CONFIG_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextForceReloadProxyConfigResponseParamsForwardToCallback(callback));

        }


        @Override
        public void clearBadProxiesCache(

ClearBadProxiesCacheResponse callback) {

            NetworkContextClearBadProxiesCacheParams _message = new NetworkContextClearBadProxiesCacheParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_BAD_PROXIES_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextClearBadProxiesCacheResponseParamsForwardToCallback(callback));

        }


        @Override
        public void createWebSocket(
com.vccorp.mojo.bindings.InterfaceRequest<WebSocket> request, int processId, int renderFrameId, com.vccorp.url.mojom.Origin origin, int options, AuthenticationHandler authHandler, TrustedHeaderClient headerClient) {

            NetworkContextCreateWebSocketParams _message = new NetworkContextCreateWebSocketParams();

            _message.request = request;

            _message.processId = processId;

            _message.renderFrameId = renderFrameId;

            _message.origin = origin;

            _message.options = options;

            _message.authHandler = authHandler;

            _message.headerClient = headerClient;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_WEB_SOCKET_ORDINAL)));

        }


        @Override
        public void createNetLogExporter(
com.vccorp.mojo.bindings.InterfaceRequest<NetLogExporter> exporter) {

            NetworkContextCreateNetLogExporterParams _message = new NetworkContextCreateNetLogExporterParams();

            _message.exporter = exporter;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_NET_LOG_EXPORTER_ORDINAL)));

        }


        @Override
        public void preconnectSockets(
int numStreams, com.vccorp.url.mojom.Url url, int loadFlags, boolean privacyModeEnabled) {

            NetworkContextPreconnectSocketsParams _message = new NetworkContextPreconnectSocketsParams();

            _message.numStreams = numStreams;

            _message.url = url;

            _message.loadFlags = loadFlags;

            _message.privacyModeEnabled = privacyModeEnabled;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(PRECONNECT_SOCKETS_ORDINAL)));

        }


        @Override
        public void createP2pSocketManager(
P2pTrustedSocketManagerClient client, com.vccorp.mojo.bindings.InterfaceRequest<P2pTrustedSocketManager> trustedSocketManager, com.vccorp.mojo.bindings.InterfaceRequest<P2pSocketManager> socketManager) {

            NetworkContextCreateP2pSocketManagerParams _message = new NetworkContextCreateP2pSocketManagerParams();

            _message.client = client;

            _message.trustedSocketManager = trustedSocketManager;

            _message.socketManager = socketManager;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_P2P_SOCKET_MANAGER_ORDINAL)));

        }


        @Override
        public void createMdnsResponder(
com.vccorp.mojo.bindings.InterfaceRequest<MdnsResponder> responderRequest) {

            NetworkContextCreateMdnsResponderParams _message = new NetworkContextCreateMdnsResponderParams();

            _message.responderRequest = responderRequest;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_MDNS_RESPONDER_ORDINAL)));

        }


        @Override
        public void resolveHost(
HostPortPair host, ResolveHostParameters optionalParameters, ResolveHostClient responseClient) {

            NetworkContextResolveHostParams _message = new NetworkContextResolveHostParams();

            _message.host = host;

            _message.optionalParameters = optionalParameters;

            _message.responseClient = responseClient;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(RESOLVE_HOST_ORDINAL)));

        }


        @Override
        public void createHostResolver(
DnsConfigOverrides configOverrides, com.vccorp.mojo.bindings.InterfaceRequest<HostResolver> hostResolver) {

            NetworkContextCreateHostResolverParams _message = new NetworkContextCreateHostResolverParams();

            _message.configOverrides = configOverrides;

            _message.hostResolver = hostResolver;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(CREATE_HOST_RESOLVER_ORDINAL)));

        }


        @Override
        public void verifyCertForSignedExchange(
X509Certificate certificate, com.vccorp.url.mojom.Url url, String ocspResponse, String sctList,
VerifyCertForSignedExchangeResponse callback) {

            NetworkContextVerifyCertForSignedExchangeParams _message = new NetworkContextVerifyCertForSignedExchangeParams();

            _message.certificate = certificate;

            _message.url = url;

            _message.ocspResponse = ocspResponse;

            _message.sctList = sctList;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    VERIFY_CERT_FOR_SIGNED_EXCHANGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextVerifyCertForSignedExchangeResponseParamsForwardToCallback(callback));

        }


        @Override
        public void addHsts(
String host, com.vccorp.mojo_base.mojom.Time expiry, boolean includeSubdomains,
AddHstsResponse callback) {

            NetworkContextAddHstsParams _message = new NetworkContextAddHstsParams();

            _message.host = host;

            _message.expiry = expiry;

            _message.includeSubdomains = includeSubdomains;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_HSTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextAddHstsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void isHstsActiveForHost(
String host, 
IsHstsActiveForHostResponse callback) {

            NetworkContextIsHstsActiveForHostParams _message = new NetworkContextIsHstsActiveForHostParams();

            _message.host = host;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    IS_HSTS_ACTIVE_FOR_HOST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextIsHstsActiveForHostResponseParamsForwardToCallback(callback));

        }


        @Override
        public void getHstsState(
String domain, 
GetHstsStateResponse callback) {

            NetworkContextGetHstsStateParams _message = new NetworkContextGetHstsStateParams();

            _message.domain = domain;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_HSTS_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextGetHstsStateResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setCorsOriginAccessListsForOrigin(
com.vccorp.url.mojom.Origin sourceOrigin, CorsOriginPattern[] allowPatterns, CorsOriginPattern[] blockPatterns,
SetCorsOriginAccessListsForOriginResponse callback) {

            NetworkContextSetCorsOriginAccessListsForOriginParams _message = new NetworkContextSetCorsOriginAccessListsForOriginParams();

            _message.sourceOrigin = sourceOrigin;

            _message.allowPatterns = allowPatterns;

            _message.blockPatterns = blockPatterns;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_CORS_ORIGIN_ACCESS_LISTS_FOR_ORIGIN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextSetCorsOriginAccessListsForOriginResponseParamsForwardToCallback(callback));

        }


        @Override
        public void deleteDynamicDataForHost(
String host, 
DeleteDynamicDataForHostResponse callback) {

            NetworkContextDeleteDynamicDataForHostParams _message = new NetworkContextDeleteDynamicDataForHostParams();

            _message.host = host;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DELETE_DYNAMIC_DATA_FOR_HOST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextDeleteDynamicDataForHostResponseParamsForwardToCallback(callback));

        }


        @Override
        public void saveHttpAuthCache(

SaveHttpAuthCacheResponse callback) {

            NetworkContextSaveHttpAuthCacheParams _message = new NetworkContextSaveHttpAuthCacheParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SAVE_HTTP_AUTH_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextSaveHttpAuthCacheResponseParamsForwardToCallback(callback));

        }


        @Override
        public void loadHttpAuthCache(
com.vccorp.mojo_base.mojom.UnguessableToken cacheKey,
LoadHttpAuthCacheResponse callback) {

            NetworkContextLoadHttpAuthCacheParams _message = new NetworkContextLoadHttpAuthCacheParams();

            _message.cacheKey = cacheKey;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    LOAD_HTTP_AUTH_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextLoadHttpAuthCacheResponseParamsForwardToCallback(callback));

        }


        @Override
        public void lookupBasicAuthCredentials(
com.vccorp.url.mojom.Url url,
LookupBasicAuthCredentialsResponse callback) {

            NetworkContextLookupBasicAuthCredentialsParams _message = new NetworkContextLookupBasicAuthCredentialsParams();

            _message.url = url;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    LOOKUP_BASIC_AUTH_CREDENTIALS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextLookupBasicAuthCredentialsResponseParamsForwardToCallback(callback));

        }


        @Override
        public void enableStaticKeyPinningForTesting(

EnableStaticKeyPinningForTestingResponse callback) {

            NetworkContextEnableStaticKeyPinningForTestingParams _message = new NetworkContextEnableStaticKeyPinningForTestingParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENABLE_STATIC_KEY_PINNING_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextEnableStaticKeyPinningForTestingResponseParamsForwardToCallback(callback));

        }


        @Override
        public void setFailingHttpTransactionForTesting(
int rv, 
SetFailingHttpTransactionForTestingResponse callback) {

            NetworkContextSetFailingHttpTransactionForTestingParams _message = new NetworkContextSetFailingHttpTransactionForTestingParams();

            _message.rv = rv;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_FAILING_HTTP_TRANSACTION_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextSetFailingHttpTransactionForTestingResponseParamsForwardToCallback(callback));

        }


        @Override
        public void verifyCertificateForTesting(
X509Certificate certificate, String hostname, String ocspResponse, 
VerifyCertificateForTestingResponse callback) {

            NetworkContextVerifyCertificateForTestingParams _message = new NetworkContextVerifyCertificateForTestingParams();

            _message.certificate = certificate;

            _message.hostname = hostname;

            _message.ocspResponse = ocspResponse;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    VERIFY_CERTIFICATE_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextVerifyCertificateForTestingResponseParamsForwardToCallback(callback));

        }


        @Override
        public void addDomainReliabilityContextForTesting(
com.vccorp.url.mojom.Url origin, com.vccorp.url.mojom.Url uploadUrl,
AddDomainReliabilityContextForTestingResponse callback) {

            NetworkContextAddDomainReliabilityContextForTestingParams _message = new NetworkContextAddDomainReliabilityContextForTestingParams();

            _message.origin = origin;

            _message.uploadUrl = uploadUrl;


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_DOMAIN_RELIABILITY_CONTEXT_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextAddDomainReliabilityContextForTestingResponseParamsForwardToCallback(callback));

        }


        @Override
        public void forceDomainReliabilityUploadsForTesting(

ForceDomainReliabilityUploadsForTestingResponse callback) {

            NetworkContextForceDomainReliabilityUploadsForTestingParams _message = new NetworkContextForceDomainReliabilityUploadsForTestingParams();


            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FORCE_DOMAIN_RELIABILITY_UPLOADS_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new NetworkContextForceDomainReliabilityUploadsForTestingResponseParamsForwardToCallback(callback));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NetworkContext> {

        Stub(com.vccorp.mojo.system.Core core, NetworkContext impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NetworkContext_Internal.MANAGER, messageWithHeader);





                    case SET_CLIENT_ORDINAL: {

                        NetworkContextSetClientParams data =
                                NetworkContextSetClientParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setClient(data.client);
                        return true;
                    }





                    case CREATE_URL_LOADER_FACTORY_ORDINAL: {

                        NetworkContextCreateUrlLoaderFactoryParams data =
                                NetworkContextCreateUrlLoaderFactoryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createUrlLoaderFactory(data.urlLoaderFactory, data.params);
                        return true;
                    }





                    case RESET_URL_LOADER_FACTORIES_ORDINAL: {

                        NetworkContextResetUrlLoaderFactoriesParams.deserialize(messageWithHeader.getPayload());

                        getImpl().resetUrlLoaderFactories();
                        return true;
                    }





                    case GET_COOKIE_MANAGER_ORDINAL: {

                        NetworkContextGetCookieManagerParams data =
                                NetworkContextGetCookieManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getCookieManager(data.cookieManager);
                        return true;
                    }





                    case GET_RESTRICTED_COOKIE_MANAGER_ORDINAL: {

                        NetworkContextGetRestrictedCookieManagerParams data =
                                NetworkContextGetRestrictedCookieManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getRestrictedCookieManager(data.restrictedCookieManager, data.origin);
                        return true;
                    }











                    case NOTIFY_EXTERNAL_CACHE_HIT_ORDINAL: {

                        NetworkContextNotifyExternalCacheHitParams data =
                                NetworkContextNotifyExternalCacheHitParams.deserialize(messageWithHeader.getPayload());

                        getImpl().notifyExternalCacheHit(data.url, data.httpMethod, data.topFrameOrigin);
                        return true;
                    }





                    case WRITE_CACHE_METADATA_ORDINAL: {

                        NetworkContextWriteCacheMetadataParams data =
                                NetworkContextWriteCacheMetadataParams.deserialize(messageWithHeader.getPayload());

                        getImpl().writeCacheMetadata(data.url, data.priority, data.expectedResponseTime, data.data);
                        return true;
                    }





















                    case QUEUE_REPORT_ORDINAL: {

                        NetworkContextQueueReportParams data =
                                NetworkContextQueueReportParams.deserialize(messageWithHeader.getPayload());

                        getImpl().queueReport(data.type, data.group, data.url, data.userAgent, data.body);
                        return true;
                    }





                    case QUEUE_SIGNED_EXCHANGE_REPORT_ORDINAL: {

                        NetworkContextQueueSignedExchangeReportParams data =
                                NetworkContextQueueSignedExchangeReportParams.deserialize(messageWithHeader.getPayload());

                        getImpl().queueSignedExchangeReport(data.report);
                        return true;
                    }









                    case SET_NETWORK_CONDITIONS_ORDINAL: {

                        NetworkContextSetNetworkConditionsParams data =
                                NetworkContextSetNetworkConditionsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setNetworkConditions(data.throttlingProfileId, data.conditions);
                        return true;
                    }





                    case SET_ACCEPT_LANGUAGE_ORDINAL: {

                        NetworkContextSetAcceptLanguageParams data =
                                NetworkContextSetAcceptLanguageParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setAcceptLanguage(data.newAcceptLanguage);
                        return true;
                    }





                    case SET_ENABLE_REFERRERS_ORDINAL: {

                        NetworkContextSetEnableReferrersParams data =
                                NetworkContextSetEnableReferrersParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setEnableReferrers(data.enableReferrers);
                        return true;
                    }





                    case SET_CT_POLICY_ORDINAL: {

                        NetworkContextSetCtPolicyParams data =
                                NetworkContextSetCtPolicyParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setCtPolicy(data.requiredHosts, data.excludedHosts, data.excludedSpkis, data.excludedLegacySpkis);
                        return true;
                    }











                    case CREATE_UDP_SOCKET_ORDINAL: {

                        NetworkContextCreateUdpSocketParams data =
                                NetworkContextCreateUdpSocketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createUdpSocket(data.request, data.receiver);
                        return true;
                    }











                    case CREATE_PROXY_RESOLVING_SOCKET_FACTORY_ORDINAL: {

                        NetworkContextCreateProxyResolvingSocketFactoryParams data =
                                NetworkContextCreateProxyResolvingSocketFactoryParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createProxyResolvingSocketFactory(data.factory);
                        return true;
                    }





                    case LOOK_UP_PROXY_FOR_URL_ORDINAL: {

                        NetworkContextLookUpProxyForUrlParams data =
                                NetworkContextLookUpProxyForUrlParams.deserialize(messageWithHeader.getPayload());

                        getImpl().lookUpProxyForUrl(data.url, data.proxyLookupClient);
                        return true;
                    }









                    case CREATE_WEB_SOCKET_ORDINAL: {

                        NetworkContextCreateWebSocketParams data =
                                NetworkContextCreateWebSocketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createWebSocket(data.request, data.processId, data.renderFrameId, data.origin, data.options, data.authHandler, data.headerClient);
                        return true;
                    }





                    case CREATE_NET_LOG_EXPORTER_ORDINAL: {

                        NetworkContextCreateNetLogExporterParams data =
                                NetworkContextCreateNetLogExporterParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createNetLogExporter(data.exporter);
                        return true;
                    }





                    case PRECONNECT_SOCKETS_ORDINAL: {

                        NetworkContextPreconnectSocketsParams data =
                                NetworkContextPreconnectSocketsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().preconnectSockets(data.numStreams, data.url, data.loadFlags, data.privacyModeEnabled);
                        return true;
                    }





                    case CREATE_P2P_SOCKET_MANAGER_ORDINAL: {

                        NetworkContextCreateP2pSocketManagerParams data =
                                NetworkContextCreateP2pSocketManagerParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createP2pSocketManager(data.client, data.trustedSocketManager, data.socketManager);
                        return true;
                    }





                    case CREATE_MDNS_RESPONDER_ORDINAL: {

                        NetworkContextCreateMdnsResponderParams data =
                                NetworkContextCreateMdnsResponderParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createMdnsResponder(data.responderRequest);
                        return true;
                    }





                    case RESOLVE_HOST_ORDINAL: {

                        NetworkContextResolveHostParams data =
                                NetworkContextResolveHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().resolveHost(data.host, data.optionalParameters, data.responseClient);
                        return true;
                    }





                    case CREATE_HOST_RESOLVER_ORDINAL: {

                        NetworkContextCreateHostResolverParams data =
                                NetworkContextCreateHostResolverParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createHostResolver(data.configOverrides, data.hostResolver);
                        return true;
                    }






























                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NetworkContext_Internal.MANAGER, messageWithHeader, receiver);

















                    case CLEAR_NETWORKING_HISTORY_SINCE_ORDINAL: {

                        NetworkContextClearNetworkingHistorySinceParams data =
                                NetworkContextClearNetworkingHistorySinceParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearNetworkingHistorySince(data.startTime, new NetworkContextClearNetworkingHistorySinceResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_HTTP_CACHE_ORDINAL: {

                        NetworkContextClearHttpCacheParams data =
                                NetworkContextClearHttpCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearHttpCache(data.startTime, data.endTime, data.filter, new NetworkContextClearHttpCacheResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case COMPUTE_HTTP_CACHE_SIZE_ORDINAL: {

                        NetworkContextComputeHttpCacheSizeParams data =
                                NetworkContextComputeHttpCacheSizeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().computeHttpCacheSize(data.startTime, data.endTime, new NetworkContextComputeHttpCacheSizeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }











                    case CLEAR_CHANNEL_IDS_ORDINAL: {

                        NetworkContextClearChannelIdsParams data =
                                NetworkContextClearChannelIdsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearChannelIds(data.startTime, data.endTime, data.filter, new NetworkContextClearChannelIdsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_HOST_CACHE_ORDINAL: {

                        NetworkContextClearHostCacheParams data =
                                NetworkContextClearHostCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearHostCache(data.filter, new NetworkContextClearHostCacheResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_HTTP_AUTH_CACHE_ORDINAL: {

                        NetworkContextClearHttpAuthCacheParams data =
                                NetworkContextClearHttpAuthCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearHttpAuthCache(data.startTime, new NetworkContextClearHttpAuthCacheResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_REPORTING_CACHE_REPORTS_ORDINAL: {

                        NetworkContextClearReportingCacheReportsParams data =
                                NetworkContextClearReportingCacheReportsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearReportingCacheReports(data.filter, new NetworkContextClearReportingCacheReportsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_REPORTING_CACHE_CLIENTS_ORDINAL: {

                        NetworkContextClearReportingCacheClientsParams data =
                                NetworkContextClearReportingCacheClientsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearReportingCacheClients(data.filter, new NetworkContextClearReportingCacheClientsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_NETWORK_ERROR_LOGGING_ORDINAL: {

                        NetworkContextClearNetworkErrorLoggingParams data =
                                NetworkContextClearNetworkErrorLoggingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearNetworkErrorLogging(data.filter, new NetworkContextClearNetworkErrorLoggingResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_DOMAIN_RELIABILITY_ORDINAL: {

                        NetworkContextClearDomainReliabilityParams data =
                                NetworkContextClearDomainReliabilityParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearDomainReliability(data.filter, data.mode, new NetworkContextClearDomainReliabilityResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_DOMAIN_RELIABILITY_JSON_ORDINAL: {

                        NetworkContextGetDomainReliabilityJsonParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getDomainReliabilityJson(new NetworkContextGetDomainReliabilityJsonResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }











                    case CLOSE_ALL_CONNECTIONS_ORDINAL: {

                        NetworkContextCloseAllConnectionsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().closeAllConnections(new NetworkContextCloseAllConnectionsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLOSE_IDLE_CONNECTIONS_ORDINAL: {

                        NetworkContextCloseIdleConnectionsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().closeIdleConnections(new NetworkContextCloseIdleConnectionsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }















                    case ADD_EXPECT_CT_ORDINAL: {

                        NetworkContextAddExpectCtParams data =
                                NetworkContextAddExpectCtParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addExpectCt(data.host, data.expiry, data.enforce, data.reportUri, new NetworkContextAddExpectCtResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_EXPECT_CT_TEST_REPORT_ORDINAL: {

                        NetworkContextSetExpectCtTestReportParams data =
                                NetworkContextSetExpectCtTestReportParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setExpectCtTestReport(data.reportUri, new NetworkContextSetExpectCtTestReportResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_EXPECT_CT_STATE_ORDINAL: {

                        NetworkContextGetExpectCtStateParams data =
                                NetworkContextGetExpectCtStateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getExpectCtState(data.domain, new NetworkContextGetExpectCtStateResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }









                    case CREATE_TCP_SERVER_SOCKET_ORDINAL: {

                        NetworkContextCreateTcpServerSocketParams data =
                                NetworkContextCreateTcpServerSocketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createTcpServerSocket(data.localAddr, data.backlog, data.trafficAnnotation, data.socket, new NetworkContextCreateTcpServerSocketResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CREATE_TCP_CONNECTED_SOCKET_ORDINAL: {

                        NetworkContextCreateTcpConnectedSocketParams data =
                                NetworkContextCreateTcpConnectedSocketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createTcpConnectedSocket(data.localAddr, data.remoteAddrList, data.tcpConnectedSocketOptions, data.trafficAnnotation, data.socket, data.observer, new NetworkContextCreateTcpConnectedSocketResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CREATE_TCP_BOUND_SOCKET_ORDINAL: {

                        NetworkContextCreateTcpBoundSocketParams data =
                                NetworkContextCreateTcpBoundSocketParams.deserialize(messageWithHeader.getPayload());

                        getImpl().createTcpBoundSocket(data.localAddr, data.trafficAnnotation, data.socket, new NetworkContextCreateTcpBoundSocketResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }











                    case FORCE_RELOAD_PROXY_CONFIG_ORDINAL: {

                        NetworkContextForceReloadProxyConfigParams.deserialize(messageWithHeader.getPayload());

                        getImpl().forceReloadProxyConfig(new NetworkContextForceReloadProxyConfigResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case CLEAR_BAD_PROXIES_CACHE_ORDINAL: {

                        NetworkContextClearBadProxiesCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().clearBadProxiesCache(new NetworkContextClearBadProxiesCacheResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }





















                    case VERIFY_CERT_FOR_SIGNED_EXCHANGE_ORDINAL: {

                        NetworkContextVerifyCertForSignedExchangeParams data =
                                NetworkContextVerifyCertForSignedExchangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().verifyCertForSignedExchange(data.certificate, data.url, data.ocspResponse, data.sctList, new NetworkContextVerifyCertForSignedExchangeResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ADD_HSTS_ORDINAL: {

                        NetworkContextAddHstsParams data =
                                NetworkContextAddHstsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addHsts(data.host, data.expiry, data.includeSubdomains, new NetworkContextAddHstsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case IS_HSTS_ACTIVE_FOR_HOST_ORDINAL: {

                        NetworkContextIsHstsActiveForHostParams data =
                                NetworkContextIsHstsActiveForHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().isHstsActiveForHost(data.host, new NetworkContextIsHstsActiveForHostResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case GET_HSTS_STATE_ORDINAL: {

                        NetworkContextGetHstsStateParams data =
                                NetworkContextGetHstsStateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getHstsState(data.domain, new NetworkContextGetHstsStateResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_CORS_ORIGIN_ACCESS_LISTS_FOR_ORIGIN_ORDINAL: {

                        NetworkContextSetCorsOriginAccessListsForOriginParams data =
                                NetworkContextSetCorsOriginAccessListsForOriginParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setCorsOriginAccessListsForOrigin(data.sourceOrigin, data.allowPatterns, data.blockPatterns, new NetworkContextSetCorsOriginAccessListsForOriginResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case DELETE_DYNAMIC_DATA_FOR_HOST_ORDINAL: {

                        NetworkContextDeleteDynamicDataForHostParams data =
                                NetworkContextDeleteDynamicDataForHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().deleteDynamicDataForHost(data.host, new NetworkContextDeleteDynamicDataForHostResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SAVE_HTTP_AUTH_CACHE_ORDINAL: {

                        NetworkContextSaveHttpAuthCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().saveHttpAuthCache(new NetworkContextSaveHttpAuthCacheResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case LOAD_HTTP_AUTH_CACHE_ORDINAL: {

                        NetworkContextLoadHttpAuthCacheParams data =
                                NetworkContextLoadHttpAuthCacheParams.deserialize(messageWithHeader.getPayload());

                        getImpl().loadHttpAuthCache(data.cacheKey, new NetworkContextLoadHttpAuthCacheResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case LOOKUP_BASIC_AUTH_CREDENTIALS_ORDINAL: {

                        NetworkContextLookupBasicAuthCredentialsParams data =
                                NetworkContextLookupBasicAuthCredentialsParams.deserialize(messageWithHeader.getPayload());

                        getImpl().lookupBasicAuthCredentials(data.url, new NetworkContextLookupBasicAuthCredentialsResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ENABLE_STATIC_KEY_PINNING_FOR_TESTING_ORDINAL: {

                        NetworkContextEnableStaticKeyPinningForTestingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().enableStaticKeyPinningForTesting(new NetworkContextEnableStaticKeyPinningForTestingResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case SET_FAILING_HTTP_TRANSACTION_FOR_TESTING_ORDINAL: {

                        NetworkContextSetFailingHttpTransactionForTestingParams data =
                                NetworkContextSetFailingHttpTransactionForTestingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().setFailingHttpTransactionForTesting(data.rv, new NetworkContextSetFailingHttpTransactionForTestingResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case VERIFY_CERTIFICATE_FOR_TESTING_ORDINAL: {

                        NetworkContextVerifyCertificateForTestingParams data =
                                NetworkContextVerifyCertificateForTestingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().verifyCertificateForTesting(data.certificate, data.hostname, data.ocspResponse, new NetworkContextVerifyCertificateForTestingResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case ADD_DOMAIN_RELIABILITY_CONTEXT_FOR_TESTING_ORDINAL: {

                        NetworkContextAddDomainReliabilityContextForTestingParams data =
                                NetworkContextAddDomainReliabilityContextForTestingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().addDomainReliabilityContextForTesting(data.origin, data.uploadUrl, new NetworkContextAddDomainReliabilityContextForTestingResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }







                    case FORCE_DOMAIN_RELIABILITY_UPLOADS_FOR_TESTING_ORDINAL: {

                        NetworkContextForceDomainReliabilityUploadsForTestingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().forceDomainReliabilityUploadsForTesting(new NetworkContextForceDomainReliabilityUploadsForTestingResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NetworkContextSetClientParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public NetworkContextClient client;

        private NetworkContextSetClientParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetClientParams() {
            this(0);
        }

        public static NetworkContextSetClientParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetClientParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetClientParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetClientParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetClientParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readServiceInterface(8, false, NetworkContextClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false, NetworkContextClient.MANAGER);
        }
    }



    
    static final class NetworkContextCreateUrlLoaderFactoryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<UrlLoaderFactory> urlLoaderFactory;
        public UrlLoaderFactoryParams params;

        private NetworkContextCreateUrlLoaderFactoryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateUrlLoaderFactoryParams() {
            this(0);
        }

        public static NetworkContextCreateUrlLoaderFactoryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateUrlLoaderFactoryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateUrlLoaderFactoryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateUrlLoaderFactoryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateUrlLoaderFactoryParams(elementsOrVersion);
                    {
                        
                    result.urlLoaderFactory = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.params = UrlLoaderFactoryParams.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.urlLoaderFactory, 8, false);
            
            encoder0.encode(this.params, 16, false);
        }
    }



    
    static final class NetworkContextResetUrlLoaderFactoriesParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextResetUrlLoaderFactoriesParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextResetUrlLoaderFactoriesParams() {
            this(0);
        }

        public static NetworkContextResetUrlLoaderFactoriesParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextResetUrlLoaderFactoriesParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextResetUrlLoaderFactoriesParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextResetUrlLoaderFactoriesParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextResetUrlLoaderFactoriesParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextGetCookieManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<CookieManager> cookieManager;

        private NetworkContextGetCookieManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetCookieManagerParams() {
            this(0);
        }

        public static NetworkContextGetCookieManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetCookieManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetCookieManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetCookieManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetCookieManagerParams(elementsOrVersion);
                    {
                        
                    result.cookieManager = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cookieManager, 8, false);
        }
    }



    
    static final class NetworkContextGetRestrictedCookieManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<RestrictedCookieManager> restrictedCookieManager;
        public com.vccorp.url.mojom.Origin origin;

        private NetworkContextGetRestrictedCookieManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetRestrictedCookieManagerParams() {
            this(0);
        }

        public static NetworkContextGetRestrictedCookieManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetRestrictedCookieManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetRestrictedCookieManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetRestrictedCookieManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetRestrictedCookieManagerParams(elementsOrVersion);
                    {
                        
                    result.restrictedCookieManager = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.restrictedCookieManager, 8, false);
            
            encoder0.encode(this.origin, 16, false);
        }
    }



    
    static final class NetworkContextClearNetworkingHistorySinceParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Time startTime;

        private NetworkContextClearNetworkingHistorySinceParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearNetworkingHistorySinceParams() {
            this(0);
        }

        public static NetworkContextClearNetworkingHistorySinceParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearNetworkingHistorySinceParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearNetworkingHistorySinceParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearNetworkingHistorySinceParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearNetworkingHistorySinceParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.startTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.startTime, 8, false);
        }
    }



    
    static final class NetworkContextClearNetworkingHistorySinceResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearNetworkingHistorySinceResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearNetworkingHistorySinceResponseParams() {
            this(0);
        }

        public static NetworkContextClearNetworkingHistorySinceResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearNetworkingHistorySinceResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearNetworkingHistorySinceResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearNetworkingHistorySinceResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearNetworkingHistorySinceResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearNetworkingHistorySinceResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearNetworkingHistorySinceResponse mCallback;

        NetworkContextClearNetworkingHistorySinceResponseParamsForwardToCallback(NetworkContext.ClearNetworkingHistorySinceResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_NETWORKING_HISTORY_SINCE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearNetworkingHistorySinceResponseParamsProxyToResponder implements NetworkContext.ClearNetworkingHistorySinceResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearNetworkingHistorySinceResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearNetworkingHistorySinceResponseParams _response = new NetworkContextClearNetworkingHistorySinceResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_NETWORKING_HISTORY_SINCE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearHttpCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Time startTime;
        public com.vccorp.mojo_base.mojom.Time endTime;
        public ClearDataFilter filter;

        private NetworkContextClearHttpCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearHttpCacheParams() {
            this(0);
        }

        public static NetworkContextClearHttpCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearHttpCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearHttpCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearHttpCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearHttpCacheParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.startTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.endTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.filter = ClearDataFilter.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.startTime, 8, false);
            
            encoder0.encode(this.endTime, 16, false);
            
            encoder0.encode(this.filter, 24, true);
        }
    }



    
    static final class NetworkContextClearHttpCacheResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearHttpCacheResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearHttpCacheResponseParams() {
            this(0);
        }

        public static NetworkContextClearHttpCacheResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearHttpCacheResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearHttpCacheResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearHttpCacheResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearHttpCacheResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearHttpCacheResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearHttpCacheResponse mCallback;

        NetworkContextClearHttpCacheResponseParamsForwardToCallback(NetworkContext.ClearHttpCacheResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_HTTP_CACHE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearHttpCacheResponseParamsProxyToResponder implements NetworkContext.ClearHttpCacheResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearHttpCacheResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearHttpCacheResponseParams _response = new NetworkContextClearHttpCacheResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_HTTP_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextComputeHttpCacheSizeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Time startTime;
        public com.vccorp.mojo_base.mojom.Time endTime;

        private NetworkContextComputeHttpCacheSizeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextComputeHttpCacheSizeParams() {
            this(0);
        }

        public static NetworkContextComputeHttpCacheSizeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextComputeHttpCacheSizeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextComputeHttpCacheSizeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextComputeHttpCacheSizeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextComputeHttpCacheSizeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.startTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.endTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.startTime, 8, false);
            
            encoder0.encode(this.endTime, 16, false);
        }
    }



    
    static final class NetworkContextComputeHttpCacheSizeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean isUpperBound;
        public long sizeOrError;

        private NetworkContextComputeHttpCacheSizeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextComputeHttpCacheSizeResponseParams() {
            this(0);
        }

        public static NetworkContextComputeHttpCacheSizeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextComputeHttpCacheSizeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextComputeHttpCacheSizeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextComputeHttpCacheSizeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextComputeHttpCacheSizeResponseParams(elementsOrVersion);
                    {
                        
                    result.isUpperBound = decoder0.readBoolean(8, 0);
                    }
                    {
                        
                    result.sizeOrError = decoder0.readLong(16);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.isUpperBound, 8, 0);
            
            encoder0.encode(this.sizeOrError, 16);
        }
    }

    static class NetworkContextComputeHttpCacheSizeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ComputeHttpCacheSizeResponse mCallback;

        NetworkContextComputeHttpCacheSizeResponseParamsForwardToCallback(NetworkContext.ComputeHttpCacheSizeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(COMPUTE_HTTP_CACHE_SIZE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextComputeHttpCacheSizeResponseParams response = NetworkContextComputeHttpCacheSizeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.isUpperBound, response.sizeOrError);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextComputeHttpCacheSizeResponseParamsProxyToResponder implements NetworkContext.ComputeHttpCacheSizeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextComputeHttpCacheSizeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean isUpperBound, Long sizeOrError) {
            NetworkContextComputeHttpCacheSizeResponseParams _response = new NetworkContextComputeHttpCacheSizeResponseParams();

            _response.isUpperBound = isUpperBound;

            _response.sizeOrError = sizeOrError;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    COMPUTE_HTTP_CACHE_SIZE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextNotifyExternalCacheHitParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public String httpMethod;
        public com.vccorp.url.mojom.Origin topFrameOrigin;

        private NetworkContextNotifyExternalCacheHitParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextNotifyExternalCacheHitParams() {
            this(0);
        }

        public static NetworkContextNotifyExternalCacheHitParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextNotifyExternalCacheHitParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextNotifyExternalCacheHitParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextNotifyExternalCacheHitParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextNotifyExternalCacheHitParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.httpMethod = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.topFrameOrigin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.httpMethod, 16, false);
            
            encoder0.encode(this.topFrameOrigin, 24, true);
        }
    }



    
    static final class NetworkContextWriteCacheMetadataParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public int priority;
        public com.vccorp.mojo_base.mojom.Time expectedResponseTime;
        public byte[] data;

        private NetworkContextWriteCacheMetadataParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextWriteCacheMetadataParams() {
            this(0);
        }

        public static NetworkContextWriteCacheMetadataParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextWriteCacheMetadataParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextWriteCacheMetadataParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextWriteCacheMetadataParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextWriteCacheMetadataParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.priority = decoder0.readInt(16);
                        RequestPriority.validate(result.priority);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.expectedResponseTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    result.data = decoder0.readBytes(32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.priority, 16);
            
            encoder0.encode(this.expectedResponseTime, 24, false);
            
            encoder0.encode(this.data, 32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
    }



    
    static final class NetworkContextClearChannelIdsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Time startTime;
        public com.vccorp.mojo_base.mojom.Time endTime;
        public ClearDataFilter filter;

        private NetworkContextClearChannelIdsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearChannelIdsParams() {
            this(0);
        }

        public static NetworkContextClearChannelIdsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearChannelIdsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearChannelIdsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearChannelIdsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearChannelIdsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.startTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.endTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.filter = ClearDataFilter.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.startTime, 8, false);
            
            encoder0.encode(this.endTime, 16, false);
            
            encoder0.encode(this.filter, 24, true);
        }
    }



    
    static final class NetworkContextClearChannelIdsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearChannelIdsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearChannelIdsResponseParams() {
            this(0);
        }

        public static NetworkContextClearChannelIdsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearChannelIdsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearChannelIdsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearChannelIdsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearChannelIdsResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearChannelIdsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearChannelIdsResponse mCallback;

        NetworkContextClearChannelIdsResponseParamsForwardToCallback(NetworkContext.ClearChannelIdsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_CHANNEL_IDS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearChannelIdsResponseParamsProxyToResponder implements NetworkContext.ClearChannelIdsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearChannelIdsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearChannelIdsResponseParams _response = new NetworkContextClearChannelIdsResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_CHANNEL_IDS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearHostCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ClearDataFilter filter;

        private NetworkContextClearHostCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearHostCacheParams() {
            this(0);
        }

        public static NetworkContextClearHostCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearHostCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearHostCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearHostCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearHostCacheParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.filter = ClearDataFilter.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.filter, 8, true);
        }
    }



    
    static final class NetworkContextClearHostCacheResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearHostCacheResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearHostCacheResponseParams() {
            this(0);
        }

        public static NetworkContextClearHostCacheResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearHostCacheResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearHostCacheResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearHostCacheResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearHostCacheResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearHostCacheResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearHostCacheResponse mCallback;

        NetworkContextClearHostCacheResponseParamsForwardToCallback(NetworkContext.ClearHostCacheResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_HOST_CACHE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearHostCacheResponseParamsProxyToResponder implements NetworkContext.ClearHostCacheResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearHostCacheResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearHostCacheResponseParams _response = new NetworkContextClearHostCacheResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_HOST_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearHttpAuthCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Time startTime;

        private NetworkContextClearHttpAuthCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearHttpAuthCacheParams() {
            this(0);
        }

        public static NetworkContextClearHttpAuthCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearHttpAuthCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearHttpAuthCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearHttpAuthCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearHttpAuthCacheParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.startTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.startTime, 8, false);
        }
    }



    
    static final class NetworkContextClearHttpAuthCacheResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearHttpAuthCacheResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearHttpAuthCacheResponseParams() {
            this(0);
        }

        public static NetworkContextClearHttpAuthCacheResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearHttpAuthCacheResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearHttpAuthCacheResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearHttpAuthCacheResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearHttpAuthCacheResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearHttpAuthCacheResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearHttpAuthCacheResponse mCallback;

        NetworkContextClearHttpAuthCacheResponseParamsForwardToCallback(NetworkContext.ClearHttpAuthCacheResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_HTTP_AUTH_CACHE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearHttpAuthCacheResponseParamsProxyToResponder implements NetworkContext.ClearHttpAuthCacheResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearHttpAuthCacheResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearHttpAuthCacheResponseParams _response = new NetworkContextClearHttpAuthCacheResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_HTTP_AUTH_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearReportingCacheReportsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ClearDataFilter filter;

        private NetworkContextClearReportingCacheReportsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearReportingCacheReportsParams() {
            this(0);
        }

        public static NetworkContextClearReportingCacheReportsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearReportingCacheReportsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearReportingCacheReportsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearReportingCacheReportsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearReportingCacheReportsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.filter = ClearDataFilter.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.filter, 8, true);
        }
    }



    
    static final class NetworkContextClearReportingCacheReportsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearReportingCacheReportsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearReportingCacheReportsResponseParams() {
            this(0);
        }

        public static NetworkContextClearReportingCacheReportsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearReportingCacheReportsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearReportingCacheReportsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearReportingCacheReportsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearReportingCacheReportsResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearReportingCacheReportsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearReportingCacheReportsResponse mCallback;

        NetworkContextClearReportingCacheReportsResponseParamsForwardToCallback(NetworkContext.ClearReportingCacheReportsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_REPORTING_CACHE_REPORTS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearReportingCacheReportsResponseParamsProxyToResponder implements NetworkContext.ClearReportingCacheReportsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearReportingCacheReportsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearReportingCacheReportsResponseParams _response = new NetworkContextClearReportingCacheReportsResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_REPORTING_CACHE_REPORTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearReportingCacheClientsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ClearDataFilter filter;

        private NetworkContextClearReportingCacheClientsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearReportingCacheClientsParams() {
            this(0);
        }

        public static NetworkContextClearReportingCacheClientsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearReportingCacheClientsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearReportingCacheClientsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearReportingCacheClientsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearReportingCacheClientsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.filter = ClearDataFilter.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.filter, 8, true);
        }
    }



    
    static final class NetworkContextClearReportingCacheClientsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearReportingCacheClientsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearReportingCacheClientsResponseParams() {
            this(0);
        }

        public static NetworkContextClearReportingCacheClientsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearReportingCacheClientsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearReportingCacheClientsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearReportingCacheClientsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearReportingCacheClientsResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearReportingCacheClientsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearReportingCacheClientsResponse mCallback;

        NetworkContextClearReportingCacheClientsResponseParamsForwardToCallback(NetworkContext.ClearReportingCacheClientsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_REPORTING_CACHE_CLIENTS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearReportingCacheClientsResponseParamsProxyToResponder implements NetworkContext.ClearReportingCacheClientsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearReportingCacheClientsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearReportingCacheClientsResponseParams _response = new NetworkContextClearReportingCacheClientsResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_REPORTING_CACHE_CLIENTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearNetworkErrorLoggingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ClearDataFilter filter;

        private NetworkContextClearNetworkErrorLoggingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearNetworkErrorLoggingParams() {
            this(0);
        }

        public static NetworkContextClearNetworkErrorLoggingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearNetworkErrorLoggingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearNetworkErrorLoggingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearNetworkErrorLoggingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearNetworkErrorLoggingParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.filter = ClearDataFilter.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.filter, 8, true);
        }
    }



    
    static final class NetworkContextClearNetworkErrorLoggingResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearNetworkErrorLoggingResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearNetworkErrorLoggingResponseParams() {
            this(0);
        }

        public static NetworkContextClearNetworkErrorLoggingResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearNetworkErrorLoggingResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearNetworkErrorLoggingResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearNetworkErrorLoggingResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearNetworkErrorLoggingResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearNetworkErrorLoggingResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearNetworkErrorLoggingResponse mCallback;

        NetworkContextClearNetworkErrorLoggingResponseParamsForwardToCallback(NetworkContext.ClearNetworkErrorLoggingResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_NETWORK_ERROR_LOGGING_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearNetworkErrorLoggingResponseParamsProxyToResponder implements NetworkContext.ClearNetworkErrorLoggingResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearNetworkErrorLoggingResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearNetworkErrorLoggingResponseParams _response = new NetworkContextClearNetworkErrorLoggingResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_NETWORK_ERROR_LOGGING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearDomainReliabilityParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public ClearDataFilter filter;
        public int mode;

        private NetworkContextClearDomainReliabilityParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearDomainReliabilityParams() {
            this(0);
        }

        public static NetworkContextClearDomainReliabilityParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearDomainReliabilityParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearDomainReliabilityParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearDomainReliabilityParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearDomainReliabilityParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.filter = ClearDataFilter.decode(decoder1);
                    }
                    {
                        
                    result.mode = decoder0.readInt(16);
                        NetworkContext.DomainReliabilityClearMode.validate(result.mode);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.filter, 8, true);
            
            encoder0.encode(this.mode, 16);
        }
    }



    
    static final class NetworkContextClearDomainReliabilityResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearDomainReliabilityResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearDomainReliabilityResponseParams() {
            this(0);
        }

        public static NetworkContextClearDomainReliabilityResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearDomainReliabilityResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearDomainReliabilityResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearDomainReliabilityResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearDomainReliabilityResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearDomainReliabilityResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearDomainReliabilityResponse mCallback;

        NetworkContextClearDomainReliabilityResponseParamsForwardToCallback(NetworkContext.ClearDomainReliabilityResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_DOMAIN_RELIABILITY_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearDomainReliabilityResponseParamsProxyToResponder implements NetworkContext.ClearDomainReliabilityResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearDomainReliabilityResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearDomainReliabilityResponseParams _response = new NetworkContextClearDomainReliabilityResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_DOMAIN_RELIABILITY_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextGetDomainReliabilityJsonParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextGetDomainReliabilityJsonParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetDomainReliabilityJsonParams() {
            this(0);
        }

        public static NetworkContextGetDomainReliabilityJsonParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetDomainReliabilityJsonParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetDomainReliabilityJsonParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetDomainReliabilityJsonParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetDomainReliabilityJsonParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextGetDomainReliabilityJsonResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.Value data;

        private NetworkContextGetDomainReliabilityJsonResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetDomainReliabilityJsonResponseParams() {
            this(0);
        }

        public static NetworkContextGetDomainReliabilityJsonResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetDomainReliabilityJsonResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetDomainReliabilityJsonResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetDomainReliabilityJsonResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetDomainReliabilityJsonResponseParams(elementsOrVersion);
                    {
                        
                    result.data = com.vccorp.mojo_base.mojom.Value.decode(decoder0, 8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.data, 8, false);
        }
    }

    static class NetworkContextGetDomainReliabilityJsonResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.GetDomainReliabilityJsonResponse mCallback;

        NetworkContextGetDomainReliabilityJsonResponseParamsForwardToCallback(NetworkContext.GetDomainReliabilityJsonResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_DOMAIN_RELIABILITY_JSON_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextGetDomainReliabilityJsonResponseParams response = NetworkContextGetDomainReliabilityJsonResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.data);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextGetDomainReliabilityJsonResponseParamsProxyToResponder implements NetworkContext.GetDomainReliabilityJsonResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextGetDomainReliabilityJsonResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.Value data) {
            NetworkContextGetDomainReliabilityJsonResponseParams _response = new NetworkContextGetDomainReliabilityJsonResponseParams();

            _response.data = data;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_DOMAIN_RELIABILITY_JSON_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextQueueReportParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String type;
        public String group;
        public com.vccorp.url.mojom.Url url;
        public String userAgent;
        public com.vccorp.mojo_base.mojom.DictionaryValue body;

        private NetworkContextQueueReportParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextQueueReportParams() {
            this(0);
        }

        public static NetworkContextQueueReportParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextQueueReportParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextQueueReportParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextQueueReportParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextQueueReportParams(elementsOrVersion);
                    {
                        
                    result.type = decoder0.readString(8, false);
                    }
                    {
                        
                    result.group = decoder0.readString(16, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.userAgent = decoder0.readString(32, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
                    result.body = com.vccorp.mojo_base.mojom.DictionaryValue.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.type, 8, false);
            
            encoder0.encode(this.group, 16, false);
            
            encoder0.encode(this.url, 24, false);
            
            encoder0.encode(this.userAgent, 32, true);
            
            encoder0.encode(this.body, 40, false);
        }
    }



    
    static final class NetworkContextQueueSignedExchangeReportParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public SignedExchangeReport report;

        private NetworkContextQueueSignedExchangeReportParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextQueueSignedExchangeReportParams() {
            this(0);
        }

        public static NetworkContextQueueSignedExchangeReportParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextQueueSignedExchangeReportParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextQueueSignedExchangeReportParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextQueueSignedExchangeReportParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextQueueSignedExchangeReportParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.report = SignedExchangeReport.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.report, 8, false);
        }
    }



    
    static final class NetworkContextCloseAllConnectionsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextCloseAllConnectionsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCloseAllConnectionsParams() {
            this(0);
        }

        public static NetworkContextCloseAllConnectionsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCloseAllConnectionsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCloseAllConnectionsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCloseAllConnectionsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCloseAllConnectionsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextCloseAllConnectionsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextCloseAllConnectionsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCloseAllConnectionsResponseParams() {
            this(0);
        }

        public static NetworkContextCloseAllConnectionsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCloseAllConnectionsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCloseAllConnectionsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCloseAllConnectionsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCloseAllConnectionsResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextCloseAllConnectionsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.CloseAllConnectionsResponse mCallback;

        NetworkContextCloseAllConnectionsResponseParamsForwardToCallback(NetworkContext.CloseAllConnectionsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLOSE_ALL_CONNECTIONS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextCloseAllConnectionsResponseParamsProxyToResponder implements NetworkContext.CloseAllConnectionsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextCloseAllConnectionsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextCloseAllConnectionsResponseParams _response = new NetworkContextCloseAllConnectionsResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLOSE_ALL_CONNECTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextCloseIdleConnectionsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextCloseIdleConnectionsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCloseIdleConnectionsParams() {
            this(0);
        }

        public static NetworkContextCloseIdleConnectionsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCloseIdleConnectionsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCloseIdleConnectionsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCloseIdleConnectionsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCloseIdleConnectionsParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextCloseIdleConnectionsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextCloseIdleConnectionsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCloseIdleConnectionsResponseParams() {
            this(0);
        }

        public static NetworkContextCloseIdleConnectionsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCloseIdleConnectionsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCloseIdleConnectionsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCloseIdleConnectionsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCloseIdleConnectionsResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextCloseIdleConnectionsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.CloseIdleConnectionsResponse mCallback;

        NetworkContextCloseIdleConnectionsResponseParamsForwardToCallback(NetworkContext.CloseIdleConnectionsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLOSE_IDLE_CONNECTIONS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextCloseIdleConnectionsResponseParamsProxyToResponder implements NetworkContext.CloseIdleConnectionsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextCloseIdleConnectionsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextCloseIdleConnectionsResponseParams _response = new NetworkContextCloseIdleConnectionsResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLOSE_IDLE_CONNECTIONS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextSetNetworkConditionsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.UnguessableToken throttlingProfileId;
        public NetworkConditions conditions;

        private NetworkContextSetNetworkConditionsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetNetworkConditionsParams() {
            this(0);
        }

        public static NetworkContextSetNetworkConditionsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetNetworkConditionsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetNetworkConditionsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetNetworkConditionsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetNetworkConditionsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.throttlingProfileId = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.conditions = NetworkConditions.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.throttlingProfileId, 8, false);
            
            encoder0.encode(this.conditions, 16, true);
        }
    }



    
    static final class NetworkContextSetAcceptLanguageParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String newAcceptLanguage;

        private NetworkContextSetAcceptLanguageParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetAcceptLanguageParams() {
            this(0);
        }

        public static NetworkContextSetAcceptLanguageParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetAcceptLanguageParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetAcceptLanguageParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetAcceptLanguageParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetAcceptLanguageParams(elementsOrVersion);
                    {
                        
                    result.newAcceptLanguage = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.newAcceptLanguage, 8, false);
        }
    }



    
    static final class NetworkContextSetEnableReferrersParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean enableReferrers;

        private NetworkContextSetEnableReferrersParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetEnableReferrersParams() {
            this(0);
        }

        public static NetworkContextSetEnableReferrersParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetEnableReferrersParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetEnableReferrersParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetEnableReferrersParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetEnableReferrersParams(elementsOrVersion);
                    {
                        
                    result.enableReferrers = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.enableReferrers, 8, 0);
        }
    }



    
    static final class NetworkContextSetCtPolicyParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String[] requiredHosts;
        public String[] excludedHosts;
        public String[] excludedSpkis;
        public String[] excludedLegacySpkis;

        private NetworkContextSetCtPolicyParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetCtPolicyParams() {
            this(0);
        }

        public static NetworkContextSetCtPolicyParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetCtPolicyParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetCtPolicyParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetCtPolicyParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetCtPolicyParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.requiredHosts = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.requiredHosts[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.excludedHosts = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.excludedHosts[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.excludedSpkis = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.excludedSpkis[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.excludedLegacySpkis = new String[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            result.excludedLegacySpkis[i1] = decoder1.readString(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            if (this.requiredHosts == null) {
                encoder0.encodeNullPointer(8, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.requiredHosts.length, 8, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.requiredHosts.length; ++i0) {
                    
                    encoder1.encode(this.requiredHosts[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            if (this.excludedHosts == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.excludedHosts.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.excludedHosts.length; ++i0) {
                    
                    encoder1.encode(this.excludedHosts[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            if (this.excludedSpkis == null) {
                encoder0.encodeNullPointer(24, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.excludedSpkis.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.excludedSpkis.length; ++i0) {
                    
                    encoder1.encode(this.excludedSpkis[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            if (this.excludedLegacySpkis == null) {
                encoder0.encodeNullPointer(32, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.excludedLegacySpkis.length, 32, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.excludedLegacySpkis.length; ++i0) {
                    
                    encoder1.encode(this.excludedLegacySpkis[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class NetworkContextAddExpectCtParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String host;
        public com.vccorp.mojo_base.mojom.Time expiry;
        public boolean enforce;
        public com.vccorp.url.mojom.Url reportUri;

        private NetworkContextAddExpectCtParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextAddExpectCtParams() {
            this(0);
        }

        public static NetworkContextAddExpectCtParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextAddExpectCtParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextAddExpectCtParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextAddExpectCtParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextAddExpectCtParams(elementsOrVersion);
                    {
                        
                    result.host = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.expiry = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    result.enforce = decoder0.readBoolean(24, 0);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.reportUri = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
            
            encoder0.encode(this.expiry, 16, false);
            
            encoder0.encode(this.enforce, 24, 0);
            
            encoder0.encode(this.reportUri, 32, false);
        }
    }



    
    static final class NetworkContextAddExpectCtResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private NetworkContextAddExpectCtResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextAddExpectCtResponseParams() {
            this(0);
        }

        public static NetworkContextAddExpectCtResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextAddExpectCtResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextAddExpectCtResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextAddExpectCtResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextAddExpectCtResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class NetworkContextAddExpectCtResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.AddExpectCtResponse mCallback;

        NetworkContextAddExpectCtResponseParamsForwardToCallback(NetworkContext.AddExpectCtResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ADD_EXPECT_CT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextAddExpectCtResponseParams response = NetworkContextAddExpectCtResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextAddExpectCtResponseParamsProxyToResponder implements NetworkContext.AddExpectCtResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextAddExpectCtResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            NetworkContextAddExpectCtResponseParams _response = new NetworkContextAddExpectCtResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_EXPECT_CT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextSetExpectCtTestReportParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url reportUri;

        private NetworkContextSetExpectCtTestReportParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetExpectCtTestReportParams() {
            this(0);
        }

        public static NetworkContextSetExpectCtTestReportParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetExpectCtTestReportParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetExpectCtTestReportParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetExpectCtTestReportParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetExpectCtTestReportParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.reportUri = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.reportUri, 8, false);
        }
    }



    
    static final class NetworkContextSetExpectCtTestReportResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean success;

        private NetworkContextSetExpectCtTestReportResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetExpectCtTestReportResponseParams() {
            this(0);
        }

        public static NetworkContextSetExpectCtTestReportResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetExpectCtTestReportResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetExpectCtTestReportResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetExpectCtTestReportResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetExpectCtTestReportResponseParams(elementsOrVersion);
                    {
                        
                    result.success = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.success, 8, 0);
        }
    }

    static class NetworkContextSetExpectCtTestReportResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.SetExpectCtTestReportResponse mCallback;

        NetworkContextSetExpectCtTestReportResponseParamsForwardToCallback(NetworkContext.SetExpectCtTestReportResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_EXPECT_CT_TEST_REPORT_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextSetExpectCtTestReportResponseParams response = NetworkContextSetExpectCtTestReportResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.success);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextSetExpectCtTestReportResponseParamsProxyToResponder implements NetworkContext.SetExpectCtTestReportResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextSetExpectCtTestReportResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean success) {
            NetworkContextSetExpectCtTestReportResponseParams _response = new NetworkContextSetExpectCtTestReportResponseParams();

            _response.success = success;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_EXPECT_CT_TEST_REPORT_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextGetExpectCtStateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String domain;

        private NetworkContextGetExpectCtStateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetExpectCtStateParams() {
            this(0);
        }

        public static NetworkContextGetExpectCtStateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetExpectCtStateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetExpectCtStateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetExpectCtStateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetExpectCtStateParams(elementsOrVersion);
                    {
                        
                    result.domain = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.domain, 8, false);
        }
    }



    
    static final class NetworkContextGetExpectCtStateResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.DictionaryValue state;

        private NetworkContextGetExpectCtStateResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetExpectCtStateResponseParams() {
            this(0);
        }

        public static NetworkContextGetExpectCtStateResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetExpectCtStateResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetExpectCtStateResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetExpectCtStateResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetExpectCtStateResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.state = com.vccorp.mojo_base.mojom.DictionaryValue.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.state, 8, false);
        }
    }

    static class NetworkContextGetExpectCtStateResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.GetExpectCtStateResponse mCallback;

        NetworkContextGetExpectCtStateResponseParamsForwardToCallback(NetworkContext.GetExpectCtStateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_EXPECT_CT_STATE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextGetExpectCtStateResponseParams response = NetworkContextGetExpectCtStateResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.state);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextGetExpectCtStateResponseParamsProxyToResponder implements NetworkContext.GetExpectCtStateResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextGetExpectCtStateResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.DictionaryValue state) {
            NetworkContextGetExpectCtStateResponseParams _response = new NetworkContextGetExpectCtStateResponseParams();

            _response.state = state;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_EXPECT_CT_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextCreateUdpSocketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<UdpSocket> request;
        public UdpSocketReceiver receiver;

        private NetworkContextCreateUdpSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateUdpSocketParams() {
            this(0);
        }

        public static NetworkContextCreateUdpSocketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateUdpSocketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateUdpSocketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateUdpSocketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateUdpSocketParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    result.receiver = decoder0.readServiceInterface(12, true, UdpSocketReceiver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
            
            encoder0.encode(this.receiver, 12, true, UdpSocketReceiver.MANAGER);
        }
    }



    
    static final class NetworkContextCreateTcpServerSocketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public IpEndPoint localAddr;
        public int backlog;
        public MutableNetworkTrafficAnnotationTag trafficAnnotation;
        public com.vccorp.mojo.bindings.InterfaceRequest<TcpServerSocket> socket;

        private NetworkContextCreateTcpServerSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateTcpServerSocketParams() {
            this(0);
        }

        public static NetworkContextCreateTcpServerSocketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateTcpServerSocketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateTcpServerSocketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateTcpServerSocketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateTcpServerSocketParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.localAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    result.backlog = decoder0.readInt(16);
                    }
                    {
                        
                    result.socket = decoder0.readInterfaceRequest(20, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.trafficAnnotation = MutableNetworkTrafficAnnotationTag.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.localAddr, 8, false);
            
            encoder0.encode(this.backlog, 16);
            
            encoder0.encode(this.socket, 20, false);
            
            encoder0.encode(this.trafficAnnotation, 24, false);
        }
    }



    
    static final class NetworkContextCreateTcpServerSocketResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public IpEndPoint localAddrOut;

        private NetworkContextCreateTcpServerSocketResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateTcpServerSocketResponseParams() {
            this(0);
        }

        public static NetworkContextCreateTcpServerSocketResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateTcpServerSocketResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateTcpServerSocketResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateTcpServerSocketResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateTcpServerSocketResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.localAddrOut = IpEndPoint.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.localAddrOut, 16, true);
        }
    }

    static class NetworkContextCreateTcpServerSocketResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.CreateTcpServerSocketResponse mCallback;

        NetworkContextCreateTcpServerSocketResponseParamsForwardToCallback(NetworkContext.CreateTcpServerSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_TCP_SERVER_SOCKET_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextCreateTcpServerSocketResponseParams response = NetworkContextCreateTcpServerSocketResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.localAddrOut);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextCreateTcpServerSocketResponseParamsProxyToResponder implements NetworkContext.CreateTcpServerSocketResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextCreateTcpServerSocketResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, IpEndPoint localAddrOut) {
            NetworkContextCreateTcpServerSocketResponseParams _response = new NetworkContextCreateTcpServerSocketResponseParams();

            _response.result = result;

            _response.localAddrOut = localAddrOut;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_TCP_SERVER_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextCreateTcpConnectedSocketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 56;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public IpEndPoint localAddr;
        public AddressList remoteAddrList;
        public TcpConnectedSocketOptions tcpConnectedSocketOptions;
        public MutableNetworkTrafficAnnotationTag trafficAnnotation;
        public com.vccorp.mojo.bindings.InterfaceRequest<TcpConnectedSocket> socket;
        public SocketObserver observer;

        private NetworkContextCreateTcpConnectedSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateTcpConnectedSocketParams() {
            this(0);
        }

        public static NetworkContextCreateTcpConnectedSocketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateTcpConnectedSocketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateTcpConnectedSocketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateTcpConnectedSocketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateTcpConnectedSocketParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.localAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.remoteAddrList = AddressList.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.tcpConnectedSocketOptions = TcpConnectedSocketOptions.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
                    result.trafficAnnotation = MutableNetworkTrafficAnnotationTag.decode(decoder1);
                    }
                    {
                        
                    result.socket = decoder0.readInterfaceRequest(40, false);
                    }
                    {
                        
                    result.observer = decoder0.readServiceInterface(44, true, SocketObserver.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.localAddr, 8, true);
            
            encoder0.encode(this.remoteAddrList, 16, false);
            
            encoder0.encode(this.tcpConnectedSocketOptions, 24, true);
            
            encoder0.encode(this.trafficAnnotation, 32, false);
            
            encoder0.encode(this.socket, 40, false);
            
            encoder0.encode(this.observer, 44, true, SocketObserver.MANAGER);
        }
    }



    
    static final class NetworkContextCreateTcpConnectedSocketResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public IpEndPoint localAddr;
        public IpEndPoint peerAddr;
        public com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream;
        public com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream;

        private NetworkContextCreateTcpConnectedSocketResponseParams(int version) {
            super(STRUCT_SIZE, version);
            this.receiveStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
            this.sendStream = com.vccorp.mojo.system.InvalidHandle.INSTANCE;
        }

        public NetworkContextCreateTcpConnectedSocketResponseParams() {
            this(0);
        }

        public static NetworkContextCreateTcpConnectedSocketResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateTcpConnectedSocketResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateTcpConnectedSocketResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateTcpConnectedSocketResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateTcpConnectedSocketResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                    }
                    {
                        
                    result.receiveStream = decoder0.readConsumerHandle(12, true);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.localAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
                    result.peerAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    result.sendStream = decoder0.readProducerHandle(32, true);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.receiveStream, 12, true);
            
            encoder0.encode(this.localAddr, 16, true);
            
            encoder0.encode(this.peerAddr, 24, true);
            
            encoder0.encode(this.sendStream, 32, true);
        }
    }

    static class NetworkContextCreateTcpConnectedSocketResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.CreateTcpConnectedSocketResponse mCallback;

        NetworkContextCreateTcpConnectedSocketResponseParamsForwardToCallback(NetworkContext.CreateTcpConnectedSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_TCP_CONNECTED_SOCKET_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextCreateTcpConnectedSocketResponseParams response = NetworkContextCreateTcpConnectedSocketResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.localAddr, response.peerAddr, response.receiveStream, response.sendStream);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextCreateTcpConnectedSocketResponseParamsProxyToResponder implements NetworkContext.CreateTcpConnectedSocketResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextCreateTcpConnectedSocketResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, IpEndPoint localAddr, IpEndPoint peerAddr, com.vccorp.mojo.system.DataPipe.ConsumerHandle receiveStream, com.vccorp.mojo.system.DataPipe.ProducerHandle sendStream) {
            NetworkContextCreateTcpConnectedSocketResponseParams _response = new NetworkContextCreateTcpConnectedSocketResponseParams();

            _response.result = result;

            _response.localAddr = localAddr;

            _response.peerAddr = peerAddr;

            _response.receiveStream = receiveStream;

            _response.sendStream = sendStream;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_TCP_CONNECTED_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextCreateTcpBoundSocketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public IpEndPoint localAddr;
        public MutableNetworkTrafficAnnotationTag trafficAnnotation;
        public com.vccorp.mojo.bindings.InterfaceRequest<TcpBoundSocket> socket;

        private NetworkContextCreateTcpBoundSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateTcpBoundSocketParams() {
            this(0);
        }

        public static NetworkContextCreateTcpBoundSocketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateTcpBoundSocketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateTcpBoundSocketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateTcpBoundSocketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateTcpBoundSocketParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.localAddr = IpEndPoint.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.trafficAnnotation = MutableNetworkTrafficAnnotationTag.decode(decoder1);
                    }
                    {
                        
                    result.socket = decoder0.readInterfaceRequest(24, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.localAddr, 8, false);
            
            encoder0.encode(this.trafficAnnotation, 16, false);
            
            encoder0.encode(this.socket, 24, false);
        }
    }



    
    static final class NetworkContextCreateTcpBoundSocketResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int result;
        public IpEndPoint localAddr;

        private NetworkContextCreateTcpBoundSocketResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateTcpBoundSocketResponseParams() {
            this(0);
        }

        public static NetworkContextCreateTcpBoundSocketResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateTcpBoundSocketResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateTcpBoundSocketResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateTcpBoundSocketResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateTcpBoundSocketResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.localAddr = IpEndPoint.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8);
            
            encoder0.encode(this.localAddr, 16, true);
        }
    }

    static class NetworkContextCreateTcpBoundSocketResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.CreateTcpBoundSocketResponse mCallback;

        NetworkContextCreateTcpBoundSocketResponseParamsForwardToCallback(NetworkContext.CreateTcpBoundSocketResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CREATE_TCP_BOUND_SOCKET_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextCreateTcpBoundSocketResponseParams response = NetworkContextCreateTcpBoundSocketResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result, response.localAddr);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextCreateTcpBoundSocketResponseParamsProxyToResponder implements NetworkContext.CreateTcpBoundSocketResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextCreateTcpBoundSocketResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, IpEndPoint localAddr) {
            NetworkContextCreateTcpBoundSocketResponseParams _response = new NetworkContextCreateTcpBoundSocketResponseParams();

            _response.result = result;

            _response.localAddr = localAddr;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CREATE_TCP_BOUND_SOCKET_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextCreateProxyResolvingSocketFactoryParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<ProxyResolvingSocketFactory> factory;

        private NetworkContextCreateProxyResolvingSocketFactoryParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateProxyResolvingSocketFactoryParams() {
            this(0);
        }

        public static NetworkContextCreateProxyResolvingSocketFactoryParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateProxyResolvingSocketFactoryParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateProxyResolvingSocketFactoryParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateProxyResolvingSocketFactoryParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateProxyResolvingSocketFactoryParams(elementsOrVersion);
                    {
                        
                    result.factory = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.factory, 8, false);
        }
    }



    
    static final class NetworkContextLookUpProxyForUrlParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;
        public ProxyLookupClient proxyLookupClient;

        private NetworkContextLookUpProxyForUrlParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextLookUpProxyForUrlParams() {
            this(0);
        }

        public static NetworkContextLookUpProxyForUrlParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextLookUpProxyForUrlParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextLookUpProxyForUrlParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextLookUpProxyForUrlParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextLookUpProxyForUrlParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.proxyLookupClient = decoder0.readServiceInterface(16, false, ProxyLookupClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
            
            encoder0.encode(this.proxyLookupClient, 16, false, ProxyLookupClient.MANAGER);
        }
    }



    
    static final class NetworkContextForceReloadProxyConfigParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextForceReloadProxyConfigParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextForceReloadProxyConfigParams() {
            this(0);
        }

        public static NetworkContextForceReloadProxyConfigParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextForceReloadProxyConfigParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextForceReloadProxyConfigParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextForceReloadProxyConfigParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextForceReloadProxyConfigParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextForceReloadProxyConfigResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextForceReloadProxyConfigResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextForceReloadProxyConfigResponseParams() {
            this(0);
        }

        public static NetworkContextForceReloadProxyConfigResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextForceReloadProxyConfigResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextForceReloadProxyConfigResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextForceReloadProxyConfigResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextForceReloadProxyConfigResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextForceReloadProxyConfigResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ForceReloadProxyConfigResponse mCallback;

        NetworkContextForceReloadProxyConfigResponseParamsForwardToCallback(NetworkContext.ForceReloadProxyConfigResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(FORCE_RELOAD_PROXY_CONFIG_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextForceReloadProxyConfigResponseParamsProxyToResponder implements NetworkContext.ForceReloadProxyConfigResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextForceReloadProxyConfigResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextForceReloadProxyConfigResponseParams _response = new NetworkContextForceReloadProxyConfigResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FORCE_RELOAD_PROXY_CONFIG_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextClearBadProxiesCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearBadProxiesCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearBadProxiesCacheParams() {
            this(0);
        }

        public static NetworkContextClearBadProxiesCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearBadProxiesCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearBadProxiesCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearBadProxiesCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearBadProxiesCacheParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextClearBadProxiesCacheResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextClearBadProxiesCacheResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextClearBadProxiesCacheResponseParams() {
            this(0);
        }

        public static NetworkContextClearBadProxiesCacheResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextClearBadProxiesCacheResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextClearBadProxiesCacheResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextClearBadProxiesCacheResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextClearBadProxiesCacheResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextClearBadProxiesCacheResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ClearBadProxiesCacheResponse mCallback;

        NetworkContextClearBadProxiesCacheResponseParamsForwardToCallback(NetworkContext.ClearBadProxiesCacheResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CLEAR_BAD_PROXIES_CACHE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextClearBadProxiesCacheResponseParamsProxyToResponder implements NetworkContext.ClearBadProxiesCacheResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextClearBadProxiesCacheResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextClearBadProxiesCacheResponseParams _response = new NetworkContextClearBadProxiesCacheResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    CLEAR_BAD_PROXIES_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextCreateWebSocketParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 48;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<WebSocket> request;
        public int processId;
        public int renderFrameId;
        public com.vccorp.url.mojom.Origin origin;
        public int options;
        public AuthenticationHandler authHandler;
        public TrustedHeaderClient headerClient;

        private NetworkContextCreateWebSocketParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateWebSocketParams() {
            this(0);
        }

        public static NetworkContextCreateWebSocketParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateWebSocketParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateWebSocketParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateWebSocketParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateWebSocketParams(elementsOrVersion);
                    {
                        
                    result.request = decoder0.readInterfaceRequest(8, false);
                    }
                    {
                        
                    result.processId = decoder0.readInt(12);
                    }
                    {
                        
                    result.renderFrameId = decoder0.readInt(16);
                    }
                    {
                        
                    result.options = decoder0.readInt(20);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.origin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    result.authHandler = decoder0.readServiceInterface(32, true, AuthenticationHandler.MANAGER);
                    }
                    {
                        
                    result.headerClient = decoder0.readServiceInterface(40, true, TrustedHeaderClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.request, 8, false);
            
            encoder0.encode(this.processId, 12);
            
            encoder0.encode(this.renderFrameId, 16);
            
            encoder0.encode(this.options, 20);
            
            encoder0.encode(this.origin, 24, false);
            
            encoder0.encode(this.authHandler, 32, true, AuthenticationHandler.MANAGER);
            
            encoder0.encode(this.headerClient, 40, true, TrustedHeaderClient.MANAGER);
        }
    }



    
    static final class NetworkContextCreateNetLogExporterParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<NetLogExporter> exporter;

        private NetworkContextCreateNetLogExporterParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateNetLogExporterParams() {
            this(0);
        }

        public static NetworkContextCreateNetLogExporterParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateNetLogExporterParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateNetLogExporterParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateNetLogExporterParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateNetLogExporterParams(elementsOrVersion);
                    {
                        
                    result.exporter = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.exporter, 8, false);
        }
    }



    
    static final class NetworkContextPreconnectSocketsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int numStreams;
        public com.vccorp.url.mojom.Url url;
        public int loadFlags;
        public boolean privacyModeEnabled;

        private NetworkContextPreconnectSocketsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextPreconnectSocketsParams() {
            this(0);
        }

        public static NetworkContextPreconnectSocketsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextPreconnectSocketsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextPreconnectSocketsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextPreconnectSocketsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextPreconnectSocketsParams(elementsOrVersion);
                    {
                        
                    result.numStreams = decoder0.readInt(8);
                    }
                    {
                        
                    result.loadFlags = decoder0.readInt(12);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.privacyModeEnabled = decoder0.readBoolean(24, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.numStreams, 8);
            
            encoder0.encode(this.loadFlags, 12);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.privacyModeEnabled, 24, 0);
        }
    }



    
    static final class NetworkContextCreateP2pSocketManagerParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public P2pTrustedSocketManagerClient client;
        public com.vccorp.mojo.bindings.InterfaceRequest<P2pTrustedSocketManager> trustedSocketManager;
        public com.vccorp.mojo.bindings.InterfaceRequest<P2pSocketManager> socketManager;

        private NetworkContextCreateP2pSocketManagerParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateP2pSocketManagerParams() {
            this(0);
        }

        public static NetworkContextCreateP2pSocketManagerParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateP2pSocketManagerParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateP2pSocketManagerParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateP2pSocketManagerParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateP2pSocketManagerParams(elementsOrVersion);
                    {
                        
                    result.client = decoder0.readServiceInterface(8, false, P2pTrustedSocketManagerClient.MANAGER);
                    }
                    {
                        
                    result.trustedSocketManager = decoder0.readInterfaceRequest(16, false);
                    }
                    {
                        
                    result.socketManager = decoder0.readInterfaceRequest(20, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.client, 8, false, P2pTrustedSocketManagerClient.MANAGER);
            
            encoder0.encode(this.trustedSocketManager, 16, false);
            
            encoder0.encode(this.socketManager, 20, false);
        }
    }



    
    static final class NetworkContextCreateMdnsResponderParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo.bindings.InterfaceRequest<MdnsResponder> responderRequest;

        private NetworkContextCreateMdnsResponderParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateMdnsResponderParams() {
            this(0);
        }

        public static NetworkContextCreateMdnsResponderParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateMdnsResponderParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateMdnsResponderParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateMdnsResponderParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateMdnsResponderParams(elementsOrVersion);
                    {
                        
                    result.responderRequest = decoder0.readInterfaceRequest(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.responderRequest, 8, false);
        }
    }



    
    static final class NetworkContextResolveHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public HostPortPair host;
        public ResolveHostParameters optionalParameters;
        public ResolveHostClient responseClient;

        private NetworkContextResolveHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextResolveHostParams() {
            this(0);
        }

        public static NetworkContextResolveHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextResolveHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextResolveHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextResolveHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextResolveHostParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.host = HostPortPair.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                    result.optionalParameters = ResolveHostParameters.decode(decoder1);
                    }
                    {
                        
                    result.responseClient = decoder0.readServiceInterface(24, false, ResolveHostClient.MANAGER);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
            
            encoder0.encode(this.optionalParameters, 16, true);
            
            encoder0.encode(this.responseClient, 24, false, ResolveHostClient.MANAGER);
        }
    }



    
    static final class NetworkContextCreateHostResolverParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public DnsConfigOverrides configOverrides;
        public com.vccorp.mojo.bindings.InterfaceRequest<HostResolver> hostResolver;

        private NetworkContextCreateHostResolverParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextCreateHostResolverParams() {
            this(0);
        }

        public static NetworkContextCreateHostResolverParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextCreateHostResolverParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextCreateHostResolverParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextCreateHostResolverParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextCreateHostResolverParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.configOverrides = DnsConfigOverrides.decode(decoder1);
                    }
                    {
                        
                    result.hostResolver = decoder0.readInterfaceRequest(16, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.configOverrides, 8, true);
            
            encoder0.encode(this.hostResolver, 16, false);
        }
    }



    
    static final class NetworkContextVerifyCertForSignedExchangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 40;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(40, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public X509Certificate certificate;
        public com.vccorp.url.mojom.Url url;
        public String ocspResponse;
        public String sctList;

        private NetworkContextVerifyCertForSignedExchangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextVerifyCertForSignedExchangeParams() {
            this(0);
        }

        public static NetworkContextVerifyCertForSignedExchangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextVerifyCertForSignedExchangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextVerifyCertForSignedExchangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextVerifyCertForSignedExchangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextVerifyCertForSignedExchangeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.certificate = X509Certificate.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    result.ocspResponse = decoder0.readString(24, false);
                    }
                    {
                        
                    result.sctList = decoder0.readString(32, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.certificate, 8, false);
            
            encoder0.encode(this.url, 16, false);
            
            encoder0.encode(this.ocspResponse, 24, false);
            
            encoder0.encode(this.sctList, 32, false);
        }
    }



    
    static final class NetworkContextVerifyCertForSignedExchangeResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int errorCode;
        public CertVerifyResult cvResult;
        public CtVerifyResult ctResult;

        private NetworkContextVerifyCertForSignedExchangeResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextVerifyCertForSignedExchangeResponseParams() {
            this(0);
        }

        public static NetworkContextVerifyCertForSignedExchangeResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextVerifyCertForSignedExchangeResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextVerifyCertForSignedExchangeResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextVerifyCertForSignedExchangeResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextVerifyCertForSignedExchangeResponseParams(elementsOrVersion);
                    {
                        
                    result.errorCode = decoder0.readInt(8);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.cvResult = CertVerifyResult.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.ctResult = CtVerifyResult.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.errorCode, 8);
            
            encoder0.encode(this.cvResult, 16, false);
            
            encoder0.encode(this.ctResult, 24, false);
        }
    }

    static class NetworkContextVerifyCertForSignedExchangeResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.VerifyCertForSignedExchangeResponse mCallback;

        NetworkContextVerifyCertForSignedExchangeResponseParamsForwardToCallback(NetworkContext.VerifyCertForSignedExchangeResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(VERIFY_CERT_FOR_SIGNED_EXCHANGE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextVerifyCertForSignedExchangeResponseParams response = NetworkContextVerifyCertForSignedExchangeResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.errorCode, response.cvResult, response.ctResult);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextVerifyCertForSignedExchangeResponseParamsProxyToResponder implements NetworkContext.VerifyCertForSignedExchangeResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextVerifyCertForSignedExchangeResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer errorCode, CertVerifyResult cvResult, CtVerifyResult ctResult) {
            NetworkContextVerifyCertForSignedExchangeResponseParams _response = new NetworkContextVerifyCertForSignedExchangeResponseParams();

            _response.errorCode = errorCode;

            _response.cvResult = cvResult;

            _response.ctResult = ctResult;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    VERIFY_CERT_FOR_SIGNED_EXCHANGE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextAddHstsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String host;
        public com.vccorp.mojo_base.mojom.Time expiry;
        public boolean includeSubdomains;

        private NetworkContextAddHstsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextAddHstsParams() {
            this(0);
        }

        public static NetworkContextAddHstsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextAddHstsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextAddHstsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextAddHstsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextAddHstsParams(elementsOrVersion);
                    {
                        
                    result.host = decoder0.readString(8, false);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.expiry = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                    }
                    {
                        
                    result.includeSubdomains = decoder0.readBoolean(24, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
            
            encoder0.encode(this.expiry, 16, false);
            
            encoder0.encode(this.includeSubdomains, 24, 0);
        }
    }



    
    static final class NetworkContextAddHstsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextAddHstsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextAddHstsResponseParams() {
            this(0);
        }

        public static NetworkContextAddHstsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextAddHstsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextAddHstsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextAddHstsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextAddHstsResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextAddHstsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.AddHstsResponse mCallback;

        NetworkContextAddHstsResponseParamsForwardToCallback(NetworkContext.AddHstsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ADD_HSTS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextAddHstsResponseParamsProxyToResponder implements NetworkContext.AddHstsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextAddHstsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextAddHstsResponseParams _response = new NetworkContextAddHstsResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_HSTS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextIsHstsActiveForHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String host;

        private NetworkContextIsHstsActiveForHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextIsHstsActiveForHostParams() {
            this(0);
        }

        public static NetworkContextIsHstsActiveForHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextIsHstsActiveForHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextIsHstsActiveForHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextIsHstsActiveForHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextIsHstsActiveForHostParams(elementsOrVersion);
                    {
                        
                    result.host = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
        }
    }



    
    static final class NetworkContextIsHstsActiveForHostResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean result;

        private NetworkContextIsHstsActiveForHostResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextIsHstsActiveForHostResponseParams() {
            this(0);
        }

        public static NetworkContextIsHstsActiveForHostResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextIsHstsActiveForHostResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextIsHstsActiveForHostResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextIsHstsActiveForHostResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextIsHstsActiveForHostResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, 0);
        }
    }

    static class NetworkContextIsHstsActiveForHostResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.IsHstsActiveForHostResponse mCallback;

        NetworkContextIsHstsActiveForHostResponseParamsForwardToCallback(NetworkContext.IsHstsActiveForHostResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(IS_HSTS_ACTIVE_FOR_HOST_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextIsHstsActiveForHostResponseParams response = NetworkContextIsHstsActiveForHostResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextIsHstsActiveForHostResponseParamsProxyToResponder implements NetworkContext.IsHstsActiveForHostResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextIsHstsActiveForHostResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean result) {
            NetworkContextIsHstsActiveForHostResponseParams _response = new NetworkContextIsHstsActiveForHostResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    IS_HSTS_ACTIVE_FOR_HOST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextGetHstsStateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String domain;

        private NetworkContextGetHstsStateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetHstsStateParams() {
            this(0);
        }

        public static NetworkContextGetHstsStateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetHstsStateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetHstsStateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetHstsStateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetHstsStateParams(elementsOrVersion);
                    {
                        
                    result.domain = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.domain, 8, false);
        }
    }



    
    static final class NetworkContextGetHstsStateResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.DictionaryValue state;

        private NetworkContextGetHstsStateResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextGetHstsStateResponseParams() {
            this(0);
        }

        public static NetworkContextGetHstsStateResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextGetHstsStateResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextGetHstsStateResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextGetHstsStateResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextGetHstsStateResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.state = com.vccorp.mojo_base.mojom.DictionaryValue.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.state, 8, false);
        }
    }

    static class NetworkContextGetHstsStateResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.GetHstsStateResponse mCallback;

        NetworkContextGetHstsStateResponseParamsForwardToCallback(NetworkContext.GetHstsStateResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_HSTS_STATE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextGetHstsStateResponseParams response = NetworkContextGetHstsStateResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.state);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextGetHstsStateResponseParamsProxyToResponder implements NetworkContext.GetHstsStateResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextGetHstsStateResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.DictionaryValue state) {
            NetworkContextGetHstsStateResponseParams _response = new NetworkContextGetHstsStateResponseParams();

            _response.state = state;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    GET_HSTS_STATE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextSetCorsOriginAccessListsForOriginParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Origin sourceOrigin;
        public CorsOriginPattern[] allowPatterns;
        public CorsOriginPattern[] blockPatterns;

        private NetworkContextSetCorsOriginAccessListsForOriginParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetCorsOriginAccessListsForOriginParams() {
            this(0);
        }

        public static NetworkContextSetCorsOriginAccessListsForOriginParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetCorsOriginAccessListsForOriginParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetCorsOriginAccessListsForOriginParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetCorsOriginAccessListsForOriginParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetCorsOriginAccessListsForOriginParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.sourceOrigin = com.vccorp.url.mojom.Origin.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.allowPatterns = new CorsOriginPattern[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.allowPatterns[i1] = CorsOriginPattern.decode(decoder2);
                        }
                    }
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    {
                        com.vccorp.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                        result.blockPatterns = new CorsOriginPattern[si1.elementsOrVersion];
                        for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                            
                            com.vccorp.mojo.bindings.Decoder decoder2 = decoder1.readPointer(com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                            result.blockPatterns[i1] = CorsOriginPattern.decode(decoder2);
                        }
                    }
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.sourceOrigin, 8, false);
            
            if (this.allowPatterns == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.allowPatterns.length, 16, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.allowPatterns.length; ++i0) {
                    
                    encoder1.encode(this.allowPatterns[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            
            if (this.blockPatterns == null) {
                encoder0.encodeNullPointer(24, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(this.blockPatterns.length, 24, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < this.blockPatterns.length; ++i0) {
                    
                    encoder1.encode(this.blockPatterns[i0], com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE + com.vccorp.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
        }
    }



    
    static final class NetworkContextSetCorsOriginAccessListsForOriginResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextSetCorsOriginAccessListsForOriginResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetCorsOriginAccessListsForOriginResponseParams() {
            this(0);
        }

        public static NetworkContextSetCorsOriginAccessListsForOriginResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetCorsOriginAccessListsForOriginResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetCorsOriginAccessListsForOriginResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetCorsOriginAccessListsForOriginResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetCorsOriginAccessListsForOriginResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextSetCorsOriginAccessListsForOriginResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.SetCorsOriginAccessListsForOriginResponse mCallback;

        NetworkContextSetCorsOriginAccessListsForOriginResponseParamsForwardToCallback(NetworkContext.SetCorsOriginAccessListsForOriginResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_CORS_ORIGIN_ACCESS_LISTS_FOR_ORIGIN_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextSetCorsOriginAccessListsForOriginResponseParamsProxyToResponder implements NetworkContext.SetCorsOriginAccessListsForOriginResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextSetCorsOriginAccessListsForOriginResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextSetCorsOriginAccessListsForOriginResponseParams _response = new NetworkContextSetCorsOriginAccessListsForOriginResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_CORS_ORIGIN_ACCESS_LISTS_FOR_ORIGIN_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextDeleteDynamicDataForHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public String host;

        private NetworkContextDeleteDynamicDataForHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextDeleteDynamicDataForHostParams() {
            this(0);
        }

        public static NetworkContextDeleteDynamicDataForHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextDeleteDynamicDataForHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextDeleteDynamicDataForHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextDeleteDynamicDataForHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextDeleteDynamicDataForHostParams(elementsOrVersion);
                    {
                        
                    result.host = decoder0.readString(8, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.host, 8, false);
        }
    }



    
    static final class NetworkContextDeleteDynamicDataForHostResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean result;

        private NetworkContextDeleteDynamicDataForHostResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextDeleteDynamicDataForHostResponseParams() {
            this(0);
        }

        public static NetworkContextDeleteDynamicDataForHostResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextDeleteDynamicDataForHostResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextDeleteDynamicDataForHostResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextDeleteDynamicDataForHostResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextDeleteDynamicDataForHostResponseParams(elementsOrVersion);
                    {
                        
                    result.result = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.result, 8, 0);
        }
    }

    static class NetworkContextDeleteDynamicDataForHostResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.DeleteDynamicDataForHostResponse mCallback;

        NetworkContextDeleteDynamicDataForHostResponseParamsForwardToCallback(NetworkContext.DeleteDynamicDataForHostResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(DELETE_DYNAMIC_DATA_FOR_HOST_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextDeleteDynamicDataForHostResponseParams response = NetworkContextDeleteDynamicDataForHostResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.result);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextDeleteDynamicDataForHostResponseParamsProxyToResponder implements NetworkContext.DeleteDynamicDataForHostResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextDeleteDynamicDataForHostResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Boolean result) {
            NetworkContextDeleteDynamicDataForHostResponseParams _response = new NetworkContextDeleteDynamicDataForHostResponseParams();

            _response.result = result;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    DELETE_DYNAMIC_DATA_FOR_HOST_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextSaveHttpAuthCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextSaveHttpAuthCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSaveHttpAuthCacheParams() {
            this(0);
        }

        public static NetworkContextSaveHttpAuthCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSaveHttpAuthCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSaveHttpAuthCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSaveHttpAuthCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSaveHttpAuthCacheParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextSaveHttpAuthCacheResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.UnguessableToken cacheKey;

        private NetworkContextSaveHttpAuthCacheResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSaveHttpAuthCacheResponseParams() {
            this(0);
        }

        public static NetworkContextSaveHttpAuthCacheResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSaveHttpAuthCacheResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSaveHttpAuthCacheResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSaveHttpAuthCacheResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSaveHttpAuthCacheResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.cacheKey = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cacheKey, 8, false);
        }
    }

    static class NetworkContextSaveHttpAuthCacheResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.SaveHttpAuthCacheResponse mCallback;

        NetworkContextSaveHttpAuthCacheResponseParamsForwardToCallback(NetworkContext.SaveHttpAuthCacheResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SAVE_HTTP_AUTH_CACHE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextSaveHttpAuthCacheResponseParams response = NetworkContextSaveHttpAuthCacheResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.cacheKey);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextSaveHttpAuthCacheResponseParamsProxyToResponder implements NetworkContext.SaveHttpAuthCacheResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextSaveHttpAuthCacheResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(com.vccorp.mojo_base.mojom.UnguessableToken cacheKey) {
            NetworkContextSaveHttpAuthCacheResponseParams _response = new NetworkContextSaveHttpAuthCacheResponseParams();

            _response.cacheKey = cacheKey;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SAVE_HTTP_AUTH_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextLoadHttpAuthCacheParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.UnguessableToken cacheKey;

        private NetworkContextLoadHttpAuthCacheParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextLoadHttpAuthCacheParams() {
            this(0);
        }

        public static NetworkContextLoadHttpAuthCacheParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextLoadHttpAuthCacheParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextLoadHttpAuthCacheParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextLoadHttpAuthCacheParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextLoadHttpAuthCacheParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.cacheKey = com.vccorp.mojo_base.mojom.UnguessableToken.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.cacheKey, 8, false);
        }
    }



    
    static final class NetworkContextLoadHttpAuthCacheResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextLoadHttpAuthCacheResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextLoadHttpAuthCacheResponseParams() {
            this(0);
        }

        public static NetworkContextLoadHttpAuthCacheResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextLoadHttpAuthCacheResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextLoadHttpAuthCacheResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextLoadHttpAuthCacheResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextLoadHttpAuthCacheResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextLoadHttpAuthCacheResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.LoadHttpAuthCacheResponse mCallback;

        NetworkContextLoadHttpAuthCacheResponseParamsForwardToCallback(NetworkContext.LoadHttpAuthCacheResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(LOAD_HTTP_AUTH_CACHE_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextLoadHttpAuthCacheResponseParamsProxyToResponder implements NetworkContext.LoadHttpAuthCacheResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextLoadHttpAuthCacheResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextLoadHttpAuthCacheResponseParams _response = new NetworkContextLoadHttpAuthCacheResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    LOAD_HTTP_AUTH_CACHE_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextLookupBasicAuthCredentialsParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url url;

        private NetworkContextLookupBasicAuthCredentialsParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextLookupBasicAuthCredentialsParams() {
            this(0);
        }

        public static NetworkContextLookupBasicAuthCredentialsParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextLookupBasicAuthCredentialsParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextLookupBasicAuthCredentialsParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextLookupBasicAuthCredentialsParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextLookupBasicAuthCredentialsParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.url = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.url, 8, false);
        }
    }



    
    static final class NetworkContextLookupBasicAuthCredentialsResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AuthCredentials credentials;

        private NetworkContextLookupBasicAuthCredentialsResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextLookupBasicAuthCredentialsResponseParams() {
            this(0);
        }

        public static NetworkContextLookupBasicAuthCredentialsResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextLookupBasicAuthCredentialsResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextLookupBasicAuthCredentialsResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextLookupBasicAuthCredentialsResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextLookupBasicAuthCredentialsResponseParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, true);
                    result.credentials = AuthCredentials.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.credentials, 8, true);
        }
    }

    static class NetworkContextLookupBasicAuthCredentialsResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.LookupBasicAuthCredentialsResponse mCallback;

        NetworkContextLookupBasicAuthCredentialsResponseParamsForwardToCallback(NetworkContext.LookupBasicAuthCredentialsResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(LOOKUP_BASIC_AUTH_CREDENTIALS_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextLookupBasicAuthCredentialsResponseParams response = NetworkContextLookupBasicAuthCredentialsResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.credentials);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextLookupBasicAuthCredentialsResponseParamsProxyToResponder implements NetworkContext.LookupBasicAuthCredentialsResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextLookupBasicAuthCredentialsResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(AuthCredentials credentials) {
            NetworkContextLookupBasicAuthCredentialsResponseParams _response = new NetworkContextLookupBasicAuthCredentialsResponseParams();

            _response.credentials = credentials;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    LOOKUP_BASIC_AUTH_CREDENTIALS_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextEnableStaticKeyPinningForTestingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextEnableStaticKeyPinningForTestingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextEnableStaticKeyPinningForTestingParams() {
            this(0);
        }

        public static NetworkContextEnableStaticKeyPinningForTestingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextEnableStaticKeyPinningForTestingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextEnableStaticKeyPinningForTestingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextEnableStaticKeyPinningForTestingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextEnableStaticKeyPinningForTestingParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextEnableStaticKeyPinningForTestingResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextEnableStaticKeyPinningForTestingResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextEnableStaticKeyPinningForTestingResponseParams() {
            this(0);
        }

        public static NetworkContextEnableStaticKeyPinningForTestingResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextEnableStaticKeyPinningForTestingResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextEnableStaticKeyPinningForTestingResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextEnableStaticKeyPinningForTestingResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextEnableStaticKeyPinningForTestingResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextEnableStaticKeyPinningForTestingResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.EnableStaticKeyPinningForTestingResponse mCallback;

        NetworkContextEnableStaticKeyPinningForTestingResponseParamsForwardToCallback(NetworkContext.EnableStaticKeyPinningForTestingResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ENABLE_STATIC_KEY_PINNING_FOR_TESTING_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextEnableStaticKeyPinningForTestingResponseParamsProxyToResponder implements NetworkContext.EnableStaticKeyPinningForTestingResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextEnableStaticKeyPinningForTestingResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextEnableStaticKeyPinningForTestingResponseParams _response = new NetworkContextEnableStaticKeyPinningForTestingResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ENABLE_STATIC_KEY_PINNING_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextSetFailingHttpTransactionForTestingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int rv;

        private NetworkContextSetFailingHttpTransactionForTestingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetFailingHttpTransactionForTestingParams() {
            this(0);
        }

        public static NetworkContextSetFailingHttpTransactionForTestingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetFailingHttpTransactionForTestingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetFailingHttpTransactionForTestingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetFailingHttpTransactionForTestingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetFailingHttpTransactionForTestingParams(elementsOrVersion);
                    {
                        
                    result.rv = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.rv, 8);
        }
    }



    
    static final class NetworkContextSetFailingHttpTransactionForTestingResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextSetFailingHttpTransactionForTestingResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextSetFailingHttpTransactionForTestingResponseParams() {
            this(0);
        }

        public static NetworkContextSetFailingHttpTransactionForTestingResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextSetFailingHttpTransactionForTestingResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextSetFailingHttpTransactionForTestingResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextSetFailingHttpTransactionForTestingResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextSetFailingHttpTransactionForTestingResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextSetFailingHttpTransactionForTestingResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.SetFailingHttpTransactionForTestingResponse mCallback;

        NetworkContextSetFailingHttpTransactionForTestingResponseParamsForwardToCallback(NetworkContext.SetFailingHttpTransactionForTestingResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(SET_FAILING_HTTP_TRANSACTION_FOR_TESTING_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextSetFailingHttpTransactionForTestingResponseParamsProxyToResponder implements NetworkContext.SetFailingHttpTransactionForTestingResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextSetFailingHttpTransactionForTestingResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextSetFailingHttpTransactionForTestingResponseParams _response = new NetworkContextSetFailingHttpTransactionForTestingResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    SET_FAILING_HTTP_TRANSACTION_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextVerifyCertificateForTestingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public X509Certificate certificate;
        public String hostname;
        public String ocspResponse;

        private NetworkContextVerifyCertificateForTestingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextVerifyCertificateForTestingParams() {
            this(0);
        }

        public static NetworkContextVerifyCertificateForTestingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextVerifyCertificateForTestingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextVerifyCertificateForTestingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextVerifyCertificateForTestingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextVerifyCertificateForTestingParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.certificate = X509Certificate.decode(decoder1);
                    }
                    {
                        
                    result.hostname = decoder0.readString(16, false);
                    }
                    {
                        
                    result.ocspResponse = decoder0.readString(24, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.certificate, 8, false);
            
            encoder0.encode(this.hostname, 16, false);
            
            encoder0.encode(this.ocspResponse, 24, false);
        }
    }



    
    static final class NetworkContextVerifyCertificateForTestingResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int errorCode;

        private NetworkContextVerifyCertificateForTestingResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextVerifyCertificateForTestingResponseParams() {
            this(0);
        }

        public static NetworkContextVerifyCertificateForTestingResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextVerifyCertificateForTestingResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextVerifyCertificateForTestingResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextVerifyCertificateForTestingResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextVerifyCertificateForTestingResponseParams(elementsOrVersion);
                    {
                        
                    result.errorCode = decoder0.readInt(8);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.errorCode, 8);
        }
    }

    static class NetworkContextVerifyCertificateForTestingResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.VerifyCertificateForTestingResponse mCallback;

        NetworkContextVerifyCertificateForTestingResponseParamsForwardToCallback(NetworkContext.VerifyCertificateForTestingResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(VERIFY_CERTIFICATE_FOR_TESTING_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                NetworkContextVerifyCertificateForTestingResponseParams response = NetworkContextVerifyCertificateForTestingResponseParams.deserialize(messageWithHeader.getPayload());

                mCallback.call(response.errorCode);
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextVerifyCertificateForTestingResponseParamsProxyToResponder implements NetworkContext.VerifyCertificateForTestingResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextVerifyCertificateForTestingResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer errorCode) {
            NetworkContextVerifyCertificateForTestingResponseParams _response = new NetworkContextVerifyCertificateForTestingResponseParams();

            _response.errorCode = errorCode;

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    VERIFY_CERTIFICATE_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextAddDomainReliabilityContextForTestingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 24;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.url.mojom.Url origin;
        public com.vccorp.url.mojom.Url uploadUrl;

        private NetworkContextAddDomainReliabilityContextForTestingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextAddDomainReliabilityContextForTestingParams() {
            this(0);
        }

        public static NetworkContextAddDomainReliabilityContextForTestingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextAddDomainReliabilityContextForTestingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextAddDomainReliabilityContextForTestingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextAddDomainReliabilityContextForTestingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextAddDomainReliabilityContextForTestingParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.origin = com.vccorp.url.mojom.Url.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.uploadUrl = com.vccorp.url.mojom.Url.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.origin, 8, false);
            
            encoder0.encode(this.uploadUrl, 16, false);
        }
    }



    
    static final class NetworkContextAddDomainReliabilityContextForTestingResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextAddDomainReliabilityContextForTestingResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextAddDomainReliabilityContextForTestingResponseParams() {
            this(0);
        }

        public static NetworkContextAddDomainReliabilityContextForTestingResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextAddDomainReliabilityContextForTestingResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextAddDomainReliabilityContextForTestingResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextAddDomainReliabilityContextForTestingResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextAddDomainReliabilityContextForTestingResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextAddDomainReliabilityContextForTestingResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.AddDomainReliabilityContextForTestingResponse mCallback;

        NetworkContextAddDomainReliabilityContextForTestingResponseParamsForwardToCallback(NetworkContext.AddDomainReliabilityContextForTestingResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(ADD_DOMAIN_RELIABILITY_CONTEXT_FOR_TESTING_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextAddDomainReliabilityContextForTestingResponseParamsProxyToResponder implements NetworkContext.AddDomainReliabilityContextForTestingResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextAddDomainReliabilityContextForTestingResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextAddDomainReliabilityContextForTestingResponseParams _response = new NetworkContextAddDomainReliabilityContextForTestingResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    ADD_DOMAIN_RELIABILITY_CONTEXT_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



    
    static final class NetworkContextForceDomainReliabilityUploadsForTestingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextForceDomainReliabilityUploadsForTestingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextForceDomainReliabilityUploadsForTestingParams() {
            this(0);
        }

        public static NetworkContextForceDomainReliabilityUploadsForTestingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextForceDomainReliabilityUploadsForTestingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextForceDomainReliabilityUploadsForTestingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextForceDomainReliabilityUploadsForTestingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextForceDomainReliabilityUploadsForTestingParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class NetworkContextForceDomainReliabilityUploadsForTestingResponseParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private NetworkContextForceDomainReliabilityUploadsForTestingResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NetworkContextForceDomainReliabilityUploadsForTestingResponseParams() {
            this(0);
        }

        public static NetworkContextForceDomainReliabilityUploadsForTestingResponseParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NetworkContextForceDomainReliabilityUploadsForTestingResponseParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NetworkContextForceDomainReliabilityUploadsForTestingResponseParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NetworkContextForceDomainReliabilityUploadsForTestingResponseParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NetworkContextForceDomainReliabilityUploadsForTestingResponseParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }

    static class NetworkContextForceDomainReliabilityUploadsForTestingResponseParamsForwardToCallback extends com.vccorp.mojo.bindings.SideEffectFreeCloseable
            implements com.vccorp.mojo.bindings.MessageReceiver {
        private final NetworkContext.ForceDomainReliabilityUploadsForTestingResponse mCallback;

        NetworkContextForceDomainReliabilityUploadsForTestingResponseParamsForwardToCallback(NetworkContext.ForceDomainReliabilityUploadsForTestingResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(FORCE_DOMAIN_RELIABILITY_UPLOADS_FOR_TESTING_ORDINAL,
                                           com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }

                mCallback.call();
                return true;
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class NetworkContextForceDomainReliabilityUploadsForTestingResponseParamsProxyToResponder implements NetworkContext.ForceDomainReliabilityUploadsForTestingResponse {

        private final com.vccorp.mojo.system.Core mCore;
        private final com.vccorp.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        NetworkContextForceDomainReliabilityUploadsForTestingResponseParamsProxyToResponder(
                com.vccorp.mojo.system.Core core,
                com.vccorp.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call() {
            NetworkContextForceDomainReliabilityUploadsForTestingResponseParams _response = new NetworkContextForceDomainReliabilityUploadsForTestingResponseParams();

            com.vccorp.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new com.vccorp.mojo.bindings.MessageHeader(
                                    FORCE_DOMAIN_RELIABILITY_UPLOADS_FOR_TESTING_ORDINAL,
                                    com.vccorp.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }



}
