
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/network/public/mojom/cookie_manager.mojom
//

package com.vccorp.network.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class CookieOptions extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(24, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public boolean excludeHttponly;
    public int sameSiteCookieContext;
    public boolean updateAccessTime;
    public com.vccorp.mojo_base.mojom.Time serverTime;
    public boolean returnExcludedCookies;

    private CookieOptions(int version) {
        super(STRUCT_SIZE, version);
        this.excludeHttponly = (boolean) true;
        this.sameSiteCookieContext = (int) CookieSameSiteContext.CROSS_SITE;
        this.updateAccessTime = (boolean) true;
        this.returnExcludedCookies = (boolean) false;
    }

    public CookieOptions() {
        this(0);
    }

    public static CookieOptions deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static CookieOptions deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static CookieOptions decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        CookieOptions result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new CookieOptions(elementsOrVersion);
                {
                    
                result.excludeHttponly = decoder0.readBoolean(8, 0);
                }
                {
                    
                result.updateAccessTime = decoder0.readBoolean(8, 1);
                }
                {
                    
                result.returnExcludedCookies = decoder0.readBoolean(8, 2);
                }
                {
                    
                result.sameSiteCookieContext = decoder0.readInt(12);
                    CookieSameSiteContext.validate(result.sameSiteCookieContext);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
                result.serverTime = com.vccorp.mojo_base.mojom.Time.decode(decoder1);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.excludeHttponly, 8, 0);
        
        encoder0.encode(this.updateAccessTime, 8, 1);
        
        encoder0.encode(this.returnExcludedCookies, 8, 2);
        
        encoder0.encode(this.sameSiteCookieContext, 12);
        
        encoder0.encode(this.serverTime, 16, true);
    }
}