
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/video_encode_accelerator.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class VideoEncodeAcceleratorConfig extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 48;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(48, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public static final class ContentType {
        private static final boolean IS_EXTENSIBLE = false;

        public static final int CAMERA = 0;
        public static final int DISPLAY = 1; // CAMERA + 1

        public static boolean isKnownValue(int value) {
            return value >= 0 && value <= 1;
        }

        public static void validate(int value) {
            if (IS_EXTENSIBLE || isKnownValue(value)) return;
            throw new DeserializationException("Invalid enum value.");
        }

        private ContentType() {}
    }
    public int inputFormat;
    public com.vccorp.gfx.mojom.Size inputVisibleSize;
    public int outputProfile;
    public int initialBitrate;
    public int initialFramerate;
    public boolean hasInitialFramerate;
    public int gopLength;
    public boolean hasGopLength;
    public byte h264OutputLevel;
    public boolean hasH264OutputLevel;
    public int contentType;

    private VideoEncodeAcceleratorConfig(int version) {
        super(STRUCT_SIZE, version);
    }

    public VideoEncodeAcceleratorConfig() {
        this(0);
    }

    public static VideoEncodeAcceleratorConfig deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static VideoEncodeAcceleratorConfig deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static VideoEncodeAcceleratorConfig decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        VideoEncodeAcceleratorConfig result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new VideoEncodeAcceleratorConfig(elementsOrVersion);
                {
                    
                result.inputFormat = decoder0.readInt(8);
                    VideoPixelFormat.validate(result.inputFormat);
                }
                {
                    
                result.outputProfile = decoder0.readInt(12);
                    VideoCodecProfile.validate(result.outputProfile);
                }
                {
                    
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                result.inputVisibleSize = com.vccorp.gfx.mojom.Size.decode(decoder1);
                }
                {
                    
                result.initialBitrate = decoder0.readInt(24);
                }
                {
                    
                result.initialFramerate = decoder0.readInt(28);
                }
                {
                    
                result.hasInitialFramerate = decoder0.readBoolean(32, 0);
                }
                {
                    
                result.hasGopLength = decoder0.readBoolean(32, 1);
                }
                {
                    
                result.hasH264OutputLevel = decoder0.readBoolean(32, 2);
                }
                {
                    
                result.h264OutputLevel = decoder0.readByte(33);
                }
                {
                    
                result.gopLength = decoder0.readInt(36);
                }
                {
                    
                result.contentType = decoder0.readInt(40);
                    VideoEncodeAcceleratorConfig.ContentType.validate(result.contentType);
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.inputFormat, 8);
        
        encoder0.encode(this.outputProfile, 12);
        
        encoder0.encode(this.inputVisibleSize, 16, false);
        
        encoder0.encode(this.initialBitrate, 24);
        
        encoder0.encode(this.initialFramerate, 28);
        
        encoder0.encode(this.hasInitialFramerate, 32, 0);
        
        encoder0.encode(this.hasGopLength, 32, 1);
        
        encoder0.encode(this.hasH264OutputLevel, 32, 2);
        
        encoder0.encode(this.h264OutputLevel, 33);
        
        encoder0.encode(this.gopLength, 36);
        
        encoder0.encode(this.contentType, 40);
    }
}