
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/capture/mojom/video_capture_types.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class VideoCapturePixelFormat {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int UNKNOWN = 0;
    public static final int I420 = 1; // UNKNOWN + 1
    public static final int YV12 = 2; // I420 + 1
    public static final int I422 = 3; // YV12 + 1
    public static final int I420A = 4; // I422 + 1
    public static final int I444 = 5; // I420A + 1
    public static final int NV12 = 6; // I444 + 1
    public static final int NV21 = 7; // NV12 + 1
    public static final int UYVY = 8; // NV21 + 1
    public static final int YUY2 = 9; // UYVY + 1
    public static final int ARGB = 10; // YUY2 + 1
    public static final int XRGB = 11; // ARGB + 1
    public static final int RGB24 = 12; // XRGB + 1
    public static final int RGB32 = 13; // RGB24 + 1
    public static final int MJPEG = 14; // RGB32 + 1
    public static final int MT21 = 15; // MJPEG + 1
    public static final int YUV420P9 = 16; // MT21 + 1
    public static final int YUV420P10 = 17; // YUV420P9 + 1
    public static final int YUV422P9 = 18; // YUV420P10 + 1
    public static final int YUV422P10 = 19; // YUV422P9 + 1
    public static final int YUV444P9 = 20; // YUV422P10 + 1
    public static final int YUV444P10 = 21; // YUV444P9 + 1
    public static final int YUV420P12 = 22; // YUV444P10 + 1
    public static final int YUV422P12 = 23; // YUV420P12 + 1
    public static final int YUV444P12 = 24; // YUV422P12 + 1
    public static final int Y16 = 25; // YUV444P12 + 1
    public static final int ABGR = 26; // Y16 + 1
    public static final int XBGR = 27; // ABGR + 1
    public static final int P016LE = 28; // XBGR + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 28;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private VideoCapturePixelFormat() {}
}