
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/renderer.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class RendererClient_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<RendererClient, RendererClient.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<RendererClient, RendererClient.Proxy>() {

        @Override
        public String getName() {
            return "media.mojom.RendererClient";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, RendererClient impl) {
            return new Stub(core, impl);
        }

        @Override
        public RendererClient[] buildArray(int size) {
          return new RendererClient[size];
        }
    };


    private static final int ON_TIME_UPDATE_ORDINAL = 0;

    private static final int ON_BUFFERING_STATE_CHANGE_ORDINAL = 1;

    private static final int ON_ENDED_ORDINAL = 2;

    private static final int ON_ERROR_ORDINAL = 3;

    private static final int ON_AUDIO_CONFIG_CHANGE_ORDINAL = 4;

    private static final int ON_VIDEO_CONFIG_CHANGE_ORDINAL = 5;

    private static final int ON_VIDEO_NATURAL_SIZE_CHANGE_ORDINAL = 6;

    private static final int ON_VIDEO_OPACITY_CHANGE_ORDINAL = 7;

    private static final int ON_STATISTICS_UPDATE_ORDINAL = 8;

    private static final int ON_WAITING_ORDINAL = 9;

    private static final int ON_REMOTE_PLAY_STATE_CHANGE_ORDINAL = 10;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements RendererClient.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void onTimeUpdate(
com.vccorp.mojo_base.mojom.TimeDelta time, com.vccorp.mojo_base.mojom.TimeDelta maxTime, com.vccorp.mojo_base.mojom.TimeTicks captureTime) {

            RendererClientOnTimeUpdateParams _message = new RendererClientOnTimeUpdateParams();

            _message.time = time;

            _message.maxTime = maxTime;

            _message.captureTime = captureTime;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_TIME_UPDATE_ORDINAL)));

        }


        @Override
        public void onBufferingStateChange(
int state) {

            RendererClientOnBufferingStateChangeParams _message = new RendererClientOnBufferingStateChangeParams();

            _message.state = state;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_BUFFERING_STATE_CHANGE_ORDINAL)));

        }


        @Override
        public void onEnded(
) {

            RendererClientOnEndedParams _message = new RendererClientOnEndedParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ENDED_ORDINAL)));

        }


        @Override
        public void onError(
) {

            RendererClientOnErrorParams _message = new RendererClientOnErrorParams();


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_ERROR_ORDINAL)));

        }


        @Override
        public void onAudioConfigChange(
AudioDecoderConfig config) {

            RendererClientOnAudioConfigChangeParams _message = new RendererClientOnAudioConfigChangeParams();

            _message.config = config;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_AUDIO_CONFIG_CHANGE_ORDINAL)));

        }


        @Override
        public void onVideoConfigChange(
VideoDecoderConfig config) {

            RendererClientOnVideoConfigChangeParams _message = new RendererClientOnVideoConfigChangeParams();

            _message.config = config;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_VIDEO_CONFIG_CHANGE_ORDINAL)));

        }


        @Override
        public void onVideoNaturalSizeChange(
com.vccorp.gfx.mojom.Size size) {

            RendererClientOnVideoNaturalSizeChangeParams _message = new RendererClientOnVideoNaturalSizeChangeParams();

            _message.size = size;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_VIDEO_NATURAL_SIZE_CHANGE_ORDINAL)));

        }


        @Override
        public void onVideoOpacityChange(
boolean opaque) {

            RendererClientOnVideoOpacityChangeParams _message = new RendererClientOnVideoOpacityChangeParams();

            _message.opaque = opaque;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_VIDEO_OPACITY_CHANGE_ORDINAL)));

        }


        @Override
        public void onStatisticsUpdate(
PipelineStatistics stats) {

            RendererClientOnStatisticsUpdateParams _message = new RendererClientOnStatisticsUpdateParams();

            _message.stats = stats;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_STATISTICS_UPDATE_ORDINAL)));

        }


        @Override
        public void onWaiting(
int reason) {

            RendererClientOnWaitingParams _message = new RendererClientOnWaitingParams();

            _message.reason = reason;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_WAITING_ORDINAL)));

        }


        @Override
        public void onRemotePlayStateChange(
int state) {

            RendererClientOnRemotePlayStateChangeParams _message = new RendererClientOnRemotePlayStateChangeParams();

            _message.state = state;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(ON_REMOTE_PLAY_STATE_CHANGE_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<RendererClient> {

        Stub(com.vccorp.mojo.system.Core core, RendererClient impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                RendererClient_Internal.MANAGER, messageWithHeader);





                    case ON_TIME_UPDATE_ORDINAL: {

                        RendererClientOnTimeUpdateParams data =
                                RendererClientOnTimeUpdateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onTimeUpdate(data.time, data.maxTime, data.captureTime);
                        return true;
                    }





                    case ON_BUFFERING_STATE_CHANGE_ORDINAL: {

                        RendererClientOnBufferingStateChangeParams data =
                                RendererClientOnBufferingStateChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onBufferingStateChange(data.state);
                        return true;
                    }





                    case ON_ENDED_ORDINAL: {

                        RendererClientOnEndedParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onEnded();
                        return true;
                    }





                    case ON_ERROR_ORDINAL: {

                        RendererClientOnErrorParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onError();
                        return true;
                    }





                    case ON_AUDIO_CONFIG_CHANGE_ORDINAL: {

                        RendererClientOnAudioConfigChangeParams data =
                                RendererClientOnAudioConfigChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onAudioConfigChange(data.config);
                        return true;
                    }





                    case ON_VIDEO_CONFIG_CHANGE_ORDINAL: {

                        RendererClientOnVideoConfigChangeParams data =
                                RendererClientOnVideoConfigChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onVideoConfigChange(data.config);
                        return true;
                    }





                    case ON_VIDEO_NATURAL_SIZE_CHANGE_ORDINAL: {

                        RendererClientOnVideoNaturalSizeChangeParams data =
                                RendererClientOnVideoNaturalSizeChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onVideoNaturalSizeChange(data.size);
                        return true;
                    }





                    case ON_VIDEO_OPACITY_CHANGE_ORDINAL: {

                        RendererClientOnVideoOpacityChangeParams data =
                                RendererClientOnVideoOpacityChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onVideoOpacityChange(data.opaque);
                        return true;
                    }





                    case ON_STATISTICS_UPDATE_ORDINAL: {

                        RendererClientOnStatisticsUpdateParams data =
                                RendererClientOnStatisticsUpdateParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onStatisticsUpdate(data.stats);
                        return true;
                    }





                    case ON_WAITING_ORDINAL: {

                        RendererClientOnWaitingParams data =
                                RendererClientOnWaitingParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onWaiting(data.reason);
                        return true;
                    }





                    case ON_REMOTE_PLAY_STATE_CHANGE_ORDINAL: {

                        RendererClientOnRemotePlayStateChangeParams data =
                                RendererClientOnRemotePlayStateChangeParams.deserialize(messageWithHeader.getPayload());

                        getImpl().onRemotePlayStateChange(data.state);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), RendererClient_Internal.MANAGER, messageWithHeader, receiver);
























                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class RendererClientOnTimeUpdateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 32;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(32, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.mojo_base.mojom.TimeDelta time;
        public com.vccorp.mojo_base.mojom.TimeDelta maxTime;
        public com.vccorp.mojo_base.mojom.TimeTicks captureTime;

        private RendererClientOnTimeUpdateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnTimeUpdateParams() {
            this(0);
        }

        public static RendererClientOnTimeUpdateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnTimeUpdateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnTimeUpdateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnTimeUpdateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnTimeUpdateParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.time = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                    result.maxTime = com.vccorp.mojo_base.mojom.TimeDelta.decode(decoder1);
                    }
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
                    result.captureTime = com.vccorp.mojo_base.mojom.TimeTicks.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.time, 8, false);
            
            encoder0.encode(this.maxTime, 16, false);
            
            encoder0.encode(this.captureTime, 24, false);
        }
    }



    
    static final class RendererClientOnBufferingStateChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int state;

        private RendererClientOnBufferingStateChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnBufferingStateChangeParams() {
            this(0);
        }

        public static RendererClientOnBufferingStateChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnBufferingStateChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnBufferingStateChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnBufferingStateChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnBufferingStateChangeParams(elementsOrVersion);
                    {
                        
                    result.state = decoder0.readInt(8);
                        BufferingState.validate(result.state);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.state, 8);
        }
    }



    
    static final class RendererClientOnEndedParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private RendererClientOnEndedParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnEndedParams() {
            this(0);
        }

        public static RendererClientOnEndedParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnEndedParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnEndedParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnEndedParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnEndedParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class RendererClientOnErrorParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 8;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(8, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

        private RendererClientOnErrorParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnErrorParams() {
            this(0);
        }

        public static RendererClientOnErrorParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnErrorParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnErrorParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnErrorParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnErrorParams(elementsOrVersion);

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    }



    
    static final class RendererClientOnAudioConfigChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public AudioDecoderConfig config;

        private RendererClientOnAudioConfigChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnAudioConfigChangeParams() {
            this(0);
        }

        public static RendererClientOnAudioConfigChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnAudioConfigChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnAudioConfigChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnAudioConfigChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnAudioConfigChangeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.config = AudioDecoderConfig.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.config, 8, false);
        }
    }



    
    static final class RendererClientOnVideoConfigChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public VideoDecoderConfig config;

        private RendererClientOnVideoConfigChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnVideoConfigChangeParams() {
            this(0);
        }

        public static RendererClientOnVideoConfigChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnVideoConfigChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnVideoConfigChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnVideoConfigChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnVideoConfigChangeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.config = VideoDecoderConfig.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.config, 8, false);
        }
    }



    
    static final class RendererClientOnVideoNaturalSizeChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public com.vccorp.gfx.mojom.Size size;

        private RendererClientOnVideoNaturalSizeChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnVideoNaturalSizeChangeParams() {
            this(0);
        }

        public static RendererClientOnVideoNaturalSizeChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnVideoNaturalSizeChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnVideoNaturalSizeChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnVideoNaturalSizeChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnVideoNaturalSizeChangeParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.size = com.vccorp.gfx.mojom.Size.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.size, 8, false);
        }
    }



    
    static final class RendererClientOnVideoOpacityChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public boolean opaque;

        private RendererClientOnVideoOpacityChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnVideoOpacityChangeParams() {
            this(0);
        }

        public static RendererClientOnVideoOpacityChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnVideoOpacityChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnVideoOpacityChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnVideoOpacityChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnVideoOpacityChangeParams(elementsOrVersion);
                    {
                        
                    result.opaque = decoder0.readBoolean(8, 0);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.opaque, 8, 0);
        }
    }



    
    static final class RendererClientOnStatisticsUpdateParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public PipelineStatistics stats;

        private RendererClientOnStatisticsUpdateParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnStatisticsUpdateParams() {
            this(0);
        }

        public static RendererClientOnStatisticsUpdateParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnStatisticsUpdateParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnStatisticsUpdateParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnStatisticsUpdateParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnStatisticsUpdateParams(elementsOrVersion);
                    {
                        
                    com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                    result.stats = PipelineStatistics.decode(decoder1);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.stats, 8, false);
        }
    }



    
    static final class RendererClientOnWaitingParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int reason;

        private RendererClientOnWaitingParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnWaitingParams() {
            this(0);
        }

        public static RendererClientOnWaitingParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnWaitingParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnWaitingParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnWaitingParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnWaitingParams(elementsOrVersion);
                    {
                        
                    result.reason = decoder0.readInt(8);
                        WaitingReason.validate(result.reason);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.reason, 8);
        }
    }



    
    static final class RendererClientOnRemotePlayStateChangeParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int state;

        private RendererClientOnRemotePlayStateChangeParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public RendererClientOnRemotePlayStateChangeParams() {
            this(0);
        }

        public static RendererClientOnRemotePlayStateChangeParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static RendererClientOnRemotePlayStateChangeParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static RendererClientOnRemotePlayStateChangeParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            RendererClientOnRemotePlayStateChangeParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new RendererClientOnRemotePlayStateChangeParams(elementsOrVersion);
                    {
                        
                    result.state = decoder0.readInt(8);
                        MediaStatusState.validate(result.state);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.state, 8);
        }
    }



}
