
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/key_system_support.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class KeySystemCapability extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(56, 0)};
    private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    public int[] videoCodecs;
    public boolean supportsVp9Profile2;
    public int[] encryptionSchemes;
    public int[] hwSecureVideoCodecs;
    public int[] hwSecureEncryptionSchemes;
    public int[] sessionTypes;

    private KeySystemCapability(int version) {
        super(STRUCT_SIZE, version);
    }

    public KeySystemCapability() {
        this(0);
    }

    public static KeySystemCapability deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message));
    }

    /**
     * Similar to the method above, but deserializes from a |ByteBuffer| instance.
     *
     * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
     */
    public static KeySystemCapability deserialize(java.nio.ByteBuffer data) {
        return deserialize(new com.vccorp.mojo.bindings.Message(
                data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
    }

    @SuppressWarnings("unchecked")
    public static KeySystemCapability decode(com.vccorp.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        decoder0.increaseStackDepth();
        KeySystemCapability result;
        try {
            com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            final int elementsOrVersion = mainDataHeader.elementsOrVersion;
            result = new KeySystemCapability(elementsOrVersion);
                {
                    
                result.videoCodecs = decoder0.readInts(8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.videoCodecs.length; ++i0) {
                        VideoCodec.validate(result.videoCodecs[i0]);
                    }
                }
                }
                {
                    
                result.supportsVp9Profile2 = decoder0.readBoolean(16, 0);
                }
                {
                    
                result.encryptionSchemes = decoder0.readInts(24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.encryptionSchemes.length; ++i0) {
                        EncryptionMode.validate(result.encryptionSchemes[i0]);
                    }
                }
                }
                {
                    
                result.hwSecureVideoCodecs = decoder0.readInts(32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.hwSecureVideoCodecs.length; ++i0) {
                        VideoCodec.validate(result.hwSecureVideoCodecs[i0]);
                    }
                }
                }
                {
                    
                result.hwSecureEncryptionSchemes = decoder0.readInts(40, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.hwSecureEncryptionSchemes.length; ++i0) {
                        EncryptionMode.validate(result.hwSecureEncryptionSchemes[i0]);
                    }
                }
                }
                {
                    
                result.sessionTypes = decoder0.readInts(48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                {
                    for (int i0 = 0; i0 < result.sessionTypes.length; ++i0) {
                        CdmSessionType.validate(result.sessionTypes[i0]);
                    }
                }
                }

        } finally {
            decoder0.decreaseStackDepth();
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        
        encoder0.encode(this.videoCodecs, 8, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        encoder0.encode(this.supportsVp9Profile2, 16, 0);
        
        encoder0.encode(this.encryptionSchemes, 24, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        encoder0.encode(this.hwSecureVideoCodecs, 32, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        encoder0.encode(this.hwSecureEncryptionSchemes, 40, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        
        encoder0.encode(this.sessionTypes, 48, com.vccorp.mojo.bindings.BindingsHelper.NOTHING_NULLABLE, com.vccorp.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
    }
}