
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     media/mojo/interfaces/content_decryption_module.mojom
//

package com.vccorp.media.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public interface ContentDecryptionModule extends com.vccorp.mojo.bindings.Interface {



    public interface Proxy extends ContentDecryptionModule, com.vccorp.mojo.bindings.Interface.Proxy {
    }

    Manager<ContentDecryptionModule, ContentDecryptionModule.Proxy> MANAGER = ContentDecryptionModule_Internal.MANAGER;


    void setClient(
com.vccorp.mojo.bindings.AssociatedInterfaceNotSupported client);



    void initialize(
String keySystem, com.vccorp.url.mojom.Origin securityOrigin, CdmConfig cdmConfig,
InitializeResponse callback);

    interface InitializeResponse extends com.vccorp.mojo.bindings.Callbacks.Callback3<CdmPromiseResult, Integer, Decryptor> { }



    void setServerCertificate(
byte[] certificateData, 
SetServerCertificateResponse callback);

    interface SetServerCertificateResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<CdmPromiseResult> { }



    void getStatusForPolicy(
int minHdcpVersion, 
GetStatusForPolicyResponse callback);

    interface GetStatusForPolicyResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<CdmPromiseResult, Integer> { }



    void createSessionAndGenerateRequest(
int sessionType, int initDataType, byte[] initData, 
CreateSessionAndGenerateRequestResponse callback);

    interface CreateSessionAndGenerateRequestResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<CdmPromiseResult, String> { }



    void loadSession(
int sessionType, String sessionId, 
LoadSessionResponse callback);

    interface LoadSessionResponse extends com.vccorp.mojo.bindings.Callbacks.Callback2<CdmPromiseResult, String> { }



    void updateSession(
String sessionId, byte[] response, 
UpdateSessionResponse callback);

    interface UpdateSessionResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<CdmPromiseResult> { }



    void closeSession(
String sessionId, 
CloseSessionResponse callback);

    interface CloseSessionResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<CdmPromiseResult> { }



    void removeSession(
String sessionId, 
RemoveSessionResponse callback);

    interface RemoveSessionResponse extends com.vccorp.mojo.bindings.Callbacks.Callback1<CdmPromiseResult> { }


}
