
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     gpu/ipc/common/context_result.mojom
//

package com.vccorp.gpu.mojom;

import com.vccorp.mojo.bindings.DeserializationException;

public final class ContextResult {
    private static final boolean IS_EXTENSIBLE = false;

    public static final int SUCCESS = 0;
    public static final int TRANSIENT_FAILURE = 1; // SUCCESS + 1
    public static final int FATAL_FAILURE = 2; // TRANSIENT_FAILURE + 1
    public static final int SURFACE_FAILURE = 3; // FATAL_FAILURE + 1

    public static boolean isKnownValue(int value) {
        return value >= 0 && value <= 3;
    }

    public static void validate(int value) {
        if (IS_EXTENSIBLE || isKnownValue(value)) return;
        throw new DeserializationException("Invalid enum value.");
    }

    private ContextResult() {}
}