
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     services/device/public/mojom/nfc_provider.mojom
//

package com.vccorp.device.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


class NfcProvider_Internal {

    public static final com.vccorp.mojo.bindings.Interface.Manager<NfcProvider, NfcProvider.Proxy> MANAGER =
            new com.vccorp.mojo.bindings.Interface.Manager<NfcProvider, NfcProvider.Proxy>() {

        @Override
        public String getName() {
            return "device.mojom.NFCProvider";
        }

        @Override
        public int getVersion() {
          return 0;
        }

        @Override
        public Proxy buildProxy(com.vccorp.mojo.system.Core core,
                                com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }

        @Override
        public Stub buildStub(com.vccorp.mojo.system.Core core, NfcProvider impl) {
            return new Stub(core, impl);
        }

        @Override
        public NfcProvider[] buildArray(int size) {
          return new NfcProvider[size];
        }
    };


    private static final int GET_NFC_FOR_HOST_ORDINAL = 0;


    static final class Proxy extends com.vccorp.mojo.bindings.Interface.AbstractProxy implements NfcProvider.Proxy {

        Proxy(com.vccorp.mojo.system.Core core,
              com.vccorp.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }


        @Override
        public void getNfcForHost(
int hostId, com.vccorp.mojo.bindings.InterfaceRequest<Nfc> nfc) {

            NfcProviderGetNfcForHostParams _message = new NfcProviderGetNfcForHostParams();

            _message.hostId = hostId;

            _message.nfc = nfc;


            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new com.vccorp.mojo.bindings.MessageHeader(GET_NFC_FOR_HOST_ORDINAL)));

        }


    }

    static final class Stub extends com.vccorp.mojo.bindings.Interface.Stub<NfcProvider> {

        Stub(com.vccorp.mojo.system.Core core, NfcProvider impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(com.vccorp.mojo.bindings.Message message) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                NfcProvider_Internal.MANAGER, messageWithHeader);





                    case GET_NFC_FOR_HOST_ORDINAL: {

                        NfcProviderGetNfcForHostParams data =
                                NfcProviderGetNfcForHostParams.deserialize(messageWithHeader.getPayload());

                        getImpl().getNfcForHost(data.hostId, data.nfc);
                        return true;
                    }


                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(com.vccorp.mojo.bindings.Message message, com.vccorp.mojo.bindings.MessageReceiver receiver) {
            try {
                com.vccorp.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                com.vccorp.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(com.vccorp.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {

                    case com.vccorp.mojo.bindings.interfacecontrol.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return com.vccorp.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), NfcProvider_Internal.MANAGER, messageWithHeader, receiver);




                    default:
                        return false;
                }
            } catch (com.vccorp.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }


    
    static final class NfcProviderGetNfcForHostParams extends org.chromium.mojo.bindings.Struct {

        private static final int STRUCT_SIZE = 16;
        private static final com.vccorp.mojo.bindings.DataHeader[] VERSION_ARRAY = new com.vccorp.mojo.bindings.DataHeader[] {new com.vccorp.mojo.bindings.DataHeader(16, 0)};
        private static final com.vccorp.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
        public int hostId;
        public com.vccorp.mojo.bindings.InterfaceRequest<Nfc> nfc;

        private NfcProviderGetNfcForHostParams(int version) {
            super(STRUCT_SIZE, version);
        }

        public NfcProviderGetNfcForHostParams() {
            this(0);
        }

        public static NfcProviderGetNfcForHostParams deserialize(com.vccorp.mojo.bindings.Message message) {
            return decode(new com.vccorp.mojo.bindings.Decoder(message));
        }

        /**
         * Similar to the method above, but deserializes from a |ByteBuffer| instance.
         *
         * @throws com.vccorp.mojo.bindings.DeserializationException on deserialization failure.
         */
        public static NfcProviderGetNfcForHostParams deserialize(java.nio.ByteBuffer data) {
            return deserialize(new com.vccorp.mojo.bindings.Message(
                    data, new java.util.ArrayList<com.vccorp.mojo.system.Handle>()));
        }

        @SuppressWarnings("unchecked")
        public static NfcProviderGetNfcForHostParams decode(com.vccorp.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            decoder0.increaseStackDepth();
            NfcProviderGetNfcForHostParams result;
            try {
                com.vccorp.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
                final int elementsOrVersion = mainDataHeader.elementsOrVersion;
                result = new NfcProviderGetNfcForHostParams(elementsOrVersion);
                    {
                        
                    result.hostId = decoder0.readInt(8);
                    }
                    {
                        
                    result.nfc = decoder0.readInterfaceRequest(12, false);
                    }

            } finally {
                decoder0.decreaseStackDepth();
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            
            encoder0.encode(this.hostId, 8);
            
            encoder0.encode(this.nfc, 12, false);
        }
    }



}
