
// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/blink/public/mojom/remote_objects/remote_objects.mojom
//

package com.vccorp.blink.mojom;

import com.vccorp.mojo.bindings.DeserializationException;


public final class RemoteInvocationResultValue extends com.vccorp.mojo.bindings.Union {

    public static final class Tag {
        public static final int NumberValue = 0;
        public static final int BooleanValue = 1;
        public static final int StringValue = 2;
        public static final int SingletonValue = 3;
        public static final int ObjectId = 4;
    };
    private double mNumberValue;
    private boolean mBooleanValue;
    private com.vccorp.mojo_base.mojom.String16 mStringValue;
    private int mSingletonValue;
    private int mObjectId;

    public void setNumberValue(double numberValue) {
        this.mTag = Tag.NumberValue;
        this.mNumberValue = numberValue;
    }

    public double getNumberValue() {
        assert this.mTag == Tag.NumberValue;
        return this.mNumberValue;
    }

    public void setBooleanValue(boolean booleanValue) {
        this.mTag = Tag.BooleanValue;
        this.mBooleanValue = booleanValue;
    }

    public boolean getBooleanValue() {
        assert this.mTag == Tag.BooleanValue;
        return this.mBooleanValue;
    }

    public void setStringValue(com.vccorp.mojo_base.mojom.String16 stringValue) {
        this.mTag = Tag.StringValue;
        this.mStringValue = stringValue;
    }

    public com.vccorp.mojo_base.mojom.String16 getStringValue() {
        assert this.mTag == Tag.StringValue;
        return this.mStringValue;
    }

    public void setSingletonValue(int singletonValue) {
        this.mTag = Tag.SingletonValue;
        this.mSingletonValue = singletonValue;
    }

    public int getSingletonValue() {
        assert this.mTag == Tag.SingletonValue;
        return this.mSingletonValue;
    }

    public void setObjectId(int objectId) {
        this.mTag = Tag.ObjectId;
        this.mObjectId = objectId;
    }

    public int getObjectId() {
        assert this.mTag == Tag.ObjectId;
        return this.mObjectId;
    }


    @Override
    public final void encode(org.chromium.mojo.bindings.Encoder encoder0, int offset) {
        encoder0.encode(com.vccorp.mojo.bindings.BindingsHelper.UNION_SIZE, offset);
        encoder0.encode(this.mTag, offset + 4);
        switch (mTag) {
            case Tag.NumberValue: {
                
                encoder0.encode(this.mNumberValue, offset + 8);
                break;
            }
            case Tag.BooleanValue: {
                
                encoder0.encode(this.mBooleanValue, offset + 8, 0);
                break;
            }
            case Tag.StringValue: {
                
                encoder0.encode(this.mStringValue, offset + 8, false);
                break;
            }
            case Tag.SingletonValue: {
                
                encoder0.encode(this.mSingletonValue, offset + 8);
                break;
            }
            case Tag.ObjectId: {
                
                encoder0.encode(this.mObjectId, offset + 8);
                break;
            }
            default: {
                break;
            }
        }
    }

    public static RemoteInvocationResultValue deserialize(com.vccorp.mojo.bindings.Message message) {
        return decode(new com.vccorp.mojo.bindings.Decoder(message).decoderForSerializedUnion(), 0);
    }

    public static final RemoteInvocationResultValue decode(com.vccorp.mojo.bindings.Decoder decoder0, int offset) {
        com.vccorp.mojo.bindings.DataHeader dataHeader = decoder0.readDataHeaderForUnion(offset);
        if (dataHeader.size == 0) {
            return null;
        }
        RemoteInvocationResultValue result = new RemoteInvocationResultValue();
        switch (dataHeader.elementsOrVersion) {
            case Tag.NumberValue: {
                
                result.mNumberValue = decoder0.readDouble(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE);
                result.mTag = Tag.NumberValue;
                break;
            }
            case Tag.BooleanValue: {
                
                result.mBooleanValue = decoder0.readBoolean(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, 0);
                result.mTag = Tag.BooleanValue;
                break;
            }
            case Tag.StringValue: {
                
                com.vccorp.mojo.bindings.Decoder decoder1 = decoder0.readPointer(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE, false);
                result.mStringValue = com.vccorp.mojo_base.mojom.String16.decode(decoder1);
                result.mTag = Tag.StringValue;
                break;
            }
            case Tag.SingletonValue: {
                
                result.mSingletonValue = decoder0.readInt(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE);
                    SingletonJavaScriptValue.validate(result.mSingletonValue);
                result.mTag = Tag.SingletonValue;
                break;
            }
            case Tag.ObjectId: {
                
                result.mObjectId = decoder0.readInt(offset + com.vccorp.mojo.bindings.DataHeader.HEADER_SIZE);
                result.mTag = Tag.ObjectId;
                break;
            }
            default: {
                break;
            }
        }
        return result;
    }
}